/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.util;

import com.ibm.ws.management.util.PortConflictResolverException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PortConflictResolverNoTrace {
    private String[] configRoots;
    private Set reservedPorts;
    private SAXParser parser;
    private Vector inaccessibleFiles;
    private boolean sameHostNameAsDmgr = false;
    private String dmgrHostName = null;

    public PortConflictResolverNoTrace() throws PortConflictResolverException {
        this(null);
    }

    public PortConflictResolverNoTrace(String[] configRoots) throws PortConflictResolverException {
        this.configRoots = configRoots;
        this.reservedPorts = new HashSet();
        this.inaccessibleFiles = new Vector();
        try {
            this.parser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new PortConflictResolverException(e);
        }
        catch (SAXException e) {
            throw new PortConflictResolverException(e);
        }
        this.readPortsFromAllConfigRoots();
    }

    public Vector getInaccessibleFiles() {
        return this.inaccessibleFiles;
    }

    public synchronized int getPort(int defaultPort) {
        int curPort = defaultPort;
        while (!this.reservePort(curPort)) {
            ++curPort;
        }
        return curPort;
    }

    public String getReservedPorts() {
        return this.reservedPorts.toString();
    }

    public boolean reservePort(int port2) {
        return this.reservePortInternal(Integer.toString(port2));
    }

    protected boolean reservePortInternal(String portStr) {
        return this.reservedPorts.add(portStr);
    }

    public boolean unreservePort(int port2) {
        return this.reservedPorts.remove(Integer.toString(port2));
    }

    protected void readPortsFromAllConfigRoots() throws PortConflictResolverException {
        if (this.configRoots != null) {
            for (int i = 0; i < this.configRoots.length; ++i) {
                this.readPortsFromConfigRoot(this.configRoots[i]);
            }
        }
    }

    protected String[] getConfigRoots() {
        return this.configRoots;
    }

    protected void readPortsFromConfigRoot(String configRoot) throws PortConflictResolverException {
        if (new File(configRoot).exists()) {
            String cellName = this.getCellName(configRoot);
            String[] nodeNames = null;
            if (cellName != null) {
                nodeNames = this.getNodeNames(configRoot, cellName);
            }
            if (nodeNames != null) {
                this.readPorts(configRoot, cellName, nodeNames);
            }
        }
    }

    private String getCellName(String configRoot) {
        File cellsDir = new File(configRoot, "cells");
        if (!cellsDir.exists()) {
            return null;
        }
        File[] files = cellsDir.listFiles();
        if (files == null) {
            return null;
        }
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            return files[i].getName();
        }
        return null;
    }

    private String[] getNodeNames(String configRoot, String cellName) {
        String dmgrNode;
        String nodesDirStr = new StringBuffer(configRoot).append("/cells/").append(cellName).append("/nodes").toString();
        File nodesDir = new File(nodesDirStr);
        if (!nodesDir.exists()) {
            return null;
        }
        File[] files = nodesDir.listFiles();
        if (files == null) {
            return null;
        }
        ArrayList<File> nodeDirs = new ArrayList<File>();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory() || !new File(files[i], "node.xml").exists()) continue;
            nodeDirs.add(files[i]);
        }
        String[] nodeNames = null;
        nodeNames = nodeDirs.size() > 1 ? ((dmgrNode = this.findDMgrNode(nodeDirs, configRoot, cellName)) != null ? this.filterNodesForDmgr(nodeDirs) : this.toFileNameArray(nodeDirs)) : this.toFileNameArray(nodeDirs);
        return nodeNames;
    }

    private String[] filterNodesForDmgr(List nodeDirs) {
        String[] nodeNames = null;
        ArrayList<File> validNodeDirs = new ArrayList<File>();
        for (File f : nodeDirs) {
            File siFile = new File(f, "/serverindex.xml");
            if (!this.isFileAccessible(siFile)) continue;
            try {
                this.sameHostNameAsDmgr = false;
                this.parseServerIndexForSameHostNameAsDmgr(siFile);
                if (!this.sameHostNameAsDmgr) continue;
                validNodeDirs.add(f);
            }
            catch (PortConflictResolverException e) {
                e.printStackTrace();
            }
        }
        nodeNames = this.toFileNameArray(validNodeDirs);
        return nodeNames;
    }

    private String[] toFileNameArray(List l) {
        String[] array = new String[l.size()];
        int i = 0;
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            array[i++] = ((File)iter.next()).getName();
        }
        return array;
    }

    private String findDMgrNode(List nodeDirs, String configRoot, String cellName) {
        for (File f : nodeDirs) {
            File siFile;
            if (!f.isDirectory() || !new File(f, "/servers/dmgr").exists() || !this.isFileAccessible(siFile = new File(f, "/serverindex.xml"))) continue;
            try {
                this.parseServerIndexForDmgrHost(siFile);
            }
            catch (PortConflictResolverException e) {
                e.printStackTrace();
            }
            return f.getName();
        }
        return null;
    }

    protected void readPorts(String configRoot, String cellName, String[] nodeNames) throws PortConflictResolverException {
        for (int i = 0; i < nodeNames.length; ++i) {
            String file = new StringBuffer(configRoot).append("/cells/").append(cellName).append("/nodes/").append(nodeNames[i]).append("/serverindex.xml").toString();
            File f = new File(file);
            if (!this.isFileAccessible(f)) continue;
            this.parseServerIndex(f);
        }
    }

    protected boolean isFileAccessible(File file) {
        try {
            if (file.exists()) {
                FileInputStream fis = new FileInputStream(file);
                fis.close();
            }
        }
        catch (FileNotFoundException e) {
            this.inaccessibleFiles.add(file.getAbsolutePath());
            return false;
        }
        catch (IOException ex) {
            this.inaccessibleFiles.add(file.getAbsolutePath());
            return false;
        }
        return true;
    }

    protected void parseServerIndex(File serverIndex) throws PortConflictResolverException {
        try {
            this.parser.parse(serverIndex, (DefaultHandler)new ServerIndexHandler());
        }
        catch (SAXException e) {
            throw new PortConflictResolverException(e);
        }
        catch (IOException e) {
            throw new PortConflictResolverException(e);
        }
    }

    protected void parseServerIndexForDmgrHost(File serverIndex) throws PortConflictResolverException {
        try {
            this.parser.parse(serverIndex, (DefaultHandler)new ServerIndexHandlerForDmgrHost());
        }
        catch (SAXException e) {
            throw new PortConflictResolverException(e);
        }
        catch (IOException e) {
            throw new PortConflictResolverException(e);
        }
    }

    protected void parseServerIndexForSameHostNameAsDmgr(File serverIndex) throws PortConflictResolverException {
        try {
            this.parser.parse(serverIndex, (DefaultHandler)new ServerIndexHandlerForSameHostNameAsDmgr());
        }
        catch (SAXException e) {
            throw new PortConflictResolverException(e);
        }
        catch (IOException e) {
            throw new PortConflictResolverException(e);
        }
    }

    class ServerIndexHandlerForSameHostNameAsDmgr
    extends DefaultHandler {
        ServerIndexHandlerForSameHostNameAsDmgr() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals("serverindex:ServerIndex")) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!attributes.getQName(i).equals("hostName") || !attributes.getValue(i).equals(PortConflictResolverNoTrace.this.dmgrHostName)) continue;
                    PortConflictResolverNoTrace.this.sameHostNameAsDmgr = true;
                }
            }
        }
    }

    class ServerIndexHandlerForDmgrHost
    extends DefaultHandler {
        ServerIndexHandlerForDmgrHost() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals("serverindex:ServerIndex")) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!attributes.getQName(i).equals("hostName")) continue;
                    PortConflictResolverNoTrace.this.dmgrHostName = attributes.getValue(i);
                }
            }
        }
    }

    class ServerIndexHandler
    extends DefaultHandler {
        ServerIndexHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals("endPoint")) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!attributes.getQName(i).equals("port")) continue;
                    PortConflictResolverNoTrace.this.reservePortInternal(attributes.getValue(i));
                }
            }
        }
    }
}

