/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.util.PortConflictResolverException;
import com.ibm.ws.management.util.PortConflictResolverNoTrace;
import java.io.File;

public class PortConflictResolver
extends PortConflictResolverNoTrace {
    private static TraceComponent tc = Tr.register(PortConflictResolver.class, "Admin", null);

    public PortConflictResolver() throws PortConflictResolverException {
    }

    public PortConflictResolver(String[] configRoots) throws PortConflictResolverException {
        super(configRoots);
    }

    public synchronized int getPort(int defaultPort) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPort " + defaultPort);
        }
        int curPort = super.getPort(defaultPort);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPort " + curPort);
        }
        return curPort;
    }

    protected boolean reservePortInternal(String portStr) {
        boolean notPreviouslyReserved = super.reservePortInternal(portStr);
        if (tc.isDebugEnabled()) {
            if (notPreviouslyReserved) {
                Tr.debug(tc, portStr + " successfully reserved.");
            } else {
                Tr.debug(tc, portStr + " already in use");
            }
        }
        return notPreviouslyReserved;
    }

    public boolean unreservePort(int port2) {
        boolean previouslyReserved = super.unreservePort(port2);
        if (tc.isDebugEnabled()) {
            String portStr = Integer.toString(port2);
            if (previouslyReserved) {
                Tr.debug(tc, portStr + " successfully unreserved.");
            } else {
                Tr.debug(tc, portStr + " was not previously reserved.");
            }
        }
        return previouslyReserved;
    }

    protected void readPortsFromAllConfigRoots() throws PortConflictResolverException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Reading ports from", this.getConfigRoots());
        }
        super.readPortsFromAllConfigRoots();
    }

    protected void readPortsFromConfigRoot(String configRoot) throws PortConflictResolverException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readPortsFromConfigRoot", configRoot);
        }
        super.readPortsFromConfigRoot(configRoot);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readPortsFromConfigRoot");
        }
    }

    protected void readPorts(String configRoot, String cellName, String[] nodeNames) throws PortConflictResolverException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("[ ");
            for (int i = 0; i < nodeNames.length; ++i) {
                buf.append(nodeNames[i]);
                if (i + 1 >= nodeNames.length) continue;
                buf.append(", ");
            }
            buf.append(" ]");
            Tr.entry(tc, "readPorts", new String[]{configRoot, cellName, buf.toString()});
        }
        super.readPorts(configRoot, cellName, nodeNames);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readPorts");
        }
    }

    protected void parseServerIndex(File serverIndex) throws PortConflictResolverException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseServerIndex", serverIndex);
        }
        super.parseServerIndex(serverIndex);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseServerIndex");
        }
    }
}

