/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.ws.management.AdminHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Properties;

public class MiscUtils {
    private static TraceComponent tc = Tr.register(MiscUtils.class, "MiscUtils", "com.ibm.ws.management.util");
    private static String tempDir = null;

    public static boolean isLocalAdminClient(AdminClient adminClient) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isLocalAdminClient");
        }
        boolean ret = false;
        Properties props = adminClient.getConnectorProperties();
        String remoteHost = props.getProperty("host");
        if (remoteHost != null && MiscUtils.isLocalHost(remoteHost)) {
            ret = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isLocalAdminClient:" + ret);
        }
        return ret;
    }

    public static boolean isLocalHost(String remoteHostName) throws Exception {
        InetAddress[] remoteAddresses;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isLocalHost(" + remoteHostName + ")");
        }
        boolean ret = false;
        for (InetAddress addr : remoteAddresses = InetAddress.getAllByName(remoteHostName)) {
            boolean isLoopback = addr.isLoopbackAddress();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checking loopback for: " + addr + ": " + isLoopback);
            }
            if (!isLoopback) continue;
            ret = true;
            break;
        }
        if (!ret) {
            InetAddress localAddress = InetAddress.getLocalHost();
            String hostName = localAddress.getHostName();
            String canonicalHostName = localAddress.getCanonicalHostName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "local address: " + localAddress + ", hostName: " + hostName + ", canonicalHostName: " + canonicalHostName);
                Tr.debug(tc, "Checking against " + hostName);
            }
            InetAddress[] localAddresses = InetAddress.getAllByName(hostName);
            for (InetAddress remoteAddr : remoteAddresses) {
                for (InetAddress localAddr : localAddresses) {
                    boolean match = remoteAddr.equals(localAddr);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "comparing " + remoteAddr + " with " + localAddr + ": " + match);
                    }
                    if (!match) continue;
                    ret = true;
                    break;
                }
                if (ret) break;
            }
            if (!ret && canonicalHostName != null && !canonicalHostName.equals(hostName)) {
                InetAddress[] canonicalAddresses = InetAddress.getAllByName(canonicalHostName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Checking against " + canonicalHostName);
                }
                for (InetAddress remoteAddr : remoteAddresses) {
                    for (InetAddress localAddr : canonicalAddresses) {
                        boolean match = remoteAddr.equals(localAddr);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "comparing " + remoteAddr + " with " + localAddr + ": " + match);
                        }
                        if (!match) continue;
                        ret = true;
                        break;
                    }
                    if (ret) break;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isLocalHost(" + remoteHostName + "):" + ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File destinationFile, File sourceFile, boolean deleteSrc) throws FileNotFoundException, IOException {
        block17: {
            Exception e22;
            FileOutputStream out;
            block16: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "copyFile", new Object[]{destinationFile, sourceFile});
                }
                FileInputStream in = null;
                out = null;
                try {
                    MiscUtils.createDirectoryIfMissing(destinationFile);
                    in = new FileInputStream(sourceFile);
                    out = new FileOutputStream(destinationFile, false);
                    boolean done = false;
                    byte[] data = new byte[8096];
                    int bytesRead = in.read(data);
                    while (bytesRead != -1) {
                        out.write(data, 0, bytesRead);
                        bytesRead = in.read(data);
                    }
                    Object var9_8 = null;
                    if (in == null) break block16;
                }
                catch (Throwable throwable) {
                    block19: {
                        Exception e22;
                        block18: {
                            Object var9_9 = null;
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (Exception e22) {
                                    if (!tc.isDebugEnabled()) break block18;
                                    Tr.debug(tc, "ignoring exception on input close.", e22);
                                }
                            }
                        }
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (Exception e22) {
                                if (!tc.isDebugEnabled()) break block19;
                                Tr.debug(tc, "ignoring exception on output close.", e22);
                            }
                        }
                    }
                    if (deleteSrc) {
                        sourceFile.delete();
                    }
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (Exception e22) {
                    if (!tc.isDebugEnabled()) break block16;
                    Tr.debug(tc, "ignoring exception on input close.", e22);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e22) {
                    if (!tc.isDebugEnabled()) break block17;
                    Tr.debug(tc, "ignoring exception on output close.", e22);
                }
            }
        }
        if (deleteSrc) {
            sourceFile.delete();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyFile");
        }
    }

    public static synchronized String getTempDirPath() throws IOException {
        File scriptingTempDirectory = null;
        if (AdminHelper.getPlatformHelper().isZOS()) {
            String scriptingTempProperty = System.getProperty("user.install.root") + "/temp";
            if (scriptingTempProperty != null) {
                scriptingTempDirectory = new File(scriptingTempProperty);
            }
            if (tc.isDebugEnabled() && scriptingTempDirectory != null) {
                Tr.debug(tc, "local client on ZOS Platform - using scripting temp directory " + scriptingTempDirectory.getCanonicalPath());
            }
        }
        if (tempDir == null) {
            File tempFile = File.createTempFile("MiscUtils", null, scriptingTempDirectory);
            tempDir = tempFile.getParentFile().getCanonicalPath();
            tempFile.delete();
        }
        return tempDir;
    }

    private static void createDirectoryIfMissing(File file) {
        File dir;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDirectoryIfMissing" + file);
        }
        String absolutePath = file.getAbsolutePath();
        String fileName = file.getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "absolutePath=" + absolutePath);
            Tr.debug(tc, "fileName=" + fileName);
        }
        String directory = absolutePath.substring(0, absolutePath.length() - fileName.length() - 1);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "directory=" + directory);
        }
        if (!(dir = new File(directory)).exists()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The directory: " + directory + " does not exist, creating it now.");
            }
            dir.mkdirs();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "");
        }
    }
}

