/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.exception.AdminException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class ConfigLimits {
    private static TraceComponent _tc = Tr.register(ConfigLimits.class, "Admin", null);
    private static final String CONFIG_LIMITS_FILE_PATH = "properties" + File.separator + "cctl.dat";
    private static final int CURRENT_FILE_VERSION = 0;
    private static final byte[] FILE_HEADER = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
    private static final int DEFAULT_CLUSTER_LIMIT = -1;
    private static final int DEFAULT_CLUSTER_MEMBER_LIMIT = -1;
    private static final Object _configLimitsLock = new Object();
    private static ConfigLimits _configLimits = null;
    private String _fileName;
    private byte[] _fileHeader = new byte[FILE_HEADER.length];
    private short _fileVersion;
    private short _maxNumberOfClusters;
    private short _maxNumberOfClusterMembers;
    private long _checksum;
    private boolean _haveData = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigLimits createConfigLimits() throws AdminException {
        Object object = _configLimitsLock;
        synchronized (object) {
            if (_configLimits == null) {
                _configLimits = new ConfigLimits();
            }
        }
        return _configLimits;
    }

    ConfigLimits() throws AdminException {
        String wasInstallRoot = System.getProperty("was.install.root");
        if (wasInstallRoot == null) {
            AdminException ae = new AdminException("The property, was.install.root, is not set as a System property.");
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "ConfigLimits(): was.install.root property not set.", ae);
            }
            Manager.Ffdc.log(ae, this, "com.ibm.ws.management.util.ConfigLimits.ConfigLimits()", "122", this);
            throw ae;
        }
        this._fileName = wasInstallRoot + File.separator + CONFIG_LIMITS_FILE_PATH;
        this.readInData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readInData() throws AdminException {
        ConfigLimits configLimits = this;
        synchronized (configLimits) {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "readInData");
            }
            try {
                block14: {
                    File f = new File(this._fileName);
                    if (f.exists()) {
                        if (!f.isDirectory()) {
                            FileInputStream fis = new FileInputStream(f);
                            DataInputStream dis = new DataInputStream(fis);
                            dis.read(this._fileHeader);
                            this.verifyHeader();
                            this._fileVersion = dis.readShort();
                            this._maxNumberOfClusters = dis.readShort();
                            this._maxNumberOfClusterMembers = dis.readShort();
                            this._checksum = dis.readLong();
                            long checksum = this.createChecksum();
                            if (checksum != this._checksum) {
                                AdminException ae = new AdminException("Config limits data is corrupted.");
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "readInData: Config limits data is corrupted.", ae);
                                }
                                Manager.Ffdc.log(ae, this, "com.ibm.ws.management.util.ConfigLimits.readInData", "118", this);
                                throw ae;
                            }
                            fis.close();
                            break block14;
                        } else {
                            AdminException ae = new AdminException("File " + this._fileName + " is a directory.");
                            if (_tc.isEventEnabled()) {
                                Tr.event(_tc, "readInData: file name resolves to a directory.", ae);
                            }
                            Manager.Ffdc.log(ae, this, "com.ibm.ws.management.util.ConfigLimits.readInData", "122", this);
                            throw ae;
                        }
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "readInData: file does not exist");
                    }
                    System.arraycopy(FILE_HEADER, 0, this._fileHeader, 0, FILE_HEADER.length);
                    this._fileVersion = 0;
                    this._maxNumberOfClusters = (short)-1;
                    this._maxNumberOfClusterMembers = (short)-1;
                    this._checksum = this.createChecksum();
                }
                this._haveData = true;
            }
            catch (AdminException e) {
                if (!_tc.isEntryEnabled()) throw e;
                Tr.exit(_tc, "readInData: Received AdminException: " + e);
                throw e;
            }
            catch (EOFException e) {
                AdminException ae = new AdminException(e, "Reached premature end-of-file when attempting to read config limit data.");
                if (!_tc.isEntryEnabled()) throw ae;
                Tr.exit(_tc, "readInData: Received EOFException:", e);
                throw ae;
            }
            catch (Exception e) {
                AdminException ae = new AdminException(e, "Encountered error when attempting to read config limit data.");
                if (!_tc.isEntryEnabled()) throw ae;
                Tr.exit(_tc, "readInData: Received Exception:", e);
                throw ae;
            }
            if (!_tc.isEntryEnabled()) return;
            Tr.exit(_tc, "readInData");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeOutData() throws AdminException {
        ConfigLimits configLimits = this;
        synchronized (configLimits) {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "writeOutData");
            }
            try {
                if (!this._haveData) {
                    AdminException ae = new AdminException("Config limit data has not yet been read or initialized.");
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "writeOutData: Data not read or initialized.", ae);
                    }
                    throw ae;
                }
                File f = new File(this._fileName);
                if (f.isDirectory()) {
                    AdminException ae = new AdminException("File " + this._fileName + " is a directory.");
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "writeOutData: file name resolves to a directory.", ae);
                    }
                    Manager.Ffdc.log(ae, this, "com.ibm.ws.management.util.ConfigLimits.writeOutData", "196", this);
                    throw ae;
                }
                FileOutputStream fos = new FileOutputStream(this._fileName, false);
                DataOutputStream dos = new DataOutputStream(fos);
                dos.write(FILE_HEADER, 0, FILE_HEADER.length);
                dos.writeShort(this._fileVersion);
                dos.writeShort(this._maxNumberOfClusters);
                dos.writeShort(this._maxNumberOfClusterMembers);
                this._checksum = this.createChecksum();
                dos.writeLong(this._checksum);
                dos.flush();
                fos.close();
            }
            catch (AdminException e) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "writeOutData: Received AdminException: " + e);
                }
                throw e;
            }
            catch (Exception e) {
                AdminException ae = new AdminException(e, "Encountered error when attempting to write config limit data.");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "writeOutData: Received Exception.", ae);
                }
                throw ae;
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "writeOutData");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getMaxNumberOfClusters() throws AdminException {
        ConfigLimits configLimits = this;
        synchronized (configLimits) {
            if (!this._haveData) {
                AdminException ae = new AdminException("Config limit data has not yet been read or initialized.");
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "getMaxNumberOfClusters: Data not read or initialized.", ae);
                }
                throw ae;
            }
            return this._maxNumberOfClusters;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getMaxNumberOfClusterMembers() throws AdminException {
        ConfigLimits configLimits = this;
        synchronized (configLimits) {
            if (!this._haveData) {
                AdminException ae = new AdminException("Config limit data has not yet been read or initialized.");
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "getMaxNumberOfClusterMembers: Data not read or initialized.", ae);
                }
                throw ae;
            }
            return this._maxNumberOfClusterMembers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxNumberOfClusters(short maxNumberOfClusters) throws AdminException {
        ConfigLimits configLimits = this;
        synchronized (configLimits) {
            if (maxNumberOfClusters < -1) {
                AdminException ae = new AdminException("Value for maxNumberOfClusters is outof range: " + maxNumberOfClusters);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "getMaxNumberOfClusters: Value out of range: " + maxNumberOfClusters, ae);
                }
                throw ae;
            }
            this._maxNumberOfClusters = maxNumberOfClusters;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxNumberOfClusterMembers(short maxNumberOfClusterMembers) throws AdminException {
        ConfigLimits configLimits = this;
        synchronized (configLimits) {
            if (maxNumberOfClusterMembers < -1) {
                AdminException ae = new AdminException("Value for maxNumberOfClusterMembers is outof range: " + maxNumberOfClusterMembers);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "getMaxNumberOfClusterMembers: Value out of range: " + maxNumberOfClusterMembers, ae);
                }
                throw ae;
            }
            this._maxNumberOfClusterMembers = maxNumberOfClusterMembers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNumberOfClustersWithinLimit(short numberOfClusters) throws AdminException {
        ConfigLimits configLimits = this;
        synchronized (configLimits) {
            boolean withinLimit;
            if (!this._haveData) {
                AdminException ae = new AdminException("Config limit data has not yet been read or initialized.");
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "isNumberOfClustersWithinLimit: Data not read or initialized.", ae);
                }
                throw ae;
            }
            boolean bl = withinLimit = this._maxNumberOfClusters == -1 || numberOfClusters <= this._maxNumberOfClusters;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "isNumberOfClustersWithinLimit: " + withinLimit, new String[]{"num=" + numberOfClusters, "max=" + this._maxNumberOfClusters});
            }
            return withinLimit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNumberOfClusterMembersWithinLimit(short numberOfClusterMembers) throws AdminException {
        ConfigLimits configLimits = this;
        synchronized (configLimits) {
            boolean withinLimit;
            if (!this._haveData) {
                AdminException ae = new AdminException("Config limit data has not yet been read or initialized.");
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "isNumberOfClusterMembersWithinLimit: Data not read or initialized.", ae);
                }
                throw ae;
            }
            boolean bl = withinLimit = this._maxNumberOfClusterMembers == -1 || numberOfClusterMembers <= this._maxNumberOfClusterMembers;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "isNumberOfClusterMembersWithinLimit: " + withinLimit, new String[]{"num=" + numberOfClusterMembers, "max=" + this._maxNumberOfClusterMembers});
            }
            return withinLimit;
        }
    }

    private void verifyHeader() throws AdminException {
        for (int i = 0; i < FILE_HEADER.length; ++i) {
            if (this._fileHeader[i] == FILE_HEADER[i]) continue;
            AdminException ae = new AdminException("File header incorrect.");
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "verifyHeader: File header incorrect.", ae);
            }
            Manager.Ffdc.log(ae, this, "com.ibm.ws.management.util.ConfigLimits.verifyHeader", "365", this);
            throw ae;
        }
    }

    long createChecksum() {
        long checksum = (long)(Math.pow(this._fileVersion + 4, 3.2) * 11.0 / 3.0) + (long)(Math.pow(Math.abs(this._maxNumberOfClusters + 4) + 4, 7.2) * 17.0 / 3.0) + (long)(Math.pow(Math.abs(this._maxNumberOfClusterMembers + 4) + 3, 6.25) * 11.0 / 6.0);
        return checksum;
    }
}

