/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.ObjectName;

public class AdminCommandHelper {
    private static TraceComponent tc = Tr.register(AdminCommandHelper.class, "Admin", null);

    public static ObjectName[] getResources(Session session, ConfigService configService, String resource) throws ConfigServiceException, ConnectorException {
        ObjectName[] scopes;
        String nodeName;
        String memberName;
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResources", resource);
        }
        LinkedHashMap<String, String> resouceTypeMap = new LinkedHashMap<String, String>();
        StringTokenizer resourcesTokenizer = new StringTokenizer(resource, ",");
        StringBuffer newResourceFormat = new StringBuffer();
        while (resourcesTokenizer.hasMoreTokens()) {
            String resourceToken = resourcesTokenizer.nextToken();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Parsing " + resourceToken);
            }
            String resourceType = resourceToken;
            String resourceName = "";
            if (resourceToken.indexOf(61) != -1) {
                resourceType = resourceToken.substring(0, resourceToken.indexOf(61));
                if (resourceType.equalsIgnoreCase("cluster")) {
                    resourceType = "ServerCluster";
                } else if (resourceType.equalsIgnoreCase("application")) {
                    resourceType = "Deployment";
                } else if (resourceType.equalsIgnoreCase("clustermember")) {
                    resourceType = "ClusterMember";
                }
                resourceName = resourceToken.substring(resourceToken.indexOf(61) + 1);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "New resource String is " + resourceToken + ".  Resource name is " + resourceName);
            }
            char firstLetter = resourceType.charAt(0);
            char CapFirstLetter = Character.toUpperCase(firstLetter);
            char[] resourceTypeChars = resourceType.toCharArray();
            resourceTypeChars[0] = CapFirstLetter;
            resouceTypeMap.put(new String(resourceTypeChars), resourceName);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "resourceTypeMap is: " + resouceTypeMap);
        }
        if (resouceTypeMap.containsKey("ClusterMember")) {
            ObjectName cluster = null;
            if (resouceTypeMap.get("ServerCluster") != null) {
                String clusterQueryString = new String("ServerCluster=" + (String)resouceTypeMap.get("ServerCluster"));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cluster QueryString is " + clusterQueryString);
                }
                cluster = AdminCommandHelper.getClusterObjectName(session, configService, clusterQueryString);
            }
            ObjectName clusterMemberPattern = ConfigServiceHelper.createObjectName(null, "ClusterMember");
            ObjectName[] memberList = configService.queryConfigObjects(session, cluster, clusterMemberPattern, null);
            boolean memberFound = false;
            for (i = 0; i < memberList.length; ++i) {
                memberName = (String)configService.getAttribute(session, memberList[i], "memberName", false);
                if (!memberName.equals((String)resouceTypeMap.get("ClusterMember"))) continue;
                if (!memberFound) {
                    memberFound = true;
                    nodeName = (String)configService.getAttribute(session, memberList[i], "nodeName", false);
                    newResourceFormat.append("Node=" + nodeName + ":" + "Server=" + memberName);
                    continue;
                }
                throw new ConfigServiceException("Duplicate resources, ClusterMember, found with name: " + memberName);
            }
        } else if (resouceTypeMap.containsKey("ServerCluster")) {
            String clusterQueryString = new String("ServerCluster=" + (String)resouceTypeMap.get("ServerCluster"));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cluster QueryString is " + clusterQueryString);
            }
            ObjectName cluster = AdminCommandHelper.getClusterObjectName(session, configService, clusterQueryString);
            ObjectName clusterMemberPattern = ConfigServiceHelper.createObjectName(null, "ClusterMember");
            ObjectName[] memberList = configService.queryConfigObjects(session, cluster, clusterMemberPattern, null);
            for (i = 0; i < memberList.length; ++i) {
                if (resouceTypeMap.containsKey("Node")) {
                    String nodeName2;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "cluster QueryString is " + clusterQueryString);
                    }
                    if (!(nodeName2 = (String)configService.getAttribute(session, memberList[i], "nodeName", false)).equals((String)resouceTypeMap.get("Node"))) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Matching node found. NodeName: " + nodeName2);
                    }
                    if (resouceTypeMap.containsKey("Server")) {
                        String memberName2;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Check for Server...");
                        }
                        if (!(memberName2 = (String)configService.getAttribute(session, memberList[i], "memberName", false)).equals((String)resouceTypeMap.get("Server"))) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Matching server found.  ServerName: " + memberName2);
                        }
                        newResourceFormat.append("Node=" + nodeName2 + ":" + "Server=" + memberName2);
                    } else {
                        newResourceFormat.append("Node=" + nodeName2);
                    }
                } else {
                    if (!resouceTypeMap.containsKey("Server") || !(memberName = (String)configService.getAttribute(session, memberList[i], "memberName", false)).equals((String)resouceTypeMap.get("Server"))) continue;
                    nodeName = (String)configService.getAttribute(session, memberList[i], "nodeName", false);
                    newResourceFormat.append("Node=" + nodeName + ":" + "Server=" + memberName);
                }
                break;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "newResourceFormat is " + newResourceFormat.toString());
        }
        if (newResourceFormat.toString().equals("")) {
            Iterator iter = resouceTypeMap.keySet().iterator();
            while (iter.hasNext()) {
                String scopeType = (String)iter.next();
                String scopeName = (String)resouceTypeMap.get(scopeType);
                newResourceFormat.append(scopeType);
                if (scopeName != null && scopeName != "") {
                    newResourceFormat.append("=");
                    newResourceFormat.append(scopeName);
                }
                if (!iter.hasNext()) continue;
                newResourceFormat.append(":");
            }
        }
        String resourceQueryString = newResourceFormat.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "resourceQueryString is " + resourceQueryString);
        }
        if ((scopes = configService.resolve(session, resourceQueryString)) == null || scopes.length == 0) {
            throw new ConfigServiceException("No resource found with name " + resource);
        }
        if (scopes != null && scopes.length > 1) {
            throw new ConfigServiceException("Duplicate resources found with name: " + resource);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResources", scopes);
        }
        return scopes;
    }

    public static ObjectName[] getResourceForAssetsBlasOrCus(ConfigService configService, Session session, String resourceName) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceForAssetsBlasOrCus ", resourceName);
        }
        ObjectName[] resourceNameObj = null;
        if (null != resourceName) {
            if (resourceName.contains("=")) {
                ObjectName cellName;
                String savedResourceName = new String(resourceName);
                resourceName = resourceName.toLowerCase();
                int afterEqualsIndex = resourceName.indexOf("=") + 1;
                String resourceValue = savedResourceName.substring(afterEqualsIndex);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "afterEqualsIndex=" + afterEqualsIndex);
                    Tr.debug(tc, "resourceValue=" + resourceValue);
                }
                if (null != (cellName = ConfigServiceHelper.createObjectName(null, "Cell"))) {
                    Tr.debug(tc, "cellName.getCanonicalName()=" + cellName.getCanonicalName());
                    ObjectName[] cellObjects = configService.queryConfigObjects(session, null, cellName, null);
                    if (null != cellObjects && cellObjects.length > 0) {
                        ObjectName cellObject = cellObjects[0];
                        String queryString = "cells/" + ConfigServiceHelper.getDisplayName(cellObject);
                        queryString = resourceName.contains("blas") ? queryString + "/blas/" + resourceValue : (resourceName.contains("assets") ? queryString + "/assets/" + resourceValue : queryString + "/cus/" + resourceValue);
                        resourceName = queryString;
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resourceName now has the value=" + resourceName);
            }
            resourceNameObj = new ObjectName[]{ConfigServiceHelper.createObjectName(new ConfigDataId(resourceName))};
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceForAssetsBlasOrCus ", resourceNameObj);
        }
        return resourceNameObj;
    }

    private static ObjectName getClusterObjectName(Session session, ConfigService configService, String clusterQueryString) throws ConfigServiceException, ConnectorException {
        ObjectName[] clustersList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterObjectName", clusterQueryString);
        }
        if ((clustersList = configService.resolve(session, clusterQueryString)) == null || clustersList.length == 0) {
            throw new ConfigServiceException("No resource, Cluster, found with name " + clusterQueryString);
        }
        if (clustersList != null && clustersList.length > 1) {
            throw new ConfigServiceException("Duplicate resources, Cluster, found with name: " + clusterQueryString);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterObjectName", clustersList[0]);
        }
        return clustersList[0];
    }

    public static List getScopes(Session session, ConfigService configService, String[] scopeTypes) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getScopes", scopeTypes);
        }
        ArrayList result = new ArrayList();
        for (int i = 0; i < scopeTypes.length; ++i) {
            AdminCommandHelper.addScope(session, configService, result, scopeTypes[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getScopes", result);
        }
        return result;
    }

    private static void addScope(Session session, ConfigService configService, List list, String scopeType) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addScope", scopeType);
        }
        String configType = AdminCommandHelper.scopeType2ConfigType(scopeType);
        System.out.println("configType:" + configType);
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, configType);
        ObjectName[] matches = configService.queryConfigObjects(session, null, pattern, null);
        for (int i = 0; i < matches.length; ++i) {
            list.add(AdminCommandHelper.objectName2Scope(matches[i]));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addScope", list);
        }
    }

    private static String scopeType2ConfigType(String scopeType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "scopeType2ConfigType", scopeType);
        }
        String configType = "unknown";
        if (scopeType.equals("cell")) {
            configType = "Cell";
        } else if (scopeType.equals("node")) {
            configType = "Node";
        } else if (scopeType.equals("cluster")) {
            configType = "ServerCluster";
        } else if (scopeType.equals("application")) {
            configType = "Deployment";
        } else if (scopeType.equals("server")) {
            configType = "Server";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "scopeType2ConfigType", scopeType);
        }
        return configType;
    }

    private static String objectName2Scope(ObjectName objName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "objectName2Scope", objName);
        }
        StringBuffer scope = new StringBuffer();
        Properties loc = ConfigServiceHelper.getObjectLocation(objName);
        String propVal = null;
        propVal = loc.getProperty("cell");
        if (propVal != null) {
            scope.append("cell=").append(propVal);
        }
        if ((propVal = loc.getProperty("node")) != null) {
            if (scope.length() > 0) {
                scope.append(",");
            }
            scope.append("node=").append(propVal);
        }
        if ((propVal = loc.getProperty("cluster")) != null) {
            if (scope.length() > 0) {
                scope.append(",");
            }
            scope.append("cluster=").append(propVal);
        }
        if ((propVal = loc.getProperty("application")) != null) {
            if (scope.length() > 0) {
                scope.append(",");
            }
            scope.append("application=").append(propVal);
        }
        if ((propVal = loc.getProperty("server")) != null) {
            if (scope.length() > 0) {
                scope.append(",");
            }
            scope.append("server=").append(propVal);
        }
        String result = scope.toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "objectName2Scope", result);
        }
        return result;
    }
}

