/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.management.configservice.ConfigServiceSubsystemProxy;
import com.ibm.wsspi.management.agent.AdminSubsystemServiceRegistry;
import java.lang.reflect.Constructor;
import java.util.Properties;

public class ConfigServiceFactoryInitializer {
    private static ConfigService configService = null;
    private static ConfigService serverProxy = null;
    private static boolean initialized = false;
    private static boolean local = false;
    private static TraceComponent tc = Tr.register(ConfigServiceFactoryInitializer.class, "management", "com.ibm.ws.management.resources.configservice");
    private static WebSphereRuntimePermission adminPermission = new WebSphereRuntimePermission("AdminPermission");
    private static ConfigService subsystemProxy = new ConfigServiceSubsystemProxy();

    public static ConfigService getProxy() {
        return subsystemProxy;
    }

    public static void setConfigService(ConfigService service) throws AdminException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setConfigService");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(adminPermission);
        }
        if (initialized) {
            throw new AdminException("Config service is initialized already");
        }
        configService = service;
        initialized = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setConfigService");
        }
    }

    public static ConfigService createConfigService(boolean enable, Properties props) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigService");
        }
        String profileKey = AdminContext.peek();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Profile key ", profileKey);
        }
        if (profileKey != null) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "getConfigService", profileKey);
            }
            ConfigService ret = ConfigServiceFactoryInitializer.createConfigService(enable, props, profileKey);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createConfigService", ret);
            }
            return ret;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(adminPermission);
        }
        if (initialized) {
            throw new AdminException("Config service is initialized already");
        }
        if (enable) {
            try {
                String className = "com.ibm.ws.management.configservice.ConfigServiceImpl";
                Class<?> implClass = Class.forName(className);
                Constructor<?> constructor = implClass.getConstructor(Properties.class);
                configService = (ConfigService)constructor.newInstance(props);
                initialized = true;
                if (props != null && "local".equals(props.get("location")) || AdminServiceFactory.getAdminService() == null) {
                    local = true;
                }
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, ConfigServiceFactoryInitializer.class, "com.ibm.websphere.management.configservice.ConfigServiceFactoryInitializer.initialize", "100");
                throw new AdminException(e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConfigService", configService);
        }
        return configService;
    }

    private static ConfigService createConfigService(boolean enable, Properties props, String profileKey) throws AdminException {
        ConfigService service;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigService " + enable + " " + props + " " + profileKey);
        }
        ConfigService remoteConfigService = null;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(adminPermission);
        }
        if ((service = (ConfigService)AdminSubsystemServiceRegistry.getService(ConfigService.class.getName())) != null) {
            throw new AdminException("The Configuration Service for managed endpoint " + profileKey + " is already created");
        }
        if (enable) {
            try {
                String className = "com.ibm.ws.management.configservice.ConfigServiceImpl";
                Class<?> implClass = Class.forName(className);
                Constructor<?> constructor = implClass.getConstructor(Properties.class);
                remoteConfigService = (ConfigService)constructor.newInstance(props);
                AdminSubsystemServiceRegistry.addService(ConfigService.class.getName(), remoteConfigService);
                if (props != null && "local".equals(props.get("location")) || AdminServiceFactory.getAdminService() == null) {
                    local = true;
                }
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, ConfigServiceFactoryInitializer.class, "com.ibm.websphere.management.configservice.ConfigServiceFactoryInitializer.initialize", "142");
                throw new AdminException(e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConfigService", remoteConfigService);
        }
        return remoteConfigService;
    }

    public static synchronized ConfigService getConfigService() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigService");
        }
        String profileKey = AdminContext.peek();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Profile key ", profileKey);
        }
        if (profileKey != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getConfigService", profileKey);
            }
            return ConfigServiceFactoryInitializer.getConfigService(profileKey);
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(adminPermission);
        }
        if (!initialized) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getConfigService - call createConfigService first");
            }
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "local mode: " + local);
        }
        if (local) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getConfigService", configService);
            }
            return configService;
        }
        if (serverProxy == null) {
            try {
                String className = "com.ibm.ws.management.configservice.ConfigServiceServerProxy";
                Class<?> implClass = Class.forName(className);
                Constructor<?> constructor = implClass.getConstructor(ConfigService.class);
                serverProxy = (ConfigService)constructor.newInstance(configService);
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, ConfigServiceFactoryInitializer.class, "com.ibm.websphere.management.configservice.ConfigServiceFactoryInitializer.initialize", "197");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigService", serverProxy);
        }
        return serverProxy;
    }

    private static ConfigService getConfigService(String profileKey) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigService with profile key " + profileKey);
        }
        ConfigService remoteConfigService = null;
        ConfigService remoteServerProxy = null;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(adminPermission);
        }
        if ((remoteConfigService = (ConfigService)AdminSubsystemServiceRegistry.getService(ConfigService.class.getName())) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getConfigService - config service not created");
            }
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "local mode: " + local);
        }
        if (local) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getConfigService", remoteConfigService);
            }
            return remoteConfigService;
        }
        String className = "com.ibm.ws.management.configservice.ConfigServiceServerProxy";
        remoteServerProxy = (ConfigService)AdminSubsystemServiceRegistry.getService(className);
        if (remoteServerProxy == null) {
            try {
                Class<?> implClass = Class.forName(className);
                Constructor<?> constructor = implClass.getConstructor(ConfigService.class);
                remoteServerProxy = (ConfigService)constructor.newInstance(remoteConfigService);
                AdminSubsystemServiceRegistry.addService(className, remoteServerProxy);
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, ConfigServiceFactoryInitializer.class, "com.ibm.websphere.management.configservice.ConfigServiceFactoryInitializer.initialize", "243");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigService", remoteServerProxy);
        }
        return remoteServerProxy;
    }
}

