/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.cmdframework.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandGroupMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.management.cmdframework.impl.CmdFrameworkConstants;
import com.ibm.ws.management.cmdframework.impl.CommandMetadataMgr;
import com.ibm.ws.management.cmdframework.impl.CommandUtility;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

public abstract class CommandMgrImpl
extends CommandMgr {
    private static TraceComponent tc = Tr.register(CommandMgrImpl.class, "CommandMgrImpl", "com.ibm.ws.management.resources.cmdframework");
    protected CommandProviderHelper helper = null;

    public Collection listCommandGroups() throws ConnectorException, CommandException {
        return CommandMetadataMgr.getInstance().listCommandGroups();
    }

    public Collection listCommands(String commandGroup) throws ConnectorException, CommandException {
        return CommandMetadataMgr.getInstance().listCommands(commandGroup);
    }

    public Collection listCommands() throws ConnectorException, CommandException {
        return CommandMetadataMgr.getInstance().listCommands();
    }

    public Collection listAllCommands() throws ConnectorException, CommandException {
        return CommandMetadataMgr.getInstance().listAllCommands();
    }

    public CommandMetadata getCommandMetadata(String commandName) throws CommandNotFoundException, ConnectorException, CommandException {
        return CommandMetadataMgr.getInstance().getCommandMetadata(commandName);
    }

    public Collection getAllCommandMetadata() throws ConnectorException, CommandException {
        Collection cmdList = CommandMetadataMgr.getInstance().listAllCommands();
        Iterator cmdListIterator = cmdList.iterator();
        ArrayList<CommandMetadata> cmdMetadataList = new ArrayList<CommandMetadata>();
        while (cmdListIterator.hasNext()) {
            String commandName = (String)cmdListIterator.next();
            CommandMetadata cmdMetadata = CommandMgr.getCommandMgr().getCommandMetadata(commandName);
            cmdMetadataList.add(cmdMetadata);
        }
        return cmdMetadataList;
    }

    public CommandGroupMetadata getCommandGroupMetadata(String commandGrp) throws CommandNotFoundException, ConnectorException, CommandException {
        return CommandMetadataMgr.getInstance().getCommandGroupMetadata(commandGrp);
    }

    public Collection getAllCommandGroupMetadata() throws ConnectorException, CommandException {
        Collection cmdGrpList = CommandMetadataMgr.getInstance().listCommandGroups();
        Iterator cmdGrpListIterator = cmdGrpList.iterator();
        ArrayList<CommandGroupMetadata> cmdGrpMetadataList = new ArrayList<CommandGroupMetadata>();
        while (cmdGrpListIterator.hasNext()) {
            String commandGrpName = (String)cmdGrpListIterator.next();
            CommandGroupMetadata cmdGrpMetadata = CommandMgr.getCommandMgr().getCommandGroupMetadata(commandGrpName);
            cmdGrpMetadataList.add(cmdGrpMetadata);
        }
        return cmdGrpMetadataList;
    }

    public AdminCommand createCommand(String command) throws ConnectorException, CommandException {
        CommandMetadata cmdMetadata = (CommandMetadata)CommandUtility.clone(CommandMetadataMgr.getInstance().getCommandMetadata(command));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createCommand(" + command + ") uses cmd metadata: @" + Integer.toHexString(cmdMetadata.hashCode()), cmdMetadata);
        }
        AbstractAdminCommand adminCmd = CommandMetadataMgr.getInstance().getCommandProvider(command).createCommand(cmdMetadata);
        adminCmd.setCmdMgrType(CmdFrameworkConstants.SERVER_CMD_MANAGER);
        return adminCmd;
    }

    public AdminCommand loadCommand(InputStream inputStream) throws CommandLoadException, ConnectorException, CommandException {
        try {
            ResourceSetImpl resSet = new ResourceSetImpl();
            XMIResourceImpl res = new XMIResourceImpl();
            res.setURI(URI.createURI("Command.xmi"));
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("DECLARE_XML", Boolean.FALSE);
            res.load(inputStream, options);
            EList resList = res.getContents();
            CommandData cmdData = (CommandData)resList.get(0);
            String commandName = cmdData.getName();
            return CommandMetadataMgr.getInstance().getCommandProvider(commandName).loadCommand(cmdData);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new CommandLoadException(ioe);
        }
        catch (CommandNotFoundException cnfe) {
            cnfe.printStackTrace();
            throw new CommandLoadException(cnfe);
        }
    }
}

