/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.agent;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;

public class AdminSubsystemServiceRegistryHelper {
    private static Hashtable subsystems = new Hashtable();
    private static final TraceComponent tc = Tr.register(AdminSubsystemServiceRegistryHelper.class, "Admin");

    public static void initialize(String uuid) {
        if (uuid == null) {
            return;
        }
        Hashtable tbl = (Hashtable)subsystems.get(uuid);
        if (tbl == null) {
            tbl = new Hashtable();
            subsystems.put(uuid, tbl);
        }
    }

    public static void destroy(String uuid) {
        if (uuid == null) {
            return;
        }
        subsystems.remove(uuid);
    }

    public static Object addService(String serviceName, Object serviceImpl) {
        String uuid = AdminContext.peek();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addService: " + uuid + " serviceName=" + serviceName + " serviceImpl=" + serviceImpl);
        }
        if (uuid == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addService exit: uuid:" + uuid + "  serviceName:" + serviceName);
            }
            throw new IllegalStateException("Attempt to add a new service without when top of AdminContext stack is null");
        }
        if (serviceName == null || serviceImpl == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addService exit: uuid:" + uuid + "  serviceName:" + serviceName);
            }
            return null;
        }
        Hashtable tbl = (Hashtable)subsystems.get(uuid);
        if (tbl == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addService exit: no hashtable");
            }
            throw new IllegalStateException("Attempt to add a new service when the AdminSubsystemServiceRegistry has not been initialized for " + uuid);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addService exit: normal return");
        }
        return tbl.put(serviceName, serviceImpl);
    }

    public static Object getService(String serviceName) {
        String uuid = AdminContext.peek();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getService:" + uuid + " serviceName=" + serviceName);
        }
        if (uuid == null || serviceName == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getService exit: uuid:" + uuid + "  serviceName:" + serviceName);
            }
            return null;
        }
        Hashtable tbl = (Hashtable)subsystems.get(uuid);
        if (tbl == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getService exit: no hashtable");
            }
            return null;
        }
        Object ret = tbl.get(serviceName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getService exit: normal return: " + ret);
        }
        return ret;
    }

    public static Object removeService(String serviceName) {
        String uuid;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeService", serviceName);
        }
        if ((uuid = AdminContext.peek()) == null || serviceName == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeService exit: uuid:" + uuid + "  serviceName:" + serviceName);
            }
            return null;
        }
        Hashtable tbl = (Hashtable)subsystems.get(uuid);
        if (tbl == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeService exit: no hashtable");
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeService exit: normal return");
        }
        return tbl.remove(serviceName);
    }

    public static Set getServiceNames() {
        String uuid;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceNames");
        }
        if ((uuid = AdminContext.peek()) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServiceNames exit: uuid:" + uuid);
            }
            return new HashSet();
        }
        Hashtable tbl = (Hashtable)subsystems.get(uuid);
        if (tbl == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServiceNames exit: no hashtable");
            }
            return new HashSet();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServiceNames : normal return");
        }
        return tbl.keySet();
    }
}

