/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.cbe;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.logging.TraceLogFormatter;
import com.ibm.ws.logging.cbe.BBOMessageIdHelper;
import com.ibm.ws.logging.cbe.CBEHelper;
import com.ibm.ws.logging.cbe.EventFactoryHelper;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;

public class CBEFormatHelper {
    private static EventFactory svPlainEventFactory = EventFactoryHelper.getPlainEventFactory();
    private boolean ibLocalizationSucceeded = false;

    public String localize(CommonBaseEvent cbe, ResourceBundle resourceBundle, String resourceBundleName, Locale locale) {
        String formattedMessage;
        boolean alreadyFormatted = false;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((formattedMessage = CBEHelper.getAlreadyFormattedMessage(cbe, locale)) != null) {
            alreadyFormatted = true;
        } else {
            String localizedMessage = this.attemptLocalization(cbe, resourceBundle, resourceBundleName, locale);
            if (localizedMessage != null) {
                Object[] parms;
                formattedMessage = localizedMessage.indexOf(123) >= 0 ? ((parms = TraceLogFormatter.convertParameters(CBEHelper.getParameters(cbe))) == null ? localizedMessage : TraceNLS.getFormattedMessageFromLocalizedMessage(localizedMessage, parms, true)) : localizedMessage;
            }
        }
        if (formattedMessage != null) {
            if (this.ibLocalizationSucceeded) {
                CBEHelper.populateMsgId(cbe, formattedMessage);
            }
            if (!alreadyFormatted) {
                formattedMessage = BBOMessageIdHelper.addBBOMessageIdIfNeeded(cbe, formattedMessage);
                CBEHelper.setMessageLocale(svPlainEventFactory, cbe, locale.toString());
                CBEHelper.setFormattedMessage(cbe, formattedMessage);
            }
        }
        return formattedMessage;
    }

    public String getFormattedMessage(CommonBaseEvent cbe, ResourceBundle resourceBundle, String resourceBundleName, Locale locale) {
        String formattedMessage;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((formattedMessage = this.localize(cbe, resourceBundle, resourceBundleName, locale)) != null) {
            return formattedMessage;
        }
        formattedMessage = cbe.getMsg();
        if (formattedMessage != null) {
            return formattedMessage;
        }
        return "<Null Message>";
    }

    private String attemptLocalization(CommonBaseEvent cbe, ResourceBundle resourceBundle, String resourceBundleName, Locale locale) {
        String localizedMessage = null;
        this.ibLocalizationSucceeded = false;
        String msgCatalogId = null;
        MsgDataElement mde = cbe.getMsgDataElement();
        if (mde != null) {
            msgCatalogId = mde.getMsgCatalogId();
        }
        if (resourceBundleName != null || resourceBundle != null) {
            String defaultMessage;
            String messageKey;
            if (msgCatalogId != null && (localizedMessage = TraceNLS.getStringFromBundle(resourceBundle, resourceBundleName, messageKey = (defaultMessage = msgCatalogId).replace(' ', '.'), locale, defaultMessage)) != null && localizedMessage != defaultMessage && localizedMessage != messageKey) {
                this.ibLocalizationSucceeded = true;
            }
        } else {
            localizedMessage = msgCatalogId == null ? cbe.getMsg() : msgCatalogId;
        }
        return localizedMessage;
    }
}

