/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.logging.LoggerHelper;
import com.ibm.ws.logging.WsLogger;
import com.ibm.ws.logging.cbe.EventFactoryHelper;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;

class WsLoggerConfigurator {
    static final String CLASSNAME = "com.ibm.ws.logging.WsLoggerConfigurator";
    private static final String[] CONFIGURATION_RESOURCE_NAMES = new String[]{"META-INF/Logger.properties", "Logger.properties"};
    private static final String ATTRIBUTE_NAME_ORGANIZATION = "organization";
    private static final String ATTRIBUTE_NAME_PRODUCT = "product";
    private static final String ATTRIBUTE_NAME_COMPONENT = "component";
    private static final String ATTRIBUTE_NAME_MINIMUM_LOCALIZATION_LEVEL = "minimum_localization_level";
    private static final String ATTRIBUTE_NAME_GROUP = "group";
    private static final String ATTRIBUTE_NAME_ASYNC = "async";
    private static final String ATTRIBUTE_NAME_EVENTFACTORY = "eventfactory";
    private static WsLoggerConfigurator singleton = new WsLoggerConfigurator();
    private WeakHashMap ivLoggingConfigurations = null;
    private Logger ivLogger = null;
    private Vector ivLoggingQueue = null;

    private WsLoggerConfigurator() {
    }

    static WsLoggerConfigurator getInstance() {
        return singleton;
    }

    private HashMap getLoggerConfiguration(Logger logger) {
        HashMap logger_configuration = null;
        HashMap current_configuration = this.getCurrentLoggingConfiguration();
        if (current_configuration != null && current_configuration.size() > 0) {
            HashMap<String, String> logger_configuration_keys = null;
            Map.Entry entry2 = null;
            String key = null;
            String keyName = null;
            for (Map.Entry entry2 : current_configuration.entrySet()) {
                key = (String)entry2.getKey();
                int keyNameIndex = key.lastIndexOf(46);
                if (keyNameIndex == -1 || keyNameIndex >= key.length() - 1 || !logger.getName().startsWith(key.substring(0, keyNameIndex))) continue;
                if (logger_configuration_keys == null) {
                    logger_configuration_keys = new HashMap<String, String>();
                }
                if (logger_configuration_keys.containsKey(keyName = key.substring(keyNameIndex + 1)) && key.length() <= ((String)logger_configuration_keys.get(keyName)).length()) continue;
                logger_configuration_keys.put(keyName, key);
            }
            if (logger_configuration_keys != null) {
                logger_configuration = new HashMap();
                for (Map.Entry entry2 : logger_configuration_keys.entrySet()) {
                    logger_configuration.put(entry2.getKey(), current_configuration.get(entry2.getValue()));
                }
            }
        }
        return logger_configuration;
    }

    private HashMap getExtensionPointLoggingConfiguration() {
        String methodName = "getExtensionPointLoggingConfiguration";
        final HashMap epLoggingConfiguration = new HashMap();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                IExtensionRegistry registry = ExtensionRegistryFactory.instance().getExtensionRegistry();
                if (registry == null) {
                    WsLoggerConfigurator.this.logMessage(Level.WARNING, "getExtensionPointLoggingConfiguration", "Unable to get eclipse extension registry", null);
                    return null;
                }
                String epid = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".logger-properties";
                IExtensionPoint extensionPoint = registry.getExtensionPoint(epid);
                if (extensionPoint == null) {
                    WsLoggerConfigurator.this.logMessage(Level.WARNING, "getExtensionPointLoggingConfiguration", "Unable to get extension point - " + epid, null);
                    return null;
                }
                WsLoggerConfigurator.this.logMessage(Level.FINE, "getExtensionPointLoggingConfiguration", "Processing extension point " + epid, null);
                IExtension[] extensions = extensionPoint.getExtensions();
                for (int i = 0; i < extensions.length; ++i) {
                    IExtension extension = extensions[i];
                    WsLoggerConfigurator.this.logMessage(Level.FINE, "getExtensionPointLoggingConfiguration", "Processing extension " + extension.getUniqueIdentifier(), null);
                    IConfigurationElement[] loggerPropertiesElements = extension.getConfigurationElements();
                    if (loggerPropertiesElements.length == 0) {
                        WsLoggerConfigurator.this.logMessage(Level.FINE, "getExtensionPointLoggingConfiguration", "No data provided for extension.", null);
                        continue;
                    }
                    if (loggerPropertiesElements.length != 1) {
                        WsLoggerConfigurator.this.logMessage(Level.WARNING, "getExtensionPointLoggingConfiguration", "Invalid number of main elements - " + loggerPropertiesElements.length, null);
                        continue;
                    }
                    IConfigurationElement loggerPropertiesElement = loggerPropertiesElements[0];
                    if (!loggerPropertiesElement.getName().equals("logger-properties")) {
                        WsLoggerConfigurator.this.logMessage(Level.WARNING, "getExtensionPointLoggingConfiguration", "Invalid name of main element - expecting <logger-properties> but got <" + loggerPropertiesElement.getName() + ">", null);
                        continue;
                    }
                    IConfigurationElement[] loggerElements = loggerPropertiesElement.getChildren();
                    if (loggerElements.length == 0) {
                        WsLoggerConfigurator.this.logMessage(Level.WARNING, "getExtensionPointLoggingConfiguration", "Missing required <logger> elements", null);
                        continue;
                    }
                    for (int j = 0; j < loggerElements.length; ++j) {
                        IConfigurationElement[] propertyElements;
                        IConfigurationElement loggerElement = loggerElements[j];
                        if (!loggerElement.getName().equals("logger")) {
                            WsLoggerConfigurator.this.logMessage(Level.WARNING, "getExtensionPointLoggingConfiguration", "Invalid name for element - expecting <logger> but got <" + loggerElement.getName() + ">", null);
                            continue;
                        }
                        String prefixName = loggerElement.getAttribute("prefix-name");
                        if (prefixName == null || prefixName.length() == 0) {
                            WsLoggerConfigurator.this.logMessage(Level.WARNING, "getExtensionPointLoggingConfiguration", "No value specified for prefix-name", null);
                            continue;
                        }
                        if (!prefixName.endsWith(".")) {
                            prefixName = prefixName + ".";
                        }
                        if ((propertyElements = loggerElement.getChildren()).length == 0) {
                            WsLoggerConfigurator.this.logMessage(Level.WARNING, "getExtensionPointLoggingConfiguration", "Missing required <property> elements", null);
                            continue;
                        }
                        for (int k = 0; k < propertyElements.length; ++k) {
                            IConfigurationElement propertyElement = propertyElements[k];
                            if (!propertyElement.getName().equals("property")) {
                                WsLoggerConfigurator.this.logMessage(Level.WARNING, "getExtensionPointLoggingConfiguration", "Invalid name for element - expecting <property> but got <" + propertyElement.getName() + ">", null);
                                continue;
                            }
                            String key = propertyElement.getAttribute("key");
                            if (key == null || key.length() == 0) {
                                WsLoggerConfigurator.this.logMessage(Level.WARNING, "getExtensionPointLoggingConfiguration", "Missing required <key> element", null);
                                continue;
                            }
                            String value2 = propertyElement.getAttribute("value");
                            if (value2 == null || value2.length() == 0) {
                                WsLoggerConfigurator.this.logMessage(Level.WARNING, "getExtensionPointLoggingConfiguration", "Missing required <value> element", null);
                                continue;
                            }
                            epLoggingConfiguration.put(prefixName + key, value2);
                        }
                    }
                }
                return null;
            }
        });
        return epLoggingConfiguration;
    }

    private HashMap getCurrentLoggingConfiguration() {
        String methodName = "getCurrentLoggingConfiguration";
        HashMap cclLoggingConfiguration = null;
        ClassLoader ccl = this.getContextClassLoader();
        if (ccl != null) {
            if (this.ivLoggingConfigurations != null) {
                WeakReference wr;
                if (TraceComponent.isAnyTracingEnabled() && this.ivLogger != null && this.ivLogger.isLoggable(Level.FINER)) {
                    this.logMessage(Level.FINER, methodName, "Getting for ccl of: " + ccl.toString() + " w/hashSz of: " + this.ivLoggingConfigurations.size(), null);
                }
                if ((wr = (WeakReference)this.ivLoggingConfigurations.get(ccl)) != null) {
                    cclLoggingConfiguration = (HashMap)wr.get();
                }
            } else {
                this.ivLoggingConfigurations = new WeakHashMap();
            }
            if (cclLoggingConfiguration == null) {
                cclLoggingConfiguration = this.getExtensionPointLoggingConfiguration();
                for (int i = 0; i < CONFIGURATION_RESOURCE_NAMES.length; ++i) {
                    Vector resources = this.getResources(ccl, CONFIGURATION_RESOURCE_NAMES[i]);
                    for (int j = 0; j < resources.size(); ++j) {
                        this.addProperties(cclLoggingConfiguration, this.getPropertiesFromURL((URL)resources.elementAt(j)));
                    }
                }
                this.ivLoggingConfigurations.put(ccl, new WeakReference<HashMap>(cclLoggingConfiguration));
                if (TraceComponent.isAnyTracingEnabled() && this.ivLogger != null && this.ivLogger.isLoggable(Level.FINER)) {
                    this.logMessage(Level.FINER, methodName, "Put for ccl of: " + ccl.toString() + " w/hashSz of: " + this.ivLoggingConfigurations.size(), null);
                }
            }
        } else {
            this.logMessage(Level.WARNING, methodName, "Obtained context class loader is null.", null);
        }
        return cclLoggingConfiguration;
    }

    void configureLogger(Logger logger) {
        String methodName = "configureLogger";
        if (logger == null) {
            throw new NullPointerException("logger passed as argument to configureLogger must not be null");
        }
        if (!(logger instanceof WsLogger)) {
            throw new IllegalArgumentException("Logger passed as argument to configureLogger must be a named logger");
        }
        HashMap hashMap = this.getLoggerConfiguration(logger);
        String eventFactoryName = null;
        if (hashMap != null && !hashMap.isEmpty()) {
            Iterator i = hashMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                Object key = entry.getKey();
                Object value2 = entry.getValue();
                boolean isExtension = false;
                if (!(key instanceof String)) {
                    this.logMessage(Level.WARNING, methodName, "Supplied Map key " + key.toString() + " is of type " + key.getClass().getName() + ".  Keys must be String typed.  Ignoring key value pair.", null);
                }
                if (!(value2 instanceof String)) {
                    this.logMessage(Level.WARNING, methodName, "Supplied Map value " + value2.toString() + " is of type " + key.getClass().getName() + ".  Values must be String typed.  Ignoring key value pair.", null);
                } else if (((String)key).equals(ATTRIBUTE_NAME_PRODUCT)) {
                    ((WsLogger)logger).setProduct((String)value2);
                } else if (((String)key).equals(ATTRIBUTE_NAME_COMPONENT)) {
                    ((WsLogger)logger).setComponent((String)value2);
                } else if (((String)key).equals(ATTRIBUTE_NAME_ORGANIZATION)) {
                    ((WsLogger)logger).setOrganization((String)value2);
                } else if (((String)key).equals(ATTRIBUTE_NAME_MINIMUM_LOCALIZATION_LEVEL)) {
                    ((WsLogger)logger).setMinimumLocalizationLevel(Level.parse((String)value2));
                } else if (((String)key).equals(ATTRIBUTE_NAME_GROUP)) {
                    LoggerHelper.addLoggerToGroup(logger, (String)value2);
                } else if (((String)key).equals(ATTRIBUTE_NAME_ASYNC)) {
                    ((WsLogger)logger).setAsync(((String)value2).equalsIgnoreCase("true"));
                } else if (((String)key).equals(ATTRIBUTE_NAME_EVENTFACTORY)) {
                    eventFactoryName = (String)value2;
                } else {
                    isExtension = true;
                }
                if (isExtension) continue;
                i.remove();
            }
            if (!hashMap.isEmpty()) {
                LoggerHelper.addExtensions(logger, hashMap);
            }
        }
        ((WsLogger)logger).setEventFactory(EventFactoryHelper.getEventFactory(eventFactoryName));
    }

    protected ClassLoader getContextClassLoader() {
        ClassLoader contextClassLoader = null;
        try {
            contextClassLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        catch (Exception e) {
            this.logMessage(Level.WARNING, "getContextClassLoader", "Exception caught while obtainaing context classloader: " + e, null);
            contextClassLoader = null;
        }
        return contextClassLoader;
    }

    protected Vector getResources(final ClassLoader classLoader, final String resourceName) {
        final Vector resources = new Vector();
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Enumeration<URL> enum_of_resources = null;
                    try {
                        enum_of_resources = classLoader != null ? classLoader.getResources(resourceName) : ClassLoader.getSystemResources(resourceName);
                    }
                    catch (IOException e) {
                        WsLoggerConfigurator.this.logMessage(Level.WARNING, "getResources", "Exception caught while obtaining resources named " + resourceName, new Object[]{e});
                    }
                    if (enum_of_resources != null && enum_of_resources.hasMoreElements()) {
                        while (enum_of_resources.hasMoreElements()) {
                            resources.add(enum_of_resources.nextElement());
                        }
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            this.logMessage(Level.WARNING, "getResources", "Exception caught while obtaining resources named " + resourceName, new Object[]{e});
        }
        return resources;
    }

    private void addProperties(HashMap target, Properties sourceProperties) {
        if (sourceProperties != null && sourceProperties.size() > 0) {
            Enumeration<Object> sourceNamesEnumeration = sourceProperties.keys();
            while (sourceNamesEnumeration.hasMoreElements()) {
                String sourceName = (String)sourceNamesEnumeration.nextElement();
                target.put(sourceName, sourceProperties.get(sourceName));
            }
        }
    }

    private Properties getPropertiesFromURL(final URL resource) {
        final Properties resource_properties = new Properties();
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    InputStream resource_inputstream = null;
                    try {
                        resource_inputstream = resource.openStream();
                    }
                    catch (IOException e) {
                        WsLoggerConfigurator.this.logMessage(Level.WARNING, "getPropertiesFromURL", "Exception caught when opening stream for resouce " + resource.toString(), null);
                    }
                    if (resource_inputstream != null) {
                        try {
                            resource_properties.load(resource_inputstream);
                        }
                        catch (IOException e1) {
                            WsLoggerConfigurator.this.logMessage(Level.WARNING, "getPropertiesFromURL", "Exception caught when loading properties from stream for resouce " + resource.toString(), null);
                        }
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            this.logMessage(Level.WARNING, "getPropertiesFromURL", "Exception caught from doPrivileged block loading properties frome resource " + resource.toString(), null);
        }
        return resource_properties;
    }

    private void logMessage(Level level, String method, String message, Object[] params) {
        if (this.ivLogger != null) {
            if (this.ivLoggingQueue != null) {
                while (!this.ivLoggingQueue.isEmpty()) {
                    this.ivLogger.log((LogRecord)this.ivLoggingQueue.elementAt(0));
                    this.ivLoggingQueue.remove(0);
                }
            }
            this.ivLogger.logp(level, CLASSNAME, method, message, params);
        } else {
            LogRecord logrecord = new LogRecord(level, message);
            logrecord.setLoggerName(CLASSNAME);
            logrecord.setSourceClassName(CLASSNAME);
            logrecord.setSourceMethodName(method);
            logrecord.setParameters(params);
            if (this.ivLoggingQueue == null) {
                this.ivLoggingQueue = new Vector();
            }
            this.ivLoggingQueue.add(logrecord);
        }
    }

    void setInternalLogger(Logger logger) {
        if (this.ivLogger == null) {
            this.ivLogger = logger;
            this.logMessage(Level.FINEST, "setInternalLogger", "Internal logger initialized.", null);
        }
    }
}

