/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.logging.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.logging.LogFile;
import com.ibm.ws.timeutils.QuickApproxTime;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;

public class LoggerOffThread
implements LogFile {
    private static final TraceComponent tc = Tr.register(LoggerOffThread.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    protected static final long TIMEOUT = 10000L;
    private File myFile = null;
    private String myName = null;
    private String myFullName = null;
    private FileChannel myChannel = null;
    private WorkerThread myWorker = null;
    private State state = State.IDLE;
    private long maxFileSize = -1L;
    private int maxBackupFiles = 1;

    public LoggerOffThread(String name2) throws FileNotFoundException {
        this.myFullName = name2;
        this.myFile = new File(name2);
        this.myName = this.myFile.getName();
        this.myChannel = new FileOutputStream(this.myFile, true).getChannel();
        this.myWorker = new WorkerThread();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, this.getFileName() + ": New logger-off-thread created");
        }
    }

    protected FileChannel getChannel() {
        return this.myChannel;
    }

    protected void setChannel(FileChannel channel) {
        this.myChannel = channel;
    }

    protected File getFile() {
        return this.myFile;
    }

    public String getFilePathName() {
        return this.myFullName;
    }

    public String getFileName() {
        return this.myName;
    }

    public boolean log(WsByteBuffer data) {
        if (null == data) {
            return false;
        }
        if (State.RUNNING != this.state) {
            data.release();
            return false;
        }
        return this.myWorker.enqueue(data);
    }

    public boolean start() {
        if (State.IDLE != this.state) {
            return false;
        }
        if (null == this.myWorker) {
            this.myWorker = new WorkerThread();
        }
        this.myWorker.start();
        this.state = State.RUNNING;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, this.getFileName() + ": started\n" + this);
        }
        return true;
    }

    public boolean stop() {
        if (State.RUNNING != this.state) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, this.myName + ": Logger already stopped");
            }
            return true;
        }
        this.state = State.IDLE;
        this.myWorker.triggerStop();
        this.myWorker = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, this.getFileName() + ": stopped");
        }
        return true;
    }

    public boolean disable() {
        block4: {
            if (State.RUNNING == this.state) {
                this.stop();
            }
            try {
                this.myChannel.close();
            }
            catch (IOException ioe) {
                FFDCFilter.processException((Throwable)ioe, this.getClass().getName() + ".disable", "124", this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Failed to close the output file: " + this.myChannel);
            }
        }
        this.state = State.DISABLED;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, this.getFileName() + ": disabled");
        }
        return true;
    }

    public boolean isStarted() {
        return State.RUNNING == this.state;
    }

    public boolean setMaximumSize(long size) {
        if (-1L > size) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, this.myName + ": Invalid file size-> " + size);
            }
            return false;
        }
        this.maxFileSize = 0L == size ? -1L : size;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, this.myName + ": Set maximum size to " + this.maxFileSize);
        }
        return true;
    }

    public long getMaximumSize() {
        return this.maxFileSize;
    }

    public int getMaximumBackupFiles() {
        return this.maxBackupFiles;
    }

    public boolean setMaximumBackupFiles(int number) {
        if (0 > number) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, this.myName + ": Invalid negative number of backup files-> " + number);
            }
            return false;
        }
        this.maxBackupFiles = number;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, this.myName + ": Set maximum files to " + this.maxBackupFiles);
        }
        return true;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(super.toString());
        buffer.append("\n  FilePathName: " + this.myFullName);
        buffer.append("\n  FileName: " + this.myName);
        buffer.append("\n  MaxFileSize: " + this.maxFileSize);
        buffer.append("\n  MaxBackupFiles: " + this.maxBackupFiles);
        buffer.append("\n  State: " + (Object)((Object)this.state));
        buffer.append("\n  Worker: " + this.myWorker);
        return buffer.toString();
    }

    private class WorkerThread
    extends Thread {
        private WorkerState workerState = WorkerState.RUNNING;
        private Object stopLock = new Object();
        private Object lock = new Object();
        private LinkedList<WsByteBuffer> queue = new LinkedList();
        private LinkedList<File> backups = null;
        private String fileinfo = null;
        private String extensioninfo = null;
        private SimpleDateFormat myFormat = null;

        protected WorkerThread() {
        }

        public void start() {
            if (0 < LoggerOffThread.this.getMaximumBackupFiles()) {
                this.myFormat = new SimpleDateFormat("_yy.MM.dd_HH.mm.ss", Locale.US);
                int index = LoggerOffThread.this.getFileName().lastIndexOf(".");
                if (-1 != index) {
                    this.fileinfo = LoggerOffThread.this.getFilePathName().substring(0, index += LoggerOffThread.this.getFilePathName().length() - LoggerOffThread.this.getFileName().length());
                    this.extensioninfo = LoggerOffThread.this.getFilePathName().substring(index);
                } else {
                    this.fileinfo = LoggerOffThread.this.getFilePathName();
                    this.extensioninfo = "";
                }
                this.backups = new LinkedList();
            }
            super.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean enqueue(WsByteBuffer buff) {
            if (WorkerState.RUNNING != this.workerState) {
                buff.release();
                return false;
            }
            Object object = this.lock;
            synchronized (object) {
                this.queue.add(buff);
                this.lock.notify();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void triggerStop() {
            Object object;
            block15: {
                if (WorkerState.RUNNING != this.workerState) {
                    return;
                }
                this.workerState = WorkerState.STOPPING;
                object = this.lock;
                synchronized (object) {
                    this.lock.notify();
                }
                try {
                    if (WorkerState.STOPPING != this.workerState) break block15;
                    object = this.stopLock;
                    synchronized (object) {
                        if (WorkerState.STOPPING == this.workerState) {
                            this.stopLock.wait(10000L);
                        }
                    }
                }
                catch (InterruptedException ie) {
                    FFDCFilter.processException((Throwable)ie, this.getClass().getName() + ".triggerStop", "201", this);
                }
            }
            object = this.lock;
            synchronized (object) {
                while (!this.queue.isEmpty()) {
                    this.queue.removeFirst().release();
                }
            }
            if (null != this.backups) {
                this.myFormat = null;
                this.backups = null;
            }
        }

        private void renameFile(File source, File target) {
            boolean rc;
            if (!source.exists()) {
                return;
            }
            if (target.exists()) {
                target.delete();
            }
            if (!(rc = source.renameTo(target)) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, LoggerOffThread.this.getFileName() + ": Unable to rename " + source + " to " + target);
            }
        }

        private void addBackup() {
            File oldest;
            String newname = this.fileinfo + this.myFormat.format(new Date(QuickApproxTime.getRef().getApproxTime())) + this.extensioninfo;
            File newFile = new File(newname);
            this.renameFile(LoggerOffThread.this.getFile(), newFile);
            if (this.backups.size() == LoggerOffThread.this.getMaximumBackupFiles() && null != (oldest = this.backups.removeLast()) && oldest.exists()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, LoggerOffThread.this.getFileName() + ": Purging oldest backup-> " + oldest.getName());
                }
                oldest.delete();
            }
            this.backups.addFirst(newFile);
        }

        private void rotate() {
            block7: {
                block6: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, LoggerOffThread.this.getFileName() + ": Rotating output log");
                    }
                    try {
                        LoggerOffThread.this.getChannel().close();
                    }
                    catch (IOException ioe) {
                        FFDCFilter.processException((Throwable)ioe, this.getClass().getName() + ".rotate", "547", this);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block6;
                        Tr.debug(tc, LoggerOffThread.this.getFileName() + ": Failed to close the output file; " + ioe);
                    }
                }
                try {
                    if (0 < LoggerOffThread.this.getMaximumBackupFiles()) {
                        this.addBackup();
                    }
                    LoggerOffThread.this.setChannel(new FileOutputStream(LoggerOffThread.this.getFile(), true).getChannel());
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, this.getClass().getName() + ".rotate", "564", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block7;
                    Tr.event(tc, LoggerOffThread.this.getFileName() + ": error in rotate; " + t);
                }
            }
        }

        private boolean isOverFileLimit(int addition) {
            if (-1L == LoggerOffThread.this.getMaximumSize()) {
                return false;
            }
            long newlen = LoggerOffThread.this.getFile().length() + (long)addition;
            return newlen > LoggerOffThread.this.getMaximumSize() || 0L > newlen;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void logData(WsByteBuffer data) {
            int bytesWritten = 0;
            int length = data.remaining();
            if (this.isOverFileLimit(length)) {
                this.rotate();
            }
            try {
                ByteBuffer buffer = data.getWrappedByteBuffer();
                while (bytesWritten < length) {
                    bytesWritten += LoggerOffThread.this.getChannel().write(buffer);
                }
            }
            catch (IOException ioe) {
                FFDCFilter.processException((Throwable)ioe, this.getClass().getName() + ".logData", "235", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, LoggerOffThread.this.getFileName() + ": error writing to log; " + ioe);
                }
            }
            finally {
                data.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            LinkedList<Object> workList = new LinkedList();
            while (true) {
                if (!this.queue.isEmpty()) {
                    object = this.lock;
                    synchronized (object) {
                        LinkedList tmpList = workList;
                        workList = this.queue;
                        this.queue = tmpList;
                    }
                    while (!workList.isEmpty()) {
                        try {
                            this.logData((WsByteBuffer)workList.removeFirst());
                        }
                        catch (Throwable t) {
                            FFDCFilter.processException(t, this.getClass().getName() + ".run", "588", this);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, LoggerOffThread.this.getFileName() + ": Unexpected exception in logData; " + t);
                        }
                    }
                }
                if (WorkerState.RUNNING != this.workerState) break;
                if (!this.queue.isEmpty()) continue;
                try {
                    Object t = this.lock;
                    synchronized (t) {
                        if (!this.queue.isEmpty()) {
                            continue;
                        }
                        this.lock.wait(10000L);
                        continue;
                    }
                }
                catch (InterruptedException ie) {
                    FFDCFilter.processException((Throwable)ie, this.getClass().getName() + ".run", "278", this);
                    continue;
                }
                break;
            }
            this.workerState = WorkerState.STOPPED;
            object = this.stopLock;
            synchronized (object) {
                this.stopLock.notify();
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            sb.append("\n    Current file size: ");
            sb.append(LoggerOffThread.this.getFile().length());
            sb.append("\n    Number of backups: ");
            sb.append(null != this.backups ? this.backups.size() : 0);
            sb.append("\n    State: ");
            sb.append((Object)this.workerState);
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum WorkerState {
        RUNNING,
        STOPPING,
        STOPPED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        IDLE,
        RUNNING,
        DISABLED;

    }
}

