/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.outbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.impl.CallbackIDs;
import com.ibm.ws.http.channel.outbound.impl.HttpOutboundServiceContextImpl;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.http.channel.exception.ExpectationFailedException;
import com.ibm.wsspi.http.channel.values.StatusCodes;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import java.io.IOException;

public class HttpOSC100ReadCallback
implements TCPReadCompletedCallback {
    private static final TraceComponent tc = Tr.register(HttpOSC100ReadCallback.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final HttpOSC100ReadCallback myInstance = new HttpOSC100ReadCallback();

    private HttpOSC100ReadCallback() {
    }

    public static final HttpOSC100ReadCallback getRef() {
        return myInstance;
    }

    private boolean handleNewData(HttpOutboundServiceContextImpl sc, VirtualConnection vc) {
        if (!sc.headersParsed()) {
            try {
                return sc.parseMessage();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".handleNewData", "73", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught exception: " + e.getMessage());
                }
                sc.setPersistent(false);
                sc.getAppWriteCallback().error(vc, e);
                return false;
            }
        }
        return true;
    }

    public void complete(VirtualConnection vc, TCPReadRequestContext rsc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "complete() called: vc=" + vc);
        }
        HttpOutboundServiceContextImpl mySC = (HttpOutboundServiceContextImpl)vc.getStateMap().get(CallbackIDs.CALLBACK_HTTPOSC);
        boolean rc = false;
        while (!rc && null != vc) {
            rc = this.handleNewData(mySC, vc);
            if (rc) continue;
            vc = rsc.read(1L, this, false, mySC.getReadTimeout());
        }
        if (rc) {
            StatusCodes status = mySC.getResponse().getStatusCode();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "100-continue scenario received " + status);
            }
            if (status.equals(StatusCodes.CONTINUE)) {
                mySC.resetRead();
                mySC.getAppWriteCallback().complete(vc);
            } else {
                mySC.setPersistent(false);
                mySC.getAppWriteCallback().error(vc, new ExpectationFailedException(status.getIntCode() + " " + mySC.getResponse().getReasonPhrase()));
            }
        }
    }

    public void error(VirtualConnection vc, TCPReadRequestContext rsc, IOException ioe) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "error() called: vc=" + vc + " ioe=" + ioe);
        }
        HttpOutboundServiceContextImpl mySC = (HttpOutboundServiceContextImpl)vc.getStateMap().get(CallbackIDs.CALLBACK_HTTPOSC);
        mySC.setPersistent(false);
        mySC.reConnect(vc, ioe);
    }
}

