/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.inbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.channel.impl.CallbackIDs;
import com.ibm.ws.http.channel.impl.HttpChannelConfig;
import com.ibm.ws.http.channel.impl.HttpObjectFactory;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundChannelFactory;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundLink;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundServiceContextImpl;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.Discriminator;
import com.ibm.wsspi.channel.base.InboundProtocolChannel;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.genericbnf.exception.MalformedMessageException;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;

public class HttpInboundChannel
extends InboundProtocolChannel
implements Discriminator {
    private static final TraceComponent tc = Tr.register(HttpInboundChannel.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final int STATE_STOPPED = 0;
    private static final int STATE_STOPPING = 1;
    private static final int STATE_RUNNING = 2;
    private HttpObjectFactory myObjectFactory = null;
    private HttpInboundChannelFactory channelFactory = null;
    private HttpChannelConfig myConfig = null;
    private int myState = 0;

    public HttpInboundChannel(ChannelData cc, HttpInboundChannelFactory cf, HttpObjectFactory of) {
        super(cc);
        this.channelFactory = cf;
        this.myObjectFactory = of;
        this.update(cc);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Created: " + this);
        }
    }

    public final Discriminator getDiscriminator() {
        return this;
    }

    public final Class getApplicationInterface() {
        return HttpInboundServiceContext.class;
    }

    public final Class getDeviceInterface() {
        return TCPConnectionContext.class;
    }

    public final Channel getChannel() {
        return this;
    }

    public final Class getDiscriminatoryDataType() {
        return WsByteBuffer.class;
    }

    public final Class getDiscriminatoryType() {
        return HttpRequestMessage.class;
    }

    public final HttpChannelConfig getHttpConfig() {
        return this.myConfig;
    }

    public final void setHttpConfig(HttpChannelConfig hcc) {
        this.myConfig = hcc;
    }

    public final HttpInboundChannelFactory getFactory() {
        return this.channelFactory;
    }

    public final HttpObjectFactory getObjectFactory() {
        return this.myObjectFactory;
    }

    public final int getWeight() {
        return this.getConfig().getDiscriminatorWeight();
    }

    public ConnectionLink getConnectionLink(VirtualConnection vc) {
        HttpInboundLink link = (HttpInboundLink)vc.getStateMap().get(CallbackIDs.CALLBACK_HTTPICL);
        if (null == link) {
            link = new HttpInboundLink(this, vc);
        }
        return link;
    }

    public boolean isRunning() {
        return 2 == this.myState;
    }

    public boolean isStopping() {
        return 2 != this.myState;
    }

    public boolean isStopped() {
        return 0 == this.myState;
    }

    private void setState(int state) {
        this.myState = state;
    }

    public void start() {
        this.setState(2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Start: " + this);
        }
    }

    public void stop(long millisec) {
        if (0L == millisec) {
            this.setState(0);
        } else {
            this.setState(1);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Stop: " + this);
        }
    }

    public void init() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "init: " + this);
        }
    }

    public void destroy() {
        this.setState(0);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "destroy: " + this);
        }
        this.channelFactory.destroyChannel(this.getConfig().getName());
        this.channelFactory = null;
        this.myConfig = null;
        this.myObjectFactory = null;
    }

    public int discriminate(VirtualConnection vc, Object discrimData) {
        WsByteBuffer[] buffs;
        if (this.isStopped()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Channel stopped, ignoring discriminate on: " + vc);
            }
            return 0;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Discriminating against " + vc + " with " + discrimData);
        }
        if (null == (buffs = (WsByteBuffer[])discrimData) || 0 == buffs.length) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "No data provided, returning MAYBE");
            }
            return -1;
        }
        HttpInboundLink link = (HttpInboundLink)vc.getStateMap().get(CallbackIDs.CALLBACK_HTTPICL);
        if (null == link) {
            link = new HttpInboundLink(this, vc);
        } else {
            link.init(vc, this);
        }
        HttpInboundServiceContextImpl mySvcCtxt = (HttpInboundServiceContextImpl)link.getChannelAccessor();
        boolean retVal = false;
        for (int i = 0; i < buffs.length && null != buffs[i]; ++i) {
            WsByteBuffer buff = buffs[i];
            int limit = buff.limit();
            int position = buff.position();
            mySvcCtxt.enableBufferModification();
            mySvcCtxt.configurePostReadBuffer(buff);
            try {
                retVal = mySvcCtxt.getRequestImpl().parseLineDiscrim(buff);
            }
            catch (MalformedMessageException mme) {
                buff.limit(limit);
                buff.position(position);
                link.destroy(null);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Discriminate returning NO for non-HTTP msg");
                }
                return 0;
            }
            catch (Exception e) {
                buff.limit(limit);
                buff.position(position);
                link.destroy(null);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unexpected exception [" + e + "]");
                    Tr.debug(tc, "Discriminate returning NO");
                }
                return 0;
            }
            mySvcCtxt.setOldLimit(buff.limit());
            if (retVal) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Discrimination returning YES");
                }
                vc.getStateMap().put(CallbackIDs.CALLBACK_HTTPICL, link);
                return 1;
            }
            buff.limit(limit);
            buff.position(position);
        }
        vc.getStateMap().put(CallbackIDs.CALLBACK_HTTPICL, link);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning MAYBE for " + vc);
        }
        return -1;
    }

    public void cleanUpState(VirtualConnection vc) {
        HttpInboundLink link = (HttpInboundLink)vc.getStateMap().get(CallbackIDs.CALLBACK_HTTPICL);
        if (null != link) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing cleanup after discrim MAYBE");
            }
            link.destroy(null);
        }
    }

    public void update(ChannelData cc) {
        this.setHttpConfig(new HttpChannelConfig(cc));
        super.setConfig(cc);
    }

    public String toString() {
        return "Inbound channel " + this.getConfig().getName() + " state=" + this.myState;
    }
}

