/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.inbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.channel.impl.CallbackIDs;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundLink;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundServiceContextImpl;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.InterChannelCallback;
import com.ibm.wsspi.channel.framework.VirtualConnection;

public class HttpIgnoreBodyCallback
implements InterChannelCallback {
    private static final TraceComponent tc = Tr.register(HttpIgnoreBodyCallback.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static HttpIgnoreBodyCallback myInstance = null;

    private HttpIgnoreBodyCallback() {
    }

    private static synchronized void createSingleton() {
        if (null == myInstance) {
            myInstance = new HttpIgnoreBodyCallback();
        }
    }

    public static final HttpIgnoreBodyCallback getRef() {
        if (null == myInstance) {
            HttpIgnoreBodyCallback.createSingleton();
        }
        return myInstance;
    }

    public void complete(VirtualConnection vc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "complete() called: " + vc);
        }
        if (null == vc) {
            return;
        }
        Object o = vc.getStateMap().get(CallbackIDs.CALLBACK_HTTPISC);
        if (null == o) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ERROR: null ISC in complete()");
            }
            return;
        }
        HttpInboundServiceContextImpl sc = (HttpInboundServiceContextImpl)o;
        try {
            VirtualConnection rc = null;
            do {
                WsByteBuffer buffer;
                if (null == (buffer = sc.getRequestBodyBuffer())) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Reached end of the body being purged");
                    }
                    sc.getLink().close(vc, null);
                    return;
                }
                buffer.release();
                rc = sc.getRequestBodyBuffer(this, false);
            } while (null != rc);
        }
        catch (Exception purgeException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception purging request body: " + purgeException);
            }
            sc.getLink().close(vc, purgeException);
        }
    }

    public void error(VirtualConnection vc, Throwable t) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "error() called: " + vc);
        }
        if (null == vc) {
            return;
        }
        Object o = vc.getStateMap().get(CallbackIDs.CALLBACK_HTTPICL);
        if (null == o) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ERROR: null ICL in error()");
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Error occurring while purging body: " + t);
        }
        ((HttpInboundLink)o).close(vc, (Exception)t);
    }
}

