/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.genericbnf.impl.GenericUtils;
import com.ibm.ws.http.channel.impl.EnumWrap;
import com.ibm.ws.http.channel.impl.HttpBaseMessageImpl;
import com.ibm.ws.http.channel.impl.HttpObjectFactory;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.genericbnf.BNFHeaders;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.genericbnf.exception.MalformedMessageException;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.genericbnf.exception.UnsupportedMethodException;
import com.ibm.wsspi.genericbnf.exception.UnsupportedProtocolVersionException;
import com.ibm.wsspi.genericbnf.exception.UnsupportedSchemeException;
import com.ibm.wsspi.http.channel.HttpChannelUtils;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import com.ibm.wsspi.http.channel.outbound.HttpOutboundServiceContext;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.http.channel.values.MethodValues;
import com.ibm.wsspi.http.channel.values.SchemeValues;
import com.ibm.wsspi.http.channel.values.VersionValues;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequestMessageImpl
extends HttpBaseMessageImpl
implements HttpRequestMessage {
    private static final TraceComponent tc = Tr.register(HttpRequestMessageImpl.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final long serialVersionUID = 5759292362534888246L;
    private static final byte LEFT_BRACKET = 91;
    private static final byte RIGHT_BRACKET = 93;
    private static final byte[] SLASH = new byte[]{47};
    private static final byte[] STAR = new byte[]{42};
    private static final int NOT_PRESENT = -1;
    private static final int NOT_TESTED = -2;
    private transient MethodValues myMethod = MethodValues.UNDEF;
    private transient SchemeValues myScheme = null;
    private byte[] myURIBytes = SLASH;
    private transient String myURIString = null;
    private byte[] myQueryBytes = null;
    private transient String sUrlHost = null;
    private transient String sHdrHost = null;
    private transient int iUrlPort = -1;
    private transient int iHdrPort = -2;
    private transient Map<String, String[]> queryParams = null;

    public HttpRequestMessageImpl() {
        this.setHeaderValidation(false);
        this.setOwner(null);
        this.setBinaryParseState(14);
    }

    public HttpRequestMessageImpl(HttpInboundServiceContext isc) {
        this.setHeaderValidation(false);
        this.setOwner(isc);
        this.setBinaryParseState(14);
    }

    public HttpRequestMessageImpl(HttpOutboundServiceContext osc) {
        this.setHeaderValidation(false);
        this.setOwner(osc);
        this.setBinaryParseState(14);
    }

    public void init(HttpInboundServiceContext sc) {
        this.setHeaderValidation(false);
        this.setOwner(sc);
        this.setBinaryParseState(14);
    }

    public void init(HttpOutboundServiceContext sc) {
        this.setHeaderValidation(false);
        this.setOwner(sc);
        this.setBinaryParseState(14);
        this.setVersion(this.getServiceContext().getHttpConfig().getOutgoingVersion());
    }

    public void init(HttpInboundServiceContext sc, BNFHeaders hdrs) {
        this.setHeaderValidation(false);
        this.setOwner(sc);
        this.setBinaryParseState(14);
        if (null != hdrs) {
            hdrs.duplicate(this);
        }
    }

    public void init(HttpOutboundServiceContext sc, BNFHeaders hdrs) {
        this.setHeaderValidation(false);
        this.setOwner(sc);
        this.setBinaryParseState(14);
        if (null != hdrs) {
            hdrs.duplicate(this);
        }
        this.setVersion(this.getServiceContext().getHttpConfig().getOutgoingVersion());
    }

    public void setOwner(HttpServiceContext hsc) {
        if (null != this.getServiceContext()) {
            this.getServiceContext().setRequestOwner(false);
        }
        if (null != hsc) {
            super.init(hsc);
            this.getServiceContext().setRequestOwner(true);
            this.setIncoming(this.getServiceContext().isInboundConnection());
        }
    }

    @Override
    public boolean isBodyExpected() {
        if (super.isBodyExpected()) {
            return this.myMethod.isBodyAllowed();
        }
        return false;
    }

    @Override
    public boolean isBodyAllowed() {
        return this.isBodyExpected();
    }

    @Override
    public void clear() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Clearing this request: " + this);
        }
        super.clear();
        this.myMethod = MethodValues.UNDEF;
        this.myScheme = null;
        this.myURIBytes = SLASH;
        this.myURIString = null;
        this.myQueryBytes = null;
        this.queryParams = null;
        this.sUrlHost = null;
        this.sHdrHost = null;
        this.iUrlPort = -1;
        this.iHdrPort = -2;
    }

    @Override
    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Destroying this request: " + this);
        }
        HttpObjectFactory tempFactory = this.getObjectFactory();
        super.destroy();
        if (null != tempFactory) {
            tempFactory.releaseRequest(this);
        }
    }

    @Override
    protected void setParsedFirstToken(byte[] token) throws Exception {
        this.setMethod(MethodValues.find(token));
    }

    @Override
    protected void setParsedSecondToken(byte[] token) throws Exception {
        this.setRequestURL(token);
    }

    @Override
    protected void setParsedThirdToken(byte[] token) throws Exception {
        this.setVersion(token);
    }

    @Override
    protected void parsingComplete() throws MalformedMessageException {
        int numTokens = this.getNumberFirstLineTokens();
        if (2 == numTokens) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Received a request without a version ID");
            }
            throw new UnsupportedProtocolVersionException("Missing version");
        }
        if (3 != numTokens) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "numFirstLineTokensRead is " + numTokens);
            }
            throw new MalformedMessageException("Received " + numTokens + " first line tokens");
        }
    }

    @Override
    protected byte[] getMarshalledFirstToken() {
        return this.myMethod.getByteArray();
    }

    @Override
    protected byte[] getMarshalledSecondToken() {
        return this.getResource();
    }

    @Override
    protected byte[] getMarshalledThirdToken() {
        return this.getVersionValue().getByteArray();
    }

    @Override
    public boolean parseBinaryFirstLine(WsByteBuffer buff) throws MalformedMessageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "parseBinaryFirstLine for " + this);
            Tr.debug(tc, "Buffer: " + buff);
        }
        if (this.getBinaryParseState() == 14) {
            if (!buff.hasRemaining()) {
                return false;
            }
            byte version = buff.get();
            if (version != 49) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unsupported binary version in message: " + version);
                }
                throw new MalformedMessageException("Invalid binary message");
            }
            this.setBinaryParseState(7);
            this.resetCacheToken(4);
        }
        boolean complete = false;
        block8: while (!complete) {
            if (!this.fillCacheToken(buff)) {
                return false;
            }
            switch (this.getBinaryParseState()) {
                case 7: {
                    int value2 = GenericUtils.asInt(this.getParsedToken());
                    if (0 == (value2 & 0x20000)) {
                        this.setMethod(MethodValues.getByOrdinal(value2));
                        this.setBinaryParseState(9);
                        this.resetCacheToken(4);
                        continue block8;
                    }
                    this.setBinaryParseState(8);
                    this.resetCacheToken(value2 & 0x1FFFF);
                    continue block8;
                }
                case 8: {
                    this.setMethod(MethodValues.find(this.getParsedToken()));
                    this.setBinaryParseState(9);
                    this.createCacheToken(4);
                    continue block8;
                }
                case 9: {
                    this.setBinaryParseState(10);
                    this.resetCacheToken(GenericUtils.asInt(this.getParsedToken()));
                    continue block8;
                }
                case 10: {
                    this.setRequestURL(this.getParsedToken());
                    this.setBinaryParseState(5);
                    this.createCacheToken(4);
                    continue block8;
                }
                case 5: {
                    int value2 = GenericUtils.asInt(this.getParsedToken());
                    if (0 == (value2 & 0x20000)) {
                        this.setVersion(VersionValues.getByOrdinal(value2));
                        this.setBinaryParseState(1);
                        this.resetCacheToken(4);
                        complete = true;
                        continue block8;
                    }
                    this.setBinaryParseState(6);
                    this.resetCacheToken(value2 & 0x1FFFF);
                    continue block8;
                }
                case 6: {
                    this.setVersion(VersionValues.find(this.getParsedToken()));
                    this.setBinaryParseState(1);
                    this.createCacheToken(4);
                    complete = true;
                    continue block8;
                }
            }
            throw new MalformedMessageException("Invalid state in first line: " + this.getBinaryParseState());
        }
        this.setFirstLineComplete(true);
        return true;
    }

    @Override
    public WsByteBuffer[] marshallLine() {
        WsByteBuffer[] firstLine = new WsByteBuffer[]{this.allocateBuffer(this.getOutgoingBufferSize())};
        firstLine = this.putBytes(this.myMethod.getByteArray(), firstLine);
        firstLine = this.putByte((byte)32, firstLine);
        firstLine = this.putBytes(this.getMarshalledSecondToken(), firstLine);
        firstLine = this.putByte((byte)32, firstLine);
        firstLine = this.putBytes(this.getVersionValue().getByteArray(), firstLine);
        firstLine = this.putBytes(BNFHeaders.EOL, firstLine);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            String url = GenericUtils.nullOutPasswords(this.getMarshalledSecondToken(), (byte)38);
            Tr.event(tc, "Marshalling first line: " + this.getMethod() + " " + url + " " + this.getVersion());
        }
        return firstLine;
    }

    @Override
    public WsByteBuffer[] marshallBinaryFirstLine() {
        WsByteBuffer[] firstLine = new WsByteBuffer[]{this.allocateBuffer(this.getOutgoingBufferSize())};
        byte[] data = null;
        firstLine = this.putByte((byte)49, firstLine);
        if (this.getMethodValue().isUndefined()) {
            data = this.myMethod.getByteArray();
            firstLine = this.putInt(data.length | 0x20000, firstLine);
            firstLine = this.putBytes(data, firstLine);
        } else {
            firstLine = this.putInt(this.myMethod.getOrdinal(), firstLine);
        }
        byte[] uri = this.getResource();
        firstLine = this.putInt(uri.length, firstLine);
        firstLine = this.putBytes(uri, firstLine);
        if (this.getVersionValue().isUndefined()) {
            data = this.getVersionValue().getByteArray();
            firstLine = this.putInt(data.length | 0x20000, firstLine);
            firstLine = this.putBytes(data, firstLine);
        } else {
            firstLine = this.putInt(this.getVersionValue().getOrdinal(), firstLine);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            String url = GenericUtils.nullOutPasswords(this.getMarshalledSecondToken(), (byte)38);
            Tr.event(tc, "Marshalling binary first line: " + this.getMethod() + " " + url + " " + this.getVersion());
        }
        return firstLine;
    }

    @Override
    public void headerComplianceCheck() throws MessageSentException {
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        if (bTrace && tc.isEntryEnabled()) {
            Tr.entry(tc, "headerComplianceCheck");
        }
        super.headerComplianceCheck();
        if (this.getServiceContext().isOutgoingBodyValid() && !this.containsHeader(HttpHeaderKeys.HDR_DATE)) {
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating a missing Date header");
            }
            this.setCurrentDate();
        }
        if (this.getVersionValue().equals(VersionValues.V11) && !this.containsHeader(HttpHeaderKeys.HDR_HOST)) {
            HttpOutboundServiceContext osc = (HttpOutboundServiceContext)((Object)this.getServiceContext());
            String data = osc.getTargetAddress().getHostname();
            if (80 != osc.getRemotePort()) {
                data = data + ":" + osc.getRemotePort();
            }
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating a missing Host header: " + data);
            }
            this.setSpecialHeader((HeaderKeys)HttpHeaderKeys.HDR_HOST, data);
        }
        if (bTrace && tc.isEntryEnabled()) {
            Tr.exit(tc, "headerComplianceCheck");
        }
    }

    @Override
    public String getMethod() {
        if (null != this.myMethod) {
            return this.myMethod.getName();
        }
        return null;
    }

    @Override
    public final MethodValues getMethodValue() {
        return this.myMethod;
    }

    @Override
    public void setMethod(String method) throws UnsupportedMethodException {
        MethodValues val = MethodValues.match(method, 0, method.length());
        if (null == val) {
            throw new UnsupportedMethodException("Illegal method " + method);
        }
        this.setMethod(val);
    }

    @Override
    public void setMethod(byte[] method) throws UnsupportedMethodException {
        MethodValues val = MethodValues.match(method, 0, method.length);
        if (null == val) {
            throw new UnsupportedMethodException("Illegal method " + GenericUtils.getEnglishString(method));
        }
        this.setMethod(val);
    }

    @Override
    public void setMethod(MethodValues method) {
        this.myMethod = method;
        super.setFirstLineChanged();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "setMethod(v): " + (null != method ? method.getName() : null));
        }
    }

    @Override
    public final String getRequestURI() {
        if (null == this.myURIString) {
            this.myURIString = GenericUtils.getEnglishString(this.myURIBytes);
        }
        return this.myURIString;
    }

    @Override
    public final byte[] getRequestURIAsByteArray() {
        return this.myURIBytes;
    }

    private String getTargetHost() {
        String host = this.getVirtualHost();
        if (null == host) {
            host = this.isIncoming() ? this.getServiceContext().getLocalAddr().getCanonicalHostName() : this.getServiceContext().getRemoteAddr().getCanonicalHostName();
        }
        return host;
    }

    private int getTargetPort() {
        int port2 = this.getVirtualPort();
        if (-1 == port2) {
            port2 = this.isIncoming() ? this.getServiceContext().getLocalPort() : this.getServiceContext().getRemotePort();
        }
        return port2;
    }

    @Override
    public StringBuffer getRequestURL() {
        StringBuffer sb = new StringBuffer(this.getScheme());
        sb.append("://");
        sb.append(this.getTargetHost());
        sb.append(":");
        sb.append(this.getTargetPort());
        sb.append(this.getRequestURI());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getRequestURL() returning " + sb.toString());
        }
        return sb;
    }

    @Override
    public final String getRequestURLAsString() {
        return this.getRequestURL().toString();
    }

    @Override
    public final byte[] getRequestURLAsByteArray() {
        return GenericUtils.getBytes(this.getRequestURL());
    }

    @Override
    public final String getURLHost() {
        return this.sUrlHost;
    }

    @Override
    public final int getURLPort() {
        return this.iUrlPort;
    }

    @Override
    public String getVirtualHost() {
        if (null != this.sUrlHost) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getVirtualHost: url host-> " + this.sUrlHost);
            }
            return this.sUrlHost;
        }
        if (null != this.sHdrHost) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getVirtualHost: hdr host-> " + this.sHdrHost);
            }
            return this.sHdrHost;
        }
        String host = this.getHeaderAsString(HttpHeaderKeys.HDR_HOST);
        if (null == host || 0 >= host.length()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getVirtualHost: No host header: [" + host + "]");
            }
            return null;
        }
        int index = -1;
        if ('[' == host.charAt(0)) {
            index = host.indexOf(93);
            if (-1 == index) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getVirtualHost: Invalid IPv6 IP, missing right bracket");
                }
                return null;
            }
            ++index;
        } else {
            index = host.indexOf(58);
        }
        if (-1 != index) {
            host = host.substring(0, index);
        }
        this.sHdrHost = host;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getVirtualHost: " + host);
        }
        return host;
    }

    @Override
    public int getVirtualPort() {
        int length;
        if (-1 != this.iUrlPort) {
            return this.iUrlPort;
        }
        if (-1 <= this.iHdrPort) {
            return this.iHdrPort;
        }
        byte[] host = this.getHeaderAsByteArray(HttpHeaderKeys.HDR_HOST);
        if (null == host) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getVirtualPort: No host header");
            }
            return -1;
        }
        this.iHdrPort = -1;
        int start = -1;
        if (91 == host[0]) {
            start = GenericUtils.byteIndexOf(host, (byte)93, 0);
            if (-1 == start) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getVirtualPort: Invalid IPV6 ip in host header");
                }
                return -1;
            }
            ++start;
        } else {
            start = GenericUtils.byteIndexOf(host, (byte)58, 0);
        }
        if (-1 == start || host.length <= start || 58 != host[start]) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getVirtualPort: No port in host header");
            }
            return -1;
        }
        if (0 >= (length = host.length - ++start)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getVirtualPort: No port after colon");
            }
            return -1;
        }
        try {
            this.iHdrPort = GenericUtils.asIntValue(host, start, length);
        }
        catch (NumberFormatException nfe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getVirtualPort: Invalid port value: " + HttpChannelUtils.getEnglishString(host, start, length));
            }
            return -1;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getVirtualPort: returning " + this.iHdrPort);
        }
        return this.iHdrPort;
    }

    private byte[] getResource() {
        byte[] resource = this.myURIBytes;
        if (this.getOutboundSCImpl().getLink().getTargetAddress().isForwardProxy()) {
            resource = this.getRequestURLAsByteArray();
        }
        if (null != this.myQueryBytes) {
            byte[] temp = resource;
            resource = new byte[temp.length + 1 + this.myQueryBytes.length];
            System.arraycopy(temp, 0, resource, 0, temp.length);
            resource[temp.length] = 63;
            System.arraycopy(this.myQueryBytes, 0, resource, temp.length + 1, this.myQueryBytes.length);
        }
        return resource;
    }

    private void parseURLHost(byte[] url, int start, int end) {
        int length = end - start;
        if (0 >= length) {
            throw new IllegalArgumentException("Missing host/port");
        }
        int name_start = start;
        int name_end = end;
        int port_start = -1;
        int port_end = -1;
        if (91 != url[name_start]) {
            int colon_index = GenericUtils.byteIndexOf(url, (byte)58, name_start, length);
            if (-1 != colon_index) {
                name_end = colon_index;
                port_start = colon_index + 1;
                port_end = end;
            }
        } else {
            int index;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "IPV6 host in the URL");
            }
            if (-1 != (index = GenericUtils.byteIndexOf(url, (byte)93, name_start, length))) {
                name_end = ++index;
                if (index < end && 58 == url[index]) {
                    port_start = index + 1;
                    port_end = end;
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "No end to the IPV6 IP");
                }
                throw new IllegalArgumentException("Invalid IPV6 IP");
            }
        }
        length = name_end - name_start;
        if (0 >= length) {
            throw new IllegalArgumentException("Hostname not present");
        }
        this.sUrlHost = GenericUtils.getEnglishString(url, name_start, name_end);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Found URL host: " + this.sUrlHost);
        }
        if (-1 != port_start && port_end > port_start) {
            length = port_end - port_start;
            this.iUrlPort = GenericUtils.asIntValue(url, port_start, length);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Defaulting URL port to match scheme: " + this.getScheme());
            }
            this.iUrlPort = SchemeValues.HTTPS.equals(this.getSchemeValue()) ? 443 : 80;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Found URL port of " + this.iUrlPort);
        }
    }

    private void parseURI(byte[] data, int start) {
        if (start >= data.length) {
            this.myURIBytes = SLASH;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Defaulting to slash since no URI data found");
            }
            return;
        }
        int uri_end = data.length;
        for (int i = start; i < data.length; ++i) {
            if (63 != data[i]) continue;
            uri_end = i;
            break;
        }
        if (start == uri_end) {
            throw new IllegalArgumentException("Missing URI: " + GenericUtils.getEnglishString(data));
        }
        if (0 == start && uri_end == data.length) {
            this.myURIBytes = data;
        } else {
            this.myURIBytes = new byte[uri_end - start];
            System.arraycopy(data, start, this.myURIBytes, 0, this.myURIBytes.length);
            if (++uri_end < data.length) {
                byte[] query = new byte[data.length - uri_end];
                System.arraycopy(data, uri_end, query, 0, query.length);
                this.setQueryString(query);
            }
        }
    }

    private void parseAuthority(byte[] data, int start) {
        if (start >= data.length) {
            throw new IllegalArgumentException("Invalid authority: " + GenericUtils.getEnglishString(data));
        }
        int host_start = start;
        int slash_start = data.length;
        for (int i = start; i < data.length; ++i) {
            if (64 == data[i]) {
                host_start = i + 1;
                continue;
            }
            if (47 != data[i]) continue;
            slash_start = i;
            break;
        }
        this.parseURLHost(data, host_start, slash_start);
        this.parseURI(data, slash_start);
    }

    private void parseScheme(byte[] data) {
        for (int i = 1; i < data.length; ++i) {
            if (58 != data[i]) continue;
            SchemeValues val = SchemeValues.match(data, 0, i);
            if (null == val) {
                throw new IllegalArgumentException("Invalid scheme inside URL: " + GenericUtils.getEnglishString(data));
            }
            this.setScheme(val);
            if (i + 2 >= data.length || 47 != data[i + 1] || 47 != data[i + 2]) {
                throw new IllegalArgumentException("Invalid net_path: " + GenericUtils.getEnglishString(data));
            }
            this.parseAuthority(data, i + 3);
            return;
        }
        throw new IllegalArgumentException("Invalid scheme in URL: " + GenericUtils.getEnglishString(data));
    }

    private boolean isAlpha(byte b) {
        if (97 <= b && 122 >= b) {
            return true;
        }
        return 65 <= b && 90 >= b;
    }

    @Override
    public void setRequestURL(String url) {
        this.setRequestURL(GenericUtils.getEnglishBytes(url));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setRequestURL(byte[] url) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "setRequestURL input [" + GenericUtils.nullOutPasswords(url, (byte)38) + "]");
        }
        if (null == url || 0 == url.length) {
            throw new IllegalArgumentException("setRequestURL: null URL");
        }
        super.setFirstLineChanged();
        this.initScheme();
        this.myURIString = null;
        this.sUrlHost = null;
        this.iUrlPort = -1;
        this.myQueryBytes = null;
        this.queryParams = null;
        if (42 == url[0]) {
            if (1 == url.length) {
                this.myURIBytes = STAR;
            } else {
                if (63 != url[1]) throw new IllegalArgumentException("Invalid leading * : " + GenericUtils.getEnglishString(url));
                this.parseURI(url, 0);
            }
        } else if (47 == url[0]) {
            if (1 == url.length) {
                this.myURIBytes = SLASH;
            } else if (47 == url[1] && this.getServiceContext().getHttpConfig().isStrictURLFormat()) {
                this.parseAuthority(url, 2);
            } else {
                this.parseURI(url, 0);
            }
        } else {
            if (!this.isAlpha(url[0])) throw new IllegalArgumentException("setRequestURL: invalid URL: " + GenericUtils.getEnglishString(url));
            this.parseScheme(url);
        }
        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) return;
        Tr.debug(tc, "setRequestURL: set URI to " + this.getRequestURI());
    }

    @Override
    public void setRequestURI(String uri) {
        this.setRequestURI(GenericUtils.getEnglishBytes(uri));
    }

    @Override
    public void setRequestURI(byte[] uri) {
        if (null == uri || 0 == uri.length) {
            throw new IllegalArgumentException("setRequestURI: null input");
        }
        super.setFirstLineChanged();
        if (42 == uri[0]) {
            if (1 != uri.length && 63 != uri[1]) {
                String value2 = GenericUtils.getEnglishString(uri);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "setRequestURI: invalid uri [" + value2 + "]");
                }
                throw new IllegalArgumentException("Invalid uri: " + value2);
            }
        } else if (47 != uri[0]) {
            String value3 = GenericUtils.getEnglishString(uri);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "setRequestURI: invalid uri [" + value3 + "]");
            }
            throw new IllegalArgumentException("Invalid uri: " + value3);
        }
        this.initScheme();
        this.myURIString = null;
        this.sUrlHost = null;
        this.iUrlPort = -1;
        this.myQueryBytes = null;
        this.queryParams = null;
        this.parseURI(uri, 0);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setRequestURI: set URI to " + this.getRequestURI());
        }
    }

    @Override
    public final SchemeValues getSchemeValue() {
        return this.myScheme;
    }

    public void initScheme() {
        if (null == this.getServiceContext().getTSC()) {
            return;
        }
        this.myScheme = this.getServiceContext().isSecure() ? SchemeValues.HTTPS : SchemeValues.HTTP;
    }

    @Override
    public String getScheme() {
        if (null == this.myScheme) {
            this.initScheme();
        }
        return this.myScheme.getName();
    }

    @Override
    public void setScheme(SchemeValues scheme) {
        this.myScheme = scheme;
        super.setFirstLineChanged();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setScheme(v): " + (null != scheme ? scheme.getName() : null));
        }
    }

    @Override
    public void setScheme(String scheme) throws UnsupportedSchemeException {
        SchemeValues val = SchemeValues.match(scheme, 0, scheme.length());
        if (null == val) {
            throw new UnsupportedSchemeException("Illegal scheme " + scheme);
        }
        this.setScheme(val);
    }

    @Override
    public void setScheme(byte[] scheme) throws UnsupportedSchemeException {
        SchemeValues val = SchemeValues.find(scheme, 0, scheme.length);
        if (null == val) {
            throw new UnsupportedSchemeException("Illegal scheme " + GenericUtils.getEnglishString(scheme));
        }
        this.setScheme(val);
    }

    @Override
    public Cookie getCookie(String name2) {
        if (null == name2) {
            return null;
        }
        Cookie cookie = this.getCookie(name2, HttpHeaderKeys.HDR_COOKIE);
        if (null == cookie) {
            cookie = this.getCookie(name2, HttpHeaderKeys.HDR_COOKIE2);
        }
        return null == cookie ? null : (Cookie)cookie.clone();
    }

    @Override
    public byte[] getCookieValue(String name2) {
        if (null == name2) {
            return null;
        }
        byte[] val = this.getCookieValue(name2, HttpHeaderKeys.HDR_COOKIE);
        if (null == val) {
            val = this.getCookieValue(name2, HttpHeaderKeys.HDR_COOKIE2);
        }
        return val;
    }

    @Override
    public List<String> getAllCookieValues(String name2) {
        LinkedList<String> list = new LinkedList<String>();
        if (null != name2) {
            this.getAllCookieValues(name2, HttpHeaderKeys.HDR_COOKIE, list);
            this.getAllCookieValues(name2, HttpHeaderKeys.HDR_COOKIE2, list);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getAllCookieValues: Found " + list.size() + " instances of " + name2);
        }
        return list;
    }

    @Override
    public List<Cookie> getAllCookies(String name2) {
        LinkedList<Cookie> list = new LinkedList<Cookie>();
        if (null != name2) {
            this.getAllCookies(name2, HttpHeaderKeys.HDR_COOKIE, list);
            this.getAllCookies(name2, HttpHeaderKeys.HDR_COOKIE2, list);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getAllCookies: Found " + list.size() + " instances of " + name2);
        }
        return list;
    }

    @Override
    public List<Cookie> getAllCookies() {
        LinkedList<Cookie> list = new LinkedList<Cookie>();
        this.getAllCookies(HttpHeaderKeys.HDR_COOKIE, list);
        this.getAllCookies(HttpHeaderKeys.HDR_COOKIE2, list);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getAllCookies: Found " + list.size() + " instances");
        }
        return list;
    }

    @Override
    public boolean setCookie(Cookie cookie, HttpHeaderKeys header2) {
        if (null == cookie || null == header2) {
            return false;
        }
        if (1 < cookie.getVersion()) {
            throw new IllegalArgumentException("Invalid cookie version: " + cookie.getVersion());
        }
        if (header2.equals(HttpHeaderKeys.HDR_COOKIE) || header2.equals(HttpHeaderKeys.HDR_COOKIE2)) {
            return this.addCookie(cookie, header2);
        }
        return false;
    }

    @Override
    public boolean setCookie(String name2, String value2, HttpHeaderKeys header2) {
        if (null == header2) {
            return false;
        }
        return this.setCookie(new Cookie(name2, value2), header2);
    }

    @Override
    public boolean removeCookie(String name2, HttpHeaderKeys header2) {
        if (null == name2 || null == header2) {
            return false;
        }
        if (header2.equals(HttpHeaderKeys.HDR_COOKIE) || header2.equals(HttpHeaderKeys.HDR_COOKIE2)) {
            return this.deleteCookie(name2, header2);
        }
        return false;
    }

    @Override
    public void debug() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Request Message: " + this);
            Tr.debug(tc, "Method: " + this.getMethod());
            Tr.debug(tc, "URL: " + this.getRequestURLAsString());
            Tr.debug(tc, "Query: " + this.getQueryString());
            Tr.debug(tc, "UrlHost: " + this.getURLHost());
            Tr.debug(tc, "UrlPort: " + this.getURLPort());
            Tr.debug(tc, "Host: " + this.getHeaderAsString(HttpHeaderKeys.HDR_HOST));
            super.debug();
        }
    }

    @Override
    public HttpRequestMessage duplicate() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Duplicating the request message: " + this);
        }
        HttpRequestMessageImpl msg = null;
        HttpObjectFactory factory = this.getObjectFactory();
        if (null == factory) {
            msg = new HttpRequestMessageImpl();
            msg.setIncoming(this.isIncoming());
        } else {
            msg = this.isIncoming() ? factory.getRequest(this.getInboundSC()) : factory.getRequest(this.getOutboundSC());
        }
        msg.setMethod(this.myMethod);
        msg.setRequestURI(this.myURIBytes);
        msg.setScheme(this.myScheme);
        msg.setQueryString(this.myQueryBytes);
        msg.iUrlPort = this.iUrlPort;
        msg.sUrlHost = this.sUrlHost;
        msg.iHdrPort = this.iHdrPort;
        msg.sHdrHost = this.sHdrHost;
        super.duplicate(msg);
        return msg;
    }

    private void deserializeMethod(ObjectInput stream) throws IOException, ClassNotFoundException {
        MethodValues method = null;
        method = -1091633150 == this.getDeserializationVersion() ? MethodValues.find(this.readByteArray(stream)) : MethodValues.find((String)stream.readObject());
        if (null == method) {
            throw new IOException("Missing method");
        }
        this.setMethod(method);
    }

    private void deserializeScheme(ObjectInput stream) throws IOException, ClassNotFoundException {
        SchemeValues scheme = null;
        if (-1091633150 == this.getDeserializationVersion()) {
            byte[] value2 = this.readByteArray(stream);
            if (null == value2) {
                throw new IOException("Missing scheme");
            }
            scheme = SchemeValues.find(value2);
        } else {
            String value3 = (String)stream.readObject();
            scheme = SchemeValues.find(value3);
        }
        this.setScheme(scheme);
    }

    @Override
    public void readExternal(ObjectInput input) throws IOException, ClassNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "De-serializing into: " + this);
        }
        super.readExternal(input);
        this.deserializeMethod(input);
        this.deserializeScheme(input);
        this.myURIBytes = this.readByteArray(input);
        this.setQueryString(this.readByteArray(input));
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Serializing: " + this);
        }
        super.writeExternal(output);
        this.writeByteArray(output, this.getMethodValue().getByteArray());
        this.writeByteArray(output, this.getSchemeValue().getByteArray());
        this.writeByteArray(output, this.getRequestURIAsByteArray());
        this.writeByteArray(output, this.getQueryStringAsByteArray());
    }

    @Override
    public void setQueryString(String query) {
        this.myQueryBytes = GenericUtils.getEnglishBytes(query);
        this.queryParams = null;
        super.setFirstLineChanged();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && null != this.myQueryBytes) {
            Tr.debug(tc, "setQueryString(String): set query to [" + GenericUtils.nullOutPasswords(this.myQueryBytes, (byte)38) + "]");
        }
    }

    @Override
    public void setQueryString(byte[] query) {
        this.myQueryBytes = query;
        this.queryParams = null;
        super.setFirstLineChanged();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && null != this.myQueryBytes) {
            Tr.debug(tc, "setQueryString(byte[]): set query to [" + GenericUtils.nullOutPasswords(this.myQueryBytes, (byte)38) + "]");
        }
    }

    @Override
    public String getQueryString() {
        return GenericUtils.getEnglishString(this.myQueryBytes);
    }

    @Override
    public final byte[] getQueryStringAsByteArray() {
        return this.myQueryBytes;
    }

    @Override
    public String getParameter(String name2) {
        String[] list = this.getParameterMap().get(name2);
        return null == list || 0 == list.length ? null : list[0];
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        if (null == this.queryParams) {
            this.parseParameters();
        }
        return this.queryParams;
    }

    @Override
    public Enumeration<String> getParameterNames() {
        return new EnumWrap(this.getParameterMap().keySet());
    }

    @Override
    public String[] getParameterValues(String name2) {
        return this.getParameterMap().get(name2);
    }

    private synchronized void parseParameters() {
        if (null != this.queryParams) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "parseParameters for " + this);
        }
        String encoding = this.getCharset().name();
        String queryString = this.getQueryString();
        if (null != queryString) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Parsing URL query data");
            }
            Map<String, String[]> urlParams = HttpChannelUtils.parseQueryString(queryString, encoding);
            if (null == this.queryParams) {
                this.queryParams = urlParams;
            } else {
                this.mergeQueryParams(urlParams);
            }
        }
        if (null == this.queryParams) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "No query data found in URL");
            }
            this.queryParams = new Hashtable<String, String[]>();
        }
    }

    private void mergeQueryParams(Map<String, String[]> urlParams) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "mergeQueryParams: " + urlParams);
        }
        if (null == urlParams) {
            return;
        }
        for (String key : urlParams.keySet()) {
            String[] post = this.queryParams.get(key);
            String[] url = urlParams.get(key);
            if (null != post) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "map already contains key " + key);
                }
                String[] newVals = new String[post.length + url.length];
                System.arraycopy(url, 0, newVals, 0, url.length);
                System.arraycopy(post, 0, newVals, url.length, post.length);
                this.queryParams.put(key, newVals);
            } else {
                this.queryParams.put(key, url);
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug(tc, "put key " + key + " into map.");
        }
    }
}

