/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.genericbnf.impl.GenericMessageImpl;
import com.ibm.ws.genericbnf.impl.GenericUtils;
import com.ibm.ws.http.channel.cookies.impl.CookieCacheData;
import com.ibm.ws.http.channel.cookies.impl.CookieHeaderByteParser;
import com.ibm.ws.http.channel.cookies.impl.CookieUtils;
import com.ibm.ws.http.channel.impl.HttpChannelConfig;
import com.ibm.ws.http.channel.impl.HttpDateFormat;
import com.ibm.ws.http.channel.impl.HttpObjectFactory;
import com.ibm.ws.http.channel.impl.HttpServiceContextImpl;
import com.ibm.ws.http.channel.impl.HttpTrailersImpl;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundServiceContextImpl;
import com.ibm.ws.http.channel.outbound.impl.HttpOutboundServiceContextImpl;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.genericbnf.exception.MalformedMessageException;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.genericbnf.exception.UnsupportedProtocolVersionException;
import com.ibm.wsspi.http.channel.HttpBaseMessage;
import com.ibm.wsspi.http.channel.HttpChannelUtils;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.http.channel.HttpTrailers;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import com.ibm.wsspi.http.channel.outbound.HttpOutboundServiceContext;
import com.ibm.wsspi.http.channel.values.ConnectionValues;
import com.ibm.wsspi.http.channel.values.ContentEncodingValues;
import com.ibm.wsspi.http.channel.values.ExpectValues;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.http.channel.values.TransferEncodingValues;
import com.ibm.wsspi.http.channel.values.VersionValues;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.Cookie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpBaseMessageImpl
extends GenericMessageImpl
implements HttpBaseMessage {
    private static final TraceComponent tc = Tr.register(HttpBaseMessageImpl.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final long serialVersionUID = -5538352173755638799L;
    private static final String HDR_LIST_SEPARATOR = ", ";
    private static final int GROWTH_SIZE = 2;
    private static final int DEFAULT_SIZE = 5;
    private static final byte QUOTE = 34;
    private static Charset DEF_CHARSET = null;
    private static final byte[] COOKIE_DELIMS = new byte[]{44, 59};
    private transient int myAge = -1;
    private transient int myContentLength = -1;
    private transient int myMaxForwards = -1;
    private transient ConnectionValues[] myConnectionVals = null;
    private transient int indexConnection = 0;
    private transient TransferEncodingValues[] myTransferVals = null;
    private transient int indexTransfer = 0;
    private transient ContentEncodingValues[] myContentEncodingVals = null;
    private transient int indexContentEncoding = 0;
    private transient boolean bIsIncoming = false;
    private transient boolean bIsKeepAliveSet = true;
    private transient boolean bIsCloseSet = false;
    private transient boolean bIsChunkedEncodingSet = false;
    private transient boolean bIs100Continue = false;
    private transient boolean bIsCommitted = false;
    private HttpTrailersImpl myTrailers = null;
    private VersionValues myVersion = VersionValues.V11;
    private transient HttpServiceContextImpl myHSC = null;
    private transient CookieCacheData cookieCache = null;
    private transient CookieCacheData cookie2Cache = null;
    private transient CookieCacheData setCookieCache = null;
    private transient CookieCacheData setCookie2Cache = null;
    private transient CookieHeaderByteParser cookieParser;
    private transient TokenDelimiter myTokenDelimiter = new TokenDelimiter();

    protected HttpBaseMessageImpl() {
        this.myConnectionVals = new ConnectionValues[5];
        this.myTransferVals = new TransferEncodingValues[5];
        this.myContentEncodingVals = new ContentEncodingValues[5];
        this.cookieParser = new CookieHeaderByteParser();
    }

    protected void init(HttpServiceContext hsc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Initializing message: " + this + " with " + hsc);
        }
        if (null == hsc) {
            return;
        }
        this.myHSC = (HttpServiceContextImpl)hsc;
        HttpChannelConfig config = this.myHSC.getHttpConfig();
        super.init(config.isDirectBufferType(), config.getOutgoingHdrBufferSize(), config.getIncomingHdrBufferSize(), config.getByteCacheSize());
        this.setLimitOfTokenSize(config.getLimitOfFieldSize());
        this.setLimitOnNumberOfHeaders(config.getLimitOnNumberOfHeaders());
    }

    @Override
    public void clear() {
        super.clear();
        this.myVersion = VersionValues.V11;
        this.cookieCache = null;
        this.cookie2Cache = null;
        this.setCookieCache = null;
        this.setCookie2Cache = null;
        this.bIsCommitted = false;
        this.bIsKeepAliveSet = true;
        this.bIsCloseSet = false;
        this.setBinaryParseState(14);
        if (null != this.myTrailers) {
            this.myTrailers.destroy();
            this.myTrailers = null;
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        HttpChannelConfig cfg = this.myHSC.getHttpConfig();
        if (null != cfg && cfg.isServantRegion()) {
            this.myHSC.getVC().getStateMap().remove("SessionPersistence");
        }
        this.myHSC = null;
        this.bIsIncoming = false;
        if (null != this.myTrailers) {
            this.myTrailers.destroy();
            this.myTrailers = null;
        }
    }

    @Override
    protected HeaderKeys findKey(byte[] data, int offset, int length) {
        return HttpHeaderKeys.find(data, offset, length);
    }

    @Override
    protected HeaderKeys findKey(byte[] name2) {
        return HttpHeaderKeys.find(name2, 0, name2.length);
    }

    @Override
    protected HeaderKeys findKey(String name2) {
        return HttpHeaderKeys.find(name2);
    }

    @Override
    protected boolean filterAdd(HeaderKeys key, byte[] value2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Adding: " + key.getName() + ":" + GenericUtils.getEnglishString(value2));
        }
        boolean rc = true;
        if (HttpHeaderKeys.HDR_CONTENT_LENGTH.equals(key)) {
            rc = this.setContentLength(value2, false);
        } else if (HttpHeaderKeys.HDR_CONNECTION.equals(key)) {
            this.matchAndParseConnection(value2);
        } else if (HttpHeaderKeys.HDR_TRANSFER_ENCODING.equals(key)) {
            this.matchAndParseTransfer(value2);
        } else if (HttpHeaderKeys.HDR_CONTENT_ENCODING.equals(key)) {
            this.matchAndParseContent(value2);
        } else if (HttpHeaderKeys.HDR_EXPECT.equals(key)) {
            this.matchAndParseExpect(value2);
        } else if (HttpHeaderKeys.HDR_AGE.equals(key)) {
            rc = this.setAge(value2, false);
        } else if (HttpHeaderKeys.HDR_MAX_FORWARDS.equals(key)) {
            rc = this.setMaxForwards(value2, false);
        }
        return rc;
    }

    @Override
    protected void filterRemove(HeaderKeys key, byte[] value2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Removing: " + key.getName() + ":" + GenericUtils.getEnglishString(value2));
        }
        if (HttpHeaderKeys.HDR_CONTENT_LENGTH.equals(key)) {
            this.myContentLength = -1;
        } else if (HttpHeaderKeys.HDR_CONNECTION.equals(key)) {
            this.removeConnectionHeader(value2);
        } else if (HttpHeaderKeys.HDR_TRANSFER_ENCODING.equals(key)) {
            this.removeTransferEncodingHeader(value2);
        } else if (HttpHeaderKeys.HDR_CONTENT_ENCODING.equals(key)) {
            this.removeContentEncodingHeader(value2);
        } else if (HttpHeaderKeys.HDR_EXPECT.equals(key)) {
            this.removeExpectHeader(value2);
        } else if (HttpHeaderKeys.HDR_AGE.equals(key)) {
            this.myAge = -1;
        } else if (HttpHeaderKeys.HDR_MAX_FORWARDS.equals(key)) {
            this.myMaxForwards = -1;
        }
    }

    @Override
    public void debug() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Version: " + this.getVersion());
            Tr.debug(tc, "Age: " + this.getAge());
            Tr.debug(tc, "MaxForwards: " + this.getMaxForwards());
            Tr.debug(tc, "ContentLength: " + this.getContentLength());
            Tr.debug(tc, "CookieCache:  " + this.getCookieCache(HttpHeaderKeys.HDR_COOKIE));
            Tr.debug(tc, "Cookie2Cache:  " + this.getCookieCache(HttpHeaderKeys.HDR_COOKIE2));
            Tr.debug(tc, "SetCookieCache:  " + this.getCookieCache(HttpHeaderKeys.HDR_SET_COOKIE));
            Tr.debug(tc, "Set2CookieCache:  " + this.getCookieCache(HttpHeaderKeys.HDR_SET_COOKIE2));
            Tr.debug(tc, "isIncoming: " + this.isIncoming());
            Tr.debug(tc, "isKeepAliveSet: " + this.isKeepAliveSet());
            Tr.debug(tc, "isCloseSet: " + this.isCloseSet());
            Tr.debug(tc, "isConnectionSet: " + this.isConnectionSet());
            Tr.debug(tc, "isChunkedEncodingSet: " + this.isChunkedEncodingSet());
            Tr.debug(tc, "isExpect100: " + this.isExpect100Continue());
            Tr.debug(tc, "isBodyAllowed: " + this.isBodyAllowed());
            Tr.debug(tc, "isBodyExcepted: " + this.isBodyExpected());
            Tr.debug(tc, "isBodyEncoded: " + this.isBodyEncoded());
            Tr.debug(tc, "Trailers: " + this.getTrailersImpl());
            if (null != this.getTrailersImpl()) {
                this.getTrailersImpl().debug();
            }
            super.debug();
        }
    }

    private void duplicateCookieCaches(HttpBaseMessageImpl msg) {
        if (null != this.cookieCache) {
            msg.cookieCache = this.cookieCache.duplicate();
        }
        if (null != this.cookie2Cache) {
            msg.cookie2Cache = this.cookie2Cache.duplicate();
        }
        if (null != this.setCookieCache) {
            msg.setCookieCache = this.setCookieCache.duplicate();
        }
        if (null != this.setCookie2Cache) {
            msg.setCookie2Cache = this.setCookie2Cache.duplicate();
        }
    }

    @Override
    public void removeAllHeaders() {
        this.cookieCache = null;
        this.cookie2Cache = null;
        this.setCookieCache = null;
        this.setCookie2Cache = null;
        super.removeAllHeaders();
    }

    protected void duplicate(HttpBaseMessageImpl msg) {
        if (null == msg) {
            throw new NullPointerException("Null message");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Duplicating the base message");
        }
        super.duplicate(msg);
        msg.setVersion(this.getVersionValue());
        if (null != this.getTrailersImpl()) {
            msg.myTrailers = this.getTrailersImpl().duplicate();
        }
        this.duplicateCookieCaches(msg);
    }

    @Override
    public void readExternal(ObjectInput input) throws IOException, ClassNotFoundException {
        boolean isTrailer;
        super.readExternal(input);
        try {
            if (-1091633150 == this.getDeserializationVersion()) {
                this.setVersion(this.readByteArray(input));
            } else {
                this.setVersion((String)input.readObject());
            }
        }
        catch (UnsupportedProtocolVersionException exc) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Unknown HTTP version");
            }
            IOException ioe = new IOException("Failed deserialization of version");
            ioe.initCause(exc);
            throw ioe;
        }
        boolean bl = -1091633150 == this.getDeserializationVersion() ? input.readBoolean() : (isTrailer = 1 == input.readByte());
        if (isTrailer) {
            this.myTrailers = (HttpTrailersImpl)input.readObject();
        }
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        this.marshallCookieCache(this.cookieCache);
        this.marshallCookieCache(this.cookie2Cache);
        this.marshallCookieCache(this.setCookieCache);
        this.marshallCookieCache(this.setCookie2Cache);
        super.writeExternal(output);
        this.writeByteArray(output, this.getVersionValue().getByteArray());
        if (null != this.myTrailers) {
            output.writeBoolean(true);
            if (output instanceof ObjectOutputStream) {
                ((ObjectOutputStream)output).writeUnshared(this.myTrailers);
            } else {
                output.writeObject(this.myTrailers);
            }
        } else {
            output.writeBoolean(false);
        }
    }

    @Override
    public boolean isIncoming() {
        return this.bIsIncoming;
    }

    public void setIncoming(boolean b) {
        this.bIsIncoming = b;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Incoming flag now " + b + " on " + this);
        }
    }

    @Override
    public boolean isCommitted() {
        return this.bIsCommitted;
    }

    @Override
    public void setCommitted() {
        this.bIsCommitted = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Committed flag set on " + this);
        }
    }

    protected void setCommitted(boolean b) {
        this.bIsCommitted = b;
    }

    @Override
    public boolean isBodyExpected() {
        if (this.isChunkedEncodingSet()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Msg says chunked encoding: " + this);
            }
            return true;
        }
        if (0 < this.getContentLength()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Msg says content-length: " + this.getContentLength() + " " + this);
            }
            return true;
        }
        if (this.isBodyEncoded()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Msg contains Content-Encoding header");
            }
            return true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "No body expected at base layer: " + this);
        }
        return false;
    }

    @Override
    public boolean isBodyAllowed() {
        return 0 != this.getContentLength();
    }

    public boolean shouldUpdateBodyHeaders() {
        return true;
    }

    protected void setMyHSC(HttpServiceContextImpl value2) {
        this.myHSC = value2;
    }

    public HttpServiceContextImpl getServiceContext() {
        return this.myHSC;
    }

    public HttpOutboundServiceContext getOutboundSC() {
        return (HttpOutboundServiceContext)((Object)this.myHSC);
    }

    public HttpInboundServiceContext getInboundSC() {
        return (HttpInboundServiceContext)((Object)this.myHSC);
    }

    public HttpOutboundServiceContextImpl getOutboundSCImpl() {
        return (HttpOutboundServiceContextImpl)this.myHSC;
    }

    public HttpInboundServiceContextImpl getInboundSCImpl() {
        return (HttpInboundServiceContextImpl)this.myHSC;
    }

    protected HttpObjectFactory getObjectFactory() {
        if (null == this.getServiceContext()) {
            return null;
        }
        return this.getServiceContext().getObjectFactory();
    }

    public HttpTrailersImpl getTrailersImpl() {
        return this.myTrailers;
    }

    public HttpTrailersImpl createTrailers() {
        if (null == this.myTrailers) {
            this.myTrailers = null == this.getObjectFactory() ? new HttpTrailersImpl() : this.getObjectFactory().getTrailers();
            this.myTrailers.init(this.shouldAllocateDirectBuffer(), this.getOutgoingBufferSize(), this.getIncomingBufferSize(), this.getByteCacheSize());
        }
        return this.myTrailers;
    }

    @Override
    public HttpTrailers getTrailers() {
        if (null == this.getTrailersImpl() && this.containsHeader(HttpHeaderKeys.HDR_TRAILER)) {
            this.createTrailers();
        }
        return this.getTrailersImpl();
    }

    @Override
    public VersionValues getVersionValue() {
        return this.myVersion;
    }

    @Override
    public String getVersion() {
        return null != this.myVersion ? this.myVersion.getName() : null;
    }

    @Override
    public void setVersion(VersionValues version) {
        if (!version.equals(this.myVersion)) {
            this.myVersion = version;
            super.setFirstLineChanged();
            if (!this.isConnectionSet() && this.getVersionValue().equals(VersionValues.V10)) {
                this.bIsKeepAliveSet = false;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "setVersion(v): set version to " + this.getVersion());
        }
    }

    @Override
    public void setVersion(String version) throws UnsupportedProtocolVersionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Called setVersion(S): " + version);
        }
        try {
            this.setVersion(VersionValues.find(version));
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedProtocolVersionException("Unsupported: " + version);
        }
    }

    @Override
    public void setVersion(byte[] version) throws UnsupportedProtocolVersionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Called setVersion(b): " + HttpChannelUtils.getEnglishString(version));
        }
        try {
            this.setVersion(VersionValues.find(version));
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedProtocolVersionException("Unsupported: " + HttpChannelUtils.getEnglishString(version));
        }
    }

    @Override
    public void setCurrentDate() {
        this.setSpecialHeader((HeaderKeys)HttpHeaderKeys.HDR_DATE, HttpDateFormat.getRef().getRFC1123TimeAsBytes(this.getServiceContext().getHttpConfig().getDateHeaderRange()));
    }

    @Override
    public void setAge(int age) {
        if (0 > age) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid Age input [" + age + "]");
            }
            return;
        }
        this.myAge = age;
        if (-1 != age) {
            this.setSpecialHeader((HeaderKeys)HttpHeaderKeys.HDR_AGE, GenericUtils.asByteArray(age));
        } else {
            this.removeSpecialHeader(HttpHeaderKeys.HDR_AGE);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setAge(i) set to " + age);
        }
    }

    @Override
    public boolean setAge(byte[] value2, boolean bCommit) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setAge(b,b): " + bCommit + " " + GenericUtils.getEnglishString(value2));
        }
        if (null == value2) {
            this.myAge = -1;
            if (bCommit) {
                this.removeSpecialHeader(HttpHeaderKeys.HDR_AGE);
            }
            return true;
        }
        try {
            int age = GenericUtils.asIntValue(value2);
            if (0 > age) {
                return false;
            }
            if (this.myAge == age) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Age already " + age);
                }
                return true;
            }
            this.myAge = age;
            if (bCommit) {
                this.setSpecialHeader((HeaderKeys)HttpHeaderKeys.HDR_AGE, value2);
            }
        }
        catch (NumberFormatException nfe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Format exception in value");
            }
            return false;
        }
        return true;
    }

    @Override
    public int getAge() {
        return this.myAge;
    }

    @Override
    public void setContentLength(int length) {
        if (0 > length) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid Content-Length input [" + length + "]");
            }
            return;
        }
        if (this.getContentLength() == length) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ContentLength already set to " + length);
            }
            return;
        }
        this.myContentLength = length;
        if (-1 != length) {
            this.setSpecialHeader((HeaderKeys)HttpHeaderKeys.HDR_CONTENT_LENGTH, GenericUtils.asByteArray(length));
        } else {
            this.removeSpecialHeader(HttpHeaderKeys.HDR_CONTENT_LENGTH);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "ContentLength set to " + length);
        }
    }

    @Override
    public boolean setContentLength(byte[] value2, boolean bCommit) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setContentLength(b,b): " + bCommit + " " + GenericUtils.getEnglishString(value2));
        }
        if (null == value2) {
            this.myContentLength = -1;
            if (bCommit) {
                this.removeSpecialHeader(HttpHeaderKeys.HDR_CONTENT_LENGTH);
            }
            return true;
        }
        try {
            int length = GenericUtils.asIntValue(value2);
            if (0 > length) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invalid Content-Length: " + length);
                }
                return false;
            }
            if (-1 != this.getContentLength()) {
                if (this.getContentLength() == length) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "setContentLength(b,b) already: " + length);
                    }
                    return true;
                }
                if (null != this.myHSC && this.myHSC.getHttpConfig().isRequestSmugglingProtectionEnabled()) {
                    this.myHSC.setPersistent(false);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "setContentLength(b,b) mismatch: " + this.getContentLength());
                }
                return false;
            }
            this.myContentLength = length;
            if (bCommit) {
                this.setSpecialHeader((HeaderKeys)HttpHeaderKeys.HDR_CONTENT_LENGTH, value2);
            }
        }
        catch (NumberFormatException nfe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Format exception in value");
            }
            return false;
        }
        return true;
    }

    @Override
    public int getContentLength() {
        return this.myContentLength;
    }

    @Override
    public void setMaxForwards(int maxforward) {
        if (0 > maxforward) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid Max-Forwards input [" + maxforward + "]");
            }
            return;
        }
        this.myMaxForwards = maxforward;
        if (-1 != maxforward) {
            this.setSpecialHeader((HeaderKeys)HttpHeaderKeys.HDR_MAX_FORWARDS, GenericUtils.asByteArray(maxforward));
        } else {
            this.removeSpecialHeader(HttpHeaderKeys.HDR_MAX_FORWARDS);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "MaxForwards set to " + maxforward);
        }
    }

    @Override
    public boolean setMaxForwards(byte[] value2, boolean bCommit) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setMaxForwards(b,b): " + bCommit + " " + GenericUtils.getEnglishString(value2));
        }
        if (null == value2) {
            this.myMaxForwards = -1;
            if (bCommit) {
                this.removeSpecialHeader(HttpHeaderKeys.HDR_MAX_FORWARDS);
            }
            return true;
        }
        try {
            int max2 = GenericUtils.asIntValue(value2);
            if (0 > max2) {
                return false;
            }
            if (this.myMaxForwards == max2) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Max-Forwards already " + max2);
                }
                return true;
            }
            this.myMaxForwards = max2;
            if (bCommit) {
                this.setSpecialHeader((HeaderKeys)HttpHeaderKeys.HDR_MAX_FORWARDS, value2);
            }
        }
        catch (NumberFormatException nfe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Format exception in value");
            }
            return false;
        }
        return true;
    }

    @Override
    public int getMaxForwards() {
        return this.myMaxForwards;
    }

    private void setupConnectionClose() {
        if (this.bIsKeepAliveSet) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Replacing Keep-Alive with Close in msg");
            }
            this.replaceConnection(ConnectionValues.KEEPALIVE, ConnectionValues.CLOSE);
            this.bIsKeepAliveSet = false;
        } else if (!VersionValues.V10.equals(this.getVersionValue())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding Close to non-persistent msg");
            }
            this.addConnection(ConnectionValues.CLOSE);
            this.commitConnection();
        }
        this.removeSpecialHeader(HttpHeaderKeys.HDR_KEEP_ALIVE);
        this.bIsCloseSet = true;
    }

    private void replaceConnection(ConnectionValues target, ConnectionValues item) {
        for (int i = 0; i < this.indexConnection; ++i) {
            if (this.myConnectionVals[i].equals(target)) {
                this.myConnectionVals[i] = item;
                this.commitConnection();
                return;
            }
            if (!this.myConnectionVals[i].equals(item)) continue;
            return;
        }
        this.addConnection(item);
        this.commitConnection();
    }

    private void addConnection(ConnectionValues item) {
        if (null == item || ConnectionValues.NOTSET.equals(item)) {
            return;
        }
        if (this.indexConnection == this.myConnectionVals.length) {
            ConnectionValues[] old = this.myConnectionVals;
            this.myConnectionVals = new ConnectionValues[old.length + 2];
            System.arraycopy(old, 0, this.myConnectionVals, 0, old.length);
        }
        if (item.equals(ConnectionValues.KEEPALIVE)) {
            this.bIsKeepAliveSet = true;
            this.bIsCloseSet = false;
        } else if (item.equals(ConnectionValues.CLOSE)) {
            this.bIsKeepAliveSet = false;
            this.bIsCloseSet = true;
        }
        this.myConnectionVals[this.indexConnection] = item;
        ++this.indexConnection;
    }

    @Override
    public void setConnection(ConnectionValues value2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setConnection(v): " + value2);
        }
        this.removeLocalConnection();
        this.addConnection(value2);
        this.commitConnection();
    }

    @Override
    public void setConnection(ConnectionValues[] values) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setConnection(v[]): " + values);
        }
        this.removeLocalConnection();
        if (null != values) {
            for (int i = 0; i < values.length; ++i) {
                this.addConnection(values[i]);
            }
        }
        this.commitConnection();
    }

    void removeConnection(ConnectionValues value2) {
        for (int i = 0; i < this.indexConnection; ++i) {
            if (!value2.equals(this.myConnectionVals[i])) continue;
            int x = i + 1;
            while (x < this.indexConnection) {
                this.myConnectionVals[i] = this.myConnectionVals[x];
                ++x;
                ++i;
            }
            this.myConnectionVals[i] = null;
            --this.indexConnection;
            if (ConnectionValues.CLOSE.equals(value2)) {
                this.bIsCloseSet = false;
            } else if (ConnectionValues.KEEPALIVE.equals(value2)) {
                this.bIsKeepAliveSet = VersionValues.V11.equals(this.myVersion);
            }
            return;
        }
    }

    private void removeLocalConnection() {
        this.bIsKeepAliveSet = VersionValues.V11.equals(this.myVersion);
        this.bIsCloseSet = false;
        for (int i = 0; i < this.indexConnection; ++i) {
            this.myConnectionVals[i] = null;
        }
        this.indexConnection = 0;
    }

    private void commitConnection() {
        if (0 == this.indexConnection) {
            this.removeSpecialHeader(HttpHeaderKeys.HDR_CONNECTION);
        } else if (1 == this.indexConnection) {
            this.setSpecialHeader((HeaderKeys)HttpHeaderKeys.HDR_CONNECTION, this.myConnectionVals[0].getName());
        } else {
            StringBuilder buff = new StringBuilder(this.myConnectionVals[0].getName());
            for (int i = 1; i < this.indexConnection; ++i) {
                buff.append(HDR_LIST_SEPARATOR);
                buff.append(this.myConnectionVals[i].getName());
            }
            this.setSpecialHeader((HeaderKeys)HttpHeaderKeys.HDR_CONNECTION, buff.toString());
        }
    }

    @Override
    public boolean setConnection(byte[] value2, boolean bCommit) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setConnection(b,b): " + bCommit + " " + GenericUtils.getEnglishString(value2));
        }
        if (null == value2) {
            this.removeLocalConnection();
            if (bCommit) {
                this.removeSpecialHeader(HttpHeaderKeys.HDR_CONNECTION);
            }
        } else {
            this.matchAndParseConnection(value2);
            if (bCommit) {
                this.setSpecialHeader((HeaderKeys)HttpHeaderKeys.HDR_CONNECTION, value2);
            }
        }
        return true;
    }

    @Override
    public void removeConnectionHeader(byte[] data) {
        if (null == data) {
            this.removeLocalConnection();
            return;
        }
        TokenDelimiter td = this.myTokenDelimiter.clear();
        while (td.next < data.length && this.findToken(data, td)) {
            this.removeConnection(ConnectionValues.find(data, td.start, td.length));
        }
    }

    private boolean findToken(byte[] data, TokenDelimiter td) {
        int end;
        int start;
        int n = start = -1 == td.next ? 0 : td.next;
        if (start >= data.length) {
            return false;
        }
        while (32 == data[start]) {
            if (++start >= data.length) {
                return false;
            }
            if (44 != data[start] || ++start < data.length) continue;
            return false;
        }
        int next = end = start + 1;
        while (end < data.length && 44 != data[end]) {
            if (32 == data[end]) {
                next = GenericUtils.skipWhiteSpace(data, end);
                if (next >= data.length || 44 == data[next]) break;
                end = next;
            }
            ++end;
            ++next;
        }
        td.start = start;
        td.next = next + 1;
        td.length = end - start;
        return true;
    }

    private void matchAndParseConnection(byte[] data) {
        if (null == data || 0 == data.length) {
            return;
        }
        TokenDelimiter td = this.myTokenDelimiter.clear();
        while (td.next < data.length && this.findToken(data, td)) {
            this.addConnection(ConnectionValues.find(data, td.start, td.length));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Parsed out " + this.indexConnection + " Connection header values");
        }
    }

    @Override
    public ConnectionValues[] getConnection() {
        if (0 == this.indexConnection) {
            return new ConnectionValues[]{ConnectionValues.NOTSET};
        }
        ConnectionValues[] list = new ConnectionValues[this.indexConnection];
        System.arraycopy(this.myConnectionVals, 0, list, 0, list.length);
        return list;
    }

    @Override
    public boolean isKeepAliveSet() {
        return this.bIsKeepAliveSet;
    }

    public boolean isCloseSet() {
        return this.bIsCloseSet;
    }

    @Override
    public boolean isConnectionSet() {
        return 0 < this.indexConnection;
    }

    public ContentEncodingValues getOutermostEncoding() {
        if (0 == this.indexContentEncoding) {
            return null;
        }
        return this.myContentEncodingVals[this.indexContentEncoding - 1];
    }

    public void removeOutermostEncoding() {
        if (0 == this.indexContentEncoding) {
            return;
        }
        --this.indexContentEncoding;
        ContentEncodingValues val = this.myContentEncodingVals[this.indexContentEncoding];
        this.myContentEncodingVals[this.indexContentEncoding] = null;
        this.commitContentEncoding();
        if (ContentEncodingValues.GZIP.equals(val)) {
            this.setSpecialHeader((HeaderKeys)HttpHeaderKeys.HDR_$WSZIP, val.getName());
        } else if (ContentEncodingValues.XGZIP.equals(val)) {
            this.setSpecialHeader((HeaderKeys)HttpHeaderKeys.HDR_$WSZIP, val.getName());
        } else if (ContentEncodingValues.DEFLATE.equals(val)) {
            this.setSpecialHeader((HeaderKeys)HttpHeaderKeys.HDR_$WSZIP, val.getName());
        }
    }

    public boolean isBodyEncoded() {
        return 0 < this.indexContentEncoding;
    }

    public boolean isDeflateOutermostEncoding() {
        return ContentEncodingValues.DEFLATE.equals(this.getOutermostEncoding());
    }

    public boolean isGZipOutermostEncoding() {
        return ContentEncodingValues.GZIP.equals(this.getOutermostEncoding());
    }

    public boolean isXGZipOutermostEncoding() {
        return ContentEncodingValues.XGZIP.equals(this.getOutermostEncoding());
    }

    private void addContentEncoding(ContentEncodingValues value2) {
        if (null == value2 || ContentEncodingValues.NOTSET.equals(value2)) {
            return;
        }
        if (this.indexContentEncoding == this.myContentEncodingVals.length) {
            ContentEncodingValues[] old = this.myContentEncodingVals;
            this.myContentEncodingVals = new ContentEncodingValues[old.length + 2];
            System.arraycopy(old, 0, this.myContentEncodingVals, 0, old.length);
        }
        this.myContentEncodingVals[this.indexContentEncoding] = value2;
        ++this.indexContentEncoding;
    }

    private void removeContentEncoding(ContentEncodingValues value2) {
        for (int i = 0; i < this.indexContentEncoding; ++i) {
            if (!value2.equals(this.myContentEncodingVals[i])) continue;
            int x = i + 1;
            while (x < this.indexContentEncoding) {
                this.myContentEncodingVals[i] = this.myContentEncodingVals[x];
                ++x;
                ++i;
            }
            this.myContentEncodingVals[i] = null;
            --this.indexContentEncoding;
            return;
        }
    }

    protected void appendContentEncoding(ContentEncodingValues value2) {
        this.addContentEncoding(value2);
        this.commitContentEncoding();
    }

    @Override
    public void setContentEncoding(ContentEncodingValues value2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setContentEncoding(v): " + value2);
        }
        this.removeLocalContentEncoding();
        this.addContentEncoding(value2);
        this.commitContentEncoding();
    }

    @Override
    public void setContentEncoding(ContentEncodingValues[] values) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setContentEncoding(v[]): " + values);
        }
        this.removeLocalContentEncoding();
        if (null != values) {
            for (int i = 0; i < values.length; ++i) {
                this.addContentEncoding(values[i]);
            }
        }
        this.commitContentEncoding();
    }

    @Override
    public boolean setContentEncoding(byte[] value2, boolean bCommit) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setContentEncoding(b,b): " + bCommit + " " + GenericUtils.getEnglishString(value2));
        }
        if (null == value2) {
            this.removeLocalContentEncoding();
            if (bCommit) {
                this.removeSpecialHeader(HttpHeaderKeys.HDR_CONTENT_ENCODING);
            }
        } else {
            this.matchAndParseContent(value2);
            if (bCommit) {
                this.setSpecialHeader((HeaderKeys)HttpHeaderKeys.HDR_CONTENT_ENCODING, value2);
            }
        }
        return true;
    }

    private void commitContentEncoding() {
        if (0 == this.indexContentEncoding) {
            this.removeSpecialHeader(HttpHeaderKeys.HDR_CONTENT_ENCODING);
        } else if (1 == this.indexContentEncoding) {
            this.setSpecialHeader((HeaderKeys)HttpHeaderKeys.HDR_CONTENT_ENCODING, this.myContentEncodingVals[0].getName());
        } else {
            StringBuilder buff = new StringBuilder(this.myContentEncodingVals[0].getName());
            for (int i = 1; i < this.indexContentEncoding; ++i) {
                buff.append(HDR_LIST_SEPARATOR);
                buff.append(this.myContentEncodingVals[i].getName());
            }
            this.setSpecialHeader((HeaderKeys)HttpHeaderKeys.HDR_CONTENT_ENCODING, buff.toString());
        }
    }

    @Override
    public void removeContentEncodingHeader(byte[] data) {
        if (null == data) {
            this.removeLocalContentEncoding();
            return;
        }
        TokenDelimiter td = this.myTokenDelimiter.clear();
        while (td.next < data.length && this.findToken(data, td)) {
            this.removeContentEncoding(ContentEncodingValues.find(data, td.start, td.length));
        }
    }

    private void removeLocalContentEncoding() {
        for (int i = 0; i < this.indexContentEncoding; ++i) {
            this.myContentEncodingVals[i] = null;
        }
        this.indexContentEncoding = 0;
    }

    private void matchAndParseContent(byte[] data) {
        if (null == data || 0 == data.length) {
            return;
        }
        TokenDelimiter td = this.myTokenDelimiter.clear();
        while (td.next < data.length && this.findToken(data, td)) {
            this.addContentEncoding(ContentEncodingValues.find(data, td.start, td.length));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Parsed out " + this.indexContentEncoding + " Content-Encoding header values");
        }
    }

    @Override
    public ContentEncodingValues[] getContentEncoding() {
        if (0 == this.indexContentEncoding) {
            return new ContentEncodingValues[]{ContentEncodingValues.NOTSET};
        }
        ContentEncodingValues[] list = new ContentEncodingValues[this.indexContentEncoding];
        System.arraycopy(this.myContentEncodingVals, 0, list, 0, list.length);
        return list;
    }

    private void addTransferEncoding(TransferEncodingValues item) {
        if (null == item || TransferEncodingValues.NOTSET.equals(item)) {
            return;
        }
        if (this.indexTransfer == this.myTransferVals.length) {
            TransferEncodingValues[] old = this.myTransferVals;
            this.myTransferVals = new TransferEncodingValues[old.length + 2];
            System.arraycopy(old, 0, this.myTransferVals, 0, old.length);
        }
        if (!this.isChunkedEncodingSet()) {
            this.bIsChunkedEncodingSet = item.equals(TransferEncodingValues.CHUNKED);
        }
        this.myTransferVals[this.indexTransfer] = item;
        ++this.indexTransfer;
    }

    protected void appendTransferEncoding(TransferEncodingValues item) {
        this.addTransferEncoding(item);
        this.commitTransferEncoding();
    }

    @Override
    public void setTransferEncoding(TransferEncodingValues value2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setTransferEncoding(v): " + value2);
        }
        this.removeLocalTransferEncoding();
        this.addTransferEncoding(value2);
        this.commitTransferEncoding();
    }

    @Override
    public void setTransferEncoding(TransferEncodingValues[] values) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setTransferEncoding(v[]): " + values);
        }
        this.removeLocalTransferEncoding();
        if (null != values) {
            for (int i = 0; i < values.length; ++i) {
                this.addTransferEncoding(values[i]);
            }
        }
        this.commitTransferEncoding();
    }

    protected void commitTransferEncoding() {
        if (0 == this.indexTransfer) {
            this.removeSpecialHeader(HttpHeaderKeys.HDR_TRANSFER_ENCODING);
        } else if (1 == this.indexTransfer) {
            this.setSpecialHeader((HeaderKeys)HttpHeaderKeys.HDR_TRANSFER_ENCODING, this.myTransferVals[0].getName());
        } else {
            StringBuilder buff = new StringBuilder(this.myTransferVals[0].getName());
            for (int i = 1; i < this.indexTransfer; ++i) {
                buff.append(HDR_LIST_SEPARATOR);
                buff.append(this.myTransferVals[i].getName());
            }
            this.setSpecialHeader((HeaderKeys)HttpHeaderKeys.HDR_TRANSFER_ENCODING, buff.toString());
        }
    }

    protected void removeTransferEncoding(TransferEncodingValues value2) {
        for (int i = 0; i < this.indexTransfer; ++i) {
            if (!value2.equals(this.myTransferVals[i])) continue;
            int x = i + 1;
            while (x < this.indexTransfer) {
                this.myTransferVals[i] = this.myTransferVals[x];
                ++x;
                ++i;
            }
            this.myTransferVals[i] = null;
            --this.indexTransfer;
            if (TransferEncodingValues.CHUNKED.equals(value2)) {
                this.bIsChunkedEncodingSet = false;
            }
            return;
        }
    }

    private void removeLocalTransferEncoding() {
        this.bIsChunkedEncodingSet = false;
        for (int i = 0; i < this.indexTransfer; ++i) {
            this.myTransferVals[i] = null;
        }
        this.indexTransfer = 0;
    }

    @Override
    public boolean setTransferEncoding(byte[] value2, boolean bCommit) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setTransferEncoding(b,b): " + bCommit + " " + GenericUtils.getEnglishString(value2));
        }
        if (null == value2) {
            this.removeLocalTransferEncoding();
            if (bCommit) {
                this.removeSpecialHeader(HttpHeaderKeys.HDR_TRANSFER_ENCODING);
            }
        } else {
            this.matchAndParseTransfer(value2);
            if (bCommit) {
                this.setSpecialHeader((HeaderKeys)HttpHeaderKeys.HDR_TRANSFER_ENCODING, value2);
            }
        }
        return true;
    }

    @Override
    public void removeTransferEncodingHeader(byte[] data) {
        if (null == data) {
            this.removeLocalTransferEncoding();
            return;
        }
        TokenDelimiter td = this.myTokenDelimiter.clear();
        while (td.next < data.length && this.findToken(data, td)) {
            this.removeTransferEncoding(TransferEncodingValues.find(data, td.start, td.length));
        }
    }

    private void matchAndParseTransfer(byte[] data) {
        if (null == data || 0 == data.length) {
            return;
        }
        TokenDelimiter td = this.myTokenDelimiter.clear();
        while (td.next < data.length && this.findToken(data, td)) {
            this.addTransferEncoding(TransferEncodingValues.find(data, td.start, td.length));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Parsed out " + this.indexTransfer + " Transfer-Encoding header values");
        }
    }

    @Override
    public TransferEncodingValues[] getTransferEncoding() {
        if (0 == this.indexTransfer) {
            return new TransferEncodingValues[]{TransferEncodingValues.NOTSET};
        }
        TransferEncodingValues[] list = new TransferEncodingValues[this.indexTransfer];
        System.arraycopy(this.myTransferVals, 0, list, 0, list.length);
        return list;
    }

    @Override
    public boolean isChunkedEncodingSet() {
        return this.bIsChunkedEncodingSet;
    }

    private void addExpect(ExpectValues value2) {
        if (ExpectValues.CONTINUE.equals(value2)) {
            this.bIs100Continue = true;
        }
    }

    private void matchAndParseExpect(byte[] data) {
        if (null == data || 0 == data.length) {
            return;
        }
        TokenDelimiter td = this.myTokenDelimiter.clear();
        while (td.next < data.length && this.findToken(data, td)) {
            this.addExpect(ExpectValues.find(data, td.start, td.length));
        }
    }

    @Override
    public void setExpect(byte[] value2) {
        this.bIs100Continue = false;
        if (null == value2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Removing Expect(b) header");
            }
            this.removeSpecialHeader(HttpHeaderKeys.HDR_EXPECT);
        } else {
            this.matchAndParseExpect(value2);
            this.setSpecialHeader((HeaderKeys)HttpHeaderKeys.HDR_EXPECT, value2);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "setExpect(b): 100-continue is " + this.isExpect100Continue());
            }
        }
    }

    @Override
    public void setExpect(String value2) {
        this.bIs100Continue = false;
        if (null == value2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Removing Expect(s) header");
            }
            this.removeSpecialHeader(HttpHeaderKeys.HDR_EXPECT);
        } else {
            this.matchAndParseExpect(GenericUtils.getEnglishBytes(value2));
            this.setSpecialHeader((HeaderKeys)HttpHeaderKeys.HDR_EXPECT, value2);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "setExpect(s): 100-continue is " + this.isExpect100Continue());
            }
        }
    }

    @Override
    public void setExpect(ExpectValues value2) {
        this.bIs100Continue = false;
        if (null == value2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Removing Expect(v) header");
            }
            this.removeSpecialHeader(HttpHeaderKeys.HDR_EXPECT);
        } else {
            this.addExpect(value2);
            this.setSpecialHeader((HeaderKeys)HttpHeaderKeys.HDR_EXPECT, value2.getByteArray());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "setExpect(v): 100-continue is " + this.isExpect100Continue());
            }
        }
    }

    @Override
    public boolean setExpect(byte[] value2, boolean bCommit) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setExpect(b,b): " + bCommit + " " + GenericUtils.getEnglishString(value2));
        }
        if (null == value2) {
            this.bIs100Continue = false;
            if (bCommit) {
                this.removeSpecialHeader(HttpHeaderKeys.HDR_EXPECT);
            }
        } else {
            this.matchAndParseExpect(value2);
            if (bCommit) {
                this.setSpecialHeader((HeaderKeys)HttpHeaderKeys.HDR_EXPECT, value2);
            }
        }
        return true;
    }

    @Override
    public void removeExpectHeader(byte[] data) {
        if (null == data) {
            this.bIs100Continue = false;
            return;
        }
        TokenDelimiter td = this.myTokenDelimiter.clear();
        while (td.next < data.length && this.findToken(data, td)) {
            if (!ExpectValues.CONTINUE.equals(ExpectValues.find(data, td.start, td.length))) continue;
            this.bIs100Continue = false;
        }
    }

    @Override
    public byte[] getExpect() {
        int size = this.getNumberOfHeaderInstances(HttpHeaderKeys.HDR_EXPECT);
        if (0 == size) {
            return null;
        }
        if (1 == size) {
            return this.getHeaderAsByteArray(HttpHeaderKeys.HDR_EXPECT);
        }
        StringBuilder buffer = new StringBuilder(this.getHeaderAsString(HttpHeaderKeys.HDR_EXPECT));
        for (int x = 1; x < size; ++x) {
            buffer.append(HDR_LIST_SEPARATOR);
            buffer.append(this.getHeaderAsString(HttpHeaderKeys.HDR_EXPECT, x));
        }
        return GenericUtils.getBytes(buffer);
    }

    @Override
    public boolean isExpect100Continue() {
        return this.bIs100Continue;
    }

    @Override
    public String getMIMEType() {
        return this.parseMIMEType();
    }

    private String parseMIMEType() {
        byte[] contentTypeBytes = this.getHeaderAsByteArray(HttpHeaderKeys.HDR_CONTENT_TYPE);
        if (null == contentTypeBytes) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "parseMIMEType: no Content-Type header present");
            }
            return null;
        }
        int length = contentTypeBytes.length;
        int end = -1;
        for (int i = 0; i < length; ++i) {
            if (59 != contentTypeBytes[i]) continue;
            end = i;
            break;
        }
        if (-1 == end) {
            end = length;
        }
        return HttpChannelUtils.getEnglishString(contentTypeBytes, 0, end);
    }

    @Override
    public void setMIMEType(String type) {
        int index = type.indexOf(";");
        StringBuilder buff = new StringBuilder();
        if (-1 != index) {
            buff.append(type.substring(0, index));
        } else {
            buff.append(type);
        }
        buff.append(";charset=");
        buff.append(this.parseCharset());
        this.setSpecialHeader((HeaderKeys)HttpHeaderKeys.HDR_CONTENT_TYPE, buff.toString());
    }

    @Override
    public Charset getCharset() {
        return this.parseCharset();
    }

    private Charset parseCharset() {
        block4: {
            String encoding = this.parseCharacterEncoding(this.getHeaderAsString(HttpHeaderKeys.HDR_CONTENT_TYPE));
            if (null != encoding) {
                try {
                    return AccessController.doPrivileged(new privCharsetLookup(encoding));
                }
                catch (UnsupportedCharsetException exc) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                    Tr.debug(tc, "Unknown charset name: " + encoding);
                }
            }
        }
        if (null == DEF_CHARSET) {
            DEF_CHARSET = AccessController.doPrivileged(new privCharsetLookup("ISO-8859-1"));
        }
        return DEF_CHARSET;
    }

    private String parseCharacterEncoding(String contentType) {
        int end;
        boolean bQuoted;
        if (null == contentType) {
            return null;
        }
        int start = contentType.indexOf("charset=");
        if (-1 == start) {
            return null;
        }
        boolean bl = bQuoted = '\"' == contentType.charAt(start += "charset=".length());
        if (bQuoted) {
            ++start;
        }
        if (-1 == (end = contentType.indexOf(59, start))) {
            end = contentType.length();
        }
        if (bQuoted && '\"' == contentType.charAt(end - 1)) {
            --end;
        }
        return contentType.substring(start, end).trim();
    }

    @Override
    public void setCharset(Charset set) {
        if (null == set) {
            throw new NullPointerException("charset");
        }
        StringBuilder buff = new StringBuilder();
        String mime = this.parseMIMEType();
        if (null == mime) {
            mime = "text/html";
        }
        buff.append(mime);
        buff.append(";charset=");
        buff.append(set.toString());
        this.setSpecialHeader((HeaderKeys)HttpHeaderKeys.HDR_CONTENT_TYPE, buff.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void headerComplianceCheck() throws MessageSentException {
        HttpServiceContextImpl sc = this.getServiceContext();
        if (sc.headersSent()) {
            throw new MessageSentException("Headers already sent.");
        }
        try {
            if (this.getVersionValue().equals(VersionValues.V11)) {
                if (-1 == this.getContentLength() && !this.isChunkedEncodingSet()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Partial bodied 1.1 output");
                    }
                    if (sc.isOutgoingBodyValid()) {
                        this.addTransferEncoding(TransferEncodingValues.CHUNKED);
                        this.commitTransferEncoding();
                    }
                }
                if (!sc.isPersistent() && !this.isCloseSet()) {
                    this.setupConnectionClose();
                }
            } else if (this.getVersionValue().equals(VersionValues.V10)) {
                if (this.isChunkedEncodingSet()) {
                    this.removeSpecialHeader(HttpHeaderKeys.HDR_TRANSFER_ENCODING);
                    this.removeLocalTransferEncoding();
                    sc.setPersistent(false);
                }
                if (!sc.isPersistent() || -1 == this.getContentLength()) {
                    if (!this.isCloseSet()) {
                        this.setupConnectionClose();
                    }
                    sc.setPersistent(false);
                } else if (sc.isPersistent() && !this.isKeepAliveSet() && !this.isCloseSet()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding Keep-Alive to persistent 1.0 msg");
                    }
                    this.addConnection(ConnectionValues.KEEPALIVE);
                    this.commitConnection();
                }
            }
            this.removeSpecialHeader(HttpHeaderKeys.HDR_$WSZIP);
            this.removeSpecialHeader(HttpHeaderKeys.HDR_$WSORIGCL);
        }
        catch (IllegalArgumentException iae) {
            try {
                FFDCFilter.processException((Throwable)iae, this.getClass().getName() + ".headerComplianceCheck", "1996", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Too many headers in message for compliance to finish");
                }
                if (!sc.getHttpConfig().isServantRegion()) return;
            }
            catch (Throwable throwable) {
                if (!sc.getHttpConfig().isServantRegion()) throw throwable;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Running on z/OS SR, persistence: " + sc.isPersistent());
                }
                sc.getVC().getStateMap().put("SessionPersistence", sc.isPersistent() ? "true" : "false");
                sc.setPersistent(false);
                throw throwable;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Running on z/OS SR, persistence: " + sc.isPersistent());
            }
            sc.getVC().getStateMap().put("SessionPersistence", sc.isPersistent() ? "true" : "false");
            sc.setPersistent(false);
            return;
        }
        if (!sc.getHttpConfig().isServantRegion()) return;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Running on z/OS SR, persistence: " + sc.isPersistent());
        }
        sc.getVC().getStateMap().put("SessionPersistence", sc.isPersistent() ? "true" : "false");
        sc.setPersistent(false);
        return;
    }

    @Override
    protected void parsingComplete() throws MalformedMessageException {
    }

    public abstract WsByteBuffer[] marshallBinaryFirstLine();

    public WsByteBuffer[] marshallBinaryMessage() throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "marshallBinaryMessage");
        }
        this.preMarshallMessage();
        WsByteBuffer[] marshalledObj = this.marshallBinaryFirstLine();
        this.headerComplianceCheck();
        marshalledObj = this.marshallBinaryHeaders(marshalledObj);
        this.postMarshallMessage();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "marshallBinaryMessage");
        }
        return marshalledObj;
    }

    @Override
    public boolean parseMessage(WsByteBuffer buffer, boolean bExtract) throws Exception {
        int excess;
        boolean rc;
        this.myHSC.checkIncomingMessageLimit(buffer.remaining());
        boolean bl = rc = this.myHSC.getHttpConfig().isBinaryTransportEnabled() ? this.parseBinaryMessage(buffer) : super.parseMessage(buffer, bExtract);
        if (rc && 0 < (excess = buffer.remaining())) {
            this.myHSC.addToIncomingMsgSize(-excess);
        }
        return rc;
    }

    public boolean parseLineDiscrim(WsByteBuffer buffer) throws Exception {
        this.getServiceContext().checkIncomingMessageLimit(buffer.remaining());
        if (this.getServiceContext().getHttpConfig().isBinaryTransportEnabled()) {
            return this.parseBinaryFirstLine(buffer);
        }
        return this.parseLine(buffer);
    }

    public abstract boolean parseBinaryFirstLine(WsByteBuffer var1) throws MalformedMessageException;

    public boolean parseBinaryMessage(WsByteBuffer buff) throws Exception {
        boolean rc = false;
        if (!this.isFirstLineComplete()) {
            rc = this.parseBinaryFirstLine(buff);
        }
        if (this.isFirstLineComplete()) {
            rc = this.parseBinaryHeaders(buff, HttpHeaderKeys.HDR_$WSAT);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "parseBinaryMessage returning " + rc);
        }
        return rc;
    }

    private void marshallCookieCache(CookieCacheData cache) {
        if (null != cache && cache.isDirty()) {
            HttpHeaderKeys type = cache.getHeaderType();
            this.parseAllCookies(cache, type);
            this.removeSpecialHeader(type);
            this.marshallCookies(cache.getParsedList(), type);
            cache.setIsDirty(false);
        }
    }

    protected boolean isCookieCacheDirty(HeaderKeys key) {
        if (HttpHeaderKeys.HDR_SET_COOKIE.equals(key)) {
            return null != this.setCookieCache ? this.setCookieCache.isDirty() : false;
        }
        if (HttpHeaderKeys.HDR_SET_COOKIE2.equals(key)) {
            return null != this.setCookie2Cache ? this.setCookie2Cache.isDirty() : false;
        }
        if (HttpHeaderKeys.HDR_COOKIE.equals(key)) {
            return null != this.cookieCache ? this.cookieCache.isDirty() : false;
        }
        if (HttpHeaderKeys.HDR_COOKIE2.equals(key)) {
            return null != this.cookie2Cache ? this.cookie2Cache.isDirty() : false;
        }
        return false;
    }

    @Override
    protected void preMarshallMessage() throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "preMarshallMessage");
        }
        super.preMarshallMessage();
        this.marshallCookieCache(this.cookieCache);
        this.marshallCookieCache(this.cookie2Cache);
        this.marshallCookieCache(this.setCookieCache);
        this.marshallCookieCache(this.setCookie2Cache);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "preMarshallMessage");
        }
    }

    protected byte[] getCookieValue(String name2, HttpHeaderKeys hdr) {
        int num = this.getNumberOfHeaderInstances(hdr);
        if (0 == num) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Header not present (" + hdr.getName() + ")");
            }
            return null;
        }
        if (null == name2 || 0 == name2.length()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getCookieValue: invalid name [" + name2 + "]");
            }
            return null;
        }
        String targetName = name2;
        if ('\"' == name2.charAt(0) && '\"' == name2.charAt(name2.length() - 1)) {
            targetName = name2.substring(1, name2.length() - 1);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getCookieValue: [" + targetName + "] num: " + num);
        }
        int index = 0;
        boolean bQuoted = false;
        for (int i = 0; i < num; ++i) {
            byte[] data = this.getHeaderAsByteArray(hdr, i);
            while (index < data.length) {
                int x;
                if (32 == data[index] && (index = GenericUtils.skipWhiteSpace(data, index)) >= data.length) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Ran out of data");
                    continue;
                }
                boolean bl = bQuoted = 34 == data[index];
                if (bQuoted) {
                    ++index;
                }
                for (x = 0; x < targetName.length() && targetName.charAt(x) == data[index]; ++x) {
                    if (++index < data.length) continue;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Only the cookie name found");
                    }
                    return null;
                }
                if (x != targetName.length()) {
                    index = GenericUtils.skipToChars(data, index, COOKIE_DELIMS) + 1;
                    continue;
                }
                if (bQuoted) {
                    if (34 != data[index]) {
                        index = GenericUtils.skipToChars(data, index, COOKIE_DELIMS) + 1;
                        continue;
                    }
                    ++index;
                }
                if (index < data.length && 32 == data[index]) {
                    index = GenericUtils.skipWhiteSpace(data, index);
                }
                if (index < data.length && 61 != data[index]) {
                    index = GenericUtils.skipToChars(data, index, COOKIE_DELIMS) + 1;
                    continue;
                }
                if (++index >= data.length) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Cookie name found but no value after =");
                    }
                    return null;
                }
                if (32 == data[index] && (index = GenericUtils.skipWhiteSpace(data, index)) >= data.length) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Cookie name with just whitespace val");
                    }
                    return null;
                }
                bQuoted = 34 == data[index];
                int start = index++;
                if (bQuoted) {
                    while (index < data.length && 34 != data[index] && 44 != data[index] && 59 != data[index]) {
                        ++index;
                    }
                    if (index < data.length && 34 == data[index]) {
                        ++index;
                    }
                } else {
                    while (index < data.length && 59 != data[index] && 44 != data[index]) {
                        if (32 == data[index]) {
                            int i2 = GenericUtils.skipWhiteSpace(data, index);
                            if (i2 >= data.length || 59 == data[i2] || 44 == data[i2]) break;
                            index = i2;
                        }
                        ++index;
                    }
                }
                if (start >= index) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "No actual value found");
                    }
                    return null;
                }
                byte[] value2 = new byte[index - start];
                System.arraycopy(data, start, value2, 0, value2.length);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getCookieValue: returning [" + GenericUtils.getEnglishString(value2) + "]");
                }
                return value2;
            }
            index = 0;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Cookie name not found");
        }
        return null;
    }

    protected void getAllCookieValues(String name2, HttpHeaderKeys header2, List<String> list) {
        if (!this.cookieCacheExists(header2) && !this.containsHeader(header2)) {
            return;
        }
        CookieCacheData cache = this.getCookieCache(header2);
        this.parseAllCookies(cache, header2);
        cache.getAllCookieValues(name2, list);
    }

    protected Cookie getCookie(String name2, HttpHeaderKeys header2) {
        CookieCacheData cache = this.getCookieCache(header2);
        Cookie cookie2 = cache.getCookie(name2);
        if (null != cookie2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Found " + name2 + " in cache");
            }
            return cookie2;
        }
        int end = this.getNumberOfHeaderInstances(header2);
        for (int i = cache.getHeaderIndex(); i < end; ++i) {
            List<Cookie> list = this.getCookieParser().parse(this.getHeaderAsByteArray(header2, i), header2);
            cache.addParsedCookies(list);
            cache.incrementHeaderIndex();
            for (Cookie cookie2 : list) {
                if (!cookie2.getName().equals(name2)) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found parsed Cookie-->" + name2);
                }
                return cookie2;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getCookie --> " + name2 + " of type " + header2.getName() + " not found");
        }
        return null;
    }

    private void parseAllCookies(CookieCacheData cache, HttpHeaderKeys header2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Parsing all cookies for " + header2.getName());
        }
        int end = this.getNumberOfHeaderInstances(header2);
        for (int i = cache.getHeaderIndex(); i < end; ++i) {
            List<Cookie> list = this.getCookieParser().parse(this.getHeaderAsByteArray(header2, i), header2);
            cache.addParsedCookies(list);
            cache.incrementHeaderIndex();
        }
    }

    protected void getAllCookies(HttpHeaderKeys header2, List<Cookie> list) {
        if (!this.cookieCacheExists(header2) && !this.containsHeader(header2)) {
            return;
        }
        CookieCacheData cache = this.getCookieCache(header2);
        this.parseAllCookies(cache, header2);
        cache.getAllCookies(list);
    }

    protected void getAllCookies(String name2, HttpHeaderKeys header2, List<Cookie> list) {
        if (!this.cookieCacheExists(header2) && !this.containsHeader(header2)) {
            return;
        }
        CookieCacheData cache = this.getCookieCache(header2);
        this.parseAllCookies(cache, header2);
        cache.getAllCookies(name2, list);
    }

    protected boolean addCookie(Cookie cookie, HttpHeaderKeys cookieType) {
        if (this.isCommitted()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Not adding cookie to committed message: " + cookie.getName() + " " + cookieType.getName());
            }
            return false;
        }
        this.getCookieCache(cookieType).addNewCookie((Cookie)cookie.clone());
        return true;
    }

    private CookieHeaderByteParser getCookieParser() {
        if (null == this.cookieParser) {
            this.cookieParser = new CookieHeaderByteParser();
        }
        return this.cookieParser;
    }

    protected boolean cookieCacheExists(HttpHeaderKeys header2) {
        if (header2.equals(HttpHeaderKeys.HDR_COOKIE)) {
            return null != this.cookieCache;
        }
        if (header2.equals(HttpHeaderKeys.HDR_COOKIE2)) {
            return null != this.cookie2Cache;
        }
        if (header2.equals(HttpHeaderKeys.HDR_SET_COOKIE)) {
            return null != this.setCookieCache;
        }
        if (header2.equals(HttpHeaderKeys.HDR_SET_COOKIE2)) {
            return null != this.setCookie2Cache;
        }
        return false;
    }

    private CookieCacheData getCookieCache(HttpHeaderKeys header2) {
        if (header2.equals(HttpHeaderKeys.HDR_COOKIE)) {
            if (null == this.cookieCache) {
                this.cookieCache = new CookieCacheData(header2);
                if (!this.isIncoming()) {
                    this.parseAllCookies(this.cookieCache, header2);
                }
            }
            return this.cookieCache;
        }
        if (header2.equals(HttpHeaderKeys.HDR_COOKIE2)) {
            if (null == this.cookie2Cache) {
                this.cookie2Cache = new CookieCacheData(header2);
                if (!this.isIncoming()) {
                    this.parseAllCookies(this.cookie2Cache, header2);
                }
            }
            return this.cookie2Cache;
        }
        if (header2.equals(HttpHeaderKeys.HDR_SET_COOKIE)) {
            if (null == this.setCookieCache) {
                this.setCookieCache = new CookieCacheData(header2);
                if (!this.isIncoming()) {
                    this.parseAllCookies(this.setCookieCache, header2);
                }
            }
            return this.setCookieCache;
        }
        if (header2.equals(HttpHeaderKeys.HDR_SET_COOKIE2)) {
            if (null == this.setCookie2Cache) {
                this.setCookie2Cache = new CookieCacheData(header2);
                if (!this.isIncoming()) {
                    this.parseAllCookies(this.setCookie2Cache, header2);
                }
            }
            return this.setCookie2Cache;
        }
        throw new IllegalArgumentException(header2.getName());
    }

    protected boolean deleteCookie(String name2, HttpHeaderKeys header2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteCookie: " + name2);
        }
        boolean rc = false;
        if (this.isCommitted()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Not removing committed cookie: " + name2);
            }
        } else {
            Cookie cookie = this.getCookie(name2, header2);
            if (null != cookie) {
                rc = this.getCookieCache(header2).removeCookie(cookie);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteCookie: " + rc);
        }
        return rc;
    }

    @Override
    public boolean containsCookie(String name2, HttpHeaderKeys header2) {
        if (null == name2 || null == header2) {
            return false;
        }
        return null != this.getCookie(name2, header2);
    }

    private void marshallCookies(List<Cookie> list, HeaderKeys header2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "marshallCookies");
        }
        Iterator<Cookie> it = list.iterator();
        while (it.hasNext()) {
            this.appendHeader(header2, CookieUtils.toString(it.next(), header2));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "marshallCookies");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class privCharsetLookup
    implements PrivilegedAction<Charset> {
        private String encoding;

        public privCharsetLookup(String enc) {
            this.encoding = enc;
        }

        @Override
        public Charset run() {
            return Charset.forName(this.encoding);
        }
    }

    protected class TokenDelimiter {
        protected int start = -1;
        protected int length = -1;
        protected int next = -1;

        protected TokenDelimiter() {
        }

        protected TokenDelimiter clear() {
            this.start = -1;
            this.length = -1;
            this.next = -1;
            return this;
        }
    }
}

