/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.cookies.impl;

import com.ibm.ws.http.channel.impl.HTTPChannelDM;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.Cookie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieCacheData {
    private List<Cookie> parsedList = null;
    private int hdrIndex = 0;
    private HttpHeaderKeys headerType;
    private boolean isDirty = false;

    private CookieCacheData() {
    }

    public CookieCacheData(HttpHeaderKeys header2) {
        this.headerType = header2;
        this.parsedList = new LinkedList<Cookie>();
    }

    public HttpHeaderKeys getHeaderType() {
        return this.headerType;
    }

    public int getHeaderIndex() {
        return this.hdrIndex;
    }

    public void incrementHeaderIndex() {
        ++this.hdrIndex;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setIsDirty(boolean flag) {
        this.isDirty = flag;
    }

    public Cookie getCookie(String name2) {
        if (null == name2 || 0 == this.parsedList.size()) {
            return null;
        }
        Cookie cookie2 = null;
        for (Cookie cookie2 : this.parsedList) {
            if (!cookie2.getName().equals(name2)) continue;
            return cookie2;
        }
        return null;
    }

    public int getAllCookies(String name2, List<Cookie> list) {
        int added = 0;
        if (0 < this.parsedList.size() && null != name2) {
            Cookie cookie2 = null;
            for (Cookie cookie2 : this.parsedList) {
                if (!cookie2.getName().equals(name2)) continue;
                list.add((Cookie)cookie2.clone());
                ++added;
            }
        }
        return added;
    }

    public int getAllCookies(List<Cookie> list) {
        int added = 0;
        if (0 < this.parsedList.size()) {
            Iterator<Cookie> it = this.parsedList.iterator();
            while (it.hasNext()) {
                list.add((Cookie)it.next().clone());
                ++added;
            }
        }
        return added;
    }

    public int getAllCookieValues(String name2, List<String> list) {
        int added = 0;
        if (0 < this.parsedList.size() && null != name2) {
            Iterator<Cookie> it = this.parsedList.iterator();
            Cookie cookie = null;
            while (it.hasNext()) {
                cookie = it.next();
                if (!name2.equals(cookie.getName())) continue;
                list.add(cookie.getValue());
            }
        }
        return added;
    }

    public List<Cookie> getParsedList() {
        return this.parsedList;
    }

    public void addParsedCookie(Cookie cookie) {
        this.parsedList.add(cookie);
    }

    public void addParsedCookies(List<Cookie> list) {
        this.parsedList.addAll(list);
    }

    public void addNewCookie(Cookie cookie) {
        this.isDirty = true;
        this.parsedList.add(cookie);
    }

    public void addNewCookies(List<Cookie> list) {
        this.isDirty = true;
        this.parsedList.addAll(list);
    }

    public boolean removeCookie(Cookie cookie) {
        this.isDirty = true;
        return this.parsedList.remove(cookie);
    }

    public CookieCacheData duplicate() {
        CookieCacheData cData = new CookieCacheData();
        cData.parsedList = this.copyList(this.parsedList);
        cData.isDirty = this.isDirty;
        cData.hdrIndex = this.hdrIndex;
        cData.headerType = this.headerType;
        return cData;
    }

    private List<Cookie> copyList(List<Cookie> originalList) {
        LinkedList<Cookie> list = new LinkedList<Cookie>();
        Iterator<Cookie> it = originalList.iterator();
        while (it.hasNext()) {
            list.add((Cookie)it.next().clone());
        }
        return list;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(HTTPChannelDM.LINE_SEPARATOR);
        sb.append("headerType=");
        sb.append(this.headerType.getName());
        sb.append(HTTPChannelDM.LINE_SEPARATOR);
        sb.append("headerIndex=");
        sb.append(this.hdrIndex);
        sb.append(HTTPChannelDM.LINE_SEPARATOR);
        sb.append("isDirty =");
        sb.append(this.isDirty);
        sb.append(HTTPChannelDM.LINE_SEPARATOR);
        sb.append("parsedList=");
        this.printCookieList(sb, this.parsedList);
        sb.append(HTTPChannelDM.LINE_SEPARATOR);
        return sb.toString();
    }

    private void printCookieList(StringBuilder sb, List<Cookie> list) {
        if (null == list) {
            sb.append("null");
            return;
        }
        Cookie cookie2 = null;
        for (Cookie cookie2 : list) {
            sb.append(HTTPChannelDM.LINE_SEPARATOR);
            sb.append(" Name: ");
            sb.append(cookie2.getName());
            sb.append(" Value: ");
            sb.append(cookie2.getValue());
            sb.append(" Path: ");
            sb.append(cookie2.getPath());
            sb.append(HTTPChannelDM.LINE_SEPARATOR);
            sb.append(" Version: ");
            sb.append(cookie2.getVersion());
            sb.append(HTTPChannelDM.LINE_SEPARATOR);
            sb.append(" Domain: ");
            sb.append(cookie2.getDomain());
            sb.append(HTTPChannelDM.LINE_SEPARATOR);
            sb.append(" Max-Age: ");
            sb.append(cookie2.getMaxAge());
            sb.append(HTTPChannelDM.LINE_SEPARATOR);
            sb.append(" Comment: ");
            sb.append(cookie2.getComment());
            sb.append(HTTPChannelDM.LINE_SEPARATOR);
        }
    }
}

