/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ffdc;

import com.ibm.ws.ffdc.DiagnosticModule;
import com.ibm.ws.ffdc.FFDC;
import com.ibm.ws.ffdc.IncidentStream;
import com.ibm.ws.ffdc.IntrospectionLevel;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public final class IncidentStreamImpl
implements IncidentStream {
    public static final String $sccsid = "@(#) 1.3 SERV1/ws/code/ras.lite/src/com/ibm/ws/ffdc/IncidentStreamImpl.java, WAS.ras.lite, WAS70.SERV1, q0834.18 07/10/03 10:00:01 [8/27/08 16:06:20]";
    private static final int DEFAULT_DEPTH = 1;
    private static final int DEFAULT_MAX_SIZE = 0x100000;
    private static final String EQUALS = " = ";
    private PrintStream ps;
    private boolean _createdPrintStream;

    public IncidentStreamImpl(final String ffdcFileName) {
        try {
            FileOutputStream fos = AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                @Override
                public FileOutputStream run() throws FileNotFoundException {
                    return new FileOutputStream(ffdcFileName, true);
                }
            });
            this.ps = new PrintStream(fos, true);
            this._createdPrintStream = true;
        }
        catch (PrivilegedActionException e) {
            this.ps = System.err;
            this._createdPrintStream = false;
            this.processIncident(e.getClass().getName(), "com.ibm.ws.ffdc.IncidentStreamImpl", "1", e, this, new Object[]{ffdcFileName});
        }
    }

    public void introspectAndWrite(String text, Object value2) {
        this.ps.println(text);
        this.introspect(value2, 1, 0x100000);
    }

    public void introspectAndWrite(String text, Object value2, int depth) {
        this.ps.println(text);
        this.introspect(value2, depth, 0x100000);
    }

    public void introspectAndWrite(String text, Object value2, int depth, int maxBytes) {
        this.ps.println(text);
        this.introspect(value2, depth, maxBytes);
    }

    public void introspectAndWriteLine(String text, Object value2) {
        this.introspectAndWrite(text, value2);
        this.ps.println();
    }

    public void introspectAndWriteLine(String text, Object value2, int depth) {
        this.introspectAndWrite(text, value2, depth);
        this.ps.println();
    }

    public void introspectAndWriteLine(String text, Object value2, int depth, int maxBytes) {
        this.introspectAndWrite(text, value2, depth, maxBytes);
        this.ps.println();
    }

    public void write(String text, boolean value2) {
        this.printValueIntro(text);
        this.ps.print(value2);
    }

    public void write(String text, byte value2) {
        this.printValueIntro(text);
        this.ps.print(value2);
    }

    public void write(String text, char value2) {
        this.printValueIntro(text);
        this.ps.print(value2);
    }

    public void write(String text, short value2) {
        this.printValueIntro(text);
        this.ps.print(value2);
    }

    public void write(String text, int value2) {
        this.printValueIntro(text);
        this.ps.print(value2);
    }

    public void write(String text, long value2) {
        this.printValueIntro(text);
        this.ps.print(value2);
    }

    public void write(String text, float value2) {
        this.printValueIntro(text);
        this.ps.print(value2);
    }

    public void write(String text, double value2) {
        this.printValueIntro(text);
        this.ps.print(value2);
    }

    public void write(String text, String value2) {
        this.printValueIntro(text);
        this.ps.print(value2);
    }

    public void write(String text, Object value2) {
        this.printValueIntro(text);
        this.ps.print(value2);
    }

    private void printValueIntro(String text) {
        if (text != null) {
            this.ps.print(text);
            this.ps.print(EQUALS);
        }
    }

    public void writeLine(String text, boolean value2) {
        this.write(text, value2);
        this.ps.println();
    }

    public void writeLine(String text, byte value2) {
        this.write(text, value2);
        this.ps.println();
    }

    public void writeLine(String text, char value2) {
        this.write(text, value2);
        this.ps.println();
    }

    public void writeLine(String text, short value2) {
        this.write(text, value2);
        this.ps.println();
    }

    public void writeLine(String text, int value2) {
        this.write(text, value2);
        this.ps.println();
    }

    public void writeLine(String text, long value2) {
        this.write(text, value2);
        this.ps.println();
    }

    public void writeLine(String text, float value2) {
        this.write(text, value2);
        this.ps.println();
    }

    public void writeLine(String text, double value2) {
        this.write(text, value2);
        this.ps.println();
    }

    public void writeLine(String text, String value2) {
        this.write(text, value2);
        this.ps.println();
    }

    public void writeLine(String text, Object value2) {
        this.write(text, value2);
        this.ps.println();
    }

    private void introspect(Object value2, int max_depth, int max_size) {
        if (value2 == null) {
            this.ps.print("null");
        } else {
            int actualDepth;
            IntrospectionLevel rootLevel;
            IntrospectionLevel currentLevel = rootLevel = new IntrospectionLevel(value2);
            IntrospectionLevel nextLevel = rootLevel.getNextLevel();
            int totalBytes = currentLevel.getNumberOfBytesinJustThisLevel();
            for (actualDepth = 0; actualDepth < max_depth && nextLevel.hasMembers() && totalBytes <= max_size; totalBytes += currentLevel.getNumberOfBytesinJustThisLevel(), ++actualDepth) {
                totalBytes -= currentLevel.getNumberOfBytesinJustThisLevel();
                totalBytes += currentLevel.getNumberOfBytesInAllLevelsIncludingThisOne();
                currentLevel = nextLevel;
                nextLevel = nextLevel.getNextLevel();
            }
            boolean exceededMaxBytes = false;
            if (totalBytes > max_size && actualDepth > 0) {
                --actualDepth;
                exceededMaxBytes = true;
            }
            rootLevel.print(this, actualDepth);
            if (exceededMaxBytes) {
                this.ps.println("Only " + actualDepth + " levels of object introspection were performed because performing the next level would have exceeded the specified maximum bytes of " + max_size);
            }
        }
    }

    public void close() {
        if (this._createdPrintStream) {
            this.ps.close();
        }
    }

    void processIncident(String txt, String sourceId, String probeId, Throwable th, Object callerThis, Object[] objectArray) {
        this.write("------Start of DE processing------", IncidentStreamImpl.formatTime());
        this.writeLine(", key", txt);
        this.writeLine("Exception", th.getClass().getName());
        this.writeLine("Source", sourceId);
        this.writeLine("probeid", probeId);
        this.writeLine("Stack Dump", IncidentStreamImpl.getStackTrace(th));
        StackTraceElement[] exceptionCallStack = th.getStackTrace();
        int commonIndex = IncidentStreamImpl.compare(exceptionCallStack);
        Map<String, DiagnosticModule> modules = FFDC.getDiagnosticModuleMap();
        boolean foundAnyDM = false;
        if (commonIndex != -1) {
            boolean tryNextDM = true;
            String[] dmsCallStack = IncidentStreamImpl.getCallStackFromStackTraceElement(exceptionCallStack);
            for (int i = commonIndex; i < exceptionCallStack.length && tryNextDM; ++i) {
                String packageName = IncidentStreamImpl.getPackageName(exceptionCallStack[i].getClassName());
                while (packageName.length() != 0 && tryNextDM) {
                    int lastDot;
                    DiagnosticModule module = modules.get(packageName);
                    if (module != null) {
                        if (!foundAnyDM) {
                            this.introspectAndWriteLine("Dump of callerThis", callerThis, 0);
                        }
                        foundAnyDM = true;
                        tryNextDM = module.dumpComponentData(new String[0], th, this, callerThis, objectArray, sourceId, dmsCallStack);
                    }
                    if ((lastDot = packageName.lastIndexOf(46)) == -1) {
                        packageName = "";
                        continue;
                    }
                    packageName = packageName.substring(0, lastDot);
                }
            }
        }
        if (!foundAnyDM) {
            this.introspectAndWriteLine("Dump of callerThis", callerThis, 3);
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    this.introspectAndWriteLine("Dump of objectArray[" + i + "]", objectArray[i], 3);
                }
            }
        }
    }

    private static String[] getCallStackFromStackTraceElement(StackTraceElement[] exceptionCallStack) {
        if (exceptionCallStack == null) {
            return null;
        }
        String[] answer = new String[exceptionCallStack.length];
        for (int i = 0; i < exceptionCallStack.length; ++i) {
            answer[exceptionCallStack.length - 1 - i] = exceptionCallStack[i].getClassName();
        }
        return answer;
    }

    private static String getPackageName(String className) {
        int end = className.lastIndexOf(46);
        if (end > 0) {
            return className.substring(0, end);
        }
        return "";
    }

    private static int compare(StackTraceElement[] exceptionCallStack) {
        if (exceptionCallStack == null || exceptionCallStack.length == 0) {
            return -1;
        }
        StackTraceElement[] currentCallStack = Thread.currentThread().getStackTrace();
        if (currentCallStack == null || currentCallStack.length == 0) {
            return -1;
        }
        int proposedExceptionIndex = exceptionCallStack.length - 1;
        for (int proposedCurrentIndex = currentCallStack.length - 1; proposedExceptionIndex >= 0 && proposedCurrentIndex >= 0 && exceptionCallStack[proposedExceptionIndex] != null && exceptionCallStack[proposedExceptionIndex].getClassName().equals(currentCallStack[proposedCurrentIndex].getClassName()); --proposedExceptionIndex, --proposedCurrentIndex) {
        }
        if (++proposedExceptionIndex > exceptionCallStack.length) {
            return -1;
        }
        return proposedExceptionIndex;
    }

    private static String formatTime() {
        Date date = new Date();
        DateFormat formatter = IncidentStreamImpl.getBasicDateFormatter();
        StringBuffer answer = new StringBuffer();
        answer.append("[");
        formatter.format(date, answer, new FieldPosition(0));
        answer.append("]");
        return answer.toString();
    }

    private static DateFormat getBasicDateFormatter() {
        DateFormat formatter = DateFormat.getDateTimeInstance(3, 2);
        if (formatter instanceof SimpleDateFormat) {
            SimpleDateFormat sdFormatter = (SimpleDateFormat)formatter;
            String pattern = sdFormatter.toPattern();
            int patternLength = pattern.length();
            int endOfSecsIndex = pattern.lastIndexOf(115) + 1;
            String newPattern = pattern.substring(0, endOfSecsIndex) + ":SSS z";
            if (endOfSecsIndex < patternLength) {
                newPattern = newPattern + pattern.substring(endOfSecsIndex, patternLength);
            }
            newPattern = newPattern.replace('h', 'H');
            newPattern = newPattern.replace('K', 'H');
            newPattern = newPattern.replace('k', 'H');
            newPattern = newPattern.replace('a', ' ');
            newPattern = newPattern.trim();
            sdFormatter.applyPattern(newPattern);
            formatter = sdFormatter;
        } else {
            formatter = new SimpleDateFormat("yy.MM.dd HH:mm:ss:SSS z");
        }
        return formatter;
    }

    static String getStackTrace(Throwable ex) {
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }
}

