/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.jitdeploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.classloader.CompoundClassLoader;
import com.ibm.ws.ejbcontainer.jitdeploy.JIT_Stub;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.dopriv.GetClassLoaderPrivileged;
import com.ibm.wsspi.classloader.JIT_StubClassPlugin;
import java.security.PrivilegedAction;

public final class JIT_StubPluginImpl
implements JIT_StubClassPlugin {
    private static final String CLASS_NAME = JIT_StubPluginImpl.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "JITDeploy", "com.ibm.ejs.container.container");
    private static final String OMG_STUB_PREFIX = "org.omg.stub.";
    private final CompoundClassLoader ivClassLoader;

    public JIT_StubPluginImpl(CompoundClassLoader classLoader) {
        this.ivClassLoader = classLoader;
    }

    private JIT_StubPluginImpl() {
        throw new RuntimeException("Default constructor not supported");
    }

    public Class defineStubClass(String stubClassName) {
        Class<?> stubClass;
        block16: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "defineStubClass: " + stubClassName);
            }
            stubClass = null;
            String remoteInterfaceName = JIT_Stub.getRemoteInterfaceName(stubClassName);
            if (remoteInterfaceName != null) {
                block15: {
                    if (!stubClassName.startsWith(OMG_STUB_PREFIX)) {
                        String omgClassName = OMG_STUB_PREFIX + stubClassName;
                        try {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "attempting load of class: " + omgClassName);
                            }
                            stubClass = this.ivClassLoader.loadClass(omgClassName);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                Tr.exit(tc, "findClass: " + stubClass);
                            }
                            return stubClass;
                        }
                        catch (Throwable ex) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block15;
                            Tr.debug(tc, "org.omg.stub load failed: " + ex);
                        }
                    }
                }
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "loading remote interface: " + remoteInterfaceName);
                    }
                    Class<?> remoteInterface = this.ivClassLoader.loadClass(remoteInterfaceName);
                    CompoundClassLoader appCl = this.ivClassLoader;
                    ClassLoader interfaceCl = (ClassLoader)AccessController.doPrivileged((PrivilegedAction)new GetClassLoaderPrivileged(remoteInterface));
                    if (interfaceCl instanceof CompoundClassLoader) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "using interface classloader: " + interfaceCl);
                        }
                        appCl = (CompoundClassLoader)interfaceCl;
                    }
                    byte[] classbytes = JIT_Stub.generateStubBytes(remoteInterface);
                    stubClass = appCl.defineApplicationClass(stubClassName, classbytes);
                }
                catch (ClassNotFoundException cnfex) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "defineStubClass failed: " + cnfex.getMessage());
                    }
                }
                catch (Throwable ex) {
                    FFDCFilter.processException(ex, CLASS_NAME + ".defineStubClass", "95", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block16;
                    Tr.debug(tc, "defineStubClass failed: " + ex.getMessage());
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "defineStubClass: " + stubClass);
        }
        return stubClass;
    }
}

