/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.topography;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.TriggerInfo;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class TriggerInfoImpl
implements TriggerInfo {
    private static final TraceComponent tc = Tr.register(TriggerInfo.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    public static final TriggerInfo TRIGGER_STRUCTURE;
    public static final TriggerInfo TRIGGER_STRUCTURE_MEMBER;
    public static final TriggerInfo TRIGGER_STRUCTURE_MEMBER_RUNNING;
    public static final TriggerInfo TRIGGER_STRUCTURE_MEMBER_STOPPING;
    public static final TriggerInfo TRIGGER_INFLUENCE;
    private String event = null;
    private TriggerInfo parent = null;
    private boolean structural = false;
    private boolean influential = false;

    public TriggerInfoImpl() {
    }

    protected TriggerInfoImpl(String event, TriggerInfo parent) {
        this.event = parent == null ? event : parent.getEventType() + "." + event;
        this.parent = parent;
        this.structural = this.event.startsWith("structure");
        this.influential = this.event.startsWith("influence");
    }

    public String getEventType() {
        return this.event;
    }

    public boolean isStructural() {
        return this.structural;
    }

    public boolean isInfluential() {
        return this.influential;
    }

    public TriggerInfo getSuperType() {
        return this.parent;
    }

    public boolean equals(Object arg0) {
        try {
            TriggerInfoImpl other = (TriggerInfoImpl)arg0;
            if (this.event.equals(other.event)) {
                return true;
            }
        }
        catch (ClassCastException cce) {
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.event.hashCode();
    }

    public String toString() {
        return this.event;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        out.writeObject(this.event);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this.event = (String)in.readObject();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.2 ");
        }
        TRIGGER_STRUCTURE = new TriggerInfoImpl("structure", null);
        TRIGGER_STRUCTURE_MEMBER = new TriggerInfoImpl("member.state", TRIGGER_STRUCTURE);
        TRIGGER_STRUCTURE_MEMBER_RUNNING = new TriggerInfoImpl("running", TRIGGER_STRUCTURE_MEMBER);
        TRIGGER_STRUCTURE_MEMBER_STOPPING = new TriggerInfoImpl("stopping", TRIGGER_STRUCTURE_MEMBER);
        TRIGGER_INFLUENCE = new TriggerInfoImpl("influence", null);
    }
}

