/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.topography;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.Concern;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionA;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.Format;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.ws.cluster.topography.ConcernImpl;
import com.ibm.ws.cluster.topography.SelectionClusterMemberDescription;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SelectionClusterMemberDescriptionImpl
extends DescriptionA
implements SelectionClusterMemberDescription {
    private static final TraceComponent tc = Tr.register(SelectionClusterMemberDescriptionImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final String LOCAL_HOST = "localhost";
    private String host = "localhost";
    private Set attributes = Collections.synchronizedSet(new HashSet());
    private DescriptionKey clusterMemberAssociation = null;
    private KeyRepository keyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();

    public SelectionClusterMemberDescriptionImpl(DescriptionKey key) {
        super(key);
    }

    public String getDefinitionKey() {
        return SelectionClusterMemberDescription.class.getName();
    }

    public void setClusterMemberAssociation(DescriptionKey association) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setClusterMemberAssociation", association);
        }
        this.clusterMemberAssociation = association;
        this.updateMemento();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setClusterMemberAssociation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportToStream(DataOutput out, Format format) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportToStream");
        }
        int type = format.getType();
        SelectionClusterMemberDescription.Memento memento = null;
        if (type == 3) {
            memento = (SelectionClusterMemberDescription.Memento)this.getMemento();
        }
        Set attrib = this.attributes;
        DescriptionKey association = this.clusterMemberAssociation;
        String hst = this.host;
        if (memento != null) {
            attrib = memento.getAttributes();
            association = memento.getClusterMemberAssociation();
            hst = memento.getHost();
        }
        out.writeByte(0);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote version 0");
        }
        if (association != null) {
            out.writeInt(1);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote association length = 1");
            }
            this.keyRepository.exportToStream(out, association);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote clusterMemberAssociation " + association);
            }
        } else {
            out.writeInt(0);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote association length = 0");
            }
        }
        out.writeUTF(hst);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote host: " + hst);
        }
        Set set = attrib;
        synchronized (set) {
            int size = attrib.size();
            Iterator iter = attrib.iterator();
            out.writeInt(size);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote size: " + size);
            }
            for (int i = 0; i < size; ++i) {
                String element = (String)iter.next();
                out.writeUTF(element);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "wrote attribute " + element);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportToStream");
        }
    }

    public Description.Memento importFromStream(DataInput in, Format format, Description.Memento memento) throws IOException {
        String tempHost;
        MementoImpl newMemento;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importFromStream");
        }
        if ((newMemento = (MementoImpl)memento) == null) {
            newMemento = (MementoImpl)this.createMemento();
        }
        in.readByte();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "read version 0");
        }
        int associationSize = in.readInt();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "read association size " + associationSize);
        }
        if (associationSize > 0) {
            try {
                newMemento.m_clusterMemberAssociation = this.keyRepository.importFromStream(in);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "read clusterMemberAssociation " + newMemento.m_clusterMemberAssociation);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, SelectionClusterMemberDescriptionImpl.class.getName() + ".importFromStream", "176", this);
                Tr.debug(tc, "unexpected exception ", e);
            }
        }
        if (!(tempHost = in.readUTF()).equals(LOCAL_HOST)) {
            newMemento.m_host = tempHost;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "read host: " + tempHost + " memento host:" + newMemento.m_host);
        }
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String attribute = in.readUTF();
            newMemento.m_attributes.add(attribute);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "read attribute " + attribute);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "importFromStream", newMemento);
        }
        return newMemento;
    }

    public void setHost(String host) {
        this.host = host;
        this.updateMemento();
    }

    public void addAttribute(String attribute) {
        this.attributes.add(attribute);
        this.updateMemento();
    }

    public void removeAttribute(String attribute) {
        this.attributes.remove(attribute);
        this.updateMemento();
    }

    public boolean isAttributeEmpty() {
        return this.attributes.isEmpty();
    }

    public String toString() {
        return new StringBuffer("[").append(super.toString()).append(this.host).append(' ').append(this.attributes).append(']').toString();
    }

    public Description.Memento createMemento() {
        return new MementoImpl();
    }

    public void setMemento(Description.Memento memento) {
        MementoImpl newMemento = (MementoImpl)memento;
        MementoImpl currentMemento = (MementoImpl)this.getMemento();
        super.setMemento(memento);
        for (String element : currentMemento.m_attributes) {
            if (newMemento.m_attributes.contains(element)) continue;
            this.notifyListeners("type.attribute.removed", element);
        }
        for (String element : newMemento.m_attributes) {
            if (currentMemento.m_attributes.contains(element)) continue;
            this.notifyListeners("type.attribute.added", element);
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.13 ");
        }
    }

    public class MementoImpl
    extends DescriptionA.MementoA
    implements SelectionClusterMemberDescription.Memento {
        private Concern concern = new ConcernImpl(Integer.MAX_VALUE);
        private String m_host = "localhost";
        private DescriptionKey m_clusterMemberAssociation;
        private Set m_attributes = new HashSet();

        public Concern getConcern() {
            return this.concern;
        }

        public String getHost() {
            return this.m_host;
        }

        public DescriptionKey getClusterMemberAssociation() {
            return this.m_clusterMemberAssociation;
        }

        public Set getAttributes() {
            return Collections.unmodifiableSet(this.m_attributes);
        }

        public String toString() {
            return new StringBuffer("[").append(super.toString()).append(this.m_host).append(this.m_attributes).append(']').toString();
        }
    }
}

