/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.topography;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.Format;
import com.ibm.websphere.cluster.topography.ProcessDescription;
import com.ibm.ws.cluster.topography.ClusterMemberDescriptionImpl;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ProcessDescriptionImpl
extends ClusterMemberDescriptionImpl
implements ProcessDescription {
    private static final TraceComponent tc = Tr.register(ProcessDescriptionImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    protected String nodeName = "nil";
    protected String processName = "nil";

    public ProcessDescriptionImpl(DescriptionKey key) {
        super(key);
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
        this.updateMemento();
    }

    public void setProcessName(String processName) {
        this.processName = processName;
        this.updateMemento();
    }

    public String getDefinitionKey() {
        return ProcessDescription.class.getName();
    }

    public synchronized void exportToStream(DataOutput out, Format format) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportToStream", format);
        }
        super.exportToStream(out, format);
        int type = format.getType();
        ProcessDescription.Memento memento = null;
        if (type == 3) {
            memento = (ProcessDescription.Memento)this.getMemento();
        }
        out.writeByte(0);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote version 0");
        }
        String nodeNm = this.nodeName;
        String processNm = this.processName;
        if (memento != null) {
            nodeNm = memento.getNodeName();
            processNm = memento.getProcessName();
        }
        out.writeUTF(nodeNm);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote nodeName " + nodeNm);
        }
        out.writeUTF(processNm);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote processName " + processNm);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportToStream");
        }
    }

    public synchronized Description.Memento importFromStream(DataInput in, Format format, Description.Memento memento) throws IOException {
        MementoImpl newMemento;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importFromStream");
        }
        if ((newMemento = (MementoImpl)memento) == null) {
            newMemento = (MementoImpl)this.createMemento();
        }
        super.importFromStream(in, format, newMemento);
        in.readByte();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "read version 0");
        }
        newMemento.m_nodeName = in.readUTF();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "read nodename " + newMemento.m_nodeName);
        }
        newMemento.m_processName = in.readUTF();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "read processName " + newMemento.m_processName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "importFromStream");
        }
        return newMemento;
    }

    public Description.Memento createMemento() {
        return new MementoImpl();
    }

    public String toString() {
        return new StringBuffer("[").append(super.toString()).append(this.nodeName).append(':').append(this.processName).append(']').toString();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.12 ");
        }
    }

    public class MementoImpl
    extends ClusterMemberDescriptionImpl.MementoImpl
    implements ProcessDescription.Memento {
        private String m_processName = "";
        private String m_nodeName = "";

        protected MementoImpl() {
        }

        public String getProcessName() {
            return this.m_processName;
        }

        public String getNodeName() {
            return this.m_nodeName;
        }

        public String toString() {
            return new StringBuffer("[").append(super.toString()).append(this.m_nodeName).append(':').append(this.m_processName).append(']').toString();
        }
    }
}

