/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.topography;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionA;
import com.ibm.websphere.cluster.topography.DescriptionFactory;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.ExtrinsicDescription;
import com.ibm.websphere.cluster.topography.Format;
import com.ibm.websphere.cluster.topography.IntrinsicDescription;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class IntrinsicDescriptionA
extends DescriptionA
implements IntrinsicDescription {
    private static final TraceComponent tc = Tr.register(IntrinsicDescriptionA.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private final String commonImplKey = "com.ibm.ws.cluster.topography.CommonClusterMemberDescription";
    private final String[] distinction = new String[]{"CommonClusterMemberDescriptionDistinction", "common"};
    private static final DescriptionManager descMgr;
    private static final DescriptionFactory descFactory;
    private static final KeyRepository keyRepository;
    private Map extrinsicData = Collections.synchronizedMap(new HashMap());
    private Map ivCommonMemberDistinction = null;

    protected IntrinsicDescriptionA(DescriptionKey key) {
        super(key);
    }

    public void exportToStream(DataOutput out, Format format) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportToStream");
        }
        int type = format.getType();
        MementoA memento = null;
        if (type == 3) {
            memento = (MementoA)this.getMemento();
        }
        out.writeByte(0);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote version 0");
        }
        Set entrySet = null;
        entrySet = memento != null ? memento.getExtrinsicData().entrySet() : this.extrinsicData.entrySet();
        int size = entrySet.size();
        out.writeInt(size);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote extrinsics size = " + size);
        }
        for (Map.Entry entry : entrySet) {
            DescriptionKey dataKey = (DescriptionKey)entry.getKey();
            keyRepository.exportToStream(out, dataKey);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote descriptionKey " + dataKey);
            }
            ExtrinsicDescription element = (ExtrinsicDescription)entry.getValue();
            out.writeUTF(element.getDefinitionKey());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote definition key " + element.getDefinitionKey());
            }
            if (memento == null) continue;
            element.exportToStream(out, format);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportToStream");
        }
    }

    public Description.Memento importFromStream(DataInput in, Format format, Description.Memento memento) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importFromStream");
        }
        MementoA newMemento = (MementoA)memento;
        byte version = in.readByte();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "read version " + version);
        }
        int size = in.readInt();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "read extrinsics size = " + size);
        }
        for (int i = 0; i < size; ++i) {
            DescriptionKey dataKey = keyRepository.importFromStream(in);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "read descriptionKey = " + dataKey);
            }
            String definition = in.readUTF();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "read definition = " + definition);
            }
            Description dataValue = (Description)newMemento.m_extrinsicData.get(dataKey);
            try {
                if (dataValue == null) {
                    try {
                        dataValue = descMgr.getDescription(dataKey, definition);
                    }
                    catch (Exception e) {
                        if (format.getType() == 4) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Unexpected", e);
                            }
                        }
                        IOException ioe = new IOException("Error serializing the description " + dataKey + ".");
                        ioe.initCause(e);
                        throw ioe;
                    }
                    newMemento.m_extrinsicData.put(dataKey, dataValue);
                }
                if (format.getType() != 3) continue;
                ExtrinsicDescription.Memento extMemento = (ExtrinsicDescription.Memento)dataValue.importFromStream(in, format, null);
                dataValue.setMemento(extMemento);
                continue;
            }
            catch (Exception e) {
                IOException ioe = new IOException("Error serializing the description " + dataKey + ".");
                ioe.initCause(e);
                throw ioe;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "importFromStream");
        }
        return newMemento;
    }

    public void setExtrinsicData(DescriptionKey protocol2, ExtrinsicDescription value2) {
        this.setExtrinsicData(value2);
    }

    public void setExtrinsicData(ExtrinsicDescription value2) throws IllegalArgumentException {
        DescriptionKey protocolKey = value2.getKey();
        if (protocolKey.equals(this.getKey())) {
            throw new IllegalArgumentException("The ExtrinsicDescription has the same key as the IntrinsicDescription: " + this.getKey());
        }
        this.extrinsicData.put(protocolKey, value2);
        this.updateMemento();
        this.notifyListeners("type.add.extrinsic", value2);
    }

    public ExtrinsicDescription removeExtrinsicData(DescriptionKey valueKey) throws IllegalArgumentException {
        ExtrinsicDescription result = (ExtrinsicDescription)this.extrinsicData.remove(valueKey);
        this.updateMemento();
        return result;
    }

    public void setMemento(Description.Memento memento) {
        Object obj;
        MementoA current_memento = (MementoA)this.getMemento();
        Map current_extrinsics = current_memento.getExtrinsicData();
        Map new_extrinsics = ((MementoA)memento).getExtrinsicData();
        super.setMemento(memento);
        for (Map.Entry entry : current_extrinsics.entrySet()) {
            if (new_extrinsics.containsKey(entry.getKey())) continue;
            obj = entry.getValue();
            this.notifyListeners("type.remove.extrinsic", obj);
            descFactory.notifyListeners(this.getKey(), "type.remove.extrinsic", obj);
        }
        for (Map.Entry entry : new_extrinsics.entrySet()) {
            obj = entry.getValue();
            if (current_extrinsics.containsKey(entry.getKey())) continue;
            this.notifyListeners("type.add.extrinsic", obj);
            descFactory.notifyListeners(this.getKey(), "type.add.extrinsic", obj);
        }
    }

    public String toString() {
        return new StringBuffer("[").append(super.toString()).append(this.extrinsicData).append(']').toString();
    }

    static {
        DescriptionManagerFactory.getInstance();
        descMgr = DescriptionManagerFactory.getDescriptionManager();
        descFactory = DescriptionFactory.getInstance();
        keyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();
    }

    public abstract class MementoA
    extends DescriptionA.MementoA
    implements IntrinsicDescription.Memento {
        protected Map m_extrinsicData = new HashMap();

        protected MementoA() {
        }

        public ExtrinsicDescription getExtrinsicData(DescriptionKey protocol2) {
            return (ExtrinsicDescription)this.m_extrinsicData.get(protocol2);
        }

        public Map getExtrinsicData() {
            return Collections.unmodifiableMap(this.m_extrinsicData);
        }

        public String toString() {
            return new StringBuffer("[").append(super.toString()).append(this.m_extrinsicData).append(']').toString();
        }
    }
}

