/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.topography;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.Concern;
import com.ibm.websphere.cluster.topography.Format;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class FormatImpl
implements Format {
    private static final TraceComponent tc = Tr.register(FormatImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    static final long serialVersionUID = 4190911471127139349L;
    private int type = 0;
    private Concern concern = null;
    private byte version = 1;

    public FormatImpl() {
    }

    public FormatImpl(Concern concern, int type) {
        if (concern == null) {
            throw new NullPointerException("Concern must not be null.");
        }
        this.concern = concern;
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public byte getVersion() {
        return this.version;
    }

    public Concern getConcern() {
        return this.concern;
    }

    public boolean equals(Object other) {
        try {
            Format format = (Format)other;
            if (format.getType() != this.type) {
                return false;
            }
            if (!format.getConcern().equals(this.concern)) {
                return false;
            }
        }
        catch (ClassCastException e) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.type | this.concern.hashCode();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(this.version);
        out.writeInt(this.type);
        out.writeObject(this.concern);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.version = in.readByte();
        this.type = in.readInt();
        this.concern = (Concern)in.readObject();
    }

    public String toString() {
        return FormatImpl.class.getName() + "[t" + this.type + ", c" + this.concern + "]";
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.4 ");
        }
    }
}

