/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.topography;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.Concern;
import com.ibm.websphere.cluster.topography.Contract;
import com.ibm.websphere.cluster.topography.TriggerInfo;
import com.ibm.ws.cluster.topography.ConcernImpl;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Set;

public class ContractImpl
implements Contract {
    private static final TraceComponent tc = Tr.register(ContractImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private int frequency = 0;
    private Concern concern = new ConcernImpl(Integer.MAX_VALUE);
    private Set events = new HashSet();

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public Set getEvents() {
        return this.events;
    }

    public void addEvent(TriggerInfo event) {
        this.events.add(event);
    }

    public void addAllEvents(Set events) {
        this.events.addAll(events);
    }

    public void removeEvent(TriggerInfo event) {
        this.events.remove(event);
    }

    public boolean match(TriggerInfo event) {
        return event == null ? false : (this.events.contains(event) ? true : this.match(event.getSuperType()));
    }

    public Concern getInterest() {
        return this.concern;
    }

    public void setInterest(Concern interest) {
        this.concern = interest;
    }

    public boolean subset(Contract contract) {
        return contract.getFrequency() <= this.frequency && this.concern.getInterest() == (this.concern.getInterest() & contract.getInterest().getInterest()) && contract.getEvents().containsAll(this.events);
    }

    public Contract getUnion(Contract contract) {
        ContractImpl result = new ContractImpl();
        result.setFrequency(this.frequency < contract.getFrequency() ? this.frequency : contract.getFrequency());
        result.setInterest(new ConcernImpl(this.concern.getInterest() | contract.getInterest().getInterest()));
        result.addAllEvents(this.events);
        result.addAllEvents(contract.getEvents());
        return result;
    }

    public boolean equals(Object other) {
        try {
            Contract contract = (Contract)other;
            if (contract.getFrequency() != this.frequency) {
                return false;
            }
            if (!contract.getInterest().equals(this.concern)) {
                return false;
            }
            if (!((Object)contract.getEvents()).equals(this.events)) {
                return false;
            }
        }
        catch (ClassCastException e) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.frequency | this.concern.hashCode() | ((Object)this.events).hashCode();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        out.writeInt(this.frequency);
        out.writeObject(this.concern);
        out.writeObject(this.events);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this.frequency = in.readInt();
        this.concern = (Concern)in.readObject();
        this.events = (Set)in.readObject();
    }

    public String toString() {
        return this.concern.toString() + this.events.toString() + this.frequency;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.2 ");
        }
    }
}

