/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.topography;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.Contract;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionFactory;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.DescriptionModificationListener;
import com.ibm.websphere.cluster.topography.Format;
import com.ibm.websphere.cluster.topography.IdentityMap;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.websphere.cluster.topography.SelectionDescription;
import com.ibm.ws.cluster.ProcessProperties;
import com.ibm.ws.cluster.topography.ClusterMemberDescriptionImpl;
import com.ibm.ws.cluster.topography.ConcernImpl;
import com.ibm.ws.cluster.topography.ContractImpl;
import com.ibm.ws.cluster.topography.IdentityMapImpl;
import com.ibm.ws.cluster.topography.SelectionDescriptionImpl;
import com.ibm.ws.cluster.topography.TriggerInfoImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.cluster.Identity;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ClusterDescriptionImpl
extends ClusterMemberDescriptionImpl
implements ClusterDescription,
DescriptionModificationListener {
    private static final TraceComponent tc = Tr.register(ClusterDescriptionImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private final long TIMESTAMPADD = 1L;
    private static final KeyRepository keyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();
    private static final DescriptionFactory ivDescriptionFactory = DescriptionFactory.getInstance();
    private static final DescriptionManager ivDescMgr = DescriptionManagerFactory.getDescriptionManager();
    public static final SelectionDescription WEIGHTED;
    public static final SelectionDescription WEIGHTED_PREFER_LOCAL;
    public static final SelectionDescription WEIGHTED_NOT_INITIALIZED;
    private static final Map weightTableDistinction;
    protected long structuralEpoch = -2L;
    protected long influentialEpoch = -2L;
    private Map ivClusterScopedData = new HashMap();
    private Map ivWeightTable;
    private final DescriptionKey ivOwnedWeightTableKey;
    private DescriptionKey ivManagingWeightTableKey;
    protected SelectionDescription selection;
    private ClusterDescription backupCluster;
    private Contract contract = null;
    protected Map ivMembers = new HashMap();
    private final Object ivMembers_mutex = new Object();
    protected Map ivQuiesceState = Collections.synchronizedMap(new HashMap(1));

    public ClusterDescriptionImpl(DescriptionKey key) {
        super(key);
        this.leaf = false;
        this.selection = WEIGHTED_NOT_INITIALIZED;
        this.contract = new ContractImpl();
        this.contract.addEvent(TriggerInfoImpl.TRIGGER_STRUCTURE);
        this.contract.addEvent(TriggerInfoImpl.TRIGGER_INFLUENCE);
        this.contract.setInterest(new ConcernImpl(Integer.MAX_VALUE));
        this.ivOwnedWeightTableKey = ClusterDescriptionImpl.getWeightTableKey(key);
        this.ivManagingWeightTableKey = (DescriptionKey)ProcessProperties.getInstance().get("key.containing.cluster.weight.table");
        if (this.ivManagingWeightTableKey == null) {
            this.ivManagingWeightTableKey = this.ivOwnedWeightTableKey;
        }
        this.assignWeightTable(this.ivManagingWeightTableKey);
    }

    public String getDefinitionKey() {
        return ClusterDescription.class.getName();
    }

    public synchronized void setStructuralEpoch(long epoch) {
        this.structuralEpoch = epoch;
        this.updateMemento();
    }

    public void setClusterScopedData(DescriptionKey dataKey, byte[] data) {
        this.ivClusterScopedData.put(dataKey, data);
        this.updateMemento();
    }

    public void setClusterWeightTable(Map weightTable) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setClusterWeightTable", weightTable);
        }
        if (this.ivOwnedWeightTableKey != this.ivManagingWeightTableKey) {
            Map previous = this.ivWeightTable;
            this.assignWeightTable(this.ivOwnedWeightTableKey);
            this.ivWeightTable.putAll(previous);
        }
        this.ivWeightTable.putAll(weightTable);
        this.updateMemento();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setClusterWeightTable", this.ivWeightTable);
        }
    }

    public void setClusterWeightTableEntry(DescriptionKey memberKey, Integer weight) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setClusterWeightTableEntry", new Object[]{memberKey, weight});
        }
        if (this.ivOwnedWeightTableKey != this.ivManagingWeightTableKey) {
            Map previous = this.ivWeightTable;
            this.assignWeightTable(this.ivOwnedWeightTableKey);
            this.ivWeightTable.putAll(previous);
        }
        this.ivWeightTable.put(memberKey, weight);
        this.updateMemento();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setClusterWeightTableEntry", this.ivWeightTable);
        }
    }

    public void setClusterIdentityForWeightTable(Identity parentClusterIdentity) {
        if (parentClusterIdentity == null) {
            throw new IllegalArgumentException("The managing cluster Identity can not be null.");
        }
        ClusterDescriptionImpl parent = (ClusterDescriptionImpl)ivDescMgr.getDescription((DescriptionKey)parentClusterIdentity);
        if (parent == null) {
            throw new IllegalStateException("The managing cluster must be fluffed up before setting it as parent.");
        }
        if (parent.ivManagingWeightTableKey == this.ivManagingWeightTableKey) {
            return;
        }
        Map newTable = (Map)((Object)ivDescMgr.getDescription(parent.ivManagingWeightTableKey));
        if (newTable == null) {
            throw new IllegalStateException("The managing cluster weight table has not been fluffed up.");
        }
        MementoImpl currentMemento = (MementoImpl)this.getMemento();
        Set currentSet = currentMemento.m_members.keySet();
        Set newSet = newTable.keySet();
        if (!newSet.containsAll(currentSet)) {
            throw new IllegalArgumentException("The new weight table does not contain weights for all members.\n" + newSet + '\n' + currentSet);
        }
        this.ivManagingWeightTableKey = (DescriptionKey)parentClusterIdentity;
        this.assignWeightTable(parent.ivManagingWeightTableKey);
        this.updateMemento();
    }

    public void removeClusterScopedData(DescriptionKey dataKey) {
        this.ivClusterScopedData.remove(dataKey);
        this.updateMemento();
    }

    public synchronized void setInfluentialEpoch(long epoch) {
        this.influentialEpoch = epoch;
        this.updateMemento();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMember(ClusterMemberDescription member) {
        boolean addedMember = false;
        Object object = this.ivMembers_mutex;
        synchronized (object) {
            if (!this.ivMembers.containsKey(member.getKey())) {
                this.ivMembers.put(member.getKey(), member);
                addedMember = true;
            }
        }
        if (addedMember) {
            this.updateMemento();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "memberAdded", new Object[]{member.getKey(), this.ivMembers});
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "memberAdded", "member already exists: " + member.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMember(ClusterMemberDescription member) {
        Object removed = null;
        Object object = this.ivMembers_mutex;
        synchronized (object) {
            removed = this.ivMembers.remove(member.getKey());
        }
        if (this.ivOwnedWeightTableKey == this.ivManagingWeightTableKey) {
            this.ivWeightTable.remove(member.getKey());
        }
        if (removed != null) {
            this.updateMemento();
        }
        if (tc.isEventEnabled()) {
            Tr.event(tc, "memberRemoved", new Object[]{member.getKey(), this.ivMembers});
        }
    }

    public synchronized void setSelectionDescription(SelectionDescription selection) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSelectionDescription ", new Object[]{selection});
        }
        if (selection == null) {
            throw new NullPointerException("Must not set selection null.");
        }
        this.selection = selection;
        this.updateMemento();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSelectionDescription ");
        }
    }

    public synchronized void setBackupCluster(ClusterDescription backupCluster) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setBackupCluster", backupCluster);
        }
        this.backupCluster = backupCluster;
        this.updateMemento();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setBackupCluster");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void exportToStream(DataOutput out, Format format) throws IOException {
        DescriptionKey lkey;
        Map.Entry entry;
        int i;
        Object data;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportToStream " + this.getKey(), format);
        }
        int streamVersion = 1;
        out.writeByte(streamVersion);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote version " + streamVersion);
        }
        super.exportToStream(out, format);
        int type = format.getType();
        ClusterDescription.Memento m_memento = null;
        if (type == 3) {
            m_memento = (ClusterDescription.Memento)this.getMemento();
        }
        Set entrySet = null;
        int size = 0;
        if (format.getType() == 3) {
            entrySet = m_memento.getClusterScopedData();
            size = entrySet.size();
        } else {
            entrySet = ((HashMap)((HashMap)this.ivClusterScopedData).clone()).entrySet();
            size = this.ivClusterScopedData.size();
        }
        out.writeInt(size);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote cluster scoped data map size = " + size);
        }
        for (Map.Entry entry2 : entrySet) {
            DescriptionKey dataKey = (DescriptionKey)entry2.getKey();
            keyRepository.exportToStream(out, dataKey);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote data key " + dataKey);
            }
            data = (byte[])entry2.getValue();
            out.writeInt(((Object)data).length);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote data length " + ((Object)data).length);
            }
            out.write((byte[])data, 0, ((Object)data).length);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "wrote cluster scoped data", data);
        }
        HashMap ivMembers_copy = null;
        int length = 0;
        if (format.getType() == 3) {
            entrySet = m_memento.getMemberEntrySet();
            length = entrySet.size();
        } else {
            data = this.ivMembers_mutex;
            synchronized (data) {
                ivMembers_copy = new HashMap(this.ivMembers);
            }
            entrySet = ivMembers_copy.entrySet();
            length = ivMembers_copy.size();
        }
        out.writeInt(length);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote length " + length);
        }
        Iterator<Object> iterator = entrySet.iterator();
        for (i = 0; i < length; ++i) {
            entry = (Map.Entry)iterator.next();
            lkey = (DescriptionKey)entry.getKey();
            Description member = (Description)entry.getValue();
            String implKey = member.getDefinitionKey();
            out.writeUTF(implKey);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote member impl key " + implKey);
            }
            keyRepository.exportToStream(out, lkey);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote member description key " + lkey);
            }
            Integer memberWeight = null;
            memberWeight = format.getType() != 3 ? (Integer)this.ivWeightTable.get(lkey) : (Integer)m_memento.getWeightTable().get(lkey);
            if (memberWeight == null) {
                memberWeight = new Integer(-1);
            }
            out.writeInt(memberWeight);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote member weight", String.valueOf(memberWeight));
            }
            if (format.getType() != 3) continue;
            member.exportToStream(out, format);
        }
        if (format.getType() != 3) {
            length = this.ivWeightTable instanceof IdentityMapImpl ? ((IdentityMapImpl)this.ivWeightTable).getVersion602EntrySetForInterop().size() : this.ivWeightTable.size();
            out.writeInt(length);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote weight table size " + length);
            }
            iterator = this.ivWeightTable instanceof IdentityMapImpl ? ((IdentityMapImpl)this.ivWeightTable).getVersion602EntrySetForInterop().iterator() : this.ivWeightTable.entrySet().iterator();
            for (i = 0; i < length; ++i) {
                entry = (Map.Entry)iterator.next();
                lkey = (DescriptionKey)entry.getKey();
                Integer lvWeight = (Integer)entry.getValue();
                keyRepository.exportToStream(out, lkey);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "wrote member key", lkey);
                }
                out.writeInt(lvWeight);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "wrote member weight", String.valueOf(lvWeight));
            }
        }
        long structEpoch = 0L;
        long influentEpoch = 0L;
        if (format.getType() == 3) {
            structEpoch = m_memento.getStructuralEpoch();
            influentEpoch = m_memento.getInfluentialEpoch();
        } else {
            ClusterDescription.Memento memento = (ClusterDescription.Memento)this.getMemento();
            long m_structural = memento.getStructuralEpoch();
            long m_influential = memento.getInfluentialEpoch();
            structEpoch = this.structuralEpoch = System.currentTimeMillis();
            influentEpoch = this.influentialEpoch = System.currentTimeMillis();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "current time stamps ie: " + influentEpoch + " se: " + structEpoch);
            }
            if (structEpoch <= m_structural) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "current time stamp <= memento's struct epoch: " + m_structural);
                }
                structEpoch = this.structuralEpoch = m_structural + 1L;
            }
            if (influentEpoch <= m_influential) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "current time stamp <= memento's influential epoch: " + m_influential);
                }
                influentEpoch = this.influentialEpoch = m_influential + 1L;
            }
        }
        out.writeLong(structEpoch);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote structualEpoch " + structEpoch);
        }
        out.writeLong(influentEpoch);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote influentialEpoch " + influentEpoch);
        }
        DescriptionKey selecKey = null;
        SelectionDescription selec = null;
        ClusterDescription backupCl = null;
        if (format.getType() == 3) {
            selec = m_memento.getSelectionDescription();
            selecKey = selec.getKey();
            keyRepository.exportToStream(out, selecKey);
            selec.exportToStream(out, format);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote selection descriptionKey " + selecKey);
            }
            backupCl = m_memento.getBackupCluster();
        } else {
            selec = this.selection;
            selecKey = this.selection.getKey();
            keyRepository.exportToStream(out, selecKey);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote selection descriptionKey " + selecKey);
            }
            backupCl = this.backupCluster;
        }
        if (backupCl == null) {
            out.writeBoolean(false);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "boolean backup cluster cell name available false");
            }
        } else {
            out.writeBoolean(true);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "boolean backup cluster data available true");
            }
            keyRepository.exportToStream(out, backupCl.getKey());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote backup cluster's data " + backupCl.getKey());
            }
        }
        if (format.getVersion() >= 1) {
            if (format.getType() == 4) {
                keyRepository.exportToStream(out, this.ivManagingWeightTableKey);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "wrote weight table key " + this.ivManagingWeightTableKey);
                }
            }
            if (format.getType() == 4 || format.getType() == 3) {
                Map stateMap = format.getType() == 4 ? this.ivQuiesceState : m_memento.getQuiesceState();
                out.writeInt(stateMap.size());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "wrote stateMap size " + stateMap.size());
                }
                for (Map.Entry entry3 : stateMap.entrySet()) {
                    DescriptionKey memberKey = (DescriptionKey)entry3.getKey();
                    keyRepository.exportToStream(out, memberKey);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "wrote memberKey " + memberKey);
                    }
                    byte state = (Byte)entry3.getValue();
                    out.writeByte(state);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "wrote state " + state);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportToStream");
        }
    }

    public synchronized Description.Memento importFromStream(DataInput in, Format format, Description.Memento memento) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importFromStream", format);
        }
        MementoImpl newMemento = (MementoImpl)memento;
        try {
            long newEpoch;
            if (newMemento == null) {
                newMemento = (MementoImpl)this.createMemento();
            }
            byte streamVersion = in.readByte();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "read version " + streamVersion);
            }
            super.importFromStream(in, format, newMemento);
            int csd_size = in.readInt();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "read cluster scoped data map size = " + csd_size);
            }
            for (int i = 0; i < csd_size; ++i) {
                DescriptionKey dataKey = null;
                dataKey = keyRepository.importFromStream(in);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "read dataKey " + dataKey);
                }
                int dataSize = in.readInt();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "read data length " + dataSize);
                }
                byte[] data = new byte[dataSize];
                in.readFully(data, 0, data.length);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "read cluster scoped data", data);
                }
                newMemento.m_clusterScopedData.put(dataKey, data);
            }
            int size = in.readInt();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "read member length " + size);
            }
            for (int i = 0; i < size; ++i) {
                String implKey = in.readUTF();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "read member impl key " + implKey);
                }
                DescriptionKey lkey = keyRepository.importFromStream(in);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "read description key " + lkey);
                }
                Description member = ivDescMgr.getDescription(lkey, implKey);
                newMemento.m_members.put(lkey, member);
                int memberWeight = -1;
                memberWeight = in.readInt();
                if (format.getType() != 3) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "read member weight " + memberWeight);
                }
                if (memberWeight != -1) {
                    newMemento.m_weightTable.put(lkey, new Integer(memberWeight));
                }
                ClusterMemberDescription.Memento memberMemento = (ClusterMemberDescription.Memento)member.importFromStream(in, format, null);
                member.setMemento(memberMemento);
            }
            int lvWeight = -1;
            if (format.getType() != 3) {
                size = in.readInt();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "read weight table size " + size);
                }
                for (int i = 0; i < size; ++i) {
                    DescriptionKey lvWeightKey = keyRepository.importFromStream(in);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "read member key", lvWeightKey);
                    }
                    lvWeight = in.readInt();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "read member weight " + lvWeight);
                    }
                    if (lvWeight == -1) continue;
                    newMemento.m_weightTable.put(lvWeightKey, new Integer(lvWeight));
                }
            }
            if ((newEpoch = in.readLong()) > newMemento.m_epoch) {
                newMemento.m_epoch = newEpoch;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "read structuralEpoch " + newEpoch);
            }
            if ((newEpoch = in.readLong()) > newMemento.m_influentialEpoch) {
                newMemento.m_influentialEpoch = newEpoch;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "read influentialEpoch " + newEpoch);
            }
            DescriptionKey selectionKey = keyRepository.importFromStream(in);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "read selection description key " + selectionKey);
            }
            SelectionDescription selec = null;
            if (selectionKey != SelectionDescription.KEY_WEIGHTED_NOT_INITIALIZED) {
                selec = (SelectionDescription)DescriptionManagerFactory.getDescriptionManager().getDescription(selectionKey, SelectionDescription.class.getName());
                newMemento.m_selection = selec;
            } else {
                selec = memento != null ? ((ClusterDescription.Memento)memento).getSelectionDescription() : WEIGHTED_NOT_INITIALIZED;
                newMemento.m_selection = selec;
            }
            if (selec != null && format.getType() == 3) {
                SelectionDescription.Memento selecMemento = (SelectionDescription.Memento)selec.importFromStream(in, format, null);
                selec.setMemento(selecMemento);
            }
            if (in.readBoolean()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "backup cluster data available true");
                }
                DescriptionKey backupKey = keyRepository.importFromStream(in);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "read backup cluster key " + backupKey);
                }
                newMemento.m_backupCluster = (ClusterDescription)ClusterDescriptionImpl.ivDescMgr.getDescription(backupKey, ClusterDescription.class.getName());
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "backup cluster data available false");
            }
            if (streamVersion >= 1) {
                if (format.getType() == 4) {
                    DescriptionKey wtKey = keyRepository.importFromStream(in);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "read weight table key " + wtKey);
                    }
                    newMemento.m_disembodiedWeightTable = (IdentityMap)ClusterDescriptionImpl.ivDescMgr.getDescription(wtKey, IdentityMap.class.getName());
                }
                if (format.getType() == 4 || format.getType() == 3 && format.getVersion() >= 1) {
                    int stateSize = in.readInt();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "read stateMap size " + stateSize);
                    }
                    for (int i = 0; i < stateSize; ++i) {
                        DescriptionKey memberKey = keyRepository.importFromStream(in);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "read memberKey " + memberKey);
                        }
                        byte state = in.readByte();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "read state " + state);
                        }
                        newMemento.m_quiesceState.put(memberKey, new Byte(state));
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not going to the Bulletin Board");
                }
            }
        }
        catch (Exception e) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unexpected", e);
            }
            IOException ioe = new IOException("An unexpected exception occurred while processing the import from stream.");
            ioe.initCause(e);
            throw ioe;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "importFromStream");
        }
        return newMemento;
    }

    public void handleNotification(DescriptionKey key, String type, Object data, Object handback) {
        DescriptionKey memberKey = (DescriptionKey)data;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "handleNotification", new Object[]{key, type, data, handback});
        }
        if (((ClusterDescription.Memento)this.getMemento()).getMembers().containsKey(memberKey)) {
            ivDescriptionFactory.notifyListeners(this.getKey(), (String)handback, data);
            this.notifyListeners((String)handback, data);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Non-member of this cluster, no need to send notifications ");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[").append(super.toString());
        sb.append(" se:").append(this.structuralEpoch);
        sb.append(" ie:").append(this.influentialEpoch);
        sb.append(" members ").append(this.ivMembers == null ? null : this.ivMembers.keySet());
        sb.append(" cluster data ").append(this.ivClusterScopedData);
        sb.append(" backup cluster ").append(this.backupCluster == null ? null : this.backupCluster.getKey());
        sb.append(" quiesce state ").append(this.ivQuiesceState);
        sb.append(" weight table [").append(this.ivManagingWeightTableKey).append(' ').append(this.ivWeightTable).append(']');
        return sb.append(']').toString();
    }

    public void setMemento(Description.Memento memento) {
        Object obj;
        Object obj2;
        ClusterDescription.Memento current_memento = (ClusterDescription.Memento)this.getMemento();
        ClusterDescription.Memento new_memento = (ClusterDescription.Memento)memento;
        Map mcurrent_members = current_memento.getMembers();
        Map mnew_members = new_memento.getMembers();
        Set mcurrent_datakey = current_memento.getClusterScopedData();
        Set mnew_datakey = new_memento.getClusterScopedData();
        super.setMemento(memento);
        for (Map.Entry entry : mcurrent_members.entrySet()) {
            if (mnew_members.containsKey(entry.getKey())) continue;
            obj2 = entry.getValue();
            this.notifyListeners("member.removed", obj2);
            ivDescriptionFactory.notifyListeners(this.getKey(), "member.removed", obj2);
        }
        for (Map.Entry entry : mnew_members.entrySet()) {
            obj2 = entry.getValue();
            if (mcurrent_members.containsKey(entry.getKey())) continue;
            this.notifyListeners("member.added", obj2);
            ivDescriptionFactory.notifyListeners(this.getKey(), "member.added", obj2);
        }
        if (!new_memento.getSelectionDescription().equals(current_memento.getSelectionDescription())) {
            this.notifyListeners("type.selection.description.modified", null);
        }
        MementoImpl new_impl = (MementoImpl)new_memento;
        MementoImpl current_impl = (MementoImpl)current_memento;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "registering with map for weight updates.", new_impl.m_disembodiedWeightTable);
        }
        new_impl.m_disembodiedWeightTable.registerNotificationListener(this, "type.key.added", "type.cluster.weight.update");
        new_impl.m_disembodiedWeightTable.registerNotificationListener(this, "type.key.removed", "type.cluster.weight.update");
        new_impl.m_disembodiedWeightTable.registerNotificationListener(this, "type.value.modified", "type.cluster.weight.update");
        if (current_impl.m_disembodiedWeightTable != new_impl.m_disembodiedWeightTable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "deregistering with map for weight updates.", current_impl.m_disembodiedWeightTable);
            }
            current_impl.m_disembodiedWeightTable.deregisterNotificationListener(this, "type.key.added");
            current_impl.m_disembodiedWeightTable.deregisterNotificationListener(this, "type.key.removed");
            current_impl.m_disembodiedWeightTable.deregisterNotificationListener(this, "type.value.modified");
        }
        for (Map.Entry entry : mcurrent_datakey) {
            obj = entry.getKey();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setMemento Cluster Scoped Data undefine: obj:" + obj.toString());
            }
            if (mnew_datakey.contains(obj)) continue;
            this.notifyListeners("type.cluster.scoped.data.removed", obj);
            ivDescriptionFactory.notifyListeners(this.getKey(), "type.cluster.scoped.data.removed", obj);
        }
        for (Map.Entry entry : mnew_datakey) {
            obj = entry.getKey();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setMemento Cluster Scoped Data define: obj:" + obj.toString());
            }
            if (mcurrent_datakey.contains(obj)) continue;
            this.notifyListeners("type.cluster.scoped.data.added", obj);
            ivDescriptionFactory.notifyListeners(this.getKey(), "type.cluster.scoped.data.added", obj);
        }
        if (!((Object)new_impl.m_quiesceState).equals(current_impl.m_quiesceState)) {
            this.notifyListeners("type.quiesce.state.changed", new_impl.getQuiesceState());
        }
    }

    public Description.Memento createMemento() {
        return new MementoImpl();
    }

    public void setQuiesce(Identity member) {
        this.ivQuiesceState.put(member, new Byte(9));
        this.updateMemento();
    }

    public void unsetQuiesce(Identity member) {
        this.ivQuiesceState.remove(member);
        this.updateMemento();
    }

    public static DescriptionKey getWeightTableKey(DescriptionKey cluster) {
        return keyRepository.getDescriptionKey(cluster, weightTableDistinction);
    }

    private void assignWeightTable(DescriptionKey newWeightTableKey) {
        block4: {
            try {
                this.ivWeightTable = (Map)((Object)ivDescMgr.getDescription(newWeightTableKey, IdentityMap.class.getName()));
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Changed over to new weight table.", new Object[]{this.ivManagingWeightTableKey, newWeightTableKey});
                }
                this.ivManagingWeightTableKey = newWeightTableKey;
            }
            catch (Exception e) {
                FFDCFilter.processException(e, ClusterDescriptionImpl.class.getName() + ".assignWeightTable", "1012", this, new Object[]{newWeightTableKey});
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "unexpected exception", e);
                }
                if (this.ivWeightTable != null) break block4;
                this.ivWeightTable = Collections.synchronizedMap(new HashMap());
            }
        }
    }

    static {
        weightTableDistinction = new HashMap();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.68.1.2 ");
        }
        weightTableDistinction.put("Type", "WeightTable");
        SelectionDescription t_WEIGHTED = null;
        SelectionDescription t_WEIGHTED_PREFER_LOCAL = null;
        SelectionDescription t_WEIGHTED_NOT_INITIALIZED = null;
        try {
            t_WEIGHTED = (SelectionDescription)DescriptionManagerFactory.getDescriptionManager().getDescription(SelectionDescription.KEY_WEIGHTED, SelectionDescription.class.getName());
            t_WEIGHTED.modifyRules(new String[]{"rule.local.server", "rule.default"});
            t_WEIGHTED_PREFER_LOCAL = (SelectionDescription)DescriptionManagerFactory.getDescriptionManager().getDescription(SelectionDescription.KEY_WEIGHTED_PREFER_LOCAL, SelectionDescription.class.getName());
            t_WEIGHTED_PREFER_LOCAL.modifyRules(new String[]{"rule.local.server", "rule.local.host", "rule.default"});
            t_WEIGHTED_NOT_INITIALIZED = (SelectionDescription)DescriptionManagerFactory.getDescriptionManager().getDescription(SelectionDescription.KEY_WEIGHTED_NOT_INITIALIZED, SelectionDescription.class.getName());
        }
        catch (Exception e) {
            FFDCFilter.processException(e, SelectionDescriptionImpl.class.getName() + "<clinit>", "125");
        }
        WEIGHTED = t_WEIGHTED;
        WEIGHTED_PREFER_LOCAL = t_WEIGHTED_PREFER_LOCAL;
        WEIGHTED_NOT_INITIALIZED = t_WEIGHTED_NOT_INITIALIZED;
    }

    public class MementoImpl
    extends ClusterMemberDescriptionImpl.MementoImpl
    implements ClusterDescription.Memento {
        private long m_epoch;
        private long m_influentialEpoch;
        private Map m_members;
        private SelectionDescription m_selection;
        private Map m_clusterScopedData;
        private ClusterDescription m_backupCluster;
        private Map m_weightTable;
        private IdentityMap m_disembodiedWeightTable;
        private Map m_quiesceState;

        protected MementoImpl() {
            block3: {
                super(ClusterDescriptionImpl.this);
                this.m_epoch = -2L;
                this.m_influentialEpoch = -2L;
                this.m_members = new HashMap(4);
                this.m_clusterScopedData = new HashMap(3);
                this.m_backupCluster = null;
                this.m_weightTable = new HashMap(4);
                this.m_quiesceState = new HashMap(1);
                try {
                    this.m_selection = (SelectionDescription)DescriptionManagerFactory.getDescriptionManager().getDescription(SelectionDescription.KEY_WEIGHTED_NOT_INITIALIZED, SelectionDescription.class.getName());
                    DescriptionKey wtKey = (DescriptionKey)ProcessProperties.getInstance().get("key.containing.cluster.weight.table");
                    if (wtKey == null) {
                        wtKey = ClusterDescriptionImpl.getWeightTableKey(ClusterDescriptionImpl.this.getKey());
                    }
                    this.m_disembodiedWeightTable = (IdentityMap)ivDescMgr.getDescription(wtKey, IdentityMap.class.getName());
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, MementoImpl.class.getName() + ".<init>", "863", this);
                    if (!tc.isEventEnabled()) break block3;
                    Tr.event(tc, "unexpected", e);
                }
            }
        }

        public long getStructuralEpoch() {
            return this.m_epoch;
        }

        public Iterator getClusterMembers() {
            return this.m_members.values().iterator();
        }

        public Map getMembers() {
            return this.m_members;
        }

        public Set getMemberEntrySet() {
            return this.m_members.entrySet();
        }

        public Map getWeightTable() {
            HashMap result = new HashMap(this.m_weightTable);
            result.putAll(this.m_disembodiedWeightTable);
            return result;
        }

        public int getWeightTableEntry(DescriptionKey memberKey) {
            if (!this.m_members.containsKey(memberKey)) {
                throw new IllegalArgumentException("The passed in member (" + memberKey + ") is not part of this cluster (" + ClusterDescriptionImpl.this.getKey() + ").");
            }
            int weight = 2;
            Integer weightObj = (Integer)this.m_disembodiedWeightTable.get(memberKey);
            if (weightObj == null) {
                weightObj = (Integer)this.m_weightTable.get(memberKey);
            }
            if (weightObj != null) {
                weight = weightObj;
            }
            return weight;
        }

        public ClusterDescription getBackupCluster() {
            return this.m_backupCluster;
        }

        public SelectionDescription getSelectionDescription() {
            return this.m_selection;
        }

        public long getInfluentialEpoch() {
            return this.m_influentialEpoch;
        }

        public byte[] getClusterScopedData(DescriptionKey dataKey) {
            return (byte[])this.m_clusterScopedData.get(dataKey);
        }

        public Set getClusterScopedData() {
            return this.m_clusterScopedData.entrySet();
        }

        public boolean isQuiesced(Identity member) {
            return this.m_quiesceState.containsKey(member);
        }

        public Map getQuiesceState() {
            return this.m_quiesceState;
        }

        public byte getState() {
            int result = 3;
            Iterator iter = this.getClusterMembers();
            while (iter.hasNext()) {
                ClusterMemberDescription member = (ClusterMemberDescription)iter.next();
                byte memberState = ((ClusterMemberDescription.Memento)member.getMemento()).getState();
                if (memberState == 0) {
                    result = 0;
                    break;
                }
                if (memberState != 9) continue;
                result = 9;
            }
            return (byte)result;
        }

        public boolean isLeaf() {
            return false;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("[").append(super.toString());
            sb.append(" se:").append(this.m_epoch);
            sb.append(" ie:").append(this.m_influentialEpoch);
            sb.append(" members ").append(this.m_members == null ? null : this.m_members.keySet());
            sb.append(" cluster data ").append(this.m_clusterScopedData);
            sb.append(" backup cluster ").append(this.m_backupCluster);
            sb.append(" quiesce state ").append(this.m_quiesceState);
            sb.append(" cluster weight table ").append(this.m_weightTable);
            sb.append(" disembodied weight table ").append(this.m_disembodiedWeightTable);
            return sb.append(']').toString();
        }
    }
}

