/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.service;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.IntrinsicDescription;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.websphere.cluster.topography.ProcessDescription;
import com.ibm.ws.cluster.service.EndPointImpl;
import com.ibm.ws.cluster.topography.SelectionClusterMemberDescription;
import com.ibm.ws.cluster.topography.SelectionClusterMemberDescriptionImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.cluster.ClusterManagement;
import com.ibm.wsspi.cluster.EndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.NoClusterDefinedException;
import com.ibm.wsspi.cluster.NoMemberAvailableException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ClusterManagementImpl
implements ClusterManagement {
    private static final TraceComponent tc = Tr.register(ClusterManagementImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final KeyRepository ivKeyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();
    private static final Map scmdDistinction = new HashMap(1);
    private final DescriptionManager localOrGlobalDescMgr;

    public ClusterManagementImpl(boolean distribute) {
        this.localOrGlobalDescMgr = distribute ? DescriptionManagerFactory.getDescriptionManager() : DescriptionManagerFactory.getLocalDescriptionManager();
    }

    public Identity createClusterMember(String cellName, String nodeName, String hostName, String memberName) {
        ProcessDescription clusterMember;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createClusterMember", cellName + ":" + nodeName + ":" + hostName + ":" + memberName);
            }
            clusterMember = null;
            SelectionClusterMemberDescriptionImpl selectionMember = null;
            TreeMap<String, String> clusterMemberIdentity = new TreeMap<String, String>();
            clusterMemberIdentity.put("CELLNAME", cellName);
            clusterMemberIdentity.put("NODENAME", nodeName);
            clusterMemberIdentity.put("MEMBERNAME", memberName);
            try {
                DescriptionKey memberKey = ivKeyRepository.getDescriptionKey(clusterMemberIdentity);
                clusterMember = (ProcessDescription)this.localOrGlobalDescMgr.getDescription(memberKey, ProcessDescription.class.getName());
                clusterMember.setNodeName(nodeName);
                clusterMember.setProcessName(memberName);
                TreeMap<String, String> selectionDistinction = new TreeMap<String, String>();
                selectionDistinction.put(SelectionClusterMemberDescription.distinction[0], SelectionClusterMemberDescription.distinction[1]);
                DescriptionKey selectionKey = ivKeyRepository.getDescriptionKey(memberKey, selectionDistinction);
                selectionMember = (SelectionClusterMemberDescriptionImpl)this.localOrGlobalDescMgr.getDescription(selectionKey, SelectionClusterMemberDescription.class.getName());
                if (hostName == null) {
                    hostName = "localhost";
                    try {
                        hostName = InetAddress.getLocalHost().getHostName();
                    }
                    catch (UnknownHostException uhe) {
                        // empty catch block
                    }
                }
                selectionMember.setHost(hostName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "localHost: " + ((SelectionClusterMemberDescription.Memento)selectionMember.getMemento()).getHost());
                }
                selectionMember.setClusterMemberAssociation(memberKey);
                clusterMember.setExtrinsicData(selectionMember);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, ClusterManagementImpl.class.getName() + ".createClusterMember", "143");
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "unexpected exception ", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createClusterMember", clusterMember.getKey());
        }
        return clusterMember.getKey();
    }

    public void joinCluster(Identity clusterIdentity, Identity[] memberIdentities) {
        ClusterDescription clusterDescription;
        block16: {
            if (clusterIdentity == null || memberIdentities == null) {
                throw new IllegalArgumentException("null arguments not allowed");
            }
            if (tc.isEntryEnabled()) {
                Identity[] traceIdentities = new Identity[memberIdentities.length + 1];
                traceIdentities[0] = clusterIdentity;
                System.arraycopy(memberIdentities, 0, traceIdentities, 1, memberIdentities.length);
                Tr.entry(tc, "joinCluster", traceIdentities);
            }
            DescriptionKey clusterKey = (DescriptionKey)clusterIdentity;
            clusterDescription = null;
            try {
                clusterDescription = (ClusterDescription)this.localOrGlobalDescMgr.getDescription(clusterKey, ClusterDescription.class.getName());
            }
            catch (Exception e) {
                FFDCFilter.processException(e, ClusterManagementImpl.class.getName() + ".joinCluster", "175");
                if (!tc.isDebugEnabled()) break block16;
                Tr.debug(tc, "unexpected exception ", e);
            }
        }
        for (int i = 0; i < memberIdentities.length; ++i) {
            ClusterMemberDescription clusterMember;
            block17: {
                DescriptionKey memberKey = (DescriptionKey)memberIdentities[i];
                clusterMember = null;
                Description member = this.localOrGlobalDescMgr.getDescription(memberKey);
                if (member == null) {
                    try {
                        clusterMember = (ClusterMemberDescription)this.localOrGlobalDescMgr.getDescription(memberKey, ClusterMemberDescription.class.getName());
                        clusterMember.setAvailability((byte)0);
                        SelectionClusterMemberDescriptionImpl selectionMember = null;
                        TreeMap<String, String> selectionDistinction = new TreeMap<String, String>();
                        selectionDistinction.put(SelectionClusterMemberDescription.distinction[0], SelectionClusterMemberDescription.distinction[1]);
                        DescriptionKey selectionKey = ivKeyRepository.getDescriptionKey(memberKey, selectionDistinction);
                        selectionMember = (SelectionClusterMemberDescriptionImpl)this.localOrGlobalDescMgr.getDescription(selectionKey, SelectionClusterMemberDescription.class.getName());
                        String hostName = "localhost";
                        try {
                            hostName = InetAddress.getLocalHost().getHostName();
                        }
                        catch (UnknownHostException uhe) {
                            // empty catch block
                        }
                        selectionMember.setHost(hostName);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "localHost: " + ((SelectionClusterMemberDescription.Memento)selectionMember.getMemento()).getHost());
                        }
                        selectionMember.setClusterMemberAssociation(memberKey);
                        clusterMember.setExtrinsicData(selectionMember);
                    }
                    catch (Exception e) {
                        FFDCFilter.processException(e, ClusterManagementImpl.class.getName() + ".joinCluster", "194");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "unexpected exception ", e);
                        }
                        break block17;
                    }
                }
                if (member instanceof ClusterMemberDescription) {
                    clusterMember = (ClusterMemberDescription)member;
                } else {
                    throw new IllegalArgumentException("member is not of correct type");
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "add member[" + i + "] = ", memberIdentities[i]);
            }
            clusterDescription.addMember(clusterMember);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "joinCluster", clusterDescription);
        }
    }

    public void joinCluster(Identity[] clusterIdentities, Identity[] memberIdentities) {
        this.joinCluster(clusterIdentities[clusterIdentities.length - 1], memberIdentities);
        if (clusterIdentities.length > 1) {
            int length = clusterIdentities.length;
            Identity parent = clusterIdentities[length - 2];
            for (int i = clusterIdentities.length - 1; i > 0; --i) {
                Identity[] child = new Identity[]{clusterIdentities[i]};
                this.joinCluster(parent, child);
                parent = child[0];
            }
        }
    }

    public synchronized void disjoinCluster(Identity clusterIdentity, Identity[] memberIdentities) {
        DescriptionKey clusterKey;
        ClusterDescription clusterDescription;
        if (clusterIdentity == null || memberIdentities == null) {
            throw new IllegalArgumentException("null arguments not allowed");
        }
        if (tc.isEntryEnabled()) {
            Identity[] traceIdentities = new Identity[memberIdentities.length + 1];
            traceIdentities[0] = clusterIdentity;
            System.arraycopy(memberIdentities, 0, traceIdentities, 1, memberIdentities.length);
            Tr.entry(tc, "disjoinCluster", traceIdentities);
        }
        if ((clusterDescription = (ClusterDescription)this.localOrGlobalDescMgr.getDescription(clusterKey = (DescriptionKey)clusterIdentity)) != null) {
            for (int i = 0; i < memberIdentities.length; ++i) {
                DescriptionKey memberKey = (DescriptionKey)memberIdentities[i];
                ClusterMemberDescription memberDescription = (ClusterMemberDescription)this.localOrGlobalDescMgr.getDescription(memberKey);
                if (memberDescription == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "remove member[" + i + "] = ", memberIdentities[i]);
                }
                clusterDescription.removeMember(memberDescription);
            }
        } else if (tc.isEventEnabled()) {
            Tr.event(tc, "Null Cluster!");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "disjoinCluster", clusterDescription);
        }
    }

    public void disjoinCluster(Identity[] clusterIdentities, Identity[] memberIdentities) {
        if (clusterIdentities == null || memberIdentities == null) {
            throw new IllegalArgumentException("Identity[] arguments must not be null.");
        }
        if (clusterIdentities.length == 0) {
            throw new IllegalArgumentException("Identity[], clusterIdentities, must contain at least one entry.");
        }
        for (int i = 0; i < clusterIdentities.length - 1; ++i) {
            this.disjoinCluster(clusterIdentities[i], new Identity[]{clusterIdentities[i + 1]});
        }
        this.disjoinCluster(clusterIdentities[clusterIdentities.length - 1], memberIdentities);
    }

    public EndPoint defineClusterScopedData(Identity clusterIdentity, Identity dataIdentity, byte[] data) throws NoClusterDefinedException {
        EndPoint result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "defineClusterScopedData", new Object[]{clusterIdentity, dataIdentity});
        }
        if (clusterIdentity == null || dataIdentity == null || data == null) {
            throw new IllegalArgumentException("null arguments not allowed");
        }
        try {
            DescriptionKey clusterKey = (DescriptionKey)clusterIdentity;
            ClusterDescription clusterDescription = (ClusterDescription)this.localOrGlobalDescMgr.getDescription(clusterKey, ClusterDescription.class.getName());
            clusterDescription.setClusterScopedData((DescriptionKey)dataIdentity, data);
            result = (EndPoint)((Object)this.localOrGlobalDescMgr.getDescription((DescriptionKey)dataIdentity, EndPoint.class.getName()));
            result.setData(data);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, ClusterManagementImpl.class.getName() + ".defineClusterScopedData", "312", this, new Object[]{clusterIdentity, dataIdentity, data});
            IllegalArgumentException iae = new IllegalArgumentException("Could not resolve clusterIdentity.");
            iae.initCause(e);
            throw iae;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "defineClusterScopedData", result);
        }
        return result;
    }

    public EndPoint defineMemberScopedData(Identity memberIdentity, Identity dataIdentity, byte[] data) throws NoMemberAvailableException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "defineMemberScopedData", new Object[]{memberIdentity, dataIdentity});
        }
        if (memberIdentity == null || dataIdentity == null || data == null) {
            throw new IllegalArgumentException("null arguments not allowed");
        }
        DescriptionKey memberKey = (DescriptionKey)memberIdentity;
        EndPointImpl result = null;
        try {
            ClusterMemberDescription member = (ClusterMemberDescription)this.localOrGlobalDescMgr.getDescription(memberKey, ClusterMemberDescription.class.getName());
            result = (EndPointImpl)this.localOrGlobalDescMgr.getDescription((DescriptionKey)dataIdentity, EndPoint.class.getName());
            result.setMemberIdentity(memberIdentity);
            result.setData(data);
            member.setExtrinsicData(result);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, ClusterManagementImpl.class.getName() + ".defineMemberScopedData", "346");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception ", e);
            }
            IllegalArgumentException iae = new IllegalArgumentException("An internal error occurred while trying to process the member data.");
            iae.initCause(e);
            throw iae;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "defineMemberScopedData", result);
        }
        return result;
    }

    public synchronized void undefineClusterScopedData(Identity clusterIdentity, EndPoint data) throws NoClusterDefinedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "undefineClusterScopedData", new Object[]{clusterIdentity, data});
        }
        if (clusterIdentity == null || data == null) {
            throw new IllegalArgumentException("null arguments not allowed");
        }
        DescriptionKey clusterKey = (DescriptionKey)clusterIdentity;
        DescriptionKey dataKey = (DescriptionKey)data.getIdentity();
        ClusterDescription clusterDescription = (ClusterDescription)this.localOrGlobalDescMgr.getDescription(clusterKey);
        if (clusterDescription == null) {
            throw new NoClusterDefinedException(clusterIdentity);
        }
        clusterDescription.removeClusterScopedData(dataKey);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "undefineClusterScopedData");
        }
    }

    public synchronized void undefineMemberScopedData(Identity memberIdentity, EndPoint data) throws NoMemberAvailableException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "undefineMemberScopedData", new Object[]{memberIdentity, data});
        }
        if (memberIdentity == null || data == null) {
            throw new IllegalArgumentException("null arguments not allowed");
        }
        DescriptionKey memberKey = (DescriptionKey)memberIdentity;
        DescriptionKey dataKey = (DescriptionKey)data.getIdentity();
        ProcessDescription memberDescription = (ProcessDescription)this.localOrGlobalDescMgr.getDescription(memberKey);
        if (memberDescription == null) {
            throw new NoMemberAvailableException(memberIdentity);
        }
        memberDescription.removeExtrinsicData(dataKey);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "undefineMemberScopedData");
        }
    }

    public int getDesiredWeight(Identity cluster, Identity member) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDesiredWeight", new Object[]{cluster, member});
        }
        if (cluster == null) {
            throw new IllegalArgumentException("The cluster's Identity can not be null.");
        }
        if (member == null) {
            throw new IllegalArgumentException("The member's Identity can not be null.");
        }
        try {
            ClusterDescription cd = (ClusterDescription)this.localOrGlobalDescMgr.getDescription((DescriptionKey)cluster, ClusterDescription.class.getName());
            ClusterDescription.Memento cdMemento = (ClusterDescription.Memento)cd.getMemento();
            int weight = cdMemento.getWeightTableEntry((DescriptionKey)member);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDesiredWeight", String.valueOf(weight));
            }
            return weight;
        }
        catch (Exception e) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unexpected", e);
            }
            IllegalArgumentException iae = new IllegalArgumentException("Could not process parameters.");
            iae.initCause(e);
            throw iae;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDesiredWeight(Identity clusterIdentity, Identity memberIdentity, int weight) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDesiredWeight", new Object[]{clusterIdentity, memberIdentity, String.valueOf(weight)});
        }
        if (clusterIdentity == null) {
            throw new IllegalArgumentException("The cluster's Identity can not be null.");
        }
        if (memberIdentity == null) {
            throw new IllegalArgumentException("The member's Identity can not be null.");
        }
        Identity identity = clusterIdentity;
        synchronized (identity) {
            block9: {
                try {
                    ClusterDescription cluster = (ClusterDescription)this.localOrGlobalDescMgr.getDescription((DescriptionKey)clusterIdentity, ClusterDescription.class.getName());
                    cluster.setClusterWeightTableEntry((DescriptionKey)memberIdentity, new Integer(weight));
                }
                catch (Exception e) {
                    FFDCFilter.processException(e, ClusterManagementImpl.class.getName() + ".setDesiredWeight", "475", this, new Object[]{clusterIdentity, memberIdentity, String.valueOf(weight)});
                    if (!tc.isEventEnabled()) break block9;
                    Tr.event(tc, "unexpected", e);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDesiredWeight", new Integer(weight));
        }
    }

    public void defineAttribute(Identity identity, String attribute) {
        if (identity == null) {
            throw new IllegalArgumentException("The identity argument must not be null.");
        }
        if (attribute == null) {
            throw new IllegalArgumentException("The attribute argument must not be null.");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "defineAttribute", new Object[]{identity, attribute});
        }
        try {
            IntrinsicDescription intrinsic = (IntrinsicDescription)this.localOrGlobalDescMgr.getDescription((DescriptionKey)identity);
            DescriptionKey scmdKey = ivKeyRepository.getDescriptionKey((DescriptionKey)identity, scmdDistinction);
            SelectionClusterMemberDescription scmd = (SelectionClusterMemberDescription)((IntrinsicDescription.Memento)intrinsic.getMemento()).getExtrinsicData(scmdKey);
            if (scmd == null) {
                Thread.sleep(500L);
                scmd = (SelectionClusterMemberDescription)((IntrinsicDescription.Memento)intrinsic.getMemento()).getExtrinsicData(scmdKey);
                if (scmd == null) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Could not resolve identity");
                    }
                    throw new IllegalArgumentException("Could not resolve identity.");
                }
                intrinsic.setExtrinsicData(scmd);
            }
            scmd.addAttribute(attribute);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "defineAttribute", scmd);
            }
        }
        catch (ClassCastException cce) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Likely user error", cce);
            }
            IllegalArgumentException iae = new IllegalArgumentException("The identity argument must be a cluster or member identity.");
            iae.initCause(cce);
            throw iae;
        }
        catch (IllegalArgumentException iae) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Likely coding error", iae);
            }
            throw iae;
        }
        catch (Exception e) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unexpected exception", e);
            }
            IllegalStateException ise = new IllegalStateException("Unable to load attribute.");
            ise.initCause(e);
            throw ise;
        }
    }

    public void undefineAttribute(Identity identity, String attribute) {
        DescriptionKey scmdKey;
        SelectionClusterMemberDescription scmd;
        if (identity == null) {
            throw new IllegalArgumentException("The identity argument must not be null.");
        }
        if (attribute == null) {
            throw new IllegalArgumentException("The attribute argument must not be null.");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "undefineAttribute", new Object[]{identity, attribute});
        }
        if ((scmd = (SelectionClusterMemberDescription)this.localOrGlobalDescMgr.getDescription(scmdKey = ivKeyRepository.getDescriptionKey((DescriptionKey)identity, scmdDistinction))) != null) {
            scmd.removeAttribute(attribute);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "undefineAttribute", scmd);
        }
    }

    public Set getAttributes(Identity identity) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributes", identity);
        }
        Set attributes = null;
        try {
            IntrinsicDescription intrinsic = (IntrinsicDescription)this.localOrGlobalDescMgr.getDescription((DescriptionKey)identity);
            DescriptionKey scmdKey = ivKeyRepository.getDescriptionKey((DescriptionKey)identity, scmdDistinction);
            SelectionClusterMemberDescription scmd = (SelectionClusterMemberDescription)((IntrinsicDescription.Memento)intrinsic.getMemento()).getExtrinsicData(scmdKey);
            if (scmd != null) {
                attributes = ((SelectionClusterMemberDescription.Memento)scmd.getMemento()).getAttributes();
            } else if (tc.isEventEnabled()) {
                Tr.event(tc, "SelctionClusterMember Description is null");
            }
        }
        catch (ClassCastException cce) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unexpected exception trying to getAttributes", cce);
            }
            IllegalArgumentException iae = new IllegalArgumentException("The identity argument must be a cluster member identity.");
            iae.initCause(cce);
            throw iae;
        }
        catch (Exception e) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unexpected exception", e);
            }
            FFDCFilter.processException(e, ClusterManagementImpl.class.getName() + ".getAttributes", "694");
            IllegalStateException ise = new IllegalStateException("Unexpected exception trying to getAttributes");
            ise.initCause(e);
            throw ise;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributes", attributes);
        }
        return attributes;
    }

    public void setClusterAssociation(Identity cluster, Identity member) {
        block3: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setClusterAssociation", new Object[]{cluster, member});
            }
            try {
                ProcessDescription clusterMember = (ProcessDescription)this.localOrGlobalDescMgr.getDescription((DescriptionKey)member, ProcessDescription.class.getName());
                clusterMember.setClusterAssociation((DescriptionKey)cluster);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, ClusterManagementImpl.class.getName() + ".setClusterAssociation", "742");
                if (!tc.isEventEnabled()) break block3;
                Tr.event(tc, "unexpected exception ", e);
            }
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.37 ");
        }
        scmdDistinction.put(SelectionClusterMemberDescription.distinction[0], SelectionClusterMemberDescription.distinction[1]);
    }
}

