/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.selection.rule;

import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.wsspi.cluster.selection.RuleArbitrator;
import com.ibm.wsspi.cluster.selection.SelectionRule;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class ApplicableStatesRule
implements SelectionRule {
    private static final DescriptionManager descMgr = DescriptionManagerFactory.getDescriptionManager();
    private RuleArbitrator arbitrator = null;
    private final byte[] applicableStates;

    public ApplicableStatesRule(byte[] applicableStates) {
        this.applicableStates = applicableStates;
    }

    public void subset(List identities, StringBuffer reason) {
        Iterator iter = identities.iterator();
        while (iter.hasNext()) {
            DescriptionKey element = (DescriptionKey)iter.next();
            if (this.arbitrator != null) {
                this.arbitrator.registerNotificationType(this, element, "type.state.change.availability");
            }
            ClusterMemberDescription.Memento memento = (ClusterMemberDescription.Memento)descMgr.getDescription(element).getMemento();
            byte state = memento.getAvailability();
            boolean remove = true;
            for (int i = 0; i < this.applicableStates.length; ++i) {
                if (state != this.applicableStates[i]) continue;
                remove = false;
                break;
            }
            if (!remove) continue;
            iter.remove();
            reason.append(element).append(" removed: state not applicable. ").append(state);
        }
    }

    public void registerRuleArbitrator(RuleArbitrator coordinator) {
        this.arbitrator = coordinator;
    }

    public String toString() {
        return super.toString() + Arrays.toString(this.applicableStates);
    }
}

