/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.selection.algorithm;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cluster.selection.algorithm.SelectionAlgorithm;
import com.ibm.wsspi.cluster.Identity;
import java.util.Random;

public final class WeightedProportionalAlgorithm
implements SelectionAlgorithm {
    private static final TraceComponent tc = Tr.register(WeightedProportionalAlgorithm.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private Memento m;
    private static final Random random;
    private int index = random.nextInt(Integer.MAX_VALUE);
    private int round = 0;

    public WeightedProportionalAlgorithm() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.prepare(new Identity[0], new int[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Identity select() {
        int lindex;
        Memento lm = this.m;
        if (lm.size == 0) {
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "select", this);
        }
        int i = 0;
        while ((long)i < lm.sum) {
            ++this.index;
            lindex = this.index %= lm.size;
            ++this.round;
            if ((long)this.round >= lm.sum) {
                this.round = 0;
                lm = this.m;
                if (lm.size == 0) {
                    return null;
                }
                lindex %= lm.size;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "variables", new Object[]{new StringBuffer("iteration ").append(i).append(" index ").append(lindex).append(" round ").append(this.round).append(" total hits ").append(lm.totalhits).append(" sum ").append(lm.sum).append(" size ").append(lm.size), new StringBuffer("member ").append(lm.targets[lindex]).append(" weight ").append(lm.weights[lindex]).append(" hits ").append(lm.hits[lindex]).append(" proportion ").append(lm.proportion[lindex]).append(" hit proportion ").append(lm.hits[lindex] / lm.totalhits)});
            }
            if (lm.proportion[lindex] >= lm.hits[lindex] / lm.totalhits) {
                Memento memento = lm;
                synchronized (memento) {
                    lm.totalhits += 1.0;
                    int n = lindex;
                    lm.hits[n] = lm.hits[n] + 1.0;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "select", "select - " + lm.targets[lindex]);
                }
                return lm.targets[lindex];
            }
            ++i;
        }
        i = 0;
        if (i < lm.size) {
            ++this.index;
            lindex = this.index %= lm.size;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "select", "select - outer loop " + lm.targets[lindex]);
            }
            return lm.targets[lindex];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "select", "select - null target " + this);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(Identity[] members, int[] weights) {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepare", members);
        }
        if (members.length != weights.length) {
            throw new IllegalStateException("The target and weight tables must have identical size.");
        }
        int lsize = members.length;
        double ltotalhits = lsize;
        long lsum = 0L;
        double[] lhits = new double[lsize];
        for (int i2 = 0; i2 < lsize; ++i2) {
            lsum += weights[i2] <= 0 ? 0L : (long)weights[i2];
            lhits[i2] = 1.0;
        }
        double[] lproportion = new double[lsize];
        if (lsum > 0L) {
            for (i = 0; i < lsize; ++i) {
                lproportion[i] = weights[i] <= 0 ? -1.0 : (double)weights[i] / (double)lsum + 1.0E-16;
            }
        } else {
            for (i = 0; i < lsize; ++i) {
                lproportion[i] = 1.0 / (double)lsize + 1.0E-16;
            }
        }
        WeightedProportionalAlgorithm weightedProportionalAlgorithm = this;
        synchronized (weightedProportionalAlgorithm) {
            this.m = new Memento(members, weights, lproportion, lsize, lsum, lhits, ltotalhits);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepare", this);
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append("[");
        result.append(this.m.size);
        result.append(" ");
        result.append(this.m.sum);
        result.append(" ");
        result.append(this.index);
        result.append(" ");
        result.append(this.round);
        result.append(" ");
        result.append(this.m.totalhits);
        result.append(" ");
        for (int i = 0; i < this.m.size; ++i) {
            result.append(this.m.targets[i]);
            result.append(" ");
            result.append(this.m.weights[i]);
            result.append(" ");
            result.append(this.m.hits[i]);
            result.append(" ");
            result.append(this.m.proportion[i]);
            result.append(" ");
        }
        result.append("]");
        return result.toString();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.22 ");
        }
        random = new Random();
    }

    private final class Memento {
        final Identity[] targets;
        final int[] weights;
        double[] hits;
        double totalhits;
        final double[] proportion;
        final int size;
        final long sum;

        private Memento(Identity[] targets, int[] weights, double[] proportion, int size, long sum, double[] hits, double totalhits) {
            this.targets = targets;
            this.weights = weights;
            this.proportion = proportion;
            this.size = size;
            this.sum = sum;
            this.hits = hits;
            this.totalhits = totalhits;
        }
    }
}

