/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.selection;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.DescriptionModificationListener;
import com.ibm.websphere.cluster.topography.ExtrinsicDescription;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.ws.cluster.ProcessProperties;
import com.ibm.ws.cluster.service.ClusterServiceImpl;
import com.ibm.ws.cluster.topography.SelectionClusterMemberDescription;
import com.ibm.wsspi.cluster.ClusterMemberService;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.EndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TargetImpl
implements Target,
DescriptionModificationListener {
    private static final TraceComponent tc = Tr.register(TargetImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private ClusterMemberService cms = (ClusterMemberService)ProcessProperties.getInstance().get("key.clustermember.service");
    private static final DescriptionManager descMgr = DescriptionManagerFactory.getDescriptionManager();
    private static final KeyRepository keyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();
    private static final ProcessProperties processProps = ProcessProperties.getInstance();
    private static final Map scmdDistinction = new HashMap(1);
    Identity[] clusterIdentities = null;
    Identity memberIdentity = null;
    ClusterMemberDescription member = null;
    boolean inHost = false;
    boolean inProcess = false;
    boolean inServer = false;
    Map<Identity, EndPoint> endPoints = null;
    ClusterService ivClusterService = ClusterServiceFactory.getClusterService();
    private long endPointVersion = 0L;
    private Integer endPointMutex = new Integer(98);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetImpl(Identity[] clusters, Identity member, EndPoint[] endPoints) {
        DescriptionKey scmdKey;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{Arrays.toString(clusters), member, Arrays.toString(endPoints)});
        }
        this.clusterIdentities = clusters;
        this.memberIdentity = member;
        this.member = (ClusterMemberDescription)descMgr.getDescription((DescriptionKey)this.memberIdentity);
        ClusterMemberDescription.Memento cmdMemento = (ClusterMemberDescription.Memento)this.member.getMemento();
        SelectionClusterMemberDescription scmd = (SelectionClusterMemberDescription)cmdMemento.getExtrinsicData(scmdKey = keyRepository.getDescriptionKey((DescriptionKey)member, scmdDistinction));
        if (scmd != null && ((SelectionClusterMemberDescription.Memento)scmd.getMemento()).getHost().equals(processProps.get("key.virtual.host"))) {
            this.inHost = true;
        }
        if (this.cms != null) {
            this.inServer = this.cms.getServerClusterContextListener().validateClusterResidency(this.clusterIdentities[this.clusterIdentities.length - 1]);
            this.inProcess = this.cms.getServerClusterContextListener().validateClusterProcessResidency(this.clusterIdentities[this.clusterIdentities.length - 1]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "<init>", "ClusterMember=" + member);
        }
        if (member == null) {
            Tr.error(tc, "Target member is null for the key=" + member);
        }
        Integer n = this.endPointMutex;
        synchronized (n) {
            HashMap<Identity, EndPoint> tempEndPoints = new HashMap<Identity, EndPoint>();
            for (int i = 0; i < endPoints.length; ++i) {
                if (endPoints[i] instanceof ExtrinsicDescription) {
                    ((ExtrinsicDescription)((Object)endPoints[i])).registerNotificationListener(this, "type.memento.updated", null);
                }
                tempEndPoints.put(endPoints[i].getIdentity(), endPoints[i]);
            }
            this.endPoints = tempEndPoints;
            this.endPointVersion = System.currentTimeMillis();
        }
        this.member.registerNotificationListener(this, "type.add.extrinsic", null);
        this.member.registerNotificationListener(this, "type.remove.extrinsic", null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public Identity getMemberIdentity() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMemberIdentity");
            Tr.exit(tc, "getMemberIdentity", this.memberIdentity);
        }
        return this.memberIdentity;
    }

    public Identity[] getClusterIdentities() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterIdentities");
            Tr.exit(tc, "getClusterIdentities", this.clusterIdentities);
        }
        return this.clusterIdentities;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getName());
        result.append("[clusterIdentities ");
        for (int i = 0; i < this.clusterIdentities.length; ++i) {
            result.append(this.clusterIdentities[i]);
        }
        result.append(", memberIdentity ").append(this.memberIdentity);
        Map<Identity, EndPoint> traceCopyEndPoints = this.endPoints;
        result.append(", endPoints ").append(traceCopyEndPoints);
        result.append(", inHost ").append(this.inHost);
        result.append(", inProcess ").append(this.inProcess);
        result.append(", inServer ").append(this.inServer);
        result.append("]");
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndPoint selectEndPoint(Identity dataIdentity) {
        Integer n = this.endPointMutex;
        synchronized (n) {
            return this.endPoints.get(dataIdentity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndPoint[] matchEndPoints(Map propertyNames) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "matchEndPoints", propertyNames);
        }
        EndPoint[] result = null;
        Integer n = this.endPointMutex;
        synchronized (n) {
            result = ((ClusterServiceImpl)this.ivClusterService).matchEndPoints(this.endPoints, propertyNames);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "matchEndPoints", result);
        }
        return result;
    }

    public void setAvailability(boolean available) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAvailability", Boolean.toString(available));
        }
        byte state = available ? (byte)0 : 4;
        this.member.setReachability(state);
    }

    public boolean isTargetInHost() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isTargetInHost");
            Tr.exit(tc, "isTargetInHost", Boolean.toString(this.inHost));
        }
        return this.inHost;
    }

    public boolean isTargetInProcess() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isTargetInProcess");
            Tr.exit(tc, "isTargetInProcess", Boolean.toString(this.inProcess));
        }
        return this.inProcess;
    }

    public ClusterMemberDescription getMember() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMember");
            Tr.exit(tc, "getMember", this.member);
        }
        return this.member;
    }

    public boolean isAvailable() {
        return ((ClusterMemberDescription.Memento)this.member.getMemento()).getState() == 0;
    }

    public boolean isTargetInServer() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isTargetInServer");
            Tr.exit(tc, "isTargetInServer", Boolean.toString(this.inServer));
        }
        return this.inServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEndPointVersion() {
        Integer n = this.endPointMutex;
        synchronized (n) {
            return this.endPointVersion;
        }
    }

    public Object getEndPointMutex() {
        return this.endPointMutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(DescriptionKey key, String type, Object userData, Object handback) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification", new Object[]{key, type, userData, handback, "This cluster: " + Arrays.toString(this.clusterIdentities) + " This member: " + this.memberIdentity});
        }
        long thisversion = -1L;
        if (type.equals("type.add.extrinsic") || type.equals("type.remove.extrinsic") || type.equals("type.memento.updated")) {
            ClusterMemberDescription.Memento cmdMemento = (ClusterMemberDescription.Memento)this.member.getMemento();
            ArrayList epList = new ArrayList(cmdMemento.getExtrinsicData().values());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Number of Endpoints in Memento: " + String.valueOf(epList.size()));
                Tr.debug(tc, "Endpoint List", epList);
            }
            Iterator iter = epList.iterator();
            while (iter.hasNext()) {
                ExtrinsicDescription exDesc = (ExtrinsicDescription)iter.next();
                if (!(exDesc instanceof EndPoint)) {
                    iter.remove();
                    continue;
                }
                exDesc.registerNotificationListener(this, "type.memento.updated", null);
            }
            EndPoint[] eps = new EndPoint[epList.size()];
            epList.toArray(eps);
            HashMap<Identity, EndPoint> tempEndPoints = new HashMap<Identity, EndPoint>();
            for (int i = 0; i < eps.length; ++i) {
                tempEndPoints.put(eps[i].getIdentity(), eps[i]);
            }
            Integer n = this.endPointMutex;
            synchronized (n) {
                this.endPoints = tempEndPoints;
                for (thisversion = System.currentTimeMillis(); this.endPointVersion >= thisversion; ++thisversion) {
                }
                this.endPointVersion = thisversion;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification", thisversion);
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.20 : none");
        }
        scmdDistinction.put(SelectionClusterMemberDescription.distinction[0], SelectionClusterMemberDescription.distinction[1]);
    }
}

