/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.control.mbean;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.MBeanRoute;
import com.ibm.ws.wlm.TypeConversion;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.EndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.Target;
import com.ibm.wsspi.cluster.selection.SelectionCriteria;
import com.ibm.wsspi.cluster.selection.SelectionService;
import com.ibm.wsspi.cluster.selection.SelectionServiceFactory;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;

public class MBeanRouter
extends com.ibm.ws.management.MBeanRouter {
    static final TraceComponent tc = Tr.register(MBeanRouter.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final ClusterService clusterService = ClusterServiceFactory.getClusterService();
    private static final SelectionService selectionService = SelectionServiceFactory.getSelectionService();
    private static final Map criteriaCache = new HashMap();
    public static final Map dataName;

    public static Identity getIdentity(String clusterName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIdentity", clusterName);
        }
        Identity result = null;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("type", "JMX");
        map.put("clusterName", clusterName);
        result = clusterService.getIdentity(map);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIdentity", result);
        }
        return result;
    }

    public MBeanRouter() {
        super(-1);
        if (tc.isEventEnabled()) {
            Tr.event(tc, "<init>", (Object)this);
        }
    }

    public SelectionCriteria getCriteria(String clusterName) {
        SelectionCriteria result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCriteria", clusterName);
        }
        if ((result = (SelectionCriteria)criteriaCache.get(clusterName)) == null) {
            result = selectionService.getCriteria(MBeanRouter.getIdentity(clusterName), false, false, null, null);
            criteriaCache.put(clusterName, result);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCriteria", result);
        }
        return result;
    }

    public int getPriority() {
        return super.getPriority();
    }

    public MBeanRoute findRoute(ObjectName objectName) {
        MBeanRoute result;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "findRoute", objectName);
            }
            result = null;
            String clusterName = objectName.getKeyProperty("clusterName");
            if (clusterName != null) {
                SelectionCriteria criteria = this.getCriteria(clusterName);
                try {
                    Target target = selectionService.select(criteria);
                    EndPoint[] endpoint = target.matchEndPoints(dataName);
                    if (endpoint != null && endpoint.length > 0) {
                        byte[] bytes = endpoint[0].getData();
                        String[] nodeAndProcess = TypeConversion.bytesToStrings((byte[])bytes);
                        if (nodeAndProcess != null && nodeAndProcess.length == 2) {
                            String domain = objectName.getDomain();
                            Hashtable<String, String> hashtable = objectName.getKeyPropertyList();
                            hashtable.put("node", nodeAndProcess[0]);
                            hashtable.put("process", nodeAndProcess[1]);
                            ObjectName transformON = new ObjectName(domain, hashtable);
                            result = new MBeanRoute(transformON);
                        } else {
                            Throwable t = new Throwable("Unable to transform ObjectName end point data error.");
                            FFDCFilter.processException(t, MBeanRouter.class.getName() + ".findRoute", "221", (Object)this, new Object[]{objectName, clusterName, target, endpoint});
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "Unable to transform ObjectName end point data error.", endpoint);
                            }
                        }
                    } else {
                        Throwable t = new Throwable("Unable to transform ObjectName, end point unavailable");
                        FFDCFilter.processException(t, MBeanRouter.class.getName() + ".findRoute", "228", (Object)this, new Object[]{objectName, clusterName, target});
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Unable to transform ObjectName, end point unavailable", target);
                        }
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, MBeanRouter.class.getName() + "findRoute", "234", (Object)this);
                    if (!tc.isEventEnabled()) break block11;
                    Tr.event(tc, "unexpected exception", e);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findRoute", result);
        }
        return result;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.6 ");
        }
        dataName = new HashMap();
        dataName.put("type", "MBean");
        dataName.put("component", "JMX");
    }

    private class MBeanSelectionCriteria
    implements SelectionCriteria {
        private Identity identity;

        private MBeanSelectionCriteria(String clusterName) {
            this.identity = MBeanRouter.getIdentity(clusterName);
        }

        public Identity getIdentity() {
            return this.identity;
        }

        public boolean applicableEndPoint(EndPoint[] endpoints) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "applicableEndPoint", endpoints);
            }
            boolean result = false;
            for (int i = 0; i < endpoints.length; ++i) {
                Map map;
                Object type;
                if (!endpoints[i].isAvailable() || (type = (map = endpoints[i].getIdentity().getProperties()).get("type")) == null || !"JMX".equals(type)) continue;
                result = true;
                break;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "applicableEndPoint", String.valueOf(result));
            }
            return result;
        }

        public boolean localProcessOnly() {
            return false;
        }

        public boolean localHostOnly() {
            return false;
        }

        public Map getAttributes() {
            return null;
        }

        public void match(List modifiedMembers) {
        }
    }
}

