/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.ByteArrayOutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public final class Compressor {
    private static final TraceComponent tc = Tr.register(Compressor.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final int CHUNK_SIZE = 1024;
    private static final Deflater deflater;
    private static final Inflater inflater;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(byte[] input, int offset) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(input.length);
        bos.write(input, 0, offset);
        Deflater deflater = Compressor.deflater;
        synchronized (deflater) {
            try {
                Compressor.deflater.setInput(input, offset, input.length - offset);
                Compressor.deflater.finish();
                byte[] buf = new byte[1024];
                while (!Compressor.deflater.finished()) {
                    int size = Compressor.deflater.deflate(buf);
                    bos.write(buf, 0, size);
                }
            }
            finally {
                Compressor.deflater.reset();
            }
        }
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decompress(byte[] input, int offset) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(input.length);
        bos.write(input, 0, offset);
        Inflater inflater = Compressor.inflater;
        synchronized (inflater) {
            try {
                Compressor.inflater.setInput(input, offset, input.length - offset);
                byte[] buf = new byte[1024];
                while (!Compressor.inflater.finished()) {
                    int size = Compressor.inflater.inflate(buf);
                    if (size == 0) {
                        if (!Compressor.inflater.needsInput()) continue;
                        Compressor.inflater.setInput(new byte[]{-1});
                        continue;
                    }
                    bos.write(buf, 0, size);
                }
                Compressor.inflater.reset();
            }
            catch (DataFormatException dfe) {
                byte[] byArray;
                try {
                    FFDCFilter.processException((Throwable)dfe, Compressor.class.getName() + ".decompress", "182", (Object)input);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Problem reading compressed input.", new Object[]{dfe});
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Decompress returning original input.", input);
                    }
                    byArray = input;
                    Compressor.inflater.reset();
                }
                catch (Throwable throwable) {
                    Compressor.inflater.reset();
                    throw throwable;
                }
                return byArray;
            }
            return bos.toByteArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decompress(byte[] input, int offset, int dataSegmentLength) {
        byte[] result = new byte[offset + dataSegmentLength];
        System.arraycopy(input, 0, result, 0, offset);
        Inflater inflater = Compressor.inflater;
        synchronized (inflater) {
            try {
                Compressor.inflater.setInput(input, offset, input.length - offset);
                int size = Compressor.inflater.inflate(result, offset, dataSegmentLength);
                if (size != dataSegmentLength && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Data segment decompression size mismatch. Expected " + dataSegmentLength + " bytes, but actually decompressed " + size + " bytes.");
                }
                Compressor.inflater.reset();
            }
            catch (DataFormatException dfe) {
                byte[] byArray;
                try {
                    FFDCFilter.processException((Throwable)dfe, Compressor.class.getName() + ".decompress", "234", (Object)input);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Problem reading compressed input.", new Object[]{dfe});
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Decompress returning original input.", input);
                    }
                    byArray = input;
                    Compressor.inflater.reset();
                }
                catch (Throwable throwable) {
                    Compressor.inflater.reset();
                    throw throwable;
                }
                return byArray;
            }
            return result;
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.9 ");
        }
        deflater = new Deflater(-1, true);
        inflater = new Inflater(true);
    }
}

