/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloader;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.URL.ParserUtils;
import com.ibm.ws.classloader.ClassProviderListener;
import com.ibm.ws.classloader.Handler;
import com.ibm.ws.classloader.ResourceCache;
import com.ibm.ws.security.util.AccessController;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketPermission;
import java.net.URL;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SinglePathClassProvider {
    private static TraceComponent tc = Tr.register(SinglePathClassProvider.class.getName(), "Websphere ClassLoader", null);
    protected File pathFile = null;
    protected boolean pathExists = false;
    protected boolean isDirectory = false;
    protected URL url = null;
    protected String path = null;
    protected ZipFile cachedZip = null;
    protected boolean cachingEnabled = false;
    protected Manifest manifest = null;
    private static final boolean emulateURLClassLoader = Boolean.getBoolean("com.ibm.ws.classloader.strict");
    private static String resourceURLProtocol = Handler.register() ? "wsjar" : "jar";
    private static final boolean encodeResourceURLs = Boolean.getBoolean("com.ibm.ws.classloader.encodeResourceURLs");
    private ResourceCache resourcesInJar = new ResourceCache('/');
    private ResourceCache classesInJar = new ResourceCache('.');
    private Set metaInfEntries = new HashSet();

    public SinglePathClassProvider(String fpath) {
        this.pathFile = new File(fpath);
        try {
            this.path = this.pathFile.getCanonicalPath();
        }
        catch (IOException ioe) {
            Manager.Ffdc.log(ioe, this, "com.ibm.ws.classloader.SinglePathClassProvider.run", "40", this);
            this.path = fpath;
        }
        this.pathExists = this.pathFile.exists();
        this.isDirectory = this.pathFile.isDirectory();
        if (this.pathExists && !this.isDirectory) {
            this.buildContentsCache();
        }
        try {
            File canonicalFile = this.pathFile.getCanonicalFile();
            this.url = encodeResourceURLs ? canonicalFile.toURI().toURL() : canonicalFile.toURL();
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.ws.classloader.SinglePathClassProvider.run", "59", this);
        }
    }

    public void setCaching(boolean enabled) {
        this.cachingEnabled = enabled;
        if (!enabled && this.cachedZip != null) {
            try {
                this.cachedZip.close();
            }
            catch (Exception ex) {
                Manager.Ffdc.log(ex, this, "com.ibm.ws.classloader.SinglePathClassProvider.setCaching", "74", this);
            }
            this.cachedZip = null;
        }
    }

    protected Manifest getManifest() {
        return this.manifest;
    }

    public void reload() {
        this.pathFile = new File(this.path);
        this.pathExists = this.pathFile.exists();
        this.isDirectory = this.pathFile.isDirectory();
        this.resourcesInJar.clear();
        this.classesInJar.clear();
        if (this.pathExists && !this.isDirectory) {
            this.buildContentsCache();
        }
    }

    public void dispose() {
        this.resourcesInJar.clear();
        this.classesInJar.clear();
        this.cachedZip = null;
        this.pathFile = null;
        this.url = null;
        this.manifest = null;
    }

    public URL getURL() {
        return this.url;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isValid() {
        return this.pathExists;
    }

    public byte[] getClassBytes(String name2, ClassProviderListener ccl) {
        byte[] b = null;
        if (this.pathExists) {
            b = this.isDirectory ? this.getClassBytesFromDir(name2, ccl) : this.getClassBytesFromJar(name2, ccl);
        }
        return b;
    }

    protected byte[] getClassBytesFromDir(final String cName, final ClassProviderListener ccl) {
        return (byte[])AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public Object run() {
                File file;
                FileInputStream fin;
                block17: {
                    String className = cName.replace('.', '/');
                    fin = null;
                    String path = SinglePathClassProvider.this.getRealResourcePath(className + ".class");
                    file = new File(path);
                    if (file.exists()) break block17;
                    Object var5_7 = null;
                    try {
                        if (fin != null) {
                            fin.close();
                        }
                    }
                    catch (IOException e) {
                        Manager.Ffdc.log(e, this, "com.ibm.ws.classloader.SinglePathClassProvider.run", "172", this);
                    }
                    return var5_7;
                }
                fin = new FileInputStream(file);
                byte[] b = new byte[(int)file.length()];
                SinglePathClassProvider.this.readFully(fin, b);
                ccl.classLoadedFromFile(file);
                byte[] byArray = b;
                try {
                    if (fin != null) {
                        fin.close();
                    }
                }
                catch (IOException e) {
                    Manager.Ffdc.log(e, this, "com.ibm.ws.classloader.SinglePathClassProvider.run", "172", this);
                }
                return byArray;
                catch (IOException ioe) {
                    block18: {
                        try {
                            Manager.Ffdc.log(ioe, this, "com.ibm.ws.classloader.SinglePathClassProvider.run", "164", this);
                            if (!tc.isDebugEnabled()) break block18;
                            Tr.debug(tc, "getClassBytesFromDir", ioe);
                        }
                        catch (Throwable throwable) {
                            try {
                                if (fin != null) {
                                    fin.close();
                                }
                            }
                            catch (IOException e) {
                                Manager.Ffdc.log(e, this, "com.ibm.ws.classloader.SinglePathClassProvider.run", "172", this);
                            }
                            throw throwable;
                        }
                    }
                    try {
                        if (fin != null) {
                            fin.close();
                        }
                    }
                    catch (IOException e) {
                        Manager.Ffdc.log(e, this, "com.ibm.ws.classloader.SinglePathClassProvider.run", "172", this);
                    }
                }
                return null;
            }
        });
    }

    protected byte[] getClassBytesFromJar(final String className, final ClassProviderListener ccl) {
        if (this.classesInJar.contains(className, '.')) {
            return (byte[])AccessController.doPrivileged(new PrivilegedAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public Object run() {
                    byte[] buf;
                    block40: {
                        IOException ioe222222;
                        ZipFile zipFile;
                        ByteArrayOutputStream baos;
                        InputStream jis;
                        block36: {
                            block35: {
                                String name2;
                                ZipEntry zipEntry;
                                buf = null;
                                jis = null;
                                baos = null;
                                zipFile = SinglePathClassProvider.this.cachedZip;
                                if (zipFile == null) {
                                    zipFile = new ZipFile(SinglePathClassProvider.this.pathFile);
                                }
                                if ((zipEntry = zipFile.getEntry((name2 = className.replace('.', '/')) + ".class")) == null) break block35;
                                jis = zipFile.getInputStream(zipEntry);
                                long zipEntrySize = zipEntry.getSize();
                                if (zipEntrySize != -1L) {
                                    int size = (int)zipEntrySize;
                                    buf = new byte[size];
                                    SinglePathClassProvider.this.readFully(jis, buf);
                                } else {
                                    byte[] tmpbuf = new byte[4096];
                                    baos = new ByteArrayOutputStream();
                                    int len = 0;
                                    while ((len = jis.read(tmpbuf, 0, tmpbuf.length)) != -1) {
                                        baos.write(tmpbuf, 0, len);
                                    }
                                    buf = baos.toByteArray();
                                }
                                ccl.classLoadedFromFile(SinglePathClassProvider.this.pathFile);
                            }
                            Object var12_12 = null;
                            if (SinglePathClassProvider.this.cachingEnabled) {
                                SinglePathClassProvider.this.cachedZip = zipFile;
                                break block36;
                            }
                            if (zipFile == null) break block36;
                            try {
                                zipFile.close();
                            }
                            catch (IOException ioe222222) {
                                Manager.Ffdc.log(ioe222222, this, "com.ibm.ws.classloader.SinglePathClassProvider.run", "230", this);
                            }
                        }
                        if (jis != null) {
                            try {
                                jis.close();
                            }
                            catch (IOException ioe222222) {
                                Manager.Ffdc.log(ioe222222, this, "com.ibm.ws.classloader.SinglePathClassProvider.run", "241", this);
                            }
                        }
                        if (baos != null) {
                            try {
                                baos.close();
                            }
                            catch (IOException ioe222222) {
                                Manager.Ffdc.log(ioe222222, this, "com.ibm.ws.classloader.SinglePathClassProvider.run", "252", this);
                            }
                        }
                        break block40;
                        {
                            catch (IOException e) {
                                IOException ioe222222;
                                Manager.Ffdc.log(e, this, "com.ibm.ws.classloader.SinglePathClassProvider.run", "214", this);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, e.toString());
                                }
                                Object var12_13 = null;
                                if (SinglePathClassProvider.this.cachingEnabled) {
                                    SinglePathClassProvider.this.cachedZip = zipFile;
                                } else if (zipFile != null) {
                                    try {
                                        zipFile.close();
                                    }
                                    catch (IOException ioe222222) {
                                        Manager.Ffdc.log(ioe222222, this, "com.ibm.ws.classloader.SinglePathClassProvider.run", "230", this);
                                    }
                                }
                                if (jis != null) {
                                    try {
                                        jis.close();
                                    }
                                    catch (IOException ioe222222) {
                                        Manager.Ffdc.log(ioe222222, this, "com.ibm.ws.classloader.SinglePathClassProvider.run", "241", this);
                                    }
                                }
                                if (baos != null) {
                                    try {
                                        baos.close();
                                    }
                                    catch (IOException ioe222222) {
                                        Manager.Ffdc.log(ioe222222, this, "com.ibm.ws.classloader.SinglePathClassProvider.run", "252", this);
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            IOException ioe222222;
                            Object var12_14 = null;
                            if (SinglePathClassProvider.this.cachingEnabled) {
                                SinglePathClassProvider.this.cachedZip = zipFile;
                            } else if (zipFile != null) {
                                try {
                                    zipFile.close();
                                }
                                catch (IOException ioe222222) {
                                    Manager.Ffdc.log(ioe222222, this, "com.ibm.ws.classloader.SinglePathClassProvider.run", "230", this);
                                }
                            }
                            if (jis != null) {
                                try {
                                    jis.close();
                                }
                                catch (IOException ioe222222) {
                                    Manager.Ffdc.log(ioe222222, this, "com.ibm.ws.classloader.SinglePathClassProvider.run", "241", this);
                                }
                            }
                            if (baos != null) {
                                try {
                                    baos.close();
                                }
                                catch (IOException ioe222222) {
                                    Manager.Ffdc.log(ioe222222, this, "com.ibm.ws.classloader.SinglePathClassProvider.run", "252", this);
                                }
                            }
                            throw throwable;
                        }
                    }
                    if (buf == null && tc.isDebugEnabled()) {
                        Tr.debug(tc, "failed to read " + className + " from " + SinglePathClassProvider.this.path);
                    }
                    return buf;
                }
            });
        }
        return null;
    }

    protected String getRealResourcePath(String resource) {
        StringBuffer sb = new StringBuffer(this.path.length() + resource.length() + 1);
        sb.append(this.path);
        sb.append(File.separatorChar);
        char[] chars = resource.toCharArray();
        if (chars.length != 1 || chars[0] != '/' && chars[0] != '\\') {
            boolean lastCharWasSeparator = true;
            int j = 0;
            int N = chars.length;
            for (int i = 0; i < N; ++i) {
                if (lastCharWasSeparator) {
                    while ((chars[i] == '/' || chars[i] == '\\') && ++i < N) {
                    }
                }
                if (chars[i] == '/' || chars[i] == '\\') {
                    lastCharWasSeparator = true;
                    chars[j++] = File.separatorChar;
                    continue;
                }
                lastCharWasSeparator = false;
                chars[j++] = chars[i];
            }
            sb.append(chars, 0, j);
        }
        String result = sb.toString();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append('[').append(this.pathFile);
        if (!this.pathExists) {
            sb.append(", nonexistent");
        } else if (this.isDirectory) {
            sb.append(", directory");
        }
        return sb.append(']').toString();
    }

    public URL getResource(String resourceName) {
        URL url = null;
        if (this.pathExists && resourceName != null) {
            String name2;
            if (emulateURLClassLoader && resourceName.startsWith("/")) {
                return null;
            }
            boolean found = true;
            if (!this.isDirectory) {
                if (resourceName.startsWith("/")) {
                    resourceName = resourceName.substring(1);
                }
                found = resourceName.startsWith("META-INF/") ? this.metaInfEntries.contains(resourceName) : (resourceName.endsWith(".class") ? this.classesInJar.contains(resourceName, '/') : (resourceName.endsWith("/") ? this.classesInJar.containsDir(resourceName, '/') || this.resourcesInJar.containsDir(resourceName, '/') : this.resourcesInJar.contains(resourceName, '/')));
            }
            if (found && (url = (URL)AccessController.doPrivileged(new PrivilegedAction(name2 = resourceName){
                final /* synthetic */ String val$name;
                {
                    this.val$name = string;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public Object run() {
                    ZipFile zipFile;
                    URL url;
                    block14: {
                        url = null;
                        if (SinglePathClassProvider.this.isDirectory) {
                            try {
                                String resourcePath = SinglePathClassProvider.this.getRealResourcePath(this.val$name);
                                File file = new File(resourcePath);
                                if (!file.exists()) return url;
                                File canonicalFile = file.getCanonicalFile();
                                URL uRL = url = encodeResourceURLs ? canonicalFile.toURI().toURL() : canonicalFile.toURL();
                                if (resourcePath.indexOf("..") < 0 || resourcePath.indexOf("...") >= 0 || url.getFile().startsWith(SinglePathClassProvider.this.url.getFile())) return url;
                                return null;
                            }
                            catch (Exception e) {
                                Manager.Ffdc.log(e, this, "com.ibm.ws.classloader.SinglePathClassProvider.run", "324", this);
                            }
                            return url;
                        }
                        zipFile = null;
                        zipFile = new ZipFile(SinglePathClassProvider.this.pathFile);
                        ZipEntry zipEntry = zipFile.getEntry(this.val$name);
                        if (zipEntry == null) break block14;
                        URL pathURL = encodeResourceURLs ? SinglePathClassProvider.this.pathFile.toURI().toURL() : SinglePathClassProvider.this.pathFile.toURL();
                        url = new URL(new URL(resourceURLProtocol, "", -1, pathURL + "!/"), ParserUtils.encode((String)this.val$name));
                    }
                    Object var6_11 = null;
                    if (zipFile == null) return url;
                    try {
                        zipFile.close();
                        return url;
                    }
                    catch (IOException e2) {
                        Manager.Ffdc.log(e2, this, "com.ibm.ws.classloader.SinglePathClassProvider.run", "410", this);
                    }
                    return url;
                    {
                        catch (IOException e) {
                            Manager.Ffdc.log(e, this, "com.ibm.ws.classloader.SinglePathClassProvider.run", "350", this);
                            Object var6_12 = null;
                            if (zipFile == null) return url;
                            try {
                                zipFile.close();
                                return url;
                            }
                            catch (IOException e2) {
                                Manager.Ffdc.log(e2, this, "com.ibm.ws.classloader.SinglePathClassProvider.run", "410", this);
                            }
                            return url;
                        }
                        catch (Throwable th) {
                            Manager.Ffdc.log(th, this, "com.ibm.ws.classloader.SinglePathClassProvider.run", "354", this);
                            Object var6_13 = null;
                            if (zipFile == null) return url;
                            try {
                                zipFile.close();
                                return url;
                            }
                            catch (IOException e2) {
                                Manager.Ffdc.log(e2, this, "com.ibm.ws.classloader.SinglePathClassProvider.run", "410", this);
                            }
                            return url;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_14 = null;
                        if (zipFile == null) throw throwable;
                        try {
                            zipFile.close();
                            throw throwable;
                        }
                        catch (IOException e2) {
                            Manager.Ffdc.log(e2, this, "com.ibm.ws.classloader.SinglePathClassProvider.run", "410", this);
                        }
                        throw throwable;
                    }
                }
            })) == null && !this.isDirectory && tc.isDebugEnabled()) {
                Tr.debug(tc, "failed to read " + resourceName + " from " + this.path);
            }
        }
        if (url != null) {
            url = SinglePathClassProvider.checkURL(url);
        }
        return url;
    }

    private static URL checkURL(URL url) {
        try {
            SinglePathClassProvider.check(url);
        }
        catch (Exception exception) {
            return null;
        }
        return url;
    }

    private static void check(URL url) throws IOException {
        Permission permission;
        SecurityManager securitymanager = System.getSecurityManager();
        if (securitymanager != null && (permission = url.openConnection().getPermission()) != null) {
            try {
                securitymanager.checkPermission(permission);
            }
            catch (SecurityException securityexception) {
                if (permission instanceof FilePermission && permission.getActions().indexOf("read") != -1) {
                    securitymanager.checkRead(permission.getName());
                }
                if (permission instanceof SocketPermission && permission.getActions().indexOf("connect") != -1) {
                    securitymanager.checkConnect(url.getHost(), url.getPort());
                }
                throw securityexception;
            }
        }
    }

    public InputStream getResourceAsStream(String name2) {
        URL url = this.getResource(name2);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected void buildContentsCache() {
        try {
            JarFile zipFile = new JarFile(this.path);
            Enumeration<JarEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry ze = entries.nextElement();
                String entryName = ze.getName();
                if (entryName.startsWith("META-INF/")) {
                    this.metaInfEntries.add(entryName);
                    continue;
                }
                if (!emulateURLClassLoader && ze.isDirectory()) continue;
                if (entryName.endsWith(".class")) {
                    this.classesInJar.add(entryName, '/');
                    continue;
                }
                this.resourcesInJar.add(entryName, '/');
            }
            try {
                this.manifest = zipFile.getManifest();
            }
            catch (Exception exception) {
                // empty catch block
            }
            zipFile.close();
        }
        catch (IOException e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.classloader.SinglePathClassProvider.buildContentsCache", "453", this);
        }
    }

    private final void readFully(InputStream is, byte[] b) throws IOException {
        int offset = 0;
        int n = 0;
        for (int len = b.length; len > 0; len -= n) {
            n = is.read(b, offset, len);
            if (n < 0) {
                throw new EOFException();
            }
            offset += n;
        }
    }
}

