/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloader;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.classloader.ClassProviderListener;
import com.ibm.ws.classloader.CompoundClassLoader;
import com.ibm.ws.classloader.WsClassLoader;
import com.ibm.ws.util.PathUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ReloadableClassLoader
extends ClassLoader
implements ClassProviderListener,
WsClassLoader {
    private static final TraceComponent tc = Tr.register(ReloadableClassLoader.class, "Websphere ClassLoader", null);
    protected ClassLoader parent = null;
    protected CompoundClassLoader classLoader = null;
    protected boolean reloadingEnabled = false;
    protected boolean removed = false;
    protected List classProviderListeners = new ArrayList();
    protected boolean disposed = false;
    private HashMap reloadEntries = new HashMap();

    public ReloadableClassLoader(ClassLoader parent) {
        super(parent);
        this.initialize(parent);
    }

    public ReloadableClassLoader(ClassLoader parent, boolean resrcReloadingDisabled) {
        this(parent);
    }

    private void initialize(ClassLoader parent) {
        this.parent = parent;
        if (this.classLoader != null) {
            this.classLoader.addClassProviderListener(this);
        }
    }

    public void createLoader() {
        this.classLoader = new CompoundClassLoader(this.getPaths(), this.parent, this.getDelegationMode());
        this.classLoader.addClassProviderListener(this);
        for (int i = 0; i < this.classProviderListeners.size(); ++i) {
            this.classLoader.addClassProviderListener((ClassProviderListener)this.classProviderListeners.get(i));
        }
    }

    public void addClassProviderListener(ClassProviderListener cpl) {
        this.classProviderListeners.add(cpl);
        if (this.classLoader != null) {
            this.classLoader.addClassProviderListener(cpl);
        }
    }

    public void setName(String name2) {
        this.classLoader.setName(name2);
    }

    public void setDelegationMode(boolean parentFirst) {
        this.classLoader.setDelegationMode(parentFirst);
    }

    public Class loadClass(String name2) throws ClassNotFoundException {
        if (this.classLoader != null) {
            return this.classLoader.loadClass(name2);
        }
        throw new ClassNotFoundException(name2 + ": classLoader was disposed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void classLoadedFromFile(File f) {
        if (this.reloadingEnabled && !this.disposed) {
            String path = f.getPath();
            HashMap hashMap = this.reloadEntries;
            synchronized (hashMap) {
                if (this.reloadEntries.get(path) == null) {
                    long lastModified = f.lastModified();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "adding reload entry " + path + " (" + lastModified + ")");
                    }
                    this.reloadEntries.put(path, new ReloadEntry(f, path, f.lastModified()));
                }
            }
        }
    }

    public URL getResource(String name2) {
        if (this.classLoader != null) {
            return this.classLoader.getResource(name2);
        }
        return null;
    }

    public Enumeration getResources(String name2) throws IOException {
        if (this.classLoader != null) {
            return this.classLoader.getResources(name2);
        }
        return null;
    }

    public InputStream getResourceAsStream(String name2) {
        if (this.classLoader != null) {
            return this.classLoader.getResourceAsStream(name2);
        }
        return null;
    }

    public void enableReloading() {
        this.reloadingEnabled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "reload");
        }
        HashMap hashMap = this.reloadEntries;
        synchronized (hashMap) {
            this.reloadEntries.clear();
        }
        this.classLoader = this.classLoader.reload();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "reload");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(boolean deepReload) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "reload");
        }
        HashMap hashMap = this.reloadEntries;
        synchronized (hashMap) {
            this.reloadEntries.clear();
        }
        this.classLoader = this.classLoader.reload(deepReload);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "reload");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(boolean deepDispose) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "dispose");
        }
        this.disposed = true;
        if (this.reloadEntries != null) {
            HashMap hashMap = this.reloadEntries;
            synchronized (hashMap) {
                this.reloadEntries.clear();
            }
        }
        if (deepDispose && this.classLoader != null) {
            this.classLoader.dispose(true);
        }
        this.parent = null;
        this.classLoader = null;
        this.reloadEntries = null;
        this.classProviderListeners = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "dispose");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkForUpdate() {
        boolean updated = false;
        if (!this.disposed) {
            ReloadEntry[] entries;
            HashMap hashMap = this.reloadEntries;
            synchronized (hashMap) {
                entries = this.reloadEntries.values().toArray(new ReloadEntry[this.reloadEntries.size()]);
            }
            for (int i = 0; i < entries.length; ++i) {
                long lastModified = entries[i].origin.lastModified();
                if (entries[i].lastModified == lastModified) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "updated " + entries[i] + " (" + lastModified + ")");
                }
                updated = true;
                break;
            }
        }
        return updated;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        if (this.classLoader != null) {
            sb.append(this.classLoader);
        }
        return sb.toString();
    }

    public String getClassPath() {
        String classpath = "";
        if (this.classLoader == null) {
            String[] paths = this.getPaths();
            if (paths != null) {
                classpath = PathUtils.arrayToString((String[])paths);
            }
        } else {
            classpath = this.classLoader.getClassPath();
        }
        return classpath;
    }

    public boolean getDelegationMode() {
        return false;
    }

    public CompoundClassLoader getCurrentClassLoader() {
        return this.classLoader;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    public boolean getRemoved() {
        return this.removed;
    }

    public abstract String[] getPaths();

    public Map getCodeSourcePermissions() {
        return this.classLoader.getCodeSourcePermissions();
    }

    public void setCodeSourcePermissions(Map codeSourcePermissions) {
        this.classLoader.setCodeSourcePermissions(codeSourcePermissions);
    }

    protected static class ReloadEntry {
        long lastModified;
        File origin;
        String owningPath;

        public ReloadEntry(File origin, String owningPath, long lastModified) {
            this.origin = origin;
            this.lastModified = lastModified;
            this.owningPath = owningPath;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.origin.getPath()).append(" lastModified : ").append(this.lastModified).append(" owningPath : ").append(this.owningPath);
            return sb.toString();
        }
    }
}

