/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloader;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.bootstrap.ProtectionMetaData;
import com.ibm.ws.classloader.WsClassLoader;
import com.ibm.ws.security.util.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;

public class ProtectionClassLoader
extends ClassLoader
implements WsClassLoader {
    private static final TraceComponent tc = Tr.register(ProtectionClassLoader.class, "Websphere ClassLoader", null);
    private ClassLoader parent;
    private Class grandParent;
    private boolean protectClasses;
    private static final Permission accessRuntimePermission = new WebSphereRuntimePermission("accessRuntimeClasses");

    public ProtectionClassLoader(ClassLoader parent) {
        super(parent);
        this.parent = parent;
        this.grandParent = parent.getParent().getClass();
        String mode = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("ibm.websphere.internalClassAccessMode", "allow");
            }
        });
        mode = mode.toLowerCase();
        this.protectClasses = mode.equals("restrict");
    }

    public Class loadClass(String name2) throws ClassNotFoundException {
        return this.loadClass(name2, false);
    }

    protected Class loadClass(String name2, boolean resolve) throws ClassNotFoundException {
        final Class<?> c = this.parent.loadClass(name2);
        ClassLoader loadingClassLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return c.getClassLoader();
            }
        });
        if (loadingClassLoader != null && (loadingClassLoader.getClass() == this.grandParent || loadingClassLoader == this.parent) && ProtectionClassLoader.isProtected(name2)) {
            if (this.protectClasses) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "attempted to access protected class: " + name2);
                }
                throw new ClassNotFoundException(name2);
            }
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                try {
                    sm.checkPermission(accessRuntimePermission);
                }
                catch (SecurityException se) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "attempted to access protected class: " + name2, se);
                    }
                    throw new ClassNotFoundException(name2);
                }
            } else if (tc.isDebugEnabled()) {
                Exception ex = new Exception("Access given to protected class: " + name2);
                Manager.Ffdc.log(ex, this, "com.ibm.ws.classloader.ProtectionClassLoader", "91");
            }
        }
        return c;
    }

    public String getClassPath() {
        if (this.parent instanceof WsClassLoader) {
            return ((WsClassLoader)((Object)this.parent)).getClassPath();
        }
        return System.getProperty("java.class.path");
    }

    public static boolean isProtected(String name2) {
        return ProtectionMetaData.isProtected(name2);
    }
}

