/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloader;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.ffdc.Manager;
import com.ibm.ws.classloader.ClassGraphState;
import com.ibm.ws.classloader.ClassLoaderManager;
import com.ibm.ws.classloader.ClassLoaderUtils;
import com.ibm.ws.classloader.CompoundClassLoader;
import com.ibm.ws.classloader.JarClassLoader;
import com.ibm.ws.classloader.ReloadableClassLoader;
import com.ibm.ws.security.policy.DynamicPolicy;
import com.ibm.ws.security.policy.DynamicPolicyFactory;
import com.ibm.ws.util.PathUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveWrappedException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.RuntimeClasspathEntry;
import org.eclipse.jst.j2ee.jca.Connector;

public class ClassGraph {
    private static TraceComponent tc = Tr.register(ClassGraph.class.getName(), "Websphere ClassLoader", null);
    protected List moduleNodes = new ArrayList();
    protected Map modulePathMap = new HashMap();
    protected List dependentPaths = new ArrayList();
    protected ClassLoader parent = null;
    protected JarClassLoader dependencyLoader = null;
    protected boolean singleWarClassLoader;
    protected boolean libDelegationMode = true;
    protected Map localClassPathMap = new HashMap();
    protected Map sharedLibClassPathMap = new HashMap();
    protected Map sharedLibNativeLibPathMap = new HashMap();
    protected Map libraryClassLoaderMap = new HashMap();
    protected List serverPaths = new ArrayList();

    public ClassGraph(ClassGraphState state) {
        this(state.parent, state.localClassPathMap, state.sharedLibClassPathMap, state.sharedLibNativeLibPathMap, state.libraryClassLoaderMap, state.libDelegationMode, state.singleWarClassLoader);
        this.dependencyLoader = state.previousDependencyLoader;
        this.serverPaths = state.previousServerPaths;
    }

    public ClassGraph(ClassLoader parent, Map localCPMap, Map sharedLibCPMap, Map sharedLibNLPMap, Map LibraryCLMap, boolean libDelegationMode, boolean singleWarClassLoader) {
        this.parent = parent;
        this.libDelegationMode = libDelegationMode;
        this.singleWarClassLoader = singleWarClassLoader;
        this.localClassPathMap.putAll(localCPMap);
        for (Map.Entry entry : sharedLibCPMap.entrySet()) {
            String moduleRefUri = (String)entry.getKey();
            String[] sharedLibClassPaths = (String[])entry.getValue();
            sharedLibClassPaths = PathUtils.expandPaths((String[])sharedLibClassPaths);
            sharedLibClassPaths = ClassLoaderUtils.addDependentJars(sharedLibClassPaths);
            this.sharedLibClassPathMap.put(moduleRefUri, sharedLibClassPaths);
        }
        this.sharedLibNativeLibPathMap.putAll(sharedLibNLPMap);
        this.libraryClassLoaderMap.putAll(LibraryCLMap);
    }

    public void addModule(ModuleRef moduleRef) {
        ModuleFile moduleFile = moduleRef.getModuleFile();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addModule uri=" + moduleFile.getURI() + " isEJBJarFile=" + moduleFile.isEJBJarFile() + " isWARFile=" + moduleFile.isWARFile() + " ref=" + moduleRef);
        }
        boolean debug = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        ModuleNode m = new ModuleNode();
        m.moduleRef = moduleRef;
        this.moduleNodes.add(m);
        if (moduleFile.isApplicationClientFile()) {
            if (debug) {
                Tr.exit(tc, "addModule application client");
            }
            return;
        }
        RuntimeClasspathEntry[] rcpe = moduleFile.getLocalRuntimeClassPath();
        for (int i = 0; i < rcpe.length; ++i) {
            String path = this.normalizePath(rcpe[i].getAbsolutePath());
            if (debug) {
                Tr.debug(tc, "local path: " + path);
            }
            this.dependentPaths.remove(path);
            this.modulePathMap.put(path, m);
            PathUtils.listAddNoDup((List)m.paths, (Object)path);
            PathUtils.listAddNoDup((List)m.localPaths, (Object)path);
        }
        RuntimeClasspathEntry[] dcpe = moduleFile.getDependencyClassPath();
        for (int i = 0; i < dcpe.length; ++i) {
            String path = this.normalizePath(dcpe[i].getAbsolutePath());
            if (debug) {
                Tr.debug(tc, "dependency path: " + path);
            }
            PathUtils.listAddNoDup((List)m.paths, (Object)path);
            if (this.modulePathMap.get(path) != null) continue;
            PathUtils.listAddNoDup((List)this.dependentPaths, (Object)path);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addModule");
        }
    }

    public JarClassLoader getDependencyClassLoader() {
        return this.dependencyLoader;
    }

    public void addUtilityJars(String[] upaths) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addUtilityJars", PathUtils.arrayToString((String[])upaths));
        }
        for (int i = 0; i < upaths.length; ++i) {
            String path = this.normalizePath(upaths[i]);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "utility path: " + path);
            }
            if (this.modulePathMap.get(path) != null) continue;
            PathUtils.listAddNoDup((List)this.dependentPaths, (Object)path);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addUtilityJars");
        }
    }

    public ClassLoader calculate(EARFile earFile, String wasPolicy) {
        return this.createClassLoaders(earFile, wasPolicy, true, null);
    }

    public void updateClassLoaders(EARFile earFile, String wasPolicy, ClassLoader existingWarParent) {
        this.createClassLoaders(earFile, wasPolicy, false, existingWarParent);
    }

    public void dispose() {
        this.moduleNodes.clear();
        this.modulePathMap.clear();
        this.dependentPaths.clear();
        this.sharedLibClassPathMap.clear();
        this.sharedLibNativeLibPathMap.clear();
        this.libraryClassLoaderMap.clear();
        this.parent = null;
    }

    protected String normalizePath(String path) {
        File f = new File(path);
        try {
            f = f.getCanonicalFile();
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.ws.classloader.ClassGraph.normalizePath", "200", this);
        }
        return f.getPath();
    }

    public ReloadableClassLoader lookupClassLoader(ModuleRef mr) {
        for (int i = 0; i < this.moduleNodes.size(); ++i) {
            ModuleNode mn = (ModuleNode)this.moduleNodes.get(i);
            if (mn == null || mn.moduleRef != mr) continue;
            return mn.classLoader;
        }
        return this.dependencyLoader;
    }

    private void processWARModule(EARFile earFile, ClassLoader warParent, JarClassLoader warGroup, ModuleRef moduleRef, String[] paths, ModuleNode mn, DynamicPolicy dynamicPolicy, String wasPolicy, ArrayList modulePolicies) {
        JarClassLoader rcl;
        boolean debug = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        String[] policyPaths = new String[2];
        try {
            StringBuffer sb = new StringBuffer(moduleRef.getModuleFile().getBinariesPath());
            sb.append("/WEB-INF/");
            int len = sb.length();
            policyPaths[0] = sb.append("classes").toString();
            sb.setLength(len);
            policyPaths[1] = sb.append("lib").toString();
        }
        catch (FileNotFoundException e) {
            Manager.Ffdc.log(e, this, this.getClass().getName(), "232");
        }
        String moduleRefUri = moduleRef.getUri();
        DynamicPolicy.Module webModule = new DynamicPolicy.Module("web", policyPaths, moduleRefUri, null);
        String[] moduleSharedLibCPs = (String[])this.sharedLibClassPathMap.get(moduleRefUri);
        String[] moduleSharedLibNLPs = (String[])this.sharedLibNativeLibPathMap.get(moduleRefUri);
        CompoundClassLoader[] moduleLibraryClassloaders = (CompoundClassLoader[])this.libraryClassLoaderMap.get(moduleRefUri);
        if (warGroup == null) {
            ClassLoader parent = warParent;
            if (parent instanceof ReloadableClassLoader) {
                parent = ((ReloadableClassLoader)parent).getCurrentClassLoader();
            }
            rcl = new JarClassLoader(new String[0], parent, ClassLoaderManager.getDefaultDelegationMode());
            rcl.setName("war:" + earFile.getName() + '/' + moduleRef.getModuleFile().getName());
            if (dynamicPolicy != null) {
                Map codeSource = this.generateApplicationCodeSource(dynamicPolicy, earFile, wasPolicy, rcl.getCodeSourcePermissions(), webModule);
                rcl.setCodeSourcePermissions(codeSource);
            }
        } else {
            warGroup.addPaths(paths);
            rcl = warGroup;
            modulePolicies.add(webModule);
        }
        mn.classLoader = rcl;
        if (debug) {
            Tr.debug(tc, "adding module class paths");
        }
        rcl.addPaths(paths);
        if (warGroup != null) {
            this.addToServerPaths(paths);
        }
        if (moduleSharedLibCPs != null && moduleSharedLibCPs.length != 0) {
            if (debug) {
                Tr.debug(tc, "adding module shared library class paths");
            }
            rcl.addPaths(moduleSharedLibCPs);
            if (warGroup != null) {
                this.addToServerPaths(paths);
            }
        }
        if (moduleSharedLibNLPs != null && moduleSharedLibNLPs.length != 0) {
            if (debug) {
                Tr.debug(tc, "adding module shared library native paths");
            }
            rcl.addNativeLibPaths(moduleSharedLibNLPs);
        }
        if (moduleLibraryClassloaders != null && moduleLibraryClassloaders.length != 0) {
            if (debug) {
                Tr.debug(tc, "adding module shared library class loaders");
            }
            rcl.addLibraryClassLoaders(moduleLibraryClassloaders);
        }
    }

    private void processEJBModule(ModuleRef moduleRef, String[] paths, ModuleNode mn, ArrayList modulePolicies) {
        this.dependencyLoader.addPaths(paths);
        this.addToServerPaths(paths);
        mn.classLoader = this.dependencyLoader;
        String moduleRefUri = moduleRef.getUri();
        modulePolicies.add(new DynamicPolicy.Module("ejb", paths, moduleRefUri, null));
        CompoundClassLoader[] moduleLibraryClassloaders = (CompoundClassLoader[])this.libraryClassLoaderMap.get(moduleRefUri);
        if (moduleLibraryClassloaders != null && moduleLibraryClassloaders.length != 0) {
            this.dependencyLoader.addLibraryClassLoaders(moduleLibraryClassloaders);
        }
    }

    protected ClassLoader createClassLoaders(EARFile earFile, String wasPolicy, boolean applicationStartInProgress, ClassLoader existingWarParent) {
        CompoundClassLoader[] appLibraryClassLoaders;
        String[] nativeLibPaths;
        String[] libraryPaths;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createClassLoaders", new Object[]{earFile, wasPolicy});
        }
        boolean debug = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        ClassLoader warParent = null;
        JarClassLoader warGroup = null;
        ArrayList<DynamicPolicy.Module> modulePolicies = new ArrayList<DynamicPolicy.Module>(this.moduleNodes.size());
        if (applicationStartInProgress) {
            warParent = this.parent;
            if (ClassLoaderManager.getSingleServerClassLoader()) {
                if (this.singleWarClassLoader) {
                    this.dependencyLoader = warGroup = ClassLoaderManager.serverClassLoader;
                } else {
                    this.dependencyLoader = ClassLoaderManager.serverClassLoader;
                    warParent = this.dependencyLoader;
                }
            } else {
                this.dependencyLoader = new JarClassLoader(new String[0], this.parent, this.libDelegationMode);
                if (this.singleWarClassLoader) {
                    warGroup = this.dependencyLoader;
                    this.dependencyLoader.setName("appwar:" + earFile.getName());
                } else {
                    warParent = this.dependencyLoader;
                    this.dependencyLoader.setName("app:" + earFile.getName());
                }
            }
        } else {
            warParent = existingWarParent;
        }
        DynamicPolicy dynamicPolicy = DynamicPolicyFactory.getInstance();
        for (int i = 0; i < this.moduleNodes.size(); ++i) {
            ModuleNode mn = (ModuleNode)this.moduleNodes.get(i);
            String[] paths = new String[mn.localPaths.size()];
            mn.localPaths.toArray(paths);
            ModuleRef moduleRef = mn.moduleRef;
            if (debug) {
                Tr.debug(tc, "processing module: " + moduleRef.getModuleFile().getName());
            }
            if (moduleRef.isEJB()) {
                this.processEJBModule(moduleRef, paths, mn, modulePolicies);
                continue;
            }
            if (moduleRef.isWeb()) {
                this.processWARModule(earFile, warParent, warGroup, moduleRef, paths, mn, dynamicPolicy, wasPolicy, modulePolicies);
                continue;
            }
            if (moduleRef.isConnector()) {
                paths = PathUtils.expandPaths((String[])paths);
                String[] localPaths = (String[])this.localClassPathMap.get(moduleRef.getUri());
                if (localPaths != null && localPaths.length != 0) {
                    String[] newPaths = new String[paths.length + localPaths.length];
                    System.arraycopy(paths, 0, newPaths, 0, paths.length);
                    System.arraycopy(localPaths, 0, newPaths, paths.length, localPaths.length);
                    paths = newPaths;
                }
                this.dependencyLoader.addPaths(paths);
                this.addToServerPaths(paths);
                mn.classLoader = this.dependencyLoader;
                try {
                    Connector connector = (Connector)moduleRef.getDeploymentDescriptor();
                    modulePolicies.add(new DynamicPolicy.Module("RARFile", paths, moduleRef.getUri(), (List)connector.getResourceAdapter().getSecurityPermissions()));
                }
                catch (ArchiveWrappedException e) {}
                continue;
            }
            if (moduleRef.isClient()) {
                this.dependencyLoader.addPaths(paths);
                this.addToServerPaths(paths);
                mn.classLoader = this.dependencyLoader;
                modulePolicies.add(new DynamicPolicy.Module("utility", paths, moduleRef.getUri(), null));
                continue;
            }
            System.out.println("unsupported module type=" + moduleRef);
            Thread.dumpStack();
        }
        String[] depPaths = this.dependentPaths.toArray(new String[this.dependentPaths.size()]);
        if (depPaths != null && depPaths.length != 0) {
            if (debug) {
                Tr.debug(tc, "adding application class paths");
            }
            this.dependencyLoader.addPaths(depPaths);
            this.addToServerPaths(depPaths);
            modulePolicies.add(new DynamicPolicy.Module("utility", depPaths, null, null));
        }
        if ((libraryPaths = (String[])this.sharedLibClassPathMap.get(null)) != null && libraryPaths.length != 0) {
            if (debug) {
                Tr.debug(tc, "adding application shared library class paths");
            }
            this.dependencyLoader.addPaths(libraryPaths);
            this.addToServerPaths(libraryPaths);
        }
        if ((nativeLibPaths = (String[])this.sharedLibNativeLibPathMap.get(null)) != null && nativeLibPaths.length != 0) {
            if (debug) {
                Tr.debug(tc, "adding application shared library native library paths");
            }
            this.dependencyLoader.addNativeLibPaths(nativeLibPaths);
        }
        if ((appLibraryClassLoaders = (CompoundClassLoader[])this.libraryClassLoaderMap.get(null)) != null && appLibraryClassLoaders.length != 0) {
            if (debug) {
                Tr.debug(tc, "adding application library class loaders");
            }
            this.dependencyLoader.addLibraryClassLoaders(appLibraryClassLoaders);
        }
        if (dynamicPolicy != null) {
            Map codeSource = this.generateApplicationCodeSource(dynamicPolicy, earFile, wasPolicy, this.dependencyLoader.getCodeSourcePermissions(), modulePolicies);
            this.dependencyLoader.setCodeSourcePermissions(codeSource);
            this.generateLibraryCodeSource(dynamicPolicy, this.dependencyLoader.getCodeSourcePermissions(), libraryPaths);
        }
        if (debug) {
            Tr.debug(tc, "application class loader: " + this.dependencyLoader);
            if (!this.singleWarClassLoader) {
                int moduleNodesSize = this.moduleNodes.size();
                for (int i = 0; i < moduleNodesSize; ++i) {
                    ModuleNode mn = (ModuleNode)this.moduleNodes.get(i);
                    if (!mn.moduleRef.isWeb()) continue;
                    Tr.debug(tc, "module class loader: " + mn.classLoader);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createClassLoaders");
        }
        return warParent;
    }

    public String[] getServerPaths() {
        if (ClassLoaderManager.getSingleServerClassLoader()) {
            return this.serverPaths.toArray(new String[this.serverPaths.size()]);
        }
        return null;
    }

    private void addToServerPaths(String[] paths) {
        if (paths != null && paths.length != 0) {
            for (int i = 0; i < paths.length; ++i) {
                this.serverPaths.add(paths[i]);
            }
        }
    }

    private Map generateApplicationCodeSource(DynamicPolicy dynamicPolicy, EARFile earFile, String wasPolicy, Map codeSource, DynamicPolicy.Module module) {
        DynamicPolicy.Module[] modules = new DynamicPolicy.Module[]{module};
        return this.generateApplicationCodeSource(dynamicPolicy, earFile, wasPolicy, codeSource, modules);
    }

    private Map generateApplicationCodeSource(DynamicPolicy dynamicPolicy, EARFile earFile, String wasPolicy, Map codeSource, List modules) {
        DynamicPolicy.Module[] dmodules = new DynamicPolicy.Module[modules.size()];
        modules.toArray(dmodules);
        return this.generateApplicationCodeSource(dynamicPolicy, earFile, wasPolicy, codeSource, dmodules);
    }

    private Map generateApplicationCodeSource(DynamicPolicy dynamicPolicy, EARFile earFile, String wasPolicy, Map codeSource, DynamicPolicy.Module[] modules) {
        if (codeSource == null) {
            codeSource = new HashMap();
        }
        try {
            DynamicPolicy.Application application = new DynamicPolicy.Application(earFile.getBinariesPath(), wasPolicy, modules);
            HashMap<String, String> dynamicInfo = new HashMap<String, String>();
            dynamicInfo.put("type", "application");
            dynamicInfo.put("application", (String)application);
            dynamicPolicy.getSecurityPolicy(dynamicInfo, codeSource);
        }
        catch (FileNotFoundException e) {
            Manager.Ffdc.log(e, this, this.getClass().getName(), "356");
        }
        return codeSource;
    }

    private Map generateLibraryCodeSource(DynamicPolicy dynamicPolicy, Map codeSource, String[] libraryPaths) {
        if (codeSource == null) {
            codeSource = new HashMap();
        }
        HashMap<String, Object> dynamicInfo = new HashMap<String, Object>();
        dynamicInfo.put("type", "library");
        dynamicInfo.put("classpath", libraryPaths);
        dynamicPolicy.getSecurityPolicy(dynamicInfo, codeSource);
        return codeSource;
    }

    public ClassGraphState getState() {
        return new ClassGraphState(this.parent, this.dependencyLoader, this.serverPaths, this.localClassPathMap, this.sharedLibClassPathMap, this.sharedLibNativeLibPathMap, this.libraryClassLoaderMap, this.libDelegationMode, this.singleWarClassLoader);
    }

    static class ModuleNode {
        ArrayList paths = new ArrayList();
        ArrayList localPaths = new ArrayList();
        JarClassLoader classLoader = null;
        ModuleRef moduleRef;

        ModuleNode() {
        }

        public String toString() {
            return "module: " + this.moduleRef.getModuleFile().getName();
        }
    }
}

