/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.framework.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.channel.framework.ChainGroupData;
import com.ibm.websphere.channel.framework.ChainStartMode;
import com.ibm.websphere.channel.framework.ChannelData;
import com.ibm.websphere.channel.framework.ChannelFactoryData;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.websphere.models.config.channelservice.InboundTransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannelFactory;
import com.ibm.ws.channel.framework.ChannelTypeManager;
import com.ibm.ws.channel.framework.chains.Chain;
import com.ibm.ws.channel.framework.impl.CFEndPointImpl;
import com.ibm.ws.channel.framework.impl.ChainDataImpl;
import com.ibm.ws.channel.framework.impl.ChainStartAlarmListener;
import com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl;
import com.ibm.ws.channel.framework.impl.OutboundVirtualConnectionFactoryImpl;
import com.ibm.ws.channel.framework.impl.RCSUtil;
import com.ibm.ws.channel.framework.impl.WSChainData;
import com.ibm.ws.channel.framework.impl.WSVirtualConnectionFactoryImpl;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.Alias;
import com.ibm.ws.http.VirtualHost;
import com.ibm.ws.runtime.component.ChannelFrameworkServiceImpl;
import com.ibm.ws.runtime.config.InternalConfigService;
import com.ibm.ws.runtime.service.VirtualHostMgr;
import com.ibm.ws.timeutils.QuickApproxTime;
import com.ibm.ws.timeutils.QuickApproxTimeA;
import com.ibm.ws.timeutils.QuickApproxTimeZ;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.channel.ChannelFactory;
import com.ibm.wsspi.channel.WSAggregateChannelFactory;
import com.ibm.wsspi.channel.WSAggregateChannelFactoryRCS;
import com.ibm.wsspi.channel.WSChannelFactory;
import com.ibm.wsspi.channel.WSChannelFactoryRCS;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.CFEndPointCriteria;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.channel.framework.DetailedCFEndPointCriteria;
import com.ibm.wsspi.channel.framework.OutboundChannelDefinition;
import com.ibm.wsspi.channel.framework.WSVirtualConnectionFactory;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import com.ibm.wsspi.channel.framework.exception.ChainGroupException;
import com.ibm.wsspi.channel.framework.exception.ChainNotInboundException;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.channel.framework.exception.ChannelFactoryException;
import com.ibm.wsspi.channel.framework.exception.IncoherentChainException;
import com.ibm.wsspi.channel.framework.exception.InvalidChannelFactoryException;
import com.ibm.wsspi.channel.framework.exception.NoCFEndPointException;
import com.ibm.wsspi.channel.framework.exception.NullCFEndPointException;
import com.ibm.wsspi.runtime.ThreadPool;
import com.ibm.wsspi.runtime.ThreadPoolAlreadyKnownException;
import com.ibm.wsspi.runtime.ThreadPoolRepository;
import com.ibm.wsspi.runtime.ThreadPoolRepositoryManager;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;

public class WSChannelFrameworkImpl
extends ChannelFrameworkImpl
implements ChannelFrameworkService {
    private static TraceComponent tc = Tr.register(WSChannelFrameworkImpl.class, "ChannelFrameworkService", "com.ibm.ws.channel.resources.channelframeworkservice");
    private static final String CLASS_NAME = "com.ibm.ws.channel.framework.impl.WSChannelFrameworkImpl";
    protected int _chainNameCounter = 0;
    protected int _channelNameCounter = 0;
    protected VirtualHostMgr _virtualHostMgr;
    protected ClassLoader _loader;
    protected ChannelFrameworkServiceImpl _cfService;
    protected ChannelTypeManager _typeManager;
    private ConfigService cService = null;

    public WSChannelFrameworkImpl(ConfigObject configuration, ClassLoader loader, ChannelFrameworkServiceImpl cfService, ChannelTypeManager typeManager) {
        this._loader = loader;
        this._cfService = cfService;
        this._typeManager = typeManager;
        if (this.currentlyOnZ()) {
            QuickApproxTimeZ quickTime = new QuickApproxTimeZ();
            QuickApproxTime.setRef(quickTime);
        } else {
            QuickApproxTimeA quickTime = new QuickApproxTimeA();
            QuickApproxTime.setRef(quickTime);
        }
    }

    public void setClassLoader(ClassLoader loader) {
        this._loader = loader;
    }

    public void setCFService(ChannelFrameworkServiceImpl cfService) {
        this._cfService = cfService;
    }

    public void setTypeManager(ChannelTypeManager typeManager) {
        this._typeManager = typeManager;
    }

    public synchronized void clear() throws ChannelException, ChainException, ChainGroupException {
        super.clear();
        this._chainNameCounter = 0;
        this._channelNameCounter = 0;
    }

    public synchronized ChainData addChain(ConfigObject chain) throws ChannelException, ChainException, ChainGroupException {
        String acceptor;
        boolean valid;
        boolean enabled;
        String[] channels;
        boolean inbound;
        String name2;
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "addChain");
            }
            name2 = chain.getString("name", null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "using name of: " + name2);
            }
            inbound = this.isInbound(chain);
            ConfigObject first = this.getFirstChannel(chain);
            ConfigObject last = this.getLastChannel(chain);
            channels = this.getChannelNamesFromChain(chain);
            enabled = true;
            valid = true;
            acceptor = null;
            enabled = false == chain.isSet("enable") ? true : chain.getBoolean("enable", false);
            if (channels.length == 0) {
                Tr.error(tc, "chain.channels.empty", name2);
                valid = false;
            } else {
                if (!this.validateChainFlow(inbound ? FlowType.INBOUND : FlowType.OUTBOUND, chain)) {
                    Tr.error(tc, "chain.flow.mismatch", name2);
                    valid = false;
                }
                if (inbound) {
                    if (!this.validateChannelKind(ChannelTypeManager.ChannelKind.CONNECTOR, first)) {
                        Tr.error(tc, "chain.inbound.first.mismatch", name2);
                        valid = false;
                    }
                    if (!this.validateChannelKind(ChannelTypeManager.ChannelKind.ACCEPTOR, last)) {
                        Tr.error(tc, "chain.inbound.last.mismatch", name2);
                        valid = false;
                    }
                    try {
                        ChannelTypeManager.ChannelMetaData type = this._typeManager.getChannelType(last);
                        Class factoryClass = type.getClass(type.getRuntimeClass());
                        ChannelFactory cFactory = this.getChannelFactoryInternal(factoryClass, false);
                        if (cFactory instanceof WSChannelFactoryRCS) {
                            WSChannelFactoryRCS factory = (WSChannelFactoryRCS)cFactory;
                            acceptor = factory.determineAcceptorID(last);
                            break block16;
                        }
                        WSChannelFactory factory = (WSChannelFactory)cFactory;
                        EObject object = ((InternalConfigService)this._cfService.getConfigService()).getEObject(last);
                        TransportChannel wccmObject = (TransportChannel)object;
                        acceptor = factory.determineAcceptorID((InboundTransportChannel)wccmObject);
                    }
                    catch (Exception exp) {
                        FFDCFilter.processException(exp, "com.ibm.ws.channel.framework.impl.WSChannelFrameworkImpl.addChain", "229", this, new Object[]{chain});
                        Tr.error(tc, "chain.acceptor.determination.failure", name2);
                        valid = false;
                    }
                } else if (!this.validateChannelKind(ChannelTypeManager.ChannelKind.CONNECTOR, last)) {
                    Tr.error(tc, "chain.outbound.last.mismatch", name2);
                    valid = false;
                }
            }
        }
        if (!valid) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addChain");
            }
            return null;
        }
        ChainData cData = inbound ? this.addChainInternal(name2, FlowType.INBOUND, channels, acceptor, enabled) : this.addChain(name2, FlowType.OUTBOUND, channels);
        ((WSChainData)cData).setEnabled(enabled);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addChain");
        }
        return cData;
    }

    public synchronized ChainData addChain(String name2, FlowType type, String[] channels, String acceptorID) throws ChannelException, ChainException, ChainGroupException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addChain called with");
            Tr.debug(tc, "name: " + name2);
            Tr.debug(tc, "type: " + type);
            if (channels.length > 0) {
                Tr.debug(tc, "first Channel: " + channels[0]);
                Tr.debug(tc, "last  Channel: " + channels[channels.length - 1]);
            }
            Tr.debug(tc, "acceptorID: " + acceptorID);
        }
        return this.addChainInternal(name2, type, channels, acceptorID, acceptorID != null);
    }

    public synchronized ChannelData addChannel(ConfigObject channel) throws ChannelException, ConfigurationError {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "addChannel");
        }
        ChannelTypeManager.ChannelMetaData type = this.getChannelType(channel);
        String factoryClass = type.getRuntimeClass();
        ChannelData channelData = this.addChannelFromFactory(factoryClass, channel, type);
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "addChannel");
        }
        return channelData;
    }

    private boolean IsInstanceOfGenericIOChannel(ConfigObject input) {
        if (RCSUtil.instanceOfGenericInboundChannel(input) || RCSUtil.instanceOfGenericOutboundChannel(input)) {
            return true;
        }
        int rc = this._typeManager.ConnTypeChannelCheck(input, true);
        if (rc == 1 || rc == 2) {
            return false;
        }
        boolean proceed = true;
        if (this.cService == null) {
            try {
                this.cService = WsServiceRegistry.getService(this, ConfigService.class);
            }
            catch (Exception x) {
                FFDCFilter.processException((Throwable)x, "com.ibm.ws.channel.framework.impl.WSChannelFrameworkImpl.IsInstanceOfGenericIOChannel", "440", this);
                proceed = false;
            }
        }
        return proceed && (RCSUtil.instanceOfGenericInboundChannelUsingWCCM(this.cService, input) || RCSUtil.instanceOfGenericOutboundChannelUsingWCCM(this.cService, input));
    }

    protected synchronized ChannelTypeManager.ChannelMetaData getChannelType(ConfigObject channel) throws ChannelException {
        ChannelTypeManager.ChannelMetaData type;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getChannelType");
        }
        if (this.IsInstanceOfGenericIOChannel(channel)) {
            String typeID = this._typeManager.createFullyQualifiedGenericID(channel);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "generic channel detected: " + typeID);
            }
            if (channel.getString("jarFile", null) == null || channel.getString("typeID", null) == null) {
                StringBuilder message = new StringBuilder();
                message.append("generic channel ");
                message.append(channel.getString("name", null));
                message.append(" is missing jarFile and/or typeID information");
                throw new ChannelException(message.toString());
            }
            type = this._typeManager.getChannelType(typeID);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "channel.getDocumentPath(): " + channel.getDocumentPath());
                Tr.debug(tc, "channel.getID(): " + channel.getID());
                Tr.debug(tc, "channel.getClass(): " + channel.getClass());
                Tr.debug(tc, "channel.getTypeURI(): " + channel.getTypeURI());
                Tr.debug(tc, "channel.getTypeName(): " + channel.getTypeName());
            }
            type = this._typeManager.getChannelType(channel);
        }
        if (type == null) {
            Tr.error(tc, "channel.descriptor.notfound", channel.toString());
            throw new ChannelException("Channel descriptor not found for " + channel.getID());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChannelType");
        }
        return type;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized ChannelData addChannelFromFactory(String factoryClassName, ConfigObject channelConfig, ChannelTypeManager.ChannelMetaData channelMetaData) throws ConfigurationError, ChannelFactoryException, ChannelException {
        Class factoryClass;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addChannelFromFactory", new Object[]{factoryClassName, channelConfig, channelMetaData});
        }
        ChannelData channelData = null;
        ChannelFactory factory = null;
        try {
            factoryClass = channelMetaData.getClass(factoryClassName);
        }
        catch (ClassNotFoundException cnfe) {
            StringBuilder message = new StringBuilder();
            message.append(factoryClassName);
            message.append(" cannot be loaded ");
            throw new InvalidChannelFactoryException(message.toString(), cnfe);
        }
        catch (Error err) {
            StringBuilder message = new StringBuilder();
            message.append(factoryClassName);
            message.append(" cannot be loaded ");
            throw new InvalidChannelFactoryException(message.toString(), err);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Build WSChannelFactory for Class, " + factoryClassName);
        }
        if ((factory = this.getChannelFactoryInternal(factoryClass, true)) instanceof WSAggregateChannelFactory) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found impl of WSAggregateChannelFactory: " + factoryClassName);
            }
            WSAggregateChannelFactory aggregateFactory = (WSAggregateChannelFactory)factory;
            if (this._cfService.getConfigService() == null) {
                ConfigurationError x = new ConfigurationError("RCS ConfigService can not be found");
                FFDCFilter.processException(x, "com.ibm.ws.channel.framework.impl.WSChannelFrameworkImpl.addChannelFromFactory", "561", this, null);
                throw x;
            }
            EObject object = ((InternalConfigService)this._cfService.getConfigService()).getEObject(channelConfig);
            TransportChannel wccmObject = (TransportChannel)object;
            Class[] factoryArray = aggregateFactory.getAggregateChannelFactories(wccmObject, this);
            for (int i = 0; i < factoryArray.length; ++i) {
                channelData = this.addChannelFromFactory(factoryArray[i].getName(), channelConfig, channelMetaData);
            }
        } else if (factory instanceof WSAggregateChannelFactoryRCS) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found impl of WSAggregateChannelFactory: " + factoryClassName);
            }
            WSAggregateChannelFactoryRCS aggregateFactory = (WSAggregateChannelFactoryRCS)factory;
            Class[] factoryArray = aggregateFactory.getAggregateChannelFactories(channelConfig, this);
            for (int i = 0; i < factoryArray.length; ++i) {
                channelData = this.addChannelFromFactory(factoryArray[i].getName(), channelConfig, channelMetaData);
            }
        } else {
            if (!(factory instanceof WSChannelFactory) && !(factory instanceof WSChannelFactoryRCS)) {
                StringBuilder message = new StringBuilder();
                message.append(factoryClassName);
                message.append(" does not implement ");
                message.append(WSChannelFactoryRCS.class);
                message.append(" or ");
                message.append(WSChannelFactory.class);
                throw new InvalidChannelFactoryException(message.toString());
            }
            Map properties = null;
            if (factory instanceof WSChannelFactoryRCS) {
                properties = ((WSChannelFactoryRCS)factory).createChannelConfigurationMap(channelConfig, this);
            } else {
                if (this._cfService.getConfigService() == null) {
                    ConfigurationError x = new ConfigurationError("RCS ConfigService can not be found");
                    FFDCFilter.processException(x, "com.ibm.ws.channel.framework.impl.WSChannelFrameworkImpl.addChannelFromFactory", "596", this, null);
                    throw x;
                }
                EObject object = ((InternalConfigService)this._cfService.getConfigService()).getEObject(channelConfig);
                TransportChannel wccmObject = (TransportChannel)object;
                properties = ((WSChannelFactory)factory).createChannelConfigurationMap(wccmObject, this);
            }
            String name2 = null;
            name2 = factoryClassName.equals(channelMetaData.getRuntimeClass()) ? channelConfig.getString("name", null) : channelConfig.getString("name", null) + "_" + factoryClassName;
            if (this._typeManager.ConnTypeChannelCheck(channelConfig, true) == 1) {
                int weight = 0;
                weight = channelConfig.isSet("discriminationWeight") ? channelConfig.getInt("discriminationWeight", 0) : (channelMetaData.isSetDefaultWeight() ? channelMetaData.getDefaultWeight() : 0);
                channelData = this.addChannel(name2, factoryClass, properties, weight);
            } else {
                channelData = this.addChannel(name2, factoryClass, properties);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addChannelFromFactory");
        }
        return channelData;
    }

    private boolean IsInstanceOfGenericChannelFacotry(ConfigObject input) {
        if (RCSUtil.instanceOfGenericChannelFactory(input)) {
            return true;
        }
        if (RCSUtil.instanceOfTransportChannelFactory(input) || RCSUtil.instanceOfTCPFactory(input) || RCSUtil.instanceOfJFAPFactory(input)) {
            return false;
        }
        boolean proceed = true;
        if (this.cService == null) {
            try {
                this.cService = WsServiceRegistry.getService(this, ConfigService.class);
            }
            catch (Exception x) {
                FFDCFilter.processException((Throwable)x, "com.ibm.ws.channel.framework.impl.WSChannelFrameworkImpl.IsInstanceOfGenericChannelFacotry", "712", this);
                proceed = false;
            }
        }
        return proceed && RCSUtil.instanceOfGenericChannelFactoryUsingWCCM(this.cService, input);
    }

    public synchronized void intializeChannelFactory(ConfigObject factoryConfig) throws ChannelFactoryException, ConfigurationError {
        block18: {
            TransportChannel wccmObject;
            EObject object;
            ChannelTypeManager.ChannelFactoryMetaData type;
            String key = null;
            if (this.IsInstanceOfGenericChannelFacotry(factoryConfig)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "generic channel factory detected: " + factoryConfig);
                }
                if (factoryConfig.getString("jarFile", null) == null || factoryConfig.getString("typeID", null) == null) {
                    StringBuilder message = new StringBuilder();
                    message.append("generic channel factory ");
                    message.append(factoryConfig.getID());
                    message.append(" is missing jarFile and/or typeID information");
                    throw new ChannelFactoryException(message.toString());
                }
                key = factoryConfig.getTypeURI();
                type = this._typeManager.getChannelFactoryType(key = key.concat(factoryConfig.getTypeName()));
                if (type == null) {
                    try {
                        if (this.cService == null) {
                            this.cService = WsServiceRegistry.getService(this, ConfigService.class);
                        }
                        object = ((InternalConfigService)this.cService).getEObject(factoryConfig);
                        wccmObject = (TransportChannel)object;
                        type = this._typeManager.getChannelFactoryType(wccmObject);
                    }
                    catch (Exception x) {
                        FFDCFilter.processException(x, "com.ibm.ws.channel.framework.impl.WSChannelFrameworkImpl.intializeChannelFactory", "704", this, null);
                    }
                }
            } else {
                key = factoryConfig.getTypeURI();
                type = this._typeManager.getChannelFactoryType(key = key.concat(factoryConfig.getTypeName()));
                if (type == null) {
                    try {
                        if (this.cService == null) {
                            this.cService = WsServiceRegistry.getService(this, ConfigService.class);
                        }
                        object = ((InternalConfigService)this.cService).getEObject(factoryConfig);
                        wccmObject = (TransportChannel)object;
                        type = this._typeManager.getChannelFactoryType(wccmObject);
                    }
                    catch (Exception x) {
                        FFDCFilter.processException(x, "com.ibm.ws.channel.framework.impl.WSChannelFrameworkImpl.intializeChannelFactory", "718", this, null);
                    }
                }
            }
            if (type == null) {
                Tr.error(tc, "factory.descriptor.notfound", factoryConfig.getClass().getName() + " factoryType: " + key);
                return;
            }
            Class factoryClass = null;
            try {
                factoryClass = type.getClass(type.getRuntimeClass());
                ChannelFactory cFactory = this.getChannelFactoryInternal(factoryClass, false);
                if (cFactory instanceof WSChannelFactoryRCS) {
                    WSChannelFactoryRCS factory = (WSChannelFactoryRCS)cFactory;
                    Map properties = factory.createFactoryConfigurationMap(factoryConfig, this);
                    this.initChannelFactory(factoryClass, factory, properties);
                    break block18;
                }
                WSChannelFactory factory = (WSChannelFactory)cFactory;
                if (this._cfService.getConfigService() != null) {
                    EObject object2 = ((InternalConfigService)this._cfService.getConfigService()).getEObject(factoryConfig);
                    TransportChannelFactory wccmFactory = (TransportChannelFactory)object2;
                    Map properties = factory.createFactoryConfigurationMap(wccmFactory, this);
                    this.initChannelFactory(factoryClass, factory, properties);
                    break block18;
                }
                ConfigurationError x = new ConfigurationError("RCS ConfigService can not be found");
                FFDCFilter.processException(x, "com.ibm.ws.channel.framework.impl.WSChannelFrameworkImpl.intializeChannelFactory", "758", this, null);
                throw x;
            }
            catch (ClassNotFoundException cnfe) {
                StringBuilder message = new StringBuilder();
                message.append(type.getRuntimeClass());
                message.append(" cannot be loaded");
                throw new InvalidChannelFactoryException(message.toString(), cnfe);
            }
            catch (ClassCastException exp) {
                StringBuilder message = new StringBuilder();
                message.append(factoryClass);
                message.append(" does not implement ");
                message.append(WSChannelFactory.class);
                throw new InvalidChannelFactoryException(message.toString(), exp);
            }
        }
    }

    public synchronized void startChainsByAcceptorID(String acceptorID) throws ChannelException, ChainException, ChainGroupException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "starting group " + acceptorID + ":", this.getChainGroup(acceptorID));
        }
        this.startChainGroup(acceptorID);
    }

    protected void retryChainStart(ChainData chainData, Exception e) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "retryChainStart");
        }
        if (this.chainStartRetryAttempts != 0) {
            ((ChainDataImpl)chainData).chainStartFailed(1, this.chainStartRetryAttempts);
            Tr.error(tc, "chain.retrystart.warning", new Object[]{chainData.getName(), new Integer(this.chainStartRetryInterval), new Integer(this.chainStartRetryAttempts)});
            ChainStartAlarmListener listener = new ChainStartAlarmListener(this, chainData, this.chainStartRetryAttempts, this.chainStartRetryInterval);
            AlarmManager.createNonDeferrable(this.chainStartRetryInterval, listener);
        } else {
            ((ChainDataImpl)chainData).chainStartFailed(1, 0);
            FFDCFilter.processException(e, "com.ibm.ws.channel.framework.impl.WSChannelFrameworkImpl.retryChainStart", "521", this, new Object[]{chainData});
            Tr.error(tc, "chain.retrystart.error", new Object[]{chainData.getName(), new Integer(1)});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retryChainStart");
        }
    }

    public synchronized void startChainsByAcceptorID(String acceptorID, ChainStartMode mode) throws ChannelException, ChainException, ChainGroupException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "starting group " + acceptorID + ":", this.getChainGroup(acceptorID) + " mode:" + mode.getOrdinal());
        }
        this.startChainGroup(acceptorID, mode);
    }

    public synchronized void stopChainsByAcceptorID(String acceptorID, long delay) throws ChannelException, ChainException, ChainGroupException {
        this.stopChainGroup(acceptorID, delay);
    }

    public synchronized void stopChainInternal(Chain chain, long millisec) throws ChannelException, ChainException {
        super.stopChainInternal(chain, millisec);
        Tr.audit(tc, "chain.stopped", new Object[]{chain.getName()});
    }

    synchronized void startChainInternal(ChainData chainData) throws ChannelException, ChainException {
        super.startChainInternal(chainData);
    }

    public synchronized void startChainInternal(ChainData chainData, ChainStartMode startMode) throws ChannelException, ChainException {
        super.startChainInternal(chainData, startMode);
        Tr.audit(tc, "chain.started", new Object[]{chainData.getName()});
    }

    public synchronized ChainData updateChain(String chainName, String[] newChannelList) throws ChannelException, ChainException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateChain");
        }
        boolean enabled = false;
        String acceptorID = null;
        WSChainData chainData = (WSChainData)super.getChain(chainName);
        if (null != chainData) {
            enabled = chainData.isEnabled();
            acceptorID = chainData.getAcceptorID();
        }
        chainData = (WSChainData)super.updateChain(chainName, newChannelList);
        chainData.setEnabled(enabled);
        chainData.setAcceptorID(acceptorID);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateChain");
        }
        return chainData;
    }

    public synchronized CFEndPoint getEndPoint(String chainName) throws ChainNotInboundException, NoCFEndPointException, NullCFEndPointException {
        WSChainData chainData = (WSChainData)this.getChain(chainName);
        return chainData == null ? null : chainData.getEndPoint();
    }

    public CFEndPoint[] getEndPointsByAcceptorID(String acceptorID) {
        ChainGroupData group = this.getChainGroup(acceptorID);
        if (group == null) {
            return null;
        }
        ArrayList<CFEndPoint> list = new ArrayList<CFEndPoint>();
        ChainData[] chains = group.getChains();
        for (int i = 0; i < chains.length; ++i) {
            try {
                CFEndPoint temp = this.getEndPoint(chains[i].getName());
                if (temp == null) continue;
                list.add(temp);
                continue;
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Unavailable CFEndPoint for chain " + chains[i].getName());
            }
        }
        return list.toArray(new CFEndPoint[list.size()]);
    }

    public CFEndPoint[] getEndPoints(CFEndPoint[] endPointList, CFEndPointCriteria criteria) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEndPoints");
        }
        CFEndPoint[] rtnArray = this.commonGetEndPoints(endPointList, criteria, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEndPoints");
        }
        return rtnArray;
    }

    public CFEndPoint determineBestEndPoint(CFEndPoint[] endPointList, CFEndPointCriteria descriptor) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "determineBestEndPoint");
        }
        if (endPointList == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "determineBestEndPoint - null endPointList");
            }
            return null;
        }
        CFEndPoint chosenEndPoint = null;
        CFEndPoint[] matchedEps = this.commonGetEndPoints(endPointList, descriptor, true);
        if (matchedEps != null) {
            chosenEndPoint = matchedEps[matchedEps.length - 1];
        }
        if (chosenEndPoint != null) {
            ((CFEndPointImpl)chosenEndPoint).setFramework(this);
        }
        if (tc.isDebugEnabled()) {
            if (chosenEndPoint == null) {
                StringBuilder sbDebug = new StringBuilder();
                sbDebug.append("CFEndPoint not found for criteria:\r\n");
                sbDebug.append(this.getCriteriaString(descriptor));
                sbDebug.append("\r\nCFEndPointArray:");
                for (int i = 0; i < endPointList.length; ++i) {
                    sbDebug.append("\r\n");
                    sbDebug.append(endPointList[i]);
                }
                Tr.debug(tc, sbDebug.toString());
            } else {
                Tr.debug(tc, "Chosen CFEndPoint: " + chosenEndPoint);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "determineBestEndPoint");
        }
        return chosenEndPoint;
    }

    /*
     * Unable to fully structure code
     */
    private CFEndPoint[] commonGetEndPoints(CFEndPoint[] endPointList, CFEndPointCriteria criteria, boolean getBestOnly) {
        block40: {
            block41: {
                if (WSChannelFrameworkImpl.tc.isEntryEnabled()) {
                    Tr.entry(WSChannelFrameworkImpl.tc, "commonGetEndPoints", new Object[]{endPointList, criteria, getBestOnly != false ? Boolean.TRUE : Boolean.FALSE});
                }
                if (endPointList == null || endPointList.length == 0 || criteria == null) {
                    if (WSChannelFrameworkImpl.tc.isEntryEnabled()) {
                        Tr.exit(WSChannelFrameworkImpl.tc, "commonGetEndPoints", "returns null");
                    }
                    return null;
                }
                tempEndPoint = null;
                chainName = criteria.getChainName();
                if (WSChannelFrameworkImpl.tc.isDebugEnabled()) {
                    Tr.debug(WSChannelFrameworkImpl.tc, "Chain name specified in criteria: " + chainName);
                }
                chosenEndPoints = new ArrayList<CFEndPoint>();
                if (chainName == null) break block41;
                for (i = 0; i < endPointList.length; ++i) {
                    if (endPointList[i] == null) {
                        if (!WSChannelFrameworkImpl.tc.isDebugEnabled()) continue;
                        Tr.debug(WSChannelFrameworkImpl.tc, "Skipping over null end point in position " + i);
                        continue;
                    }
                    if (!endPointList[i].getName().equals(chainName)) continue;
                    chosenEndPoints.add(endPointList[i]);
                    if (!getBestOnly) {
                        continue;
                    }
                    break block40;
                }
                break block40;
            }
            vhost = this.extractVhostFromCriteria(criteria);
            if (null == vhost) {
                vhostList = null;
                nonAdminHostEndPoints = new ArrayList<CFEndPoint>();
                for (i = 0; i < endPointList.length; ++i) {
                    tempEndPoint = endPointList[i];
                    if (tempEndPoint == null) continue;
                    vhostList = tempEndPoint.getVhostArray();
                    if (vhostList == null || vhostList.length == 0) {
                        nonAdminHostEndPoints.add(tempEndPoint);
                        continue;
                    }
                    bFoundAdminHost = false;
                    for (j = 0; j < vhostList.length; ++j) {
                        if (!vhostList[j].equalsIgnoreCase("admin_host")) continue;
                        if (TraceComponent.isAnyTracingEnabled() && WSChannelFrameworkImpl.tc.isDebugEnabled()) {
                            Tr.debug(WSChannelFrameworkImpl.tc, "Removing admin_host endpoint from selectable list since it was not explicitly requested");
                        }
                        bFoundAdminHost = true;
                        break;
                    }
                    if (bFoundAdminHost) continue;
                    nonAdminHostEndPoints.add(tempEndPoint);
                }
                if (endPointList.length != nonAdminHostEndPoints.size()) {
                    endPointList = new CFEndPoint[nonAdminHostEndPoints.size()];
                    nonAdminHostEndPoints.toArray(endPointList);
                }
            } else {
                vhostList = null;
                vhostMatchingEndPoints = new ArrayList<CFEndPoint>();
                vhostNullEndPoints = new ArrayList<CFEndPoint>();
                block3: for (i = 0; i < endPointList.length; ++i) {
                    tempEndPoint = endPointList[i];
                    if (tempEndPoint == null) continue;
                    vhostList = tempEndPoint.getVhostArray();
                    if (vhostList == null || vhostList.length == 0) {
                        vhostNullEndPoints.add(tempEndPoint);
                        continue;
                    }
                    for (j = 0; j < vhostList.length; ++j) {
                        if (!vhost.equalsIgnoreCase(vhostList[j])) continue;
                        vhostMatchingEndPoints.add(tempEndPoint);
                        continue block3;
                    }
                }
                if (0 != vhostMatchingEndPoints.size()) {
                    endPointList = new CFEndPoint[vhostMatchingEndPoints.size()];
                    vhostMatchingEndPoints.toArray(endPointList);
                    if (WSChannelFrameworkImpl.tc.isDebugEnabled()) {
                        Tr.debug(WSChannelFrameworkImpl.tc, "Found matching vhost in " + vhostMatchingEndPoints.size() + " CFEndPoints.");
                    }
                } else {
                    endPointList = new CFEndPoint[vhostNullEndPoints.size()];
                    vhostNullEndPoints.toArray(endPointList);
                    if (WSChannelFrameworkImpl.tc.isDebugEnabled()) {
                        Tr.debug(WSChannelFrameworkImpl.tc, "No matching vhost found.  New CFEndPoint list size " + vhostNullEndPoints.size());
                    }
                }
            }
            sslRequired = criteria.isSSLRequired();
            if (WSChannelFrameworkImpl.tc.isDebugEnabled()) {
                Tr.debug(WSChannelFrameworkImpl.tc, "Criteria specification if SSL is required: " + sslRequired);
            }
            requiredFactories = criteria.getOptionalChannelFactories();
            for (i = 0; i < endPointList.length; ++i) {
                tempEndPoint = endPointList[i];
                if (tempEndPoint == null) {
                    if (!WSChannelFrameworkImpl.tc.isDebugEnabled()) continue;
                    Tr.debug(WSChannelFrameworkImpl.tc, "Skipping over null end point in position " + i);
                    continue;
                }
                if (tempEndPoint.getChannelAccessor() == null) {
                    if (!WSChannelFrameworkImpl.tc.isDebugEnabled()) continue;
                    Tr.debug(WSChannelFrameworkImpl.tc, "Skipping over end point with null channel accessor, " + tempEndPoint.getName());
                    continue;
                }
                if (requiredFactories != null) {
                    if (WSChannelFrameworkImpl.tc.isDebugEnabled()) {
                        Tr.debug(WSChannelFrameworkImpl.tc, "Found required factories to match");
                    }
                    foundFactory = true;
                    requiredFactory = null;
                    ocdFactory = null;
                    ocdList = tempEndPoint.getOutboundChannelDefs();
                    for (factoryIndex = 0; factoryIndex < requiredFactories.length; ++factoryIndex) {
                        requiredFactory = requiredFactories[factoryIndex];
                        if (WSChannelFrameworkImpl.tc.isDebugEnabled()) {
                            Tr.debug(WSChannelFrameworkImpl.tc, "RequiredFactory: " + requiredFactory);
                        }
                        foundFactory = false;
                        for (ocdIndex = 0; ocdIndex < ocdList.length; ++ocdIndex) {
                            ocdFactory = ocdList[ocdIndex].getOutboundFactory();
                            if (WSChannelFrameworkImpl.tc.isDebugEnabled()) {
                                Tr.debug(WSChannelFrameworkImpl.tc, "\tOCD Factory: " + ocdFactory);
                            }
                            if (!requiredFactory.isAssignableFrom(ocdFactory) && !ocdFactory.isAssignableFrom(requiredFactory)) continue;
                            if (WSChannelFrameworkImpl.tc.isDebugEnabled()) {
                                Tr.debug(WSChannelFrameworkImpl.tc, "\tFound a match");
                            }
                            foundFactory = true;
                            break;
                        }
                        if (!foundFactory) break;
                    }
                    if (!foundFactory) {
                        if (!WSChannelFrameworkImpl.tc.isDebugEnabled()) continue;
                        Tr.debug(WSChannelFrameworkImpl.tc, "Skipping over endpoint with missing required factory.");
                        continue;
                    }
                }
                if (!tempEndPoint.getChannelAccessor().equals(criteria.getChannelAccessor())) continue;
                if (!sslRequired) ** GOTO lbl140
                if (!tempEndPoint.isSSLEnabled()) continue;
                if (chosenEndPoints.size() == 0) {
                    chosenEndPoints.add(tempEndPoint);
                    if (!tempEndPoint.isLocal() || !getBestOnly) continue;
                } else if (getBestOnly) {
                    if (!tempEndPoint.isLocal()) continue;
                    chosenEndPoints.add(tempEndPoint);
                } else {
                    chosenEndPoints.add(tempEndPoint);
                    continue;
lbl140:
                    // 1 sources

                    if (tempEndPoint.isSSLEnabled()) continue;
                    chosenEndPoints.add(tempEndPoint);
                    if (!tempEndPoint.isLocal() || !getBestOnly) {
                        continue;
                    }
                }
                break;
            }
        }
        rtnSize = chosenEndPoints.size();
        rtnEPs = null;
        if (rtnSize > 0) {
            rtnEPs = new CFEndPoint[rtnSize];
            chosenEndPoints.toArray(rtnEPs);
        }
        if (WSChannelFrameworkImpl.tc.isEntryEnabled()) {
            Tr.exit(WSChannelFrameworkImpl.tc, "commonGetEndPoints", Integer.toString(rtnSize));
        }
        return rtnEPs;
    }

    private String extractVhostFromCriteria(CFEndPointCriteria basicCriteria) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractVhostFromCriteria");
        }
        String vhost = null;
        if (DetailedCFEndPointCriteria.class.isAssignableFrom(basicCriteria.getClass())) {
            Map chainProperties;
            DetailedCFEndPointCriteria detailedCriteria = (DetailedCFEndPointCriteria)basicCriteria;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found a DetailedCFEndPointCriteria, " + detailedCriteria);
            }
            if ((chainProperties = detailedCriteria.getChainProperties()) != null) {
                vhost = (String)chainProperties.get("vhost");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Vhost provided in criteria, " + vhost);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractVhostFromCriteria");
        }
        return vhost;
    }

    public String[] getVhost(String inputHost, String inputPort) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getVhost");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "inputHost=" + inputHost + ", inputPort=" + inputPort);
        }
        if (inputHost == null || inputPort == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No virtual host found for inputHost=" + inputHost + ", inputPort=" + inputPort);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getVhost");
            }
            return null;
        }
        ArrayList<String> vhostArrayList = new ArrayList<String>();
        if (this._virtualHostMgr == null) {
            this._virtualHostMgr = (VirtualHostMgr)this.lookupService(VirtualHostMgr.class);
            if (null == this._virtualHostMgr) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to find VirtualHostMgr service in ChannelFramework");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getVhost");
                }
                return new String[0];
            }
        }
        VirtualHost[] vHosts = this._virtualHostMgr.getVirtualHosts();
        Alias[] aliases = null;
        String host = null;
        String port2 = null;
        block0: for (int i = 0; i < vHosts.length; ++i) {
            aliases = vHosts[i].getAliases();
            for (int j = 0; j < aliases.length; ++j) {
                host = aliases[j].getHostname();
                port2 = aliases[j].getPort();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Comparing to host=" + host + ", port=" + port2);
                }
                if (!host.equals("*") && !inputHost.equals("*") && !host.equalsIgnoreCase(inputHost) || !port2.equals("*") && !inputPort.equals("*") && !port2.equals(inputPort)) continue;
                vhostArrayList.add(vHosts[i].getName());
                if (!tc.isDebugEnabled()) continue block0;
                Tr.debug(tc, "Found a match, " + vHosts[i].getName());
                continue block0;
            }
        }
        if (0 == vhostArrayList.size() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Never found a match");
        }
        String[] vhostStringArray = new String[vhostArrayList.size()];
        vhostArrayList.toArray(vhostStringArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getVhost");
        }
        return vhostStringArray;
    }

    private String getCriteriaString(CFEndPointCriteria criteria) {
        StringBuilder sb = new StringBuilder();
        sb.append("Name= ");
        sb.append(criteria.getChainName());
        sb.append(" SSL=");
        sb.append(criteria.isSSLRequired());
        sb.append(" Accessor=");
        sb.append(criteria.getChannelAccessor());
        Class[] clazz = criteria.getOptionalChannelFactories();
        if (clazz != null && clazz.length > 0) {
            sb.append(" Factories=");
            for (int i = 0; i < clazz.length; ++i) {
                sb.append(clazz[i]);
                sb.append(",");
            }
        }
        return sb.toString();
    }

    public synchronized void prepareEndPoint(CFEndPoint endPoint) throws ChannelException, ChainException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareEndPoint");
        }
        if (null == endPoint) {
            throw new ChainException("Parameter is null");
        }
        WSVirtualConnectionFactory vcf = null;
        if (null != ((CFEndPointImpl)endPoint).getOutboundChainData()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found existing outboundChainData for CFEndPoint");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Need to build outboundChainData and vcf for CFEndPoint");
            }
            OutboundChannelDefinition[] channelDefs = endPoint.getOutboundChannelDefs();
            vcf = this.getOutboundVCFactory(channelDefs);
            endPoint.setOutboundVCFactory(vcf);
            ((CFEndPointImpl)endPoint).setOutboundChainData((WSChainData)this.getChain(vcf.getName()));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Resulting outbound chain, " + vcf.getName());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareEndPoint");
        }
    }

    public Object lookupService(Class clazz) {
        Object service = super.lookupService(clazz);
        if (service == null && this._cfService != null) {
            service = this._cfService.getService(clazz);
        }
        return service;
    }

    public ThreadPool getDefaultThreadPool() {
        ThreadPool tp;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultThreadPool");
        }
        if (this._cfService != null) {
            tp = this.getThreadPool("Default");
            if (tp == null) {
                ThreadPoolRepository tpf = ThreadPoolRepositoryManager.getThreadPoolRepository();
                try {
                    tp = tpf.createThreadPool("Default", this.defaultMinimumThreads, this.defaultMaximumThreads, 5000L, 1000);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Created Default Thread Pool With The Name: Default");
                    }
                }
                catch (ThreadPoolAlreadyKnownException e) {
                    FFDCFilter.processException(e, "com.ibm.ws.channel.framework.impl.WSChannelFrameworkImpl.getDefaultThreadPool", "1137", this, null);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Retrieved Default Thread Pool With The Name: Default");
            }
        } else {
            tp = super.getDefaultThreadPool();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultThreadPool");
        }
        return tp;
    }

    protected void addChainToGroupInternal(String groupName, String chainName) throws ChainException, ChainGroupException {
        ChainGroupData groupData = this.getChainGroup(groupName);
        if (groupData != null) {
            this.addChainToGroup(groupName, chainName);
        } else {
            this.addChainGroup(groupName, new String[]{chainName});
        }
    }

    protected void removeChainFromGroupInternal(String groupName, String chainName) throws ChainException, ChainGroupException {
        this.removeChainFromGroup(groupName, chainName);
        ChainGroupData group = this.getChainGroup(groupName);
        if (group != null && group.getChains().length == 0) {
            this.removeChainGroup(groupName);
        }
    }

    protected ChainData createChainData(String name2, FlowType type, ChannelData[] channels, ChannelFrameworkImpl fw, Map properties) throws IncoherentChainException {
        return new WSChainData(name2, type, channels, fw, properties);
    }

    protected OutboundVirtualConnectionFactoryImpl createVirtualConnectionFactory(ChainData chainData, ChannelFrameworkImpl fw) throws ChannelException, ChainException {
        return new WSVirtualConnectionFactoryImpl(chainData, this);
    }

    private synchronized WSVirtualConnectionFactory getOutboundVCFactory(OutboundChannelDefinition[] channelDefs) throws ChainException, ChannelException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOutboundVCFactory");
        }
        WSVirtualConnectionFactoryImpl vcf2 = null;
        ChainDataImpl chainData = null;
        int tempHashKey = 0;
        boolean found = false;
        int hashKey = 0;
        for (int i = 0; i < channelDefs.length; ++i) {
            hashKey += channelDefs[i].getOutboundFactory().hashCode();
        }
        for (WSVirtualConnectionFactoryImpl vcf2 : this.outboundVCFactories.values()) {
            ChannelData[] channelDataList;
            chainData = (ChainDataImpl)vcf2.getChain().getChainData();
            tempHashKey = chainData.getChannelFactoryHash();
            if (hashKey != tempHashKey) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found matching hash keys");
            }
            if ((channelDataList = chainData.getChannelList()).length != channelDefs.length) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found matching number of channels");
            }
            found = true;
            for (int i = 0; i < channelDataList.length; ++i) {
                ChannelData existingDef = channelDataList[i];
                ChannelFactoryData existingFactoryData = super.getChannelFactory(existingDef.getFactoryType());
                OutboundChannelDefinition inputDef = channelDefs[i];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Comparing existing def ...\n " + existingDef.getFactoryType() + "\n" + "to new def ...\n" + inputDef.getOutboundFactory());
                }
                boolean sameFactoryType = existingDef.getFactoryType() == inputDef.getOutboundFactory();
                boolean sameChannelProps = this.propertiesIncluded(inputDef.getOutboundChannelProperties(), existingDef.getPropertyBag());
                boolean sameFactoryProps = this.propertiesIncluded(inputDef.getOutboundFactoryProperties(), existingFactoryData.getProperties());
                if (sameFactoryType && !sameFactoryProps) {
                    Exception e = new Exception("No support for multiple factory property maps for the same factory type");
                    FFDCFilter.processException(e, "com.ibm.ws.channel.framework.impl.WSChannelFrameworkImpl.getOutboundVCFactory", "1510", this, new Object[]{inputDef, existingFactoryData});
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No support for multiple factory property maps for the same factory type");
                    }
                }
                if (sameFactoryType && sameChannelProps && sameFactoryProps) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Keys matched, but factories didn't");
                }
                found = false;
                break;
            }
            if (!found) continue;
            break;
        }
        if (!found) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No existing VCF, create one.");
            }
            String[] channelNameList = new String[channelDefs.length];
            String channelName = null;
            for (int i = 0; i < channelDefs.length; ++i) {
                channelNameList[i] = channelName = "channel_" + this._channelNameCounter++;
                this.addChannel(channelName, channelDefs[i].getOutboundFactory(), channelDefs[i].getOutboundChannelProperties());
            }
            String chainName = new String("chain_" + this._chainNameCounter++);
            this.addChain(chainName, FlowType.OUTBOUND, channelNameList);
            vcf2 = (WSVirtualConnectionFactoryImpl)this.getOutboundVCFactory(chainName);
        } else {
            vcf2.incrementRefCount();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found an existing vcf " + vcf2.hashCode() + " and incremented vcf ref count to " + vcf2.getRefCount());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOutboundVCFactory");
        }
        return vcf2;
    }

    private boolean propertiesIncluded(Map inputMap, Map existingMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "propertiesIncluded");
        }
        boolean found = true;
        if (inputMap == null) {
            return true;
        }
        if (existingMap == null) {
            return false;
        }
        Iterator inputProps = inputMap.keySet().iterator();
        Object inputPropKey = null;
        Object inputPropValue = null;
        Object existingPropValue = null;
        while (inputProps.hasNext()) {
            inputPropKey = inputProps.next();
            inputPropValue = inputMap.get(inputPropKey);
            existingPropValue = existingMap.get(inputPropKey);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Comparing input=" + inputPropValue + " to existing=" + existingPropValue);
            }
            if (existingPropValue != null && existingPropValue.equals(inputPropValue)) continue;
            found = false;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "propertiesIncluded");
        }
        return found;
    }

    private ConfigObject getFirstChannel(ConfigObject chain) {
        if (chain == null) {
            return null;
        }
        List transportChannels = chain.getObjectList("transportChannels");
        if (transportChannels.isEmpty()) {
            return null;
        }
        return (ConfigObject)transportChannels.get(0);
    }

    private ConfigObject getLastChannel(ConfigObject chain) {
        if (chain == null) {
            return null;
        }
        List channels = chain.getObjectList("transportChannels");
        if (channels.isEmpty()) {
            return null;
        }
        return (ConfigObject)channels.get(channels.size() - 1);
    }

    private boolean isInbound(ConfigObject chain) {
        ConfigObject first = this.getFirstChannel(chain);
        return first != null && this._typeManager.ConnTypeChannelCheck(first, true) == 1;
    }

    private String[] getChannelNamesFromChain(ConfigObject chain) throws ChannelException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChannelNamesFromChain");
        }
        if (chain == null) {
            throw new ChannelException("Chain not defined");
        }
        List channels = chain.getObjectList("transportChannels");
        if (channels.isEmpty()) {
            throw new ChannelException("No channels defined in chain, " + chain.getString("name", null));
        }
        ArrayList totalNameList = new ArrayList();
        ArrayList subNameList = null;
        ConfigObject transportChannel = null;
        int channelNum = channels.size();
        for (int i = 0; i < channelNum; ++i) {
            transportChannel = (ConfigObject)channels.get(i);
            ChannelTypeManager.ChannelMetaData channelMetaData = this.getChannelType(transportChannel);
            String factoryClass = channelMetaData.getRuntimeClass();
            try {
                subNameList = this.getChannelNamesFromFactory(factoryClass, transportChannel, channelMetaData);
            }
            catch (ConfigurationError e) {
                throw new ChannelException(e);
            }
            totalNameList.addAll(subNameList);
        }
        String[] channelNameArray = new String[totalNameList.size()];
        for (int i = 0; i < totalNameList.size(); ++i) {
            channelNameArray[i] = (String)totalNameList.get(i);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChannelNamesFromChain");
        }
        return channelNameArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArrayList getChannelNamesFromFactory(String factoryClass, ConfigObject transportChannel, ChannelTypeManager.ChannelMetaData channelMetaData) throws ChannelException, ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChannelNamesFromFactory");
        }
        ArrayList<String> channelNames = new ArrayList<String>();
        ChannelFactory factory = null;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Build WSChannelFactory for Class, " + factoryClass);
            }
            factory = this.getChannelFactoryInternal(channelMetaData.getClass(factoryClass), true);
        }
        catch (ClassNotFoundException e) {
            StringBuilder message = new StringBuilder();
            message.append(factoryClass);
            message.append(" cannot be loaded");
            throw new InvalidChannelFactoryException(message.toString(), e);
        }
        if (factory instanceof WSAggregateChannelFactory) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found impl of WSAggregateChannelFactory: " + factoryClass);
            }
            WSAggregateChannelFactory aggregateFactory = (WSAggregateChannelFactory)factory;
            if (this._cfService.getConfigService() == null) {
                ConfigurationError x = new ConfigurationError("RCS ConfigService can not be found");
                FFDCFilter.processException(x, "com.ibm.ws.channel.framework.impl.WSChannelFrameworkImpl.getChannelNamesFromFactory", "1927", this, null);
                throw x;
            }
            EObject object = ((InternalConfigService)this._cfService.getConfigService()).getEObject(transportChannel);
            TransportChannel wccmObject = (TransportChannel)object;
            Class[] factoryArray = aggregateFactory.getAggregateChannelFactories(wccmObject, this);
            for (int i = 0; i < factoryArray.length; ++i) {
                channelNames.addAll(this.getChannelNamesFromFactory(factoryArray[i].getName(), transportChannel, channelMetaData));
            }
        } else if (factory instanceof WSAggregateChannelFactoryRCS) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found impl of WSAggregateChannelFactory: " + factoryClass);
            }
            WSAggregateChannelFactoryRCS aggregateFactory = (WSAggregateChannelFactoryRCS)factory;
            Class[] factoryArray = aggregateFactory.getAggregateChannelFactories(transportChannel, this);
            for (int i = 0; i < factoryArray.length; ++i) {
                channelNames.addAll(this.getChannelNamesFromFactory(factoryArray[i].getName(), transportChannel, channelMetaData));
            }
        } else {
            if (!(factory instanceof WSChannelFactory) && !(factory instanceof WSChannelFactoryRCS)) {
                StringBuilder message = new StringBuilder();
                message.append(factoryClass);
                message.append(" does not implement ");
                message.append(WSChannelFactoryRCS.class);
                message.append(" or ");
                message.append(WSChannelFactory.class);
                throw new InvalidChannelFactoryException(message.toString());
            }
            String name2 = null;
            name2 = factoryClass == channelMetaData.getRuntimeClass() ? transportChannel.getString("name", null) : transportChannel.getString("name", null) + "_" + factoryClass;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding channel name, " + name2 + ", to the list for the chain.");
            }
            channelNames.add(name2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChannelNamesFromFactory");
        }
        return channelNames;
    }

    private FlowType getFlowType(ConfigObject channel) {
        if (channel == null) {
            return null;
        }
        if (this._typeManager.ConnTypeChannelCheck(channel, true) == 1) {
            return FlowType.INBOUND;
        }
        return FlowType.OUTBOUND;
    }

    private boolean validateChainFlow(FlowType flow, ConfigObject chain) {
        boolean result = true;
        Iterator channels = chain.getObjectList("transportChannels").iterator();
        while (result && channels.hasNext()) {
            result = flow == this.getFlowType((ConfigObject)channels.next());
        }
        return result;
    }

    private boolean validateChannelKind(ChannelTypeManager.ChannelKind kind, ConfigObject channel) {
        if (channel == null) {
            return false;
        }
        ChannelTypeManager.ChannelMetaData type = this._typeManager.getChannelType(channel);
        if (type == null) {
            return false;
        }
        return kind == type.getKind();
    }

    private synchronized ChainData addChainInternal(String name2, FlowType type, String[] channels, String acceptorID, boolean enabled) throws ChannelException, ChainException, ChainGroupException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addChainInternal called with");
            Tr.debug(tc, "name: " + name2);
            Tr.debug(tc, "type: " + type);
            if (channels.length > 0) {
                Tr.debug(tc, "first Channel: " + channels[0]);
                Tr.debug(tc, "last  Channel: " + channels[channels.length - 1]);
            }
            Tr.debug(tc, "acceptorID: " + acceptorID);
        }
        WSChainData result = (WSChainData)this.addChain(name2, type, channels);
        result.setAcceptorID(acceptorID);
        if (enabled) {
            this.addChainToGroupInternal(acceptorID, name2);
            result.setEnabled(enabled);
        } else {
            Tr.audit(tc, "chain.disabled", new String[]{name2});
        }
        return result;
    }

    protected boolean currentlyOnZ() {
        PlatformHelper ph = PlatformHelperFactory.getPlatformHelper();
        if (ph != null) {
            return ph.isZOS();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "PlatformHelperFactory.getPlatformHelper() returned NULL!");
        }
        return false;
    }

    protected int currentZRegion() {
        PlatformHelper ph = PlatformHelperFactory.getPlatformHelper();
        if (ph != null) {
            if (PlatformHelperFactory.getPlatformHelper().isBaseServantJvm()) {
                return 8;
            }
            if (PlatformHelperFactory.getPlatformHelper().isControlJvm()) {
                return 2;
            }
            if (PlatformHelperFactory.getPlatformHelper().isCRAJvm()) {
                return 4;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Not on SR, CR, CRA Z region");
            }
            return 16;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "PlatformHelperFactory.getPlatformHelper() returned NULL!");
        }
        RuntimeException re = new RuntimeException("Can not determine Z region");
        throw re;
    }

    protected synchronized ChainDataImpl createOutboundChain(CFEndPointImpl cfEndPoint) throws ChannelException, ChainException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createOutboundChain");
        }
        OutboundChannelDefinition[] channelDefs = cfEndPoint.getOutboundChannelDefs();
        ChainDataImpl chainData = null;
        String[] channelNameList = new String[channelDefs.length];
        String channelName = null;
        for (int i = 0; i < channelDefs.length; ++i) {
            channelNameList[i] = channelName = "channel_" + this._channelNameCounter++;
            this.addChannel(channelName, channelDefs[i].getOutboundFactory(), channelDefs[i].getOutboundChannelProperties());
        }
        String chainName = new String("chain_" + this._chainNameCounter++);
        chainData = (ChainDataImpl)this.addChain(chainName, FlowType.OUTBOUND, channelNameList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createOutboundChain");
        }
        return chainData;
    }

    public void setChainEnabled(String chainName, boolean enabled) {
        WSChainData chainData = (WSChainData)this.getChain(chainName);
        if (null != chainData) {
            chainData.setEnabled(enabled);
        }
    }
}

