/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.framework.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.OutboundChannelDefinition;
import java.io.NotSerializableException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.util.Map;

public class CFEndPointSerializer {
    private static final TraceComponent tc = Tr.register(CFEndPointSerializer.class, "ChannelFrameworkService", "com.ibm.ws.channel.resources.channelframeworkservice");

    private CFEndPointSerializer() {
    }

    private static StringBuilder determineType(String name2, Object o) {
        String value2 = null;
        if (!(o instanceof String || o instanceof StringBuffer || o instanceof CharBuffer || o instanceof Integer || o instanceof Long || o instanceof Byte || o instanceof Double || o instanceof Float || o instanceof Short || o instanceof BigInteger || o instanceof BigDecimal)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Skipping class: " + o.getClass());
            }
            return null;
        }
        value2 = o.toString();
        StringBuilder buffer = new StringBuilder(48);
        buffer.append(name2);
        buffer.append("type=\"");
        if (o instanceof CharBuffer) {
            buffer.append("java.nio.CharBuffer");
        } else {
            buffer.append(o.getClass().getName());
        }
        buffer.append("\" ");
        buffer.append(name2);
        buffer.append("=\"");
        buffer.append(value2);
        buffer.append("\"");
        return buffer;
    }

    private static StringBuilder serializeChannel(StringBuilder buffer, OutboundChannelDefinition ocd, int order) throws NotSerializableException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Serializing channel: " + order + " " + ocd.getOutboundFactory().getName());
        }
        buffer.append("   <channel order=\"");
        buffer.append(order);
        buffer.append("\" factory=\"");
        buffer.append(ocd.getOutboundFactory().getName());
        buffer.append("\">\n");
        Map props = ocd.getOutboundChannelProperties();
        if (null != props) {
            for (Object key : props.keySet()) {
                StringBuilder vBuff;
                Object value2 = props.get(key);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Checking channel prop: [" + key + "]");
                }
                if (null == value2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Property value [" + key + "] is null, " + ocd.toString());
                    }
                    throw new NotSerializableException("Property value for [" + key + "] is null");
                }
                StringBuilder kBuff = CFEndPointSerializer.determineType("key", key);
                if (null == kBuff || null == (vBuff = CFEndPointSerializer.determineType("value", value2))) continue;
                buffer.append("      <property ");
                buffer.append((CharSequence)kBuff);
                buffer.append(" ");
                buffer.append((CharSequence)vBuff);
                buffer.append("/>\n");
            }
        }
        buffer.append("   </channel>\n");
        return buffer;
    }

    public static String serialize(CFEndPoint point) throws NotSerializableException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serialize");
        }
        if (null == point) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Null CFEndPoint input for serialization");
            }
            throw new NotSerializableException("Null input");
        }
        StringBuilder buffer = new StringBuilder(512);
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Serializing endpoint: " + point.getName());
        }
        buffer.append("<cfendpoint name=\"");
        buffer.append(point.getName());
        buffer.append("\" host=\"");
        buffer.append(point.getAddress().getCanonicalHostName());
        buffer.append("\" port=\"");
        buffer.append(point.getPort());
        buffer.append("\" local=\"");
        buffer.append(point.isLocal());
        buffer.append("\" ssl=\"");
        buffer.append(point.isSSLEnabled());
        buffer.append("\">\n");
        OutboundChannelDefinition[] list = point.getOutboundChannelDefs();
        for (int i = 0; i < list.length; ++i) {
            buffer = CFEndPointSerializer.serializeChannel(buffer, list[i], i);
        }
        buffer.append("</cfendpoint>");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Serialized string: \n" + buffer.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "serialize");
        }
        return buffer.toString();
    }
}

