/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.framework.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.ChannelData;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.channel.framework.impl.CFEndPointSerializer;
import com.ibm.ws.channel.framework.impl.OutboundChannelDefinitionImpl;
import com.ibm.ws.channel.framework.impl.OutboundVirtualConnectionFactoryImpl;
import com.ibm.ws.channel.framework.impl.WSChainData;
import com.ibm.ws.channel.framework.impl.WSChannelFrameworkImpl;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.wsspi.channel.ChannelFactory;
import com.ibm.wsspi.channel.LocalChannelFactory;
import com.ibm.wsspi.channel.SSLChannelFactory;
import com.ibm.wsspi.channel.WSChannelFactory;
import com.ibm.wsspi.channel.WSChannelFactoryRCS;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.ChannelFrameworkFactory;
import com.ibm.wsspi.channel.framework.OutboundChannelDefinition;
import com.ibm.wsspi.channel.framework.WSVirtualConnectionFactory;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.channel.framework.exception.ChannelFactoryException;
import com.ibm.wsspi.channel.framework.exception.NoCFEndPointException;
import com.ibm.wsspi.channel.framework.exception.NullCFEndPointException;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CFEndPointImpl
implements CFEndPoint,
Serializable {
    private static final TraceComponent tc = Tr.register(CFEndPointImpl.class, "ChannelFrameworkService", "com.ibm.ws.channel.resources.channelframeworkservice");
    private static final long serialVersionUID = -4050856186139408312L;
    protected String name = null;
    private String vhost = null;
    protected String[] vhostArray = null;
    protected int port = 0;
    protected InetAddress address = null;
    protected OutboundChannelDefinition[] outboundChannelDefs = null;
    protected Class<?> channelAccessor = null;
    protected transient WSVirtualConnectionFactory vcf = null;
    protected transient WSChannelFrameworkImpl framework = null;
    protected transient WSChainData outboundChainData = null;
    protected boolean isSSLEnabled = false;
    protected boolean isLocal = false;

    public CFEndPointImpl(String _name, int _port, String _vhost, InetAddress _address, OutboundChannelDefinition[] _outboundChannelDefs, Class<?> _channelAccessor) throws NullCFEndPointException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "constructor");
        }
        this.name = _name;
        this.port = _port;
        this.vhost = _vhost;
        this.vhostArray = new String[]{_vhost};
        this.address = _address;
        this.outboundChannelDefs = _outboundChannelDefs;
        this.framework = null;
        this.channelAccessor = _channelAccessor;
        if (_name == null || _port < 1 || _vhost == null || _address == null || _outboundChannelDefs == null || _outboundChannelDefs.length == 0 || _channelAccessor == null) {
            String errorMessage = "Error found in parameters: " + this;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, errorMessage);
            }
            throw new NullCFEndPointException(errorMessage);
        }
        this.determineIsSSLEnabled();
        this.determineIsLocal();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "constructor");
        }
    }

    public CFEndPointImpl(WSChainData chainData, WSChannelFrameworkImpl inputFramework) throws NullCFEndPointException, NoCFEndPointException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "constructor");
        }
        ChannelData[] channelList = chainData.getChannelList();
        String addressString = null;
        String portString = null;
        String listenPortString = null;
        ChannelFactory inboundFactoryTemp = null;
        WSChannelFactory inboundFactoryWCCM = null;
        WSChannelFactoryRCS inboundFactoryRCS = null;
        OutboundChannelDefinition ocd = null;
        HashMap<String, Object> copyMap = null;
        Map channelMap = null;
        Iterator iter = null;
        Object key2 = null;
        String value2 = null;
        this.framework = inputFramework;
        try {
            int i;
            NoCFEndPointException exception;
            Class clazz;
            inboundFactoryTemp = this.getWSChannelFactory(channelList[channelList.length - 1].getFactoryType());
            if (inboundFactoryTemp instanceof WSChannelFactoryRCS) {
                inboundFactoryRCS = (WSChannelFactoryRCS)inboundFactoryTemp;
            } else {
                inboundFactoryWCCM = (WSChannelFactory)inboundFactoryTemp;
            }
            ocd = inboundFactoryRCS != null ? inboundFactoryRCS.getOutboundChannelDefinition(new HashMap()) : inboundFactoryWCCM.getOutboundChannelDefinition(new HashMap());
            if (null != ocd && (clazz = ocd.getOutboundFactory()).isAssignableFrom((exception = new NoCFEndPointException("Chain " + chainData.getName() + " does not support CFEndPoints")).getClass())) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Chain " + chainData.getName() + " does not support CFEndPoints");
                }
                throw exception;
            }
            int outboundIndex = channelList.length - 1;
            int numNulls = 0;
            this.name = chainData.getName();
            OutboundChannelDefinition[] tempOutboundChannelDefs = new OutboundChannelDefinition[channelList.length];
            Map chainProperties = chainData.getPropertyBag();
            if (chainProperties != null) {
                addressString = (String)chainProperties.get("hostname");
                portString = (String)chainProperties.get("port");
                listenPortString = (String)chainProperties.get("listeningPort");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Resolving tcp properties: host=" + addressString + ", port=" + portString + ", listenPort=" + listenPortString);
                }
            } else {
                throw new NoCFEndPointException("No properties found in device side channel.  No CFEndPoint created.");
            }
            this.assignAddress(addressString);
            this.assignPort(portString, listenPortString);
            for (i = 0; i < channelList.length && outboundIndex >= 0; ++i, --outboundIndex) {
                inboundFactoryRCS = null;
                inboundFactoryWCCM = null;
                inboundFactoryTemp = this.getWSChannelFactory(channelList[i].getFactoryType());
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && inboundFactoryTemp == null) {
                    Tr.debug(tc, "getWSChannelFactory(channelList[i].getFactoryType() returned null");
                }
                if (inboundFactoryTemp instanceof WSChannelFactoryRCS) {
                    inboundFactoryRCS = (WSChannelFactoryRCS)inboundFactoryTemp;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getWSChannelFactory(channelList[i].getFactoryType() returned a type of WSChannelFactoryRCS:");
                    }
                } else {
                    inboundFactoryWCCM = (WSChannelFactory)inboundFactoryTemp;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getWSChannelFactory(channelList[i].getFactoryType() returned a type other than WSChannelFactoryWCCM:");
                    }
                }
                copyMap = new HashMap<String, Object>();
                channelMap = channelList[i].getPropertyBag();
                if (channelMap != null) {
                    for (Object key2 : channelMap.keySet()) {
                        value2 = (String)channelMap.get(key2);
                        if (value2 instanceof String) {
                            value2 = new String(value2);
                        }
                        copyMap.put((String)key2, value2);
                    }
                }
                if (inboundFactoryRCS != null) {
                    copyMap.put("Key_WsChainData", chainData);
                } else {
                    copyMap.put("Key_WsChainData", chainData);
                }
                tempOutboundChannelDefs[outboundIndex] = inboundFactoryRCS != null ? inboundFactoryRCS.getOutboundChannelDefinition(copyMap) : inboundFactoryWCCM.getOutboundChannelDefinition(copyMap);
                if (tempOutboundChannelDefs[outboundIndex] != null) continue;
                ++numNulls;
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Incremented numNulls to:  " + numNulls);
            }
            if (numNulls == 0) {
                this.outboundChannelDefs = tempOutboundChannelDefs;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "numNulls is 0, so outboundChannelDefs = tempOutboundChannelDefs");
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "numNulls is: " + numNulls);
                    Tr.debug(tc, "tempOutboundChannelDefs.length is: " + tempOutboundChannelDefs.length);
                }
                if (tempOutboundChannelDefs.length - numNulls <= 0) {
                    throw new NullCFEndPointException("There are no actual channels showing up in this chain");
                }
                this.outboundChannelDefs = new OutboundChannelDefinition[tempOutboundChannelDefs.length - numNulls];
                int j = 0;
                for (i = 0; i < tempOutboundChannelDefs.length; ++i) {
                    if (tempOutboundChannelDefs[i] == null) continue;
                    this.outboundChannelDefs[j++] = tempOutboundChannelDefs[i];
                }
            }
            this.determineChannelAccessor();
            this.determineIsSSLEnabled();
            this.determineIsLocal();
            this.vhostArray = inputFramework.getVhost(addressString, portString);
            if (null == this.vhostArray) {
                this.vhostArray = new String[0];
            } else if (0 != this.vhostArray.length) {
                this.vhost = this.vhostArray[0];
            }
        }
        catch (UnknownHostException exp) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid address " + addressString + " Exception: " + exp);
            }
            throw new NullCFEndPointException(exp);
        }
        catch (NumberFormatException exp) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid port " + portString + " Exception: " + exp);
            }
            throw new NullCFEndPointException(exp);
        }
        catch (ChannelFactoryException exp) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception: " + exp);
            }
            throw new NullCFEndPointException(exp);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "constructor");
        }
    }

    private ChannelFactory getWSChannelFactory(Class<?> factoryClass) throws NoCFEndPointException, ChannelFactoryException {
        ChannelFactory channelFactory;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Getting WSChannelFactory for class: " + factoryClass);
        }
        if (!((channelFactory = this.framework.getChannelFactoryInternal(factoryClass, false)) instanceof WSChannelFactory) && !(channelFactory instanceof WSChannelFactoryRCS)) {
            StringBuilder message = new StringBuilder();
            message.append("Factory class ");
            message.append(factoryClass);
            message.append(" does not implement the WSChannelFactory nor the WSChannelFactoryRCS interface.");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, message.toString());
            }
            throw new NoCFEndPointException(message.toString());
        }
        return channelFactory;
    }

    private void determineChannelAccessor() throws NullCFEndPointException, ChannelFactoryException {
        Class factoryClass;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "determineChannelAccessor");
        }
        if ((factoryClass = this.outboundChannelDefs[0].getOutboundFactory()) == null) {
            throw new NullCFEndPointException("No factory class associated with outbound channel " + this.outboundChannelDefs[this.outboundChannelDefs.length - 1]);
        }
        ChannelFactory outboundFactory = this.framework.getChannelFactoryInternal(factoryClass, false);
        if (outboundFactory == null) {
            throw new NullCFEndPointException("No channel factory could be found for factory class " + factoryClass);
        }
        this.channelAccessor = outboundFactory.getApplicationInterface();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "determineChannelAccessor");
        }
    }

    private void determineIsSSLEnabled() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "determineIsSSLEnabled");
        }
        this.isSSLEnabled = false;
        Class factoryClass = null;
        for (int i = 0; i < this.outboundChannelDefs.length; ++i) {
            factoryClass = this.outboundChannelDefs[i].getOutboundFactory();
            if (!SSLChannelFactory.class.isAssignableFrom(factoryClass)) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Found class implementing SSLChannelFactory inteface: " + factoryClass);
            }
            this.isSSLEnabled = true;
            break;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "determineIsSSLEnabled: " + this.isSSLEnabled());
        }
    }

    private void determineIsLocal() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "determineIsLocal");
        }
        this.isLocal = false;
        Class factoryClass = null;
        for (int i = 0; i < this.outboundChannelDefs.length; ++i) {
            factoryClass = this.outboundChannelDefs[i].getOutboundFactory();
            if (!LocalChannelFactory.class.isAssignableFrom(factoryClass)) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Found class implementing LocalChannelFactory inteface: " + factoryClass);
            }
            this.isLocal = true;
            break;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "determineIsLocal: " + this.isLocal());
        }
    }

    private void assignAddress(String addressString) throws NullCFEndPointException, NoCFEndPointException, UnknownHostException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "assignAddress: " + addressString);
        }
        if (addressString == null) {
            throw new NoCFEndPointException("No address available in properties.  No CFEndPoint will be created.");
        }
        String expanded_addr = null;
        VariableMap map = (VariableMap)this.framework._cfService.getService(VariableMap.class);
        expanded_addr = map != null ? map.expand(addressString) : addressString;
        if ("*".equals(expanded_addr)) {
            AdminService adminService;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Using AdminService to find node name");
            }
            if (null == (adminService = AdminServiceFactory.getAdminService())) {
                throw new NullCFEndPointException("Unable to access admin service to retrieve address");
            }
            String nodeName = adminService.getNodeName();
            expanded_addr = null != map ? map.expand(AdminHelper.getInstance().getNodeHostName(nodeName)) : AdminHelper.getInstance().getNodeHostName(nodeName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Looking up address string [" + expanded_addr + "]");
        }
        this.address = InetAddress.getByName(expanded_addr);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "assignAddress: " + this.address);
        }
    }

    private void assignPort(String portString, String listenPortString) throws NoCFEndPointException, NumberFormatException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "assignPort");
        }
        if (portString != null) {
            this.port = new Integer(portString);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Port set from regular tcp port: " + this.port);
            }
        } else if (listenPortString != null) {
            this.port = new Integer(listenPortString);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Port set from tcp listening port: " + this.port);
            }
        } else {
            throw new NoCFEndPointException("Port not available in TCP channel properties.");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "assignPort");
        }
    }

    public CFEndPointImpl() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String inputName) {
        this.name = inputName;
    }

    @Override
    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getVhost() {
        if (null == this.vhostArray || this.vhostArray.length == 0) {
            if (null != this.vhost) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "getVhost using deserialized string value; " + this.vhost);
                }
                this.vhostArray = new String[]{this.vhost};
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "getVhost encountered empty vhostarray; " + this);
                }
                return null;
            }
        }
        return this.vhostArray[0];
    }

    @Override
    public String[] getVhostArray() {
        if (null == this.vhostArray) {
            if (null != this.vhost) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "getVhostArray using deserialized string value; " + this.vhost);
                }
                this.vhostArray = new String[]{this.vhost};
            } else {
                this.vhostArray = new String[0];
            }
        }
        return this.vhostArray;
    }

    @Override
    public OutboundChannelDefinition[] getOutboundChannelDefs() {
        return this.outboundChannelDefs;
    }

    @Override
    public Class<?> getChannelAccessor() {
        return this.channelAccessor;
    }

    @Override
    public boolean isSSLEnabled() {
        return this.isSSLEnabled;
    }

    @Override
    public boolean isLocal() {
        return this.isLocal;
    }

    protected void setOutboundChainData(WSChainData inputChainData) {
        this.outboundChainData = inputChainData;
    }

    protected WSChainData getOutboundChainData() {
        return this.outboundChainData;
    }

    public void setFramework(WSChannelFrameworkImpl inputFramework) {
        this.framework = inputFramework;
    }

    @Override
    public synchronized WSChainData createOutboundChain() throws ChannelException, ChainException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createOutboundChain");
        }
        if (this.framework == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Null reference to channel framework, using factory");
            }
            this.framework = (WSChannelFrameworkImpl)ChannelFrameworkFactory.getChannelFramework();
        }
        if (this.outboundChainData == null) {
            this.outboundChainData = (WSChainData)this.framework.createOutboundChain(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createOutboundChain");
        }
        return this.outboundChainData;
    }

    @Override
    public WSVirtualConnectionFactory getOutboundVCFactory(Map sslProps, boolean overwriteExisting) throws IllegalStateException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getOutboundVCFactory(ssl)");
        }
        Class factoryClass = null;
        OutboundChannelDefinition existingChannelDef = null;
        int index = 0;
        boolean foundSslChannel = false;
        for (index = 0; index < this.outboundChannelDefs.length; ++index) {
            existingChannelDef = this.outboundChannelDefs[index];
            factoryClass = this.outboundChannelDefs[index].getOutboundFactory();
            if (!SSLChannelFactory.class.isAssignableFrom(factoryClass)) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Found class implementing SSLChannelFactory inteface: " + factoryClass);
            }
            foundSslChannel = true;
            break;
        }
        if (!foundSslChannel) {
            throw new IllegalStateException("The SSL channel factory does not exist in this CFEndPoint.");
        }
        OutboundChannelDefinitionImpl newChannelDef = new OutboundChannelDefinitionImpl(existingChannelDef, sslProps, overwriteExisting);
        this.outboundChannelDefs[index] = newChannelDef;
        WSVirtualConnectionFactory localVCF = this.getOutboundVCFactory();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getOutboundVCFactory(ssl)");
        }
        return localVCF;
    }

    @Override
    public WSVirtualConnectionFactory getOutboundVCFactory() {
        OutboundVirtualConnectionFactoryImpl outboundVCF;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getOutboundVCFactory");
        }
        if (this.vcf != null && (outboundVCF = (OutboundVirtualConnectionFactoryImpl)((Object)this.vcf)).getRefCount() == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Found destroyed vcf, nulling it out to build another");
            }
            this.vcf = null;
        }
        if (this.vcf == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Existing vcf not available.  Build one.");
            }
            if (this.outboundChainData != null) {
                try {
                    this.vcf = (WSVirtualConnectionFactory)this.framework.getOutboundVCFactory(this.outboundChainData.getName());
                }
                catch (Exception e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Caught exception while getting VCFactory: " + e);
                    }
                    this.vcf = null;
                }
            } else if (this.framework != null) {
                try {
                    this.framework.prepareEndPoint(this);
                }
                catch (ChannelException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Caught exception while preparing CFEndPoint: " + e);
                    }
                    this.vcf = null;
                }
                catch (ChainException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Caught exception while preparing CFEndPoint: " + e);
                    }
                    this.vcf = null;
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Framework is not available.  prePareEndPoint or determineBestEndPoint should have been called.");
                }
                this.vcf = null;
            }
        } else {
            outboundVCF = (OutboundVirtualConnectionFactoryImpl)((Object)this.vcf);
            outboundVCF.incrementRefCount();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Found an existing VCF, updating the ref count to " + outboundVCF.getRefCount());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getOutboundVCFactory");
        }
        return this.vcf;
    }

    @Override
    public void setOutboundVCFactory(WSVirtualConnectionFactory inputVCF) {
        this.vcf = inputVCF;
    }

    @Override
    public String serializeToXML() throws NotSerializableException {
        return CFEndPointSerializer.serialize(this);
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("CFEndPoint: name = ");
        sb.append(this.getName());
        sb.append("\n\tvhost = ");
        sb.append(this.vhost);
        sb.append("\n\tvhostArray = ");
        if (this.vhostArray == null) {
            sb.append("null");
        } else {
            for (i = 0; i < this.vhostArray.length; ++i) {
                sb.append("\n\t\t" + this.vhostArray[i]);
            }
        }
        sb.append("\n\tport = ");
        sb.append(this.getPort());
        sb.append("\n\taddress = ");
        sb.append(this.getAddress());
        sb.append("\n\taccessor = ");
        sb.append(this.getChannelAccessor());
        sb.append("\n\tvcf = ");
        sb.append(this.vcf);
        sb.append("\n\tisSSLEnabled = ");
        sb.append(this.isSSLEnabled());
        sb.append("\n\tisLocal = ");
        sb.append(this.isLocal());
        sb.append("\n\tChannels: ");
        if (this.outboundChannelDefs != null) {
            for (i = 0; i < this.outboundChannelDefs.length; ++i) {
                sb.append("\n");
                sb.append(OutboundChannelDefinitionImpl.toString(this.outboundChannelDefs[i]));
            }
        } else {
            sb.append("null");
        }
        return sb.toString();
    }
}

