/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.buffermgmt.impl;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.ws.buffermgmt.impl.WsByteBufferImpl;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class FCWsByteBufferImpl
extends WsByteBufferImpl {
    private static final long serialVersionUID = 4029999822511452951L;
    private static final String CLASS_NAME = "com.ibm.ws.buffermgmt.impl.FCWsByteBufferImpl";
    private int status = 0;
    private int fcLimit = 0;
    private int fcSize = 0;
    private FileChannel fc;
    private static final TraceComponent tc = Tr.register(FCWsByteBufferImpl.class, "WsByteBuffer", "com.ibm.ws.buffermgmt.resources.wsbytebuffermessages");

    public FCWsByteBufferImpl(FileChannel fileChannel) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "FCWsByteBufferImpl(FileChannel) constructing new FCWsByteBufferImpl");
        }
        this.fc = fileChannel;
        this.status = 2;
        try {
            this.fcSize = this.fcLimit = (int)this.fc.size();
        }
        catch (IOException iOException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "got unexpected IOException in FCWsByteBufferImpl.  exception: \n" + iOException);
            }
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.buffermgmt.impl.FCWsByteBufferImpl.FCWsByteBufferImpl(FileChannel)", "57", this);
            RuntimeException runtimeException = new RuntimeException(iOException);
            throw runtimeException;
        }
        this.oByteBuffer = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "FCWsByteBufferImpl(FileChannel) size: " + this.fcSize + "  limit: " + this.fcLimit);
        }
    }

    public int getType() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getType() returning: 1");
        }
        return 1;
    }

    public int getStatus() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getStatus() returning: " + this.status);
        }
        return this.status;
    }

    public void setStatus(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setStatus(int) setting status to: " + n);
        }
        if (n == 1) {
            this.convertBufferIfNeeded();
        }
        this.status = n;
    }

    public FileChannel getFileChannel() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getFileChannel() returning fc: " + this.fc);
        }
        return this.fc;
    }

    private void convertBufferIfNeeded() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "convertBufferIfNeeded status: " + this.status);
        }
        if ((this.status | 2) != 0) {
            this.status &= 0xFFFFFFFD;
            this.status |= 1;
            try {
                int n = (int)this.fc.position();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "creating a MappedByteBuffer from the FileChannel. position: 0  size: " + this.fc.size());
                }
                this.oByteBuffer = this.fc.map(FileChannel.MapMode.PRIVATE, 0L, this.fc.size());
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "set MappedByteBuffer position to: " + n + " limit to: " + this.fcLimit);
                }
                this.position(n);
                this.limit(this.fcLimit);
            }
            catch (IOException iOException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "got unexpected IOException in convertBufferIfNeeded: exception: " + iOException);
                }
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.buffermgmt.impl.FCWsByteBufferImpl.convertBufferIfNeeded", "112", this);
                RuntimeException runtimeException = new RuntimeException(iOException);
                throw runtimeException;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "convertBufferIfNeeded status: " + this.status);
        }
    }

    public byte[] array() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "array() status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.array();
    }

    public int arrayOffset() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "arrayOffset()  status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.arrayOffset();
    }

    public int capacity() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "capacity()  status: " + this.status);
        }
        if ((this.status & 2) != 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "FileChannel returning a capacity of: " + this.fcSize);
            }
            return this.fcSize;
        }
        return super.capacity();
    }

    public WsByteBuffer clear() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "clear()  status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.clear();
    }

    public WsByteBuffer compact() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "compact()  status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.compact();
    }

    public int compareTo(Object object) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "compareTo(Object ob)  status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.compareTo(((WsByteBuffer)object).getWrappedByteBufferNonSafe());
    }

    public WsByteBuffer duplicate() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "duplicate()");
        }
        this.convertBufferIfNeeded();
        return super.duplicate();
    }

    public WsByteBuffer flip() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "flip()");
        }
        this.convertBufferIfNeeded();
        return super.flip();
    }

    public byte get() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "get() status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.get();
    }

    public WsByteBuffer get(byte[] byArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "get(byte[]) status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.get(byArray);
    }

    public WsByteBuffer get(byte[] byArray, int n, int n2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "get(byte[] dst, int offset, int length) status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.get(byArray, n, n2);
    }

    public byte get(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "get(int) status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.get(n);
    }

    public char getChar() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getChar()  status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.getChar();
    }

    public char getChar(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getChar(int)  status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.getChar(n);
    }

    public double getDouble() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getDouble()  status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.getDouble();
    }

    public double getDouble(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getDouble(int)  status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.getDouble(n);
    }

    public float getFloat() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getFloat()  status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.getFloat();
    }

    public float getFloat(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getFloat(int)  status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.getFloat(n);
    }

    public int getInt() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getInt()  status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.getInt();
    }

    public int getInt(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getInt(int)  status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.getInt(n);
    }

    public long getLong() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getLong()  status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.getLong();
    }

    public long getLong(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getLong(index)  status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.getLong(n);
    }

    public short getShort() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getShort()  status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.getShort();
    }

    public short getShort(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getShort(int)  status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.getShort(n);
    }

    public ByteBuffer getWrappedByteBuffer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getWrappedByteBuffer()  status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.getWrappedByteBuffer();
    }

    public ByteBuffer getWrappedByteBufferNonSafe() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getWrappedByteBuffer()  status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.getWrappedByteBufferNonSafe();
    }

    public boolean hasArray() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "hasArray()  status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.hasArray();
    }

    public boolean hasRemaining() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "hasRemaining()  status: " + this.status);
        }
        if ((this.status & 2) != 0) {
            int n = 0;
            try {
                n = (int)this.fc.position();
            }
            catch (IOException iOException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "got unexpected IOException in FCWsByteBuffer.hasRemaining(): exception: " + iOException);
                }
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.buffermgmt.impl.FCWsByteBufferImpl.hasRemaining()", "1104", this);
                RuntimeException runtimeException = new RuntimeException(iOException);
                throw runtimeException;
            }
            int n2 = this.fcLimit - n;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "remaining:" + n2);
            }
            if (n2 < 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "remaining is less that 0");
                }
                RuntimeException runtimeException = new RuntimeException("FCWsByteBufferImpl.hasRemaining(): value is less than 0");
                FFDCFilter.processException((Throwable)runtimeException, "com.ibm.ws.buffermgmt.impl.FCWsByteBufferImpl.hasRemaining()", "1115", this);
                throw runtimeException;
            }
            if (n2 > 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "hasRemaining() returning true");
                }
                return true;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "hasRemaining() returning false");
            }
            return false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "super.hasRemaining()");
        }
        return super.hasRemaining();
    }

    public boolean isDirect() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isDirect()  status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.isDirect();
    }

    public boolean isReadOnly() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isReadOnly()  status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.isReadOnly();
    }

    public int limit() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "limit()  status: " + this.status);
        }
        if ((this.status & 2) != 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "limit()  returning a FCWsByteBufferImpl limit of: " + this.fcLimit);
            }
            return this.fcLimit;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "limit()  returning super.limit()");
        }
        return super.limit();
    }

    public WsByteBuffer limit(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "limit(int)  status: " + this.status);
        }
        if ((this.status & 2) != 0) {
            String string = null;
            if (n > this.fcSize) {
                string = "Requested value for the WsByteBuffer limit was greater than the capacity";
            }
            if (n < 0) {
                string = "Requested value for the WsByteBuffer limit was less than 0";
            }
            if (string != null) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, string);
                }
                FFDCFilter.processException((Throwable)illegalArgumentException, "com.ibm.ws.buffermgmt.impl.FCWsByteBufferImpl.limit(int)", "625", this);
                throw illegalArgumentException;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "limit(int)  setting a FCWsByteBufferImpl limit of: " + n);
            }
            this.fcLimit = n;
            return this;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "limit(int)  returning super.limit(newLimit)");
        }
        return super.limit(n);
    }

    public WsByteBuffer mark() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "mark()  status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.mark();
    }

    public ByteOrder order() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "order()  status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.order();
    }

    public WsByteBuffer order(ByteOrder byteOrder) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "order(ByteOrder)  status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.order(byteOrder);
    }

    public int position() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "position()  status: " + this.status);
        }
        if ((this.status & 2) != 0) {
            int n = -1;
            try {
                n = (int)this.fc.position();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "position()  returning a FileChannel position of: " + n);
                }
                return n;
            }
            catch (IOException iOException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "got unexpected IOException in FCWsByteBuffer.postion(): exception: " + iOException);
                }
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.buffermgmt.impl.FCWsByteBufferImpl.position", "656", this);
                RuntimeException runtimeException = new RuntimeException(iOException);
                throw runtimeException;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "position()  returning super.position() ");
        }
        return super.position();
    }

    public WsByteBuffer position(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "position(int)  status: " + this.status);
        }
        if ((this.status & 2) != 0) {
            try {
                long l = new Long(n);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "setting a FileChannel position of: " + l);
                }
                this.fc.position(l);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "position(int)  position(int p) ");
                }
                return this;
            }
            catch (IOException iOException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "got unexpected IOException in FCWsByteBuffer.postion(int): exception: " + iOException);
                }
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.buffermgmt.impl.FCWsByteBufferImpl.position(int)", "687", this);
                RuntimeException runtimeException = new RuntimeException(iOException);
                throw runtimeException;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "position(int)  returning super.position(int p) ");
        }
        return super.position(n);
    }

    public WsByteBuffer put(byte by) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "put(byte) status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.put(by);
    }

    public WsByteBuffer put(byte[] byArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "put(byte[]) status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.put(byArray);
    }

    public WsByteBuffer put(byte[] byArray, int n, int n2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "put(byte[] src, int offset, int length) status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.put(byArray, n, n2);
    }

    public WsByteBuffer put(ByteBuffer byteBuffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "put(src) status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.put(byteBuffer);
    }

    public WsByteBuffer put(int n, byte by) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "put(int, byte) status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.put(n, by);
    }

    public WsByteBuffer put(WsByteBuffer wsByteBuffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "put(WsByteBuffer) status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.put(wsByteBuffer);
    }

    public WsByteBuffer put(WsByteBuffer[] wsByteBufferArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "put(WsByteBuffer[]) status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.put(wsByteBufferArray);
    }

    public WsByteBuffer putChar(char c) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "put(char) status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.putChar(c);
    }

    public WsByteBuffer putChar(char[] cArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "put(char[]) status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.putChar(cArray);
    }

    public WsByteBuffer putChar(char[] cArray, int n, int n2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "put(char[],int,int) status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.putChar(cArray, n, n2);
    }

    public WsByteBuffer putChar(int n, char c) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "putChar(int, char) status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.putChar(n, c);
    }

    public WsByteBuffer putDouble(double d) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "putDouble(double) status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.putDouble(d);
    }

    public WsByteBuffer putDouble(int n, double d) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "putDouble(int, double) status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.putDouble(n, d);
    }

    public WsByteBuffer putFloat(float f) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "putFloat(float) status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.putFloat(f);
    }

    public WsByteBuffer putFloat(int n, float f) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "putFloat(int, float) status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.putFloat(n, f);
    }

    public WsByteBuffer putInt(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "putInt(int) status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.putInt(n);
    }

    public WsByteBuffer putInt(int n, int n2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "putInt(int, int) status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.putInt(n, n2);
    }

    public WsByteBuffer putLong(int n, long l) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "putLong(int, long) status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.putLong(n, l);
    }

    public WsByteBuffer putLong(long l) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "putLong(long) status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.putLong(l);
    }

    public WsByteBuffer putShort(int n, short s) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "putShort(int, short) status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.putShort(n, s);
    }

    public WsByteBuffer putShort(short s) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "putShort(short) status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.putShort(s);
    }

    public WsByteBuffer putString(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "putString(String) status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.putString(string);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "readExternal(ObjectInput) status: " + this.status);
        }
        this.convertBufferIfNeeded();
        super.readExternal(objectInput);
    }

    public void release() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "release() status: " + this.status);
        }
        super.release();
    }

    public int remaining() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "remaining()  status: " + this.status);
        }
        if ((this.status & 2) != 0) {
            int n = 0;
            try {
                n = (int)this.fc.position();
            }
            catch (IOException iOException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "got unexpected IOException in FCWsByteBuffer.remaining(): exception: " + iOException);
                }
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.buffermgmt.impl.FCWsByteBufferImpl.remaining()", "1104", this);
                RuntimeException runtimeException = new RuntimeException(iOException);
                throw runtimeException;
            }
            int n2 = this.fcLimit - n;
            if (n2 < 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "remaining is less that 0");
                }
                RuntimeException runtimeException = new RuntimeException("FCWsByteBufferImpl.remaining(): value is less than 0");
                FFDCFilter.processException((Throwable)runtimeException, "com.ibm.ws.buffermgmt.impl.FCWsByteBufferImpl.remaining()", "1115", this);
                throw runtimeException;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "remaining()    returning a FCWsByteBufferImpl remaining of: " + n2);
            }
            return n2;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "remaining()   returning super.remaining() ");
        }
        return super.remaining();
    }

    public WsByteBuffer reset() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "reset() status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.reset();
    }

    public WsByteBuffer rewind() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "rewind() status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.rewind();
    }

    public void setByteBuffer(ByteBuffer byteBuffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setByteBuffer(ByteBuffer) status: " + this.status);
        }
        this.convertBufferIfNeeded();
        super.setByteBuffer(byteBuffer);
    }

    public void setByteBufferNonSafe(ByteBuffer byteBuffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setByteBufferNonSafe(ByteBuffer) status: " + this.status);
        }
        this.convertBufferIfNeeded();
        super.setByteBufferNonSafe(byteBuffer);
    }

    public void setDirectShadowBuffer(ByteBuffer byteBuffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setDirectShadowBuffer(ByteBuffer)  status: " + this.status);
        }
        this.convertBufferIfNeeded();
        super.setDirectShadowBuffer(byteBuffer);
    }

    public WsByteBuffer slice() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "slice()   status: " + this.status);
        }
        this.convertBufferIfNeeded();
        return super.slice();
    }

    public String toString() {
        if ((this.status & 2) != 0) {
            String string = null;
            if (this.fc == null) {
                string = "FileChannel: null";
            } else {
                string = this.fc.toString();
                try {
                    String string2 = " position: " + this.fc.position() + " limit: " + this.fcLimit + " size: " + this.fcSize;
                    string = string.concat(string2);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            string = string.concat(" status: " + this.status);
            return string;
        }
        return super.toString();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "writeExternal(ObjectOutput)   status: " + this.status);
        }
        this.convertBufferIfNeeded();
        super.writeExternal(objectOutput);
    }
}

