/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security.auth;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.SyncToOSThreadHelper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessControlContext;
import java.security.GeneralSecurityException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;

public final class WSSubject {
    private static final TraceComponent tc = Tr.register(WSSubject.class, null, "com.ibm.ejs.resources.security");
    private static final SyncToOSThreadHelper syncHelper = new SyncToOSThreadHelper();
    private static final Class thisClass = WSSubject.class;
    private static final AuthPermission DOAS_PERM = new AuthPermission("doAs");
    private static final AuthPermission DOASPRIVILEGED_PERM = new AuthPermission("doAsPrivileged");
    private static final AuthPermission GETCALLERSUBJECT_PERM = new AuthPermission("wssecurity.getCallerSubject");
    private static final AuthPermission GETRUNASSUBJECT_PERM = new AuthPermission("wssecurity.getRunAsSubject");
    private static final AuthPermission SETRUNASSUBJECT_PERM = new AuthPermission("wssecurity.setRunAsSubject");
    private static final PrivilegedExceptionAction getCallerSubjectAction = new PrivilegedExceptionAction(){

        public Object run() throws WSSecurityException {
            ContextManager ctxMgr;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "WSSubject.getCallerSubjectAction.run");
            }
            if ((ctxMgr = ContextManagerFactory.getInstance()) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to get ContextManager");
                }
                throw new WSSecurityException("Failed to get ContextManager");
            }
            Subject s = ctxMgr.getCallerSubject();
            if (s != null) {
                s.setReadOnly();
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No caller subject");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "WSSubject.getCallerSubjectAction.run");
            }
            return s;
        }
    };
    private static final PrivilegedExceptionAction getRunAsSubjectAction = new PrivilegedExceptionAction(){

        public Object run() throws WSSecurityException {
            ContextManager ctxMgr;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "WSSubject.getRunAsSubjectAction.run");
            }
            if ((ctxMgr = ContextManagerFactory.getInstance()) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to get ContextManager");
                }
                throw new WSSecurityException("Failed to get ContextManager");
            }
            Subject s = ctxMgr.getInvocationSubject();
            if (s != null) {
                s.setReadOnly();
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No invocation credential");
            }
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "WSSubject.getRunAsSubjectAction.run");
            }
            return s;
        }
    };

    public static Object doAs(Subject subject, PrivilegedAction action) {
        return WSSubject.doAs(subject, action, false);
    }

    public static Object doAs(Subject subject, PrivilegedAction action, boolean setCaller) {
        SecurityManager securitymanager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doAs", new Object[]{subject, action});
        }
        if ((securitymanager = System.getSecurityManager()) != null) {
            securitymanager.checkPermission(DOAS_PERM);
        }
        if (action == null) {
            throw new IllegalArgumentException("null PrivilegedAction provided");
        }
        SubjectCookie callerCookie = null;
        SubjectCookie cookie = WSSubject.setInvocationSubject(subject);
        if (setCaller) {
            callerCookie = WSSubject.setCallerSubject(subject);
        }
        try {
            Object t = Subject.doAs(subject, action);
            return t;
        }
        catch (Throwable t) {
            Tr.event(tc, "WSSubject.doAs(Subject, PrivilegedAction) Exception caught " + WSSubject.dump(t));
            Manager.Ffdc.log(t, thisClass, "com.ibm.websphere.security.auth.WSSubject.doAs", "131");
            throw new RuntimeException(t);
        }
        finally {
            WSSubject.restoreInvocationSubject(cookie);
            if (setCaller) {
                WSSubject.restoreCallerSubject(callerCookie);
            }
        }
    }

    public static Object doAs(Subject subject, PrivilegedExceptionAction action) throws PrivilegedActionException {
        return WSSubject.doAs(subject, action, false);
    }

    public static Object doAs(Subject subject, PrivilegedExceptionAction action, boolean setCaller) throws PrivilegedActionException {
        SecurityManager securitymanager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doAs", new Object[]{subject, action});
        }
        if ((securitymanager = System.getSecurityManager()) != null) {
            securitymanager.checkPermission(DOAS_PERM);
        }
        if (action == null) {
            throw new IllegalArgumentException("null PrivilegedExceptionAction provided");
        }
        SubjectCookie callerCookie = null;
        SubjectCookie cookie = WSSubject.setInvocationSubject(subject);
        if (setCaller) {
            callerCookie = WSSubject.setCallerSubject(subject);
        }
        try {
            Object t = Subject.doAs(subject, action);
            return t;
        }
        catch (PrivilegedActionException pae) {
            throw pae;
        }
        catch (Throwable t) {
            Tr.event(tc, "WSSubject.doAs(Subject, PrivilegedExceptionAction) Exception caught " + WSSubject.dump(t));
            Manager.Ffdc.log(t, thisClass, "com.ibm.websphere.security.auth.WSSubject.doAs", "198");
            throw new RuntimeException(t);
        }
        finally {
            WSSubject.restoreInvocationSubject(cookie);
            if (setCaller) {
                WSSubject.restoreCallerSubject(callerCookie);
            }
        }
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedAction action, AccessControlContext acc) {
        return WSSubject.doAsPrivileged(subject, action, acc, false);
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedAction action, AccessControlContext acc, boolean setCaller) {
        SecurityManager securitymanager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doAsPrivileged", new Object[]{subject, action, acc});
        }
        if ((securitymanager = System.getSecurityManager()) != null) {
            securitymanager.checkPermission(DOASPRIVILEGED_PERM);
        }
        if (action == null) {
            throw new IllegalArgumentException("null PrivilegedAction provided");
        }
        SubjectCookie callerCookie = null;
        SubjectCookie cookie = WSSubject.setInvocationSubject(subject);
        if (setCaller) {
            callerCookie = WSSubject.setCallerSubject(subject);
        }
        try {
            Object t = Subject.doAsPrivileged(subject, action, acc);
            return t;
        }
        catch (Throwable t) {
            Tr.event(tc, "WSSubject.doAsPrivileged(Subject, PrivilegedAction, AccessControlContext) Exception caught " + WSSubject.dump(t));
            Manager.Ffdc.log(t, thisClass, "com.ibm.websphere.security.auth.WSSubject.doAsPrivileged", "265");
            throw new RuntimeException(t);
        }
        finally {
            WSSubject.restoreInvocationSubject(cookie);
            if (setCaller) {
                WSSubject.restoreCallerSubject(callerCookie);
            }
        }
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedExceptionAction action, AccessControlContext acc) throws PrivilegedActionException {
        return WSSubject.doAsPrivileged(subject, action, acc, false);
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedExceptionAction action, AccessControlContext acc, boolean setCaller) throws PrivilegedActionException {
        SecurityManager securitymanager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doAsPrivileged", new Object[]{subject, action, acc});
        }
        if ((securitymanager = System.getSecurityManager()) != null) {
            securitymanager.checkPermission(DOASPRIVILEGED_PERM);
        }
        if (action == null) {
            throw new IllegalArgumentException("null PrivilegedExceptionAction provided");
        }
        SubjectCookie callerCookie = null;
        SubjectCookie cookie = WSSubject.setInvocationSubject(subject);
        if (setCaller) {
            callerCookie = WSSubject.setCallerSubject(subject);
        }
        try {
            Object t = Subject.doAsPrivileged(subject, action, acc);
            return t;
        }
        catch (PrivilegedActionException pae) {
            throw pae;
        }
        catch (Throwable t) {
            Tr.event(tc, "WSSubject.doAsPrivileged(Subject, PrivilegedExceptionAction, AccessControlContext) Exception caught " + WSSubject.dump(t));
            Manager.Ffdc.log(t, thisClass, "com.ibm.websphere.security.auth.WSSubject.doAsPrivileged", "338");
            throw new RuntimeException(t);
        }
        finally {
            WSSubject.restoreInvocationSubject(cookie);
            if (setCaller) {
                WSSubject.restoreCallerSubject(callerCookie);
            }
        }
    }

    public static Subject getCallerSubject() throws WSSecurityException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCallerSubject");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(GETCALLERSUBJECT_PERM);
        }
        Subject s = null;
        if (SecurityContext.isServerProcess()) {
            try {
                s = (Subject)AccessController.doPrivileged(getCallerSubjectAction);
            }
            catch (PrivilegedActionException pae) {
                WSSecurityException e = (WSSecurityException)pae.getException();
                Tr.event(tc, "Failed in getting the caller identity: " + WSSubject.dump(e));
                Manager.Ffdc.log(e, thisClass, "com.ibm.websphere.security.auth.WSSubject.getCallerSubject", "406");
                throw e;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCallerSubject", s);
        }
        return s;
    }

    public static Subject getRunAsSubject() throws WSSecurityException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRunAsSubject");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(GETRUNASSUBJECT_PERM);
        }
        Subject s = null;
        try {
            s = (Subject)AccessController.doPrivileged(getRunAsSubjectAction);
        }
        catch (PrivilegedActionException pae) {
            WSSecurityException e = (WSSecurityException)pae.getException();
            Tr.event(tc, "Failed in getting the run as identity: " + WSSubject.dump(e));
            Manager.Ffdc.log(e, thisClass, "com.ibm.websphere.security.auth.WSSubject.getRunAsSubject", "464");
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRunAsSubject", s);
        }
        return s;
    }

    public static void setRunAsSubject(final Subject subject) throws WSSecurityException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setRunAsSubject", subject);
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(SETRUNASSUBJECT_PERM);
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws WSSecurityException {
                    ContextManager ctxMgr = ContextManagerFactory.getInstance();
                    ctxMgr.setInvocationSubject(subject);
                    ctxMgr.addWSSubjectToCache(subject);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            WSSecurityException e = (WSSecurityException)pae.getException();
            Tr.event(tc, "Failed in setting the run as identity: " + WSSubject.dump(e));
            Manager.Ffdc.log(e, thisClass, "com.ibm.websphere.security.auth.WSSubject.setRunAsSubject", "515");
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setRunAsSubject");
        }
    }

    public static String getCallerPrincipal() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCallerPrincipal");
        }
        String caller = null;
        try {
            WSCredential wsCred;
            Subject subject = ContextManagerFactory.getInstance().getCallerSubject();
            if (subject != null && (wsCred = SubjectHelper.getWSCredentialFromSubject((Subject)subject)) != null && !wsCred.isUnauthenticated()) {
                caller = wsCred.getSecurityName();
            }
        }
        catch (GeneralSecurityException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception of getting the caller principal", WSSubject.dump(e));
            }
            Manager.Ffdc.log(e, thisClass, "com.ibm.websphere.security.auth.WSSubject.getCallerPrincipal", "567");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCallerPrincipal", caller);
        }
        return caller;
    }

    public static Throwable getRootLoginException() {
        return ContextManagerFactory.getInstance().getRootException();
    }

    private static SubjectCookie setInvocationSubject(Subject s) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setInvocationSubject", s);
        }
        SubjectCookie cookie = new SubjectCookie();
        try {
            if (s == null) {
                s = SubjectHelper.createUnauthenticatedSubject();
            }
            cookie.subject = ContextManagerFactory.getInstance().pushInvocationSubject(s);
            cookie.syncEnabled = syncHelper.isThreadLocalApplicationSyncEnabled();
            if (syncHelper.isCurrentComponentAppSyncEnabled()) {
                cookie.credToken = syncHelper.setAppSyncToThread(s);
                syncHelper.setThreadLocalApplicationSyncEnabled(true);
            }
        }
        catch (Throwable t) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSSubject.setInvocationSubject(Subject), Exception caught " + WSSubject.dump(t));
            }
            Manager.Ffdc.log(t, thisClass, "com.ibm.websphere.security.auth.WSSubject.setInvocationSubject", "649");
            WSSubject.restoreInvocationSubject(cookie);
            throw new RuntimeException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setInvocationSubject", cookie);
        }
        return cookie;
    }

    private static SubjectCookie setCallerSubject(Subject s) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCallerSubject", s);
        }
        SubjectCookie cookie = new SubjectCookie();
        try {
            if (s == null) {
                s = SubjectHelper.createUnauthenticatedSubject();
            }
            cookie.subject = ContextManagerFactory.getInstance().pushReceivedSubject(s);
        }
        catch (Throwable t) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSSubject.setCallerSubject(Subject), Exception caught " + WSSubject.dump(t));
            }
            Manager.Ffdc.log(t, thisClass, "com.ibm.websphere.security.auth.WSSubject.setCallerSubject", "675");
            WSSubject.restoreCallerSubject(cookie);
            throw new RuntimeException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCallerSubject", cookie);
        }
        return cookie;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void restoreInvocationSubject(SubjectCookie cookie) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restoreInvocationSubject", cookie);
        }
        try {
            try {
                if (syncHelper.isCurrentComponentAppSyncEnabled()) {
                    syncHelper.setThreadLocalApplicationSyncEnabled(cookie.syncEnabled);
                    syncHelper.restoreAppSyncToThread(cookie.credToken);
                }
            }
            finally {
                ContextManagerFactory.getInstance().popInvocationSubject(cookie.subject);
            }
        }
        catch (Throwable t) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSSubject.restoreInvocationSubject(Subject) Exception caught " + WSSubject.dump(t));
            }
            Manager.Ffdc.log(t, thisClass, "com.ibm.websphere.security.auth.WSSubject.restoreInvocationSubject", "710");
            throw new RuntimeException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "restoreInvocationSubject");
        }
    }

    private static void restoreCallerSubject(SubjectCookie cookie) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restoreCallerSubject", cookie);
        }
        try {
            ContextManagerFactory.getInstance().popReceivedSubject(cookie.subject);
        }
        catch (Throwable t) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSSubject.restoreCallerSubject(Subject) Exception caught " + WSSubject.dump(t));
            }
            Manager.Ffdc.log(t, thisClass, "com.ibm.websphere.security.auth.WSSubject.restoreCallerSubject", "727");
            throw new RuntimeException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "restoreCallerSubject");
        }
    }

    private static String dump(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    private WSSubject() {
    }

    private static final class SubjectCookie {
        boolean syncEnabled = false;
        Subject subject = null;
        Object credToken = null;

        SubjectCookie() {
        }

        public String toString() {
            return super.toString() + ";syncEnabled=" + this.syncEnabled + ",credToken=" + this.credToken + ",subject=" + this.subject;
        }
    }
}

