/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.CertificateMapFailedException;
import com.ibm.websphere.security.CertificateMapNotSupportedException;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.NotImplementedException;
import com.ibm.websphere.security.PasswordCheckFailedException;
import com.ibm.websphere.security.RegExpSample;
import com.ibm.websphere.security.Result;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.cred.WSCredential;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.rmi.RemoteException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class FileRegistrySample
implements UserRegistry {
    private static String USERFILENAME = null;
    private static String GROUPFILENAME = null;
    private static final TraceComponent tc = Tr.register(FileRegistrySample.class, null, "com.ibm.ejs.resources.security");

    public void initialize(Properties props) throws CustomRegistryException {
        try {
            if (props != null) {
                USERFILENAME = props.getProperty("usersFile");
                GROUPFILENAME = props.getProperty("groupsFile");
            }
        }
        catch (Exception ex) {
            throw new CustomRegistryException(ex.getMessage(), (Throwable)ex);
        }
        if (USERFILENAME == null || GROUPFILENAME == null) {
            throw new CustomRegistryException("users/groups information missing");
        }
    }

    public String checkPassword(String userSecurityName, String passwd) throws PasswordCheckFailedException, CustomRegistryException {
        String userName = null;
        BufferedReader in = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkPassword with ID: " + userSecurityName + "\n using file: " + USERFILENAME);
        }
        try {
            String s;
            in = this.fileOpen(USERFILENAME);
            while ((s = in.readLine()) != null) {
                if (s.startsWith("#") || s.trim().length() <= 0) continue;
                int index = s.indexOf(":");
                int index1 = s.indexOf(":", index + 1);
                if (!s.substring(0, index).equals(userSecurityName) || !s.substring(index + 1, index1).equals(passwd)) continue;
                userName = userSecurityName;
                break;
            }
        }
        catch (Exception ex) {
            throw new CustomRegistryException(ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.fileClose(in);
        }
        if (userName == null) {
            throw new PasswordCheckFailedException("Password check failed for user: " + userSecurityName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkPassword with ID: " + userName);
        }
        return userName;
    }

    public String mapCertificate(X509Certificate[] cert) throws CertificateMapNotSupportedException, CertificateMapFailedException, CustomRegistryException {
        String name2 = null;
        X509Certificate cert1 = cert[0];
        try {
            name2 = cert1.getSubjectDN().getName();
        }
        catch (Exception ex) {
            throw new CertificateMapNotSupportedException(ex.getMessage(), (Throwable)ex);
        }
        if (!this.isValidUser(name2)) {
            throw new CertificateMapFailedException("user: " + name2 + " is not valid");
        }
        return name2;
    }

    public String getRealm() throws CustomRegistryException {
        String name2 = "customRealm";
        return name2;
    }

    public Result getUsers(String pattern, int limit) throws CustomRegistryException {
        BufferedReader in = null;
        ArrayList<String> allUsers = new ArrayList<String>();
        Result result = new Result();
        int count = 0;
        int newLimit = limit + 1;
        try {
            String s;
            in = this.fileOpen(USERFILENAME);
            while ((s = in.readLine()) != null) {
                int index;
                String user;
                if (s.startsWith("#") || s.trim().length() <= 0 || !this.match(user = s.substring(0, index = s.indexOf(":")), pattern)) continue;
                allUsers.add(user);
                if (limit == 0 || ++count != newLimit) continue;
                allUsers.remove(user);
                result.setHasMore();
                break;
            }
        }
        catch (Exception ex) {
            throw new CustomRegistryException(ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.fileClose(in);
        }
        result.setList(allUsers);
        return result;
    }

    public String getUserDisplayName(String userSecurityName) throws CustomRegistryException, EntryNotFoundException {
        String displayName = null;
        BufferedReader in = null;
        if (!this.isValidUser(userSecurityName)) {
            EntryNotFoundException nsee = new EntryNotFoundException("user: " + userSecurityName + " is not valid");
            throw nsee;
        }
        try {
            String s;
            in = this.fileOpen(USERFILENAME);
            while ((s = in.readLine()) != null) {
                if (s.startsWith("#") || s.trim().length() <= 0) continue;
                int index = s.indexOf(":");
                int index1 = s.lastIndexOf(":");
                if (!s.substring(0, index).equals(userSecurityName)) continue;
                displayName = s.substring(index1 + 1);
                break;
            }
        }
        catch (Exception ex) {
            throw new CustomRegistryException(ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.fileClose(in);
        }
        return displayName;
    }

    public String getUniqueUserId(String userSecurityName) throws CustomRegistryException, EntryNotFoundException {
        String uniqueUsrId = null;
        BufferedReader in = null;
        try {
            String s;
            in = this.fileOpen(USERFILENAME);
            while ((s = in.readLine()) != null) {
                if (s.startsWith("#") || s.trim().length() <= 0) continue;
                int index = s.indexOf(":");
                int index1 = s.indexOf(":", index + 1);
                if (!s.substring(0, index).equals(userSecurityName)) continue;
                int index2 = s.indexOf(":", index1 + 1);
                uniqueUsrId = s.substring(index1 + 1, index2);
                break;
            }
        }
        catch (Exception ex) {
            throw new CustomRegistryException(ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.fileClose(in);
        }
        if (uniqueUsrId == null) {
            EntryNotFoundException nsee = new EntryNotFoundException("Cannot obtain uniqueId for user: " + userSecurityName);
            throw nsee;
        }
        return uniqueUsrId;
    }

    public String getUserSecurityName(String uniqueUserId) throws CustomRegistryException, EntryNotFoundException {
        String usrSecName = null;
        BufferedReader in = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserSecurityName, with ID: " + uniqueUserId + "\n using file: " + USERFILENAME);
        }
        try {
            String s;
            in = this.fileOpen(USERFILENAME);
            while ((s = in.readLine()) != null) {
                int index2;
                int index;
                int index1;
                if (s.startsWith("#") || s.trim().length() <= 0 || !s.substring((index1 = s.indexOf(":", (index = s.indexOf(":")) + 1)) + 1, index2 = s.indexOf(":", index1 + 1)).equals(uniqueUserId)) continue;
                usrSecName = s.substring(0, index);
                break;
            }
        }
        catch (Exception ex) {
            throw new CustomRegistryException(ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.fileClose(in);
        }
        if (usrSecName == null) {
            EntryNotFoundException ex = new EntryNotFoundException("Cannot obtain the user securityName for " + uniqueUserId);
            throw ex;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserSecurityName, with ID: " + usrSecName);
        }
        return usrSecName;
    }

    public boolean isValidUser(String userSecurityName) throws CustomRegistryException {
        boolean isValid = false;
        BufferedReader in = null;
        try {
            String s;
            in = this.fileOpen(USERFILENAME);
            while ((s = in.readLine()) != null) {
                int index;
                if (s.startsWith("#") || s.trim().length() <= 0 || !s.substring(0, index = s.indexOf(":")).equals(userSecurityName)) continue;
                isValid = true;
                break;
            }
        }
        catch (Exception ex) {
            throw new CustomRegistryException(ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.fileClose(in);
        }
        return isValid;
    }

    public Result getGroups(String pattern, int limit) throws CustomRegistryException {
        BufferedReader in = null;
        ArrayList<String> allGroups = new ArrayList<String>();
        Result result = new Result();
        int count = 0;
        int newLimit = limit + 1;
        try {
            String s;
            in = this.fileOpen(GROUPFILENAME);
            while ((s = in.readLine()) != null) {
                int index;
                String group;
                if (s.startsWith("#") || s.trim().length() <= 0 || !this.match(group = s.substring(0, index = s.indexOf(":")), pattern)) continue;
                allGroups.add(group);
                if (limit == 0 || ++count != newLimit) continue;
                allGroups.remove(group);
                result.setHasMore();
                break;
            }
        }
        catch (Exception ex) {
            throw new CustomRegistryException(ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.fileClose(in);
        }
        result.setList(allGroups);
        return result;
    }

    public String getGroupDisplayName(String groupSecurityName) throws CustomRegistryException, EntryNotFoundException {
        String displayName = null;
        BufferedReader in = null;
        if (!this.isValidGroup(groupSecurityName)) {
            EntryNotFoundException nsee = new EntryNotFoundException("group: " + groupSecurityName + " is not valid");
            throw nsee;
        }
        try {
            String s;
            in = this.fileOpen(GROUPFILENAME);
            while ((s = in.readLine()) != null) {
                if (s.startsWith("#") || s.trim().length() <= 0) continue;
                int index = s.indexOf(":");
                int index1 = s.lastIndexOf(":");
                if (!s.substring(0, index).equals(groupSecurityName)) continue;
                displayName = s.substring(index1 + 1);
                break;
            }
        }
        catch (Exception ex) {
            throw new CustomRegistryException(ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.fileClose(in);
        }
        return displayName;
    }

    public String getUniqueGroupId(String groupSecurityName) throws CustomRegistryException, EntryNotFoundException {
        String uniqueGrpId = null;
        BufferedReader in = null;
        try {
            String s;
            in = this.fileOpen(GROUPFILENAME);
            while ((s = in.readLine()) != null) {
                if (s.startsWith("#") || s.trim().length() <= 0) continue;
                int index = s.indexOf(":");
                int index1 = s.indexOf(":", index + 1);
                if (!s.substring(0, index).equals(groupSecurityName)) continue;
                uniqueGrpId = s.substring(index + 1, index1);
                break;
            }
        }
        catch (Exception ex) {
            throw new CustomRegistryException(ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.fileClose(in);
        }
        if (uniqueGrpId == null) {
            EntryNotFoundException nsee = new EntryNotFoundException("Cannot obtain the uniqueId for group: " + groupSecurityName);
            throw nsee;
        }
        return uniqueGrpId;
    }

    public List getUniqueGroupIds(String uniqueUserId) throws CustomRegistryException, EntryNotFoundException {
        Object uniqueGrpId = null;
        BufferedReader in = null;
        ArrayList<String> uniqueGrpIds = new ArrayList<String>();
        try {
            String s;
            in = this.fileOpen(USERFILENAME);
            while ((s = in.readLine()) != null) {
                int index2;
                int index;
                int index1;
                if (s.startsWith("#") || s.trim().length() <= 0 || !s.substring((index1 = s.indexOf(":", (index = s.indexOf(":")) + 1)) + 1, index2 = s.indexOf(":", index1 + 1)).equals(uniqueUserId)) continue;
                int lastIndex = s.lastIndexOf(":");
                String subs = s.substring(index2 + 1, lastIndex);
                StringTokenizer st1 = new StringTokenizer(subs, ",");
                while (st1.hasMoreTokens()) {
                    uniqueGrpIds.add(st1.nextToken());
                }
                break;
            }
        }
        catch (Exception ex) {
            throw new CustomRegistryException(ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.fileClose(in);
        }
        return uniqueGrpIds;
    }

    public String getGroupSecurityName(String uniqueGroupId) throws CustomRegistryException, EntryNotFoundException {
        String grpSecName = null;
        BufferedReader in = null;
        try {
            String s;
            in = this.fileOpen(GROUPFILENAME);
            while ((s = in.readLine()) != null) {
                int index1;
                int index;
                if (s.startsWith("#") || s.trim().length() <= 0 || !s.substring((index = s.indexOf(":")) + 1, index1 = s.indexOf(":", index + 1)).equals(uniqueGroupId)) continue;
                grpSecName = s.substring(0, index);
                break;
            }
        }
        catch (Exception ex) {
            throw new CustomRegistryException(ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.fileClose(in);
        }
        if (grpSecName == null) {
            EntryNotFoundException ex = new EntryNotFoundException("Cannot obtain the group security name for: " + uniqueGroupId);
            throw ex;
        }
        return grpSecName;
    }

    public boolean isValidGroup(String groupSecurityName) throws CustomRegistryException {
        boolean isValid = false;
        BufferedReader in = null;
        try {
            String s;
            in = this.fileOpen(GROUPFILENAME);
            while ((s = in.readLine()) != null) {
                int index;
                if (s.startsWith("#") || s.trim().length() <= 0 || !s.substring(0, index = s.indexOf(":")).equals(groupSecurityName)) continue;
                isValid = true;
                break;
            }
        }
        catch (Exception ex) {
            throw new CustomRegistryException(ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.fileClose(in);
        }
        return isValid;
    }

    public List getGroupsForUser(String userName) throws CustomRegistryException, EntryNotFoundException {
        ArrayList<String> grpsForUser = new ArrayList<String>();
        BufferedReader in = null;
        try {
            String s;
            in = this.fileOpen(GROUPFILENAME);
            while ((s = in.readLine()) != null) {
                if (s.startsWith("#") || s.trim().length() <= 0) continue;
                StringTokenizer st = new StringTokenizer(s, ":");
                for (int i = 0; i < 2; ++i) {
                    st.nextToken();
                }
                String subs = st.nextToken();
                StringTokenizer st1 = new StringTokenizer(subs, ",");
                while (st1.hasMoreTokens()) {
                    if (!st1.nextToken().equals(userName)) continue;
                    int index = s.indexOf(":");
                    grpsForUser.add(s.substring(0, index));
                }
            }
        }
        catch (Exception ex) {
            if (!this.isValidUser(userName)) {
                throw new EntryNotFoundException("user: " + userName + " is not valid");
            }
            throw new CustomRegistryException(ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.fileClose(in);
        }
        return grpsForUser;
    }

    public Result getUsersForGroup(String groupSecurityName, int limit) throws NotImplementedException, EntryNotFoundException, CustomRegistryException {
        BufferedReader in = null;
        ArrayList<String> usrsForGroup = new ArrayList<String>();
        int count = 0;
        int newLimit = limit + 1;
        Result result = new Result();
        try {
            String s;
            in = this.fileOpen(GROUPFILENAME);
            block5: while ((s = in.readLine()) != null) {
                int index;
                if (s.startsWith("#") || s.trim().length() <= 0 || !s.substring(0, index = s.indexOf(":")).equals(groupSecurityName)) continue;
                StringTokenizer st = new StringTokenizer(s, ":");
                for (int i = 0; i < 2; ++i) {
                    st.nextToken();
                }
                String subs = st.nextToken();
                StringTokenizer st1 = new StringTokenizer(subs, ",");
                while (st1.hasMoreTokens()) {
                    String user = st1.nextToken();
                    usrsForGroup.add(user);
                    if (limit == 0 || ++count != newLimit) continue;
                    usrsForGroup.remove(user);
                    result.setHasMore();
                    continue block5;
                }
            }
        }
        catch (Exception ex) {
            if (!this.isValidGroup(groupSecurityName)) {
                throw new EntryNotFoundException("group: " + groupSecurityName + " is not valid");
            }
            throw new CustomRegistryException(ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.fileClose(in);
        }
        result.setList(usrsForGroup);
        return result;
    }

    public WSCredential createCredential(String userSecurityName) throws CustomRegistryException, NotImplementedException, EntryNotFoundException {
        return null;
    }

    private BufferedReader fileOpen(String fileName) throws FileNotFoundException {
        return new BufferedReader(new FileReader(fileName));
    }

    private void fileClose(BufferedReader in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception e) {
            System.out.println("Error closing file" + e);
        }
    }

    private boolean match(String name2, String pattern) {
        RegExpSample regexp = new RegExpSample(pattern);
        boolean matches = false;
        if (regexp.match(name2)) {
            matches = true;
        }
        return matches;
    }
}

