/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.repository;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.repository.RemoteInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

public class RepositoryInputStream
extends RemoteInputStream
implements Serializable {
    private static final long serialVersionUID = 1984160752415086662L;
    private static TraceComponent tc = Tr.register(RepositoryInputStream.class, "Admin", "com.ibm.ws.management.resources.fileservice");
    protected String srcPath;
    protected File tempfile;
    protected transient InputStream remoteStream;

    public RepositoryInputStream() {
    }

    public RepositoryInputStream(File file) {
        this();
        this.tempfile = file;
    }

    public void setStream(InputStream stream) {
        this.remoteStream = stream;
    }

    public InputStream getStream() throws FileNotFoundException {
        if (this.remoteStream == null) {
            this.remoteStream = new FileInputStream(this.tempfile);
        }
        return this.remoteStream;
    }

    public String getSrcPath() {
        return this.srcPath;
    }

    public void setSrcPath(String srcPath) {
        this.srcPath = srcPath;
        this.srcPath = this.srcPath.replace('\\', '/');
    }

    public void connect() throws IOException {
    }

    public int read() throws IOException {
        try {
            return this.getStream().read();
        }
        catch (IOException e) {
            Manager.Ffdc.log(e, this, "com.ibm.websphere.management.filetransfer.client.FileDownloadInputStream.read", "218", this);
            Tr.service(tc, "ADFS0119", e);
            throw e;
        }
    }

    public int read(byte[] buf) throws IOException {
        try {
            return this.getStream().read(buf);
        }
        catch (IOException e) {
            Manager.Ffdc.log(e, this, "com.ibm.websphere.management.filetransfer.client.FileDownloadInputStream.read", "231", this);
            Tr.service(tc, "ADFS0119", e);
            throw e;
        }
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        try {
            return this.getStream().read(buf, off, len);
        }
        catch (IOException e) {
            Manager.Ffdc.log(e, this, "com.ibm.websphere.management.filetransfer.client.FileDownloadInputStream.read", "244", this);
            Tr.service(tc, "ADFS0119", e);
            throw e;
        }
    }

    public long skip(long l) throws IOException {
        try {
            return this.getStream().skip(l);
        }
        catch (IOException e) {
            Manager.Ffdc.log(e, this, "com.ibm.websphere.management.filetransfer.client.FileDownloadInputStream.skip", "257", this);
            Tr.service(tc, "ADFS0119", e);
            throw e;
        }
    }

    public int available() throws IOException {
        try {
            return this.getStream().available();
        }
        catch (IOException e) {
            Manager.Ffdc.log(e, this, "com.ibm.websphere.management.filetransfer.client.FileDownloadInputStream.available", "269", this);
            Tr.service(tc, "ADFS0119", e);
            throw e;
        }
    }

    public void close() throws IOException {
        try {
            if (this.remoteStream != null) {
                this.remoteStream.close();
            }
        }
        catch (IOException e) {
            Manager.Ffdc.log(e, this, "com.ibm.websphere.management.filetransfer.client.FileDownloadInputStream.close", "281", this);
            Tr.service(tc, "ADFS0119", e);
            throw e;
        }
    }

    public synchronized void mark(int i) {
        try {
            this.getStream().mark(i);
        }
        catch (IOException e) {
            Manager.Ffdc.log(e, this, "com.ibm.websphere.management.filetransfer.client.FileDownloadInputStream.mark", "370", this);
            Tr.service(tc, "ADFS0119", e);
        }
    }

    public synchronized void reset() throws IOException {
        try {
            this.getStream().reset();
        }
        catch (IOException e) {
            Manager.Ffdc.log(e, this, "com.ibm.websphere.management.filetransfer.client.FileDownloadInputStream.reset", "298", this);
            Tr.service(tc, "ADFS0119", e);
            throw e;
        }
    }

    public boolean markSupported() {
        try {
            return this.getStream().markSupported();
        }
        catch (IOException e) {
            Manager.Ffdc.log(e, this, "com.ibm.websphere.management.filetransfer.client.FileDownloadInputStream.markSupported", "407", this);
            Tr.service(tc, "ADFS0119", e);
            return false;
        }
    }
}

