/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ValidationResult;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;

public class ConfigServiceProxy
implements ConfigService {
    private static TraceComponent tc = Tr.register(ConfigServiceProxy.class, "management", "com.ibm.ws.management.resources.configservice");
    private AdminClient client;
    private ObjectName configServiceMBean;

    public ConfigServiceProxy(AdminClient adminClient) throws InstanceNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ConfigServiceProxy", adminClient);
        }
        this.client = adminClient;
        ObjectName match = null;
        ObjectName server2 = this.client.getServerMBean();
        if (server2 == null) {
            throw new InstanceNotFoundException(match.getCanonicalName());
        }
        String process = server2.getKeyProperty("process");
        String objectNameString = "WebSphere:type=ConfigService,process=" + process + ",*";
        try {
            match = new ObjectName(objectNameString);
        }
        catch (MalformedObjectNameException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.ConfigServiceProxy", "39", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        Set configServiceMBeans = this.client.queryNames(match, null);
        if (configServiceMBeans.size() == 0) {
            throw new InstanceNotFoundException(match.getCanonicalName());
        }
        this.configServiceMBean = (ObjectName)configServiceMBeans.iterator().next();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ConfigServiceProxy", this.configServiceMBean);
        }
    }

    public AdminClient getAdminClient() {
        return this.client;
    }

    public void setProperties(Session session, HashMap props) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProperties", new Object[]{session, props});
        }
        try {
            this.client.invoke(this.configServiceMBean, "setProperties", new Object[]{session, props}, new String[]{"com.ibm.websphere.management.Session", "java.util.HashMap"});
        }
        catch (InstanceNotFoundException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.setProperties", "58", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (ReflectionException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.setProperties", "61", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (MBeanException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.setProperties", "64", this);
            Exception targetException = ex.getTargetException();
            if (targetException instanceof ConfigServiceException) {
                throw (ConfigServiceException)targetException;
            }
            throw new ConfigServiceException(targetException);
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.setAttributes", "400", this);
            throw new ConfigServiceException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProperties");
        }
    }

    public ValidationResult validate(Session session, ObjectName scope) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate", new Object[]{session, scope});
        }
        ValidationResult result = null;
        try {
            result = (ValidationResult)this.client.invoke(this.configServiceMBean, "validate", new Object[]{session, scope}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName"});
        }
        catch (InstanceNotFoundException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.validate", "87", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (ReflectionException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.validate", "90", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (MBeanException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.validate", "93", this);
            Exception targetException = ex.getTargetException();
            if (targetException instanceof ConfigServiceException) {
                throw (ConfigServiceException)targetException;
            }
            throw new ConfigServiceException(targetException);
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.validate", "101", this);
            throw new ConfigServiceException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate", result);
        }
        return result;
    }

    public void save(Session session, boolean overwriteOnConflict) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "save", new Object[]{session, new Boolean(overwriteOnConflict)});
        }
        try {
            this.client.invoke(this.configServiceMBean, "save", new Object[]{session, new Boolean(overwriteOnConflict)}, new String[]{"com.ibm.websphere.management.Session", "boolean"});
        }
        catch (InstanceNotFoundException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.save", "55", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (ReflectionException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.save", "58", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (MBeanException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.save", "61", this);
            Exception targetException = ex.getTargetException();
            if (targetException instanceof ConfigServiceException) {
                throw (ConfigServiceException)targetException;
            }
            throw new ConfigServiceException(targetException);
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.save", "69", this);
            throw new ConfigServiceException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "save", session);
        }
    }

    public void discard(Session session) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "discard", session);
        }
        try {
            this.client.invoke(this.configServiceMBean, "discard", new Object[]{session}, new String[]{"com.ibm.websphere.management.Session"});
        }
        catch (InstanceNotFoundException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.discard", "80", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (ReflectionException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.discard", "83", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (MBeanException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.discard", "86", this);
            Exception targetException = ex.getTargetException();
            if (targetException instanceof ConfigServiceException) {
                throw (ConfigServiceException)targetException;
            }
            throw new ConfigServiceException(targetException);
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.discard", "94", this);
            throw new ConfigServiceException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "discard", session);
        }
    }

    public String[] getUnsavedChanges(Session session) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUnsavedChanges", session);
        }
        String[] result = null;
        try {
            result = (String[])this.client.invoke(this.configServiceMBean, "getUnsavedChanges", new Object[]{session}, new String[]{"com.ibm.websphere.management.Session"});
        }
        catch (InstanceNotFoundException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getUnsavedChanges", "106", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (ReflectionException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getUnsavedChanges", "109", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (MBeanException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getUnsavedChanges", "112", this);
            Exception targetException = ex.getTargetException();
            if (targetException instanceof ConfigServiceException) {
                throw (ConfigServiceException)targetException;
            }
            throw new ConfigServiceException(targetException);
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getUnsavedChanges", "120", this);
            throw new ConfigServiceException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUnsavedChanges", result);
        }
        return result;
    }

    public Map getConflictDocuments(Session session) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConflictDocuments", session);
        }
        Map result = null;
        try {
            result = (Map)this.client.invoke(this.configServiceMBean, "getConflictDocuments", new Object[]{session}, new String[]{"com.ibm.websphere.management.Session"});
        }
        catch (InstanceNotFoundException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getConflictDocuments", "133", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (ReflectionException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getConflictDocuments", "136", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (MBeanException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getConflictDocuments", "139", this);
            Exception targetException = ex.getTargetException();
            if (targetException instanceof ConfigServiceException) {
                throw (ConfigServiceException)targetException;
            }
            throw new ConfigServiceException(targetException);
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getConflictDocuments", "147", this);
            throw new ConfigServiceException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConflictDocuments", result);
        }
        return result;
    }

    public String[] getSupportedConfigObjectTypes() throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSupportedConfigObjectTypes");
        }
        String[] result = null;
        try {
            result = (String[])this.client.invoke(this.configServiceMBean, "getSupportedConfigObjectTypes", null, null);
        }
        catch (InstanceNotFoundException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getSupportedConfigObjectTypes", "163", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (ReflectionException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getSupportedConfigObjectTypes", "166", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (MBeanException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getSupportedConfigObjectTypes", "169", this);
            Exception targetException = ex.getTargetException();
            if (targetException instanceof ConfigServiceException) {
                throw (ConfigServiceException)targetException;
            }
            throw new ConfigServiceException(targetException);
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getSupportedConfigObjectTypes", "177", this);
            throw new ConfigServiceException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSupportedConfigObjectTypes", result);
        }
        return result;
    }

    public AttributeList getAttributesMetaInfo(String configDataType) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributesMetaInfo", configDataType);
        }
        AttributeList result = null;
        try {
            result = (AttributeList)this.client.invoke(this.configServiceMBean, "getAttributesMetaInfo", new Object[]{configDataType}, new String[]{"java.lang.String"});
        }
        catch (InstanceNotFoundException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getAttributesMetaInfo", "191", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (ReflectionException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getAttributesMetaInfo", "194", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (MBeanException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getAttributesMetaInfo", "197", this);
            Exception targetException = ex.getTargetException();
            if (targetException instanceof ConfigServiceException) {
                throw (ConfigServiceException)targetException;
            }
            throw new ConfigServiceException(targetException);
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getAttributesMetaInfo", "205", this);
            throw new ConfigServiceException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributesMetaInfo", result);
        }
        return result;
    }

    public AttributeList getRelationshipsMetaInfo(String configObjectType) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationshipsMetaInfo", configObjectType);
        }
        AttributeList result = null;
        try {
            result = (AttributeList)this.client.invoke(this.configServiceMBean, "getRelationshipsMetaInfo", new Object[]{configObjectType}, new String[]{"java.lang.String"});
        }
        catch (InstanceNotFoundException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getRelationshipsMetaInfo", "219", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (ReflectionException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getRelationshipsMetaInfo", "222", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (MBeanException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getRelationshipsMetaInfo", "225", this);
            Exception targetException = ex.getTargetException();
            if (targetException instanceof ConfigServiceException) {
                throw (ConfigServiceException)targetException;
            }
            throw new ConfigServiceException(targetException);
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getRelationshipsMetaInfo", "233", this);
            throw new ConfigServiceException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelationshipsMetaInfo", result);
        }
        return result;
    }

    public ObjectName[] queryConfigObjects(Session inSession, ObjectName scope, ObjectName name2, QueryExp query) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryConfigObjects", new Object[]{inSession, scope, name2, query});
        }
        ObjectName[] result = null;
        try {
            result = (ObjectName[])this.client.invoke(this.configServiceMBean, "queryConfigObjects", new Object[]{inSession, scope, name2, query}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "javax.management.ObjectName", "javax.management.QueryExp"});
        }
        catch (InstanceNotFoundException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.queryConfigObjects", "253", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (ReflectionException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.queryConfigObjects", "256", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (MBeanException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.queryConfigObjects", "259", this);
            Exception targetException = ex.getTargetException();
            if (targetException instanceof ConfigServiceException) {
                throw (ConfigServiceException)targetException;
            }
            throw new ConfigServiceException(targetException);
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.queryConfigObjects", "267", this);
            throw new ConfigServiceException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryConfigObjects", result);
        }
        return result;
    }

    public ObjectName[] queryTemplates(Session inSession, String type) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryTemplates", new Object[]{inSession, type});
        }
        ObjectName[] result = null;
        try {
            result = (ObjectName[])this.client.invoke(this.configServiceMBean, "queryTemplates", new Object[]{inSession, type}, new String[]{"com.ibm.websphere.management.Session", "java.lang.String"});
        }
        catch (InstanceNotFoundException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.queryConfigObjects", "342", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (ReflectionException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.queryConfigObjects", "345", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (MBeanException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.queryConfigObjects", "348", this);
            Exception targetException = ex.getTargetException();
            if (targetException instanceof ConfigServiceException) {
                throw (ConfigServiceException)targetException;
            }
            throw new ConfigServiceException(targetException);
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.queryConfigObjects", "267", this);
            throw new ConfigServiceException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryTemplates", result);
        }
        return result;
    }

    public ObjectName[] resolve(Session inSession, String containmentPath) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolve", new Object[]{inSession, containmentPath});
        }
        ObjectName[] result = null;
        try {
            result = (ObjectName[])this.client.invoke(this.configServiceMBean, "resolve", new Object[]{inSession, containmentPath}, new String[]{"com.ibm.websphere.management.Session", "java.lang.String"});
        }
        catch (InstanceNotFoundException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.resolve", "283", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (ReflectionException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.resolve", "286", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (MBeanException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.resolve", "289", this);
            Exception targetException = ex.getTargetException();
            if (targetException instanceof ConfigServiceException) {
                throw (ConfigServiceException)targetException;
            }
            throw new ConfigServiceException(targetException);
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.resolve", "297", this);
            throw new ConfigServiceException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolve", result);
        }
        return result;
    }

    public ObjectName[] resolve(Session inSession, ObjectName scope, String containmentPath) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolve", new Object[]{inSession, containmentPath});
        }
        ObjectName[] result = null;
        try {
            result = (ObjectName[])this.client.invoke(this.configServiceMBean, "resolve", new Object[]{inSession, scope, containmentPath}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String"});
        }
        catch (InstanceNotFoundException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.resolve", "283", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (ReflectionException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.resolve", "286", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (MBeanException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.resolve", "289", this);
            Exception targetException = ex.getTargetException();
            if (targetException instanceof ConfigServiceException) {
                throw (ConfigServiceException)targetException;
            }
            throw new ConfigServiceException(targetException);
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.resolve", "297", this);
            throw new ConfigServiceException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolve", result);
        }
        return result;
    }

    public ObjectName createConfigDataByTemplate(Session inSession, ObjectName parent, String attributeName, AttributeList attrList, ObjectName template) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigDataByTemplate", new Object[]{inSession, parent, attributeName, attrList, template});
        }
        ObjectName result = null;
        try {
            result = (ObjectName)this.client.invoke(this.configServiceMBean, "createConfigDataByTemplate", new Object[]{inSession, parent, attributeName, attrList, template}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String", "javax.management.AttributeList", "javax.management.ObjectName"});
        }
        catch (InstanceNotFoundException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.createConfigDataByTemplate", "318", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (ReflectionException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.createConfigDataByTemplate", "321", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (MBeanException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.createConfigDataByTemplate", "324", this);
            Exception targetException = ex.getTargetException();
            if (targetException instanceof ConfigServiceException) {
                throw (ConfigServiceException)targetException;
            }
            throw new ConfigServiceException(targetException);
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.createConfigDataByTemplate", "332", this);
            throw new ConfigServiceException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConfigDataByTemplate", result);
        }
        return result;
    }

    public ObjectName createConfigData(Session inSession, ObjectName parent, String attributeName, String type, AttributeList attrList) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigData", new Object[]{inSession, parent, attributeName, type, attrList});
        }
        ObjectName result = null;
        try {
            result = (ObjectName)this.client.invoke(this.configServiceMBean, "createConfigData", new Object[]{inSession, parent, attributeName, type, attrList}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String", "java.lang.String", "javax.management.AttributeList"});
        }
        catch (InstanceNotFoundException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.createConfigData", "354", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (ReflectionException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.createConfigData", "357", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (MBeanException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.createConfigData", "360", this);
            Exception targetException = ex.getTargetException();
            if (targetException instanceof ConfigServiceException) {
                throw (ConfigServiceException)targetException;
            }
            throw new ConfigServiceException(targetException);
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.createConfigData", "368", this);
            throw new ConfigServiceException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConfigData", result);
        }
        return result;
    }

    public void setAttributes(Session inSession, ObjectName configData, AttributeList attrList) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAttributes", new Object[]{inSession, configData, attrList});
        }
        try {
            this.client.invoke(this.configServiceMBean, "setAttributes", new Object[]{inSession, configData, attrList}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "javax.management.AttributeList"});
        }
        catch (InstanceNotFoundException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.setAttributes", "386", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (ReflectionException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.setAttributes", "389", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (MBeanException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.setAttributes", "392", this);
            Exception targetException = ex.getTargetException();
            if (targetException instanceof ConfigServiceException) {
                throw (ConfigServiceException)targetException;
            }
            throw new ConfigServiceException(targetException);
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.setAttributes", "400", this);
            throw new ConfigServiceException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttributes");
        }
    }

    public void addElement(Session inSession, ObjectName configData, String attribute, Object element, int position) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addElement", new Object[]{inSession, configData, attribute, element, new Integer(position)});
        }
        try {
            this.client.invoke(this.configServiceMBean, "addElement", new Object[]{inSession, configData, attribute, element, new Integer(position)}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String", "java.lang.Object", "int"});
        }
        catch (InstanceNotFoundException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.addElement", "420", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (ReflectionException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.addElement", "423", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (MBeanException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.addElement", "426", this);
            Exception targetException = ex.getTargetException();
            if (targetException instanceof ConfigServiceException) {
                throw (ConfigServiceException)targetException;
            }
            throw new ConfigServiceException(targetException);
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.addElement", "434", this);
            throw new ConfigServiceException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addElement");
        }
    }

    public void removeElement(Session inSession, ObjectName configData, String attribute, Object element) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeElement", new Object[]{inSession, configData, attribute, element});
        }
        try {
            this.client.invoke(this.configServiceMBean, "removeElement", new Object[]{inSession, configData, attribute, element}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String", "java.lang.Object"});
        }
        catch (InstanceNotFoundException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.removeElement", "452", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (ReflectionException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.removeElement", "455", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (MBeanException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.removeElement", "458", this);
            Exception targetException = ex.getTargetException();
            if (targetException instanceof ConfigServiceException) {
                throw (ConfigServiceException)targetException;
            }
            throw new ConfigServiceException(targetException);
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.removeElement", "466", this);
            throw new ConfigServiceException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeElement");
        }
    }

    public void unsetAttributes(Session inSession, ObjectName configData, String[] attributes) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unsetAttributes", new Object[]{inSession, configData, attributes});
        }
        try {
            this.client.invoke(this.configServiceMBean, "unsetAttributes", new Object[]{inSession, configData, attributes}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "[Ljava.lang.String;"});
        }
        catch (InstanceNotFoundException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.unsetAttributes", "483", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (ReflectionException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.unsetAttributes", "486", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (MBeanException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.unsetAttributes", "489", this);
            Exception targetException = ex.getTargetException();
            if (targetException instanceof ConfigServiceException) {
                throw (ConfigServiceException)targetException;
            }
            throw new ConfigServiceException(targetException);
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.unsetAttributes", "497", this);
            throw new ConfigServiceException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unsetAttributes");
        }
    }

    public void resetAttributes(Session inSession, ObjectName configData, AttributeList attrList) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetAttributes", new Object[]{inSession, configData, attrList});
        }
        try {
            this.client.invoke(this.configServiceMBean, "resetAttributes", new Object[]{inSession, configData, attrList}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "javax.management.AttributeList"});
        }
        catch (InstanceNotFoundException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.resetAttributes", "514", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (ReflectionException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.resetAttributes", "517", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (MBeanException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.resetAttributes", "520", this);
            Exception targetException = ex.getTargetException();
            if (targetException instanceof ConfigServiceException) {
                throw (ConfigServiceException)targetException;
            }
            throw new ConfigServiceException(targetException);
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.resetAttributes", "528", this);
            throw new ConfigServiceException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetAttributes");
        }
    }

    public AttributeList getAttributes(Session inSession, ObjectName configData, String[] attributes, boolean recursive) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributes", new Object[]{inSession, configData, attributes, new Boolean(recursive)});
        }
        AttributeList result = null;
        try {
            result = (AttributeList)this.client.invoke(this.configServiceMBean, "getAttributes", new Object[]{inSession, configData, attributes, new Boolean(recursive)}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "[Ljava.lang.String;", "boolean"});
        }
        catch (InstanceNotFoundException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getAttributes", "547", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (ReflectionException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getAttributes", "550", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (MBeanException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getAttributes", "553", this);
            Exception targetException = ex.getTargetException();
            if (targetException instanceof ConfigServiceException) {
                throw (ConfigServiceException)targetException;
            }
            throw new ConfigServiceException(targetException);
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getAttributes", "561", this);
            throw new ConfigServiceException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributes", result);
        }
        return result;
    }

    public Object getAttribute(Session inSession, ObjectName configData, String attribute) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttribute", new Object[]{inSession, configData, attribute});
        }
        Object result = null;
        try {
            result = this.client.invoke(this.configServiceMBean, "getAttribute", new Object[]{inSession, configData, attribute}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String"});
        }
        catch (InstanceNotFoundException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getAttribute", "580", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (ReflectionException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getAttribute", "583", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (MBeanException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getAttribute", "586", this);
            Exception targetException = ex.getTargetException();
            if (targetException instanceof ConfigServiceException) {
                throw (ConfigServiceException)targetException;
            }
            throw new ConfigServiceException(targetException);
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getAttribute", "594", this);
            throw new ConfigServiceException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttribute", result);
        }
        return result;
    }

    public Object getAttribute(Session session, ObjectName configData, String attribute, boolean recursive) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Enter - ConfigureServiceProxy.getAttribute", new Object[]{session, configData, attribute, new Boolean(recursive)});
        }
        if (recursive) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Exit - ConfigureServiceProxy.getAttribute");
            }
            return this.getAttribute(session, configData, attribute);
        }
        AttributeList attrList = this.getAttributes(session, configData, new String[]{attribute}, false);
        Object result = null;
        try {
            result = ConfigServiceHelper.getAttributeValue(attrList, attribute);
        }
        catch (AttributeNotFoundException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceHelper.getConfigDataId", "39");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Exit - ConfigureServiceProxy.getAttribute");
        }
        return result;
    }

    public void deleteConfigData(Session inSession, ObjectName configData) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteConfigData", new Object[]{inSession, configData});
        }
        try {
            this.client.invoke(this.configServiceMBean, "deleteConfigData", new Object[]{inSession, configData}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName"});
        }
        catch (InstanceNotFoundException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.deleteConfigData", "611", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (ReflectionException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.deleteConfigData", "614", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (MBeanException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.deleteConfigData", "617", this);
            Exception targetException = ex.getTargetException();
            if (targetException instanceof ConfigServiceException) {
                throw (ConfigServiceException)targetException;
            }
            throw new ConfigServiceException(targetException);
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.deleteConfigData", "625", this);
            throw new ConfigServiceException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteConfigData");
        }
    }

    public AttributeList getRelationships(Session inSession, ObjectName configData, String[] relationshipNames) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationships", new Object[]{inSession, configData, relationshipNames});
        }
        AttributeList attrList = null;
        try {
            attrList = (AttributeList)this.client.invoke(this.configServiceMBean, "getRelationships", new Object[]{inSession, configData, relationshipNames}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "[Ljava.lang.String;"});
        }
        catch (InstanceNotFoundException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getRelationships", "642", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (ReflectionException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getRelationships", "645", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (MBeanException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getRelationships", "648", this);
            Exception targetException = ex.getTargetException();
            if (targetException instanceof ConfigServiceException) {
                throw (ConfigServiceException)targetException;
            }
            throw new ConfigServiceException(targetException);
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getRelationships", "656", this);
            throw new ConfigServiceException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelationships", attrList);
        }
        return attrList;
    }

    public ObjectName[] getRelationship(Session inSession, ObjectName configData, String relationship) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationship", new Object[]{inSession, configData, relationship});
        }
        ObjectName[] result = null;
        try {
            result = (ObjectName[])this.client.invoke(this.configServiceMBean, "getRelationship", new Object[]{inSession, configData, relationship}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String"});
        }
        catch (InstanceNotFoundException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getRelationship", "675", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (ReflectionException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getRelationship", "678", this);
            Tr.error(tc, "ADMG0011E", ex);
        }
        catch (MBeanException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getRelationship", "681", this);
            Exception targetException = ex.getTargetException();
            if (targetException instanceof ConfigServiceException) {
                throw (ConfigServiceException)targetException;
            }
            throw new ConfigServiceException(targetException);
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getRelationship", "689", this);
            throw new ConfigServiceException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelationship", result);
        }
        return result;
    }
}

