/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.cmdframework;

import com.ibm.websphere.management.cmdframework.CommandValidationException;

public class InvalidParameterValueException
extends CommandValidationException {
    private static final long serialVersionUID = -7313758753043599927L;
    private String paramName;
    private Object value;
    private String cmdName;
    private String additionalInfo;

    public InvalidParameterValueException(String cmdName, String paramName, Object paramVal) {
        super("invalid parameter value " + paramVal + " for parameter " + paramName + " for command " + cmdName);
        this.cmdName = cmdName;
        this.value = paramVal;
        this.paramName = paramName;
    }

    public InvalidParameterValueException(String cmdName, String paramName, Object paramVal, String additionalInfo) {
        super("invalid parameter value " + paramVal + " for parameter " + paramName + " for command " + cmdName + ". Additional info: " + additionalInfo);
        this.cmdName = cmdName;
        this.value = paramVal;
        this.paramName = paramName;
        this.additionalInfo = additionalInfo;
    }

    public String getParamName() {
        return this.paramName;
    }

    public Object getValue() {
        return this.value;
    }

    public String getMessage() {
        if (this.additionalInfo == null || this.additionalInfo.equals("")) {
            return nls.getFormattedMessage("ADMF0003E", new Object[]{this.value, this.paramName, this.cmdName}, null);
        }
        return nls.getFormattedMessage("ADMF0009E", new Object[]{this.value, this.paramName, this.cmdName, this.additionalInfo}, null);
    }
}

