/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.cmdframework;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgrInitException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandGroupMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.management.AdminServiceFactoryInitializer;
import com.ibm.ws.management.cmdframework.impl.ClientCommandMgr;
import com.ibm.ws.management.cmdframework.impl.CommandUtility;
import java.io.InputStream;
import java.util.Collection;

public abstract class CommandMgr {
    private static TraceComponent tc = Tr.register(CommandMgr.class, "CommandMgr", "com.ibm.ws.management.resources.cmdframework");
    protected static CommandMgr cmdMgr;
    protected static boolean initialized;
    private static CommandMgr clientCmdMgr;

    public static CommandMgr getCommandMgr() {
        if (cmdMgr == null && !initialized) {
            if (AdminServiceFactory.getAdminService() != null) {
                CommandMgr.initializeServerMode();
            } else {
                CommandMgr.initializeLocalMode();
            }
            initialized = true;
        }
        return cmdMgr;
    }

    public static CommandMgr getClientCommandMgr(AdminClient adminclient) throws CommandMgrInitException {
        if (adminclient == null) {
            Tr.error(tc, "ADMF0008E", new Object[]{"client", "AdminClient is null"});
            throw new CommandMgrInitException("ClientMode, AdminClient is null.");
        }
        return CommandMgr.initializeClientMode(adminclient);
    }

    public static CommandMgr getCommandMgr(AdminClient adminclient) throws CommandMgrInitException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandMgr(AdminClient)");
        }
        if (adminclient == null) {
            Tr.error(tc, "ADMF0008E", new Object[]{"client", "AdminClient is null"});
            throw new CommandMgrInitException("ClientMode, AdminClient is null.");
        }
        try {
            CommandUtility.getRemoteCmdMgrMbean(adminclient);
            Class<?> cmdMgrClass = Class.forName("com.ibm.ws.management.cmdframework.impl.ClientCommandMgr");
            ClientCommandMgr cmdMgrInstance = null;
            cmdMgrInstance = (ClientCommandMgr)cmdMgrClass.newInstance();
            cmdMgrInstance.setAdminClient(adminclient);
            clientCmdMgr = cmdMgrInstance;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createClientCommandMgr", cmdMgrInstance);
            }
            return cmdMgrInstance;
        }
        catch (Throwable ex) {
            Manager.Ffdc.log(ex, CommandMgr.class, "com.ibm.websphere.management.cmdframework.CommandMgr", "100");
            Tr.error(tc, "ADMF0008E", new Object[]{"client", ex});
            throw new CommandMgrInitException(ex, "ClientMode");
        }
    }

    private static synchronized CommandMgr initializeClientMode(AdminClient adminclient) throws CommandMgrInitException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeClientMode");
        }
        try {
            CommandUtility.getRemoteCmdMgrMbean(adminclient);
            Class<?> cmdMgrClass = Class.forName("com.ibm.ws.management.cmdframework.impl.ClientCommandMgr");
            ClientCommandMgr cmdMgrInstance = null;
            cmdMgrInstance = (ClientCommandMgr)cmdMgrClass.newInstance();
            cmdMgrInstance.setAdminClient(adminclient);
            initialized = true;
            cmdMgr = cmdMgrInstance;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initializeClientMode", cmdMgr);
            }
            return cmdMgr;
        }
        catch (Throwable ex) {
            Manager.Ffdc.log(ex, CommandMgr.class, "com.ibm.websphere.management.cmdframework.CommandMgr", "104");
            Tr.error(tc, "ADMF0008E", new Object[]{"local", ex});
            throw new CommandMgrInitException(ex, "ClientMode");
        }
    }

    private static synchronized CommandMgr initializeServerMode() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeServerMode");
        }
        try {
            Class<?> cmdMgrClass = AdminServiceFactoryInitializer.isCellRegistered() ? Class.forName("com.ibm.ws.management.cmdframework.impl.AgentProxyCommandMgr") : Class.forName("com.ibm.ws.management.cmdframework.impl.ServerCommandMgr");
            if (cmdMgr == null || !cmdMgrClass.isInstance(cmdMgr)) {
                cmdMgr = (CommandMgr)cmdMgrClass.newInstance();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initializeServerMode", cmdMgr);
            }
            return cmdMgr;
        }
        catch (Throwable ex) {
            Manager.Ffdc.log(ex, CommandMgr.class, "com.ibm.websphere.management.cmdframework.CommandMgr", "126");
            Tr.error(tc, "ADMF0008E", new Object[]{"server", ex});
            return null;
        }
    }

    private static CommandMgr initializeLocalMode() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeLocalMode");
        }
        try {
            Class<?> cmdMgrClass = Class.forName("com.ibm.ws.management.cmdframework.impl.LocalCommandMgr");
            if (cmdMgr == null || !cmdMgrClass.isInstance(cmdMgr)) {
                cmdMgr = (CommandMgr)cmdMgrClass.newInstance();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initializeLocalMode", cmdMgr);
            }
            return cmdMgr;
        }
        catch (Throwable ex) {
            Manager.Ffdc.log(ex, CommandMgr.class, "com.ibm.websphere.management.cmdframework.CommandMgr", "148");
            Tr.error(tc, "ADMF0008E", new Object[]{"local", ex});
            return null;
        }
    }

    public static AdminClient getAdminClient() {
        AdminClient adminClient = null;
        if (clientCmdMgr != null) {
            adminClient = clientCmdMgr.getCommandProviderHelper().getAdminClient();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getAdminClient(),", new Object[]{"clientCmdMgr: " + clientCmdMgr, "adminClient: " + adminClient});
            }
        } else if (cmdMgr != null) {
            adminClient = cmdMgr.getCommandProviderHelper().getAdminClient();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getAdminClient(),", new Object[]{"cmdMgr: " + cmdMgr, "adminClient: " + adminClient});
            }
        }
        return adminClient;
    }

    public abstract Collection listCommandGroups() throws ConnectorException, CommandException;

    public abstract Collection listCommands(String var1) throws ConnectorException, CommandException;

    public abstract Collection listCommands() throws ConnectorException, CommandException;

    public abstract Collection listAllCommands() throws ConnectorException, CommandException;

    public abstract CommandMetadata getCommandMetadata(String var1) throws ConnectorException, CommandNotFoundException, CommandException;

    public abstract Collection getAllCommandMetadata() throws ConnectorException, CommandException;

    public abstract CommandGroupMetadata getCommandGroupMetadata(String var1) throws ConnectorException, CommandNotFoundException, CommandException;

    public abstract Collection getAllCommandGroupMetadata() throws ConnectorException, CommandNotFoundException, CommandException;

    public abstract AdminCommand createCommand(String var1) throws CommandNotFoundException, CommandException, ConnectorException;

    public abstract AdminCommand loadCommand(InputStream var1) throws CommandLoadException, ConnectorException, CommandException;

    public abstract CommandProviderHelper getCommandProviderHelper();

    static {
        initialized = false;
    }
}

