/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.async.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.async.client.AsyncCommandHandlerIF;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.TaskCommand;
import com.ibm.websphere.management.cmdframework.commandmetadata.ParameterMetadata;
import com.ibm.websphere.management.cmdframework.provider.CmdNotificationHandler;
import com.ibm.websphere.management.cmdframework.provider.CommandNotification;
import com.ibm.ws.management.async.client.ADTSemaphore;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import org.eclipse.emf.common.util.EList;

public class AsyncCommandClient {
    private static TraceComponent tc = Tr.register(AsyncCommandClient.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    public static final String HIDDEN_PROP_PARAM_NAME = "ADTCommandProps";
    public static final String STEP_DISPLAY_FORMAT_KEY = "StepDisplayFormatKey";
    public static final String MULTIPLE_SCOPES_PER_STEP_FORMAT_VALUE = "MultipleScopesPerStepFormatValue";
    public static final String ONE_SCOPE_PER_STEP_FORMAT_VALUE = "OneScopePerStepFormatValue";
    private AsyncCommandHandlerIF _asyncCmdHandler;
    private Session _session;
    private ADTSemaphore _uiSema;
    private ADTSemaphore _opCompleteSema;
    private AsyncCommandHandlerIF _clientNotifHandler;

    public AsyncCommandClient(Session session, AsyncCommandHandlerIF clientNotifHandler) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AsyncCommandClient", new Object[]{session, clientNotifHandler});
        }
        this._session = session;
        this._clientNotifHandler = clientNotifHandler;
        this._uiSema = new ADTSemaphore(session.toString() + ".uiSema");
        this._opCompleteSema = new ADTSemaphore(session.toString() + ".opCompleteSema");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AsyncCommandClient");
        }
    }

    public void execute(AdminCommand adminCmd) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute", new Object[]{adminCmd});
        }
        try {
            if (adminCmd.isAsyncCommand() && adminCmd instanceof TaskCommand) {
                if (((TaskCommand)adminCmd).hasPreviousStep()) {
                    ((TaskCommand)adminCmd).previousStep();
                } else if (((TaskCommand)adminCmd).hasNextStep()) {
                    ((TaskCommand)adminCmd).nextStep();
                } else {
                    String[] stepNames = ((TaskCommand)adminCmd).listCommandSteps();
                    if (stepNames != null && stepNames.length > 0) {
                        ((TaskCommand)adminCmd).gotoStep(stepNames[0]);
                    }
                }
            }
            adminCmd.execute();
        }
        catch (Throwable th) {
            th.printStackTrace();
            StringWriter sw = new StringWriter();
            th.printStackTrace(new PrintWriter(sw));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, sw.toString());
            }
            Tr.error(tc, sw.toString());
        }
        if (adminCmd.isAsyncCommand()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "waiting");
            }
            this._opCompleteSema.waitForOpEvent("Op execution completed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }

    public void processCommandParameters(AdminCommand adminCmd) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processCommandParameters", new Object[]{adminCmd});
        }
        if (adminCmd.isAsyncCommand() && adminCmd instanceof TaskCommand) {
            CmdNotificationHandlerImpl cnh = new CmdNotificationHandlerImpl();
            adminCmd.setCmdHandler(cnh);
            ((TaskCommand)adminCmd).processTaskParameters();
            this._checkResult(adminCmd, cnh);
            this._uiSema.waitForOpEvent("User input obtained");
            this._checkResult(adminCmd, cnh);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processCommandParameters");
        }
    }

    public void setStepDisplayFormat(AdminCommand adminCmd, String displayFormat) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setStepDisplayFormat", new Object[]{adminCmd, displayFormat});
        }
        EList paramMetaList = adminCmd.getCommandMetadata().getParameters();
        for (int i = 0; i < paramMetaList.size(); ++i) {
            ParameterMetadata paramMetadata = (ParameterMetadata)paramMetaList.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "processing parameter metadata: " + paramMetadata);
            }
            if (!HIDDEN_PROP_PARAM_NAME.equals(paramMetadata.getName())) continue;
            try {
                Hashtable<String, String> object = adminCmd.getParameter(HIDDEN_PROP_PARAM_NAME);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "hidden prop object: " + object);
                }
                if (object == null) {
                    object = new Hashtable<String, String>();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "creating an empty hashtable");
                    }
                }
                if (!(object instanceof Hashtable)) break;
                object.put(STEP_DISPLAY_FORMAT_KEY, displayFormat);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "hidden prop object after setting step display format key: " + object);
                }
                adminCmd.setParameter(HIDDEN_PROP_PARAM_NAME, object);
            }
            catch (InvalidParameterNameException ipne) {
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Unexpected InvalidParameterNameException caught: " + ipne.getMessage());
            }
            catch (InvalidParameterValueException ipne) {
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Unexpected InvalidParameterValueException caught: " + ipne.getMessage());
            }
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setStepDisplayFormat");
        }
    }

    private void _checkResult(AdminCommand adminCmd, CmdNotificationHandlerImpl cnh) throws Throwable {
        CommandResult result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_checkResult", new Object[]{adminCmd, cnh});
        }
        if ((result = adminCmd.getCommandResult()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "null result; get result from notification");
            }
            result = cnh.getCommandResult();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "command result: " + result);
        }
        if (result != null && !result.isSuccessful()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "command not succesful: " + result.getException());
            }
            Throwable errException = result.getException();
            throw errException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_checkResult", new Object[]{"not error"});
        }
    }

    class CmdNotificationHandlerImpl
    implements CmdNotificationHandler {
        private String _cmdStatus;
        private CommandResult _cmdResult;

        public synchronized void handleCmdNotification(CommandNotification cn) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handleCmdNotification", new Object[]{cn});
            }
            if (cn.getCmdStatus().equals("Completed")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "command completed with result: " + cn.getResult().getResult());
                }
                this._cmdStatus = "Completed";
                this._cmdResult = cn.getResult();
                CommandResult cr = cn.getResult();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "result: " + cr);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "result exception: " + cr.getException());
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "result successful: " + cr.isSuccessful());
                }
                AsyncCommandClient.this._opCompleteSema.notifyOfOpEvent("Op execution completed");
                if (!cr.isSuccessful()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "result is set to not successful");
                    }
                    AsyncCommandClient.this._uiSema.notifyOfOpEvent("Op execution completed");
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "wake up ui semaphore to take care of command that has no ui");
                    }
                    AsyncCommandClient.this._uiSema.notifyOfOpEvent("Op execution completed");
                }
                if (AsyncCommandClient.this._clientNotifHandler != null) {
                    AsyncCommandClient.this._clientNotifHandler.handleNotification(cn);
                }
            }
            if (cn.getCmdStatus().equals("InProgress")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "command in progress");
                }
                this._cmdStatus = "InProgress";
                this._cmdResult = null;
                if (AsyncCommandClient.this._clientNotifHandler != null) {
                    AsyncCommandClient.this._clientNotifHandler.handleNotification(cn);
                }
            }
            if (cn.getCmdStatus().equals("Interactive")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "command in interactive");
                }
                this._cmdStatus = "Interactive";
                this._cmdResult = null;
                AsyncCommandClient.this._uiSema.notifyOfOpEvent("User input obtained");
            }
        }

        public String getCommandStatus() {
            return this._cmdStatus;
        }

        public CommandResult getCommandResult() {
            return this._cmdResult;
        }
    }
}

