/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws390.utility.ws390FileUtilities;
import java.io.File;
import java.io.IOException;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;

public class EarUtils {
    private static TraceComponent tc = Tr.register(EarUtils.class, null, "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static int[][] versionTable = new int[][]{{12, 5}, {13, 5}, {14, 6}, {50, 7}};

    public static EARFile getEarFile(String filePath, boolean useReflection) throws OpenFailureException {
        return EarUtils.getEarFile(filePath, useReflection, false);
    }

    public static EARFile getEarFile(String filePath, boolean useReflection, boolean isReadOnly) throws OpenFailureException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEarFile " + filePath);
        }
        EARFile archive = null;
        CommonarchiveFactory factory = CommonarchiveFactoryImpl.getActiveFactory();
        ArchiveOptions opt = new ArchiveOptions();
        opt.setUseJavaReflection(useReflection);
        opt.setIsReadOnly(isReadOnly);
        archive = factory.openEARFile(opt, filePath);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEarFile " + archive);
        }
        return archive;
    }

    public static Archive getArchive(String filePath, boolean useReflection, boolean isReadOnly) throws OpenFailureException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getArchive " + filePath + " useRef =" + useReflection + " readOnly = " + isReadOnly);
        }
        Archive archive = null;
        CommonarchiveFactory factory = CommonarchiveFactoryImpl.getActiveFactory();
        ArchiveOptions opt = new ArchiveOptions();
        opt.setUseJavaReflection(useReflection);
        opt.setIsReadOnly(isReadOnly);
        archive = factory.openArchive(opt, filePath);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getArchive " + archive);
        }
        return archive;
    }

    public static void extractEar(EARFile earFile, String dirName, boolean bCleanup) throws SaveFailureException, IOException {
        EarUtils.extractEar(earFile, dirName, bCleanup, 66);
    }

    public static void extractEar(EARFile earFile, String dirName, boolean bCleanup, int options) throws SaveFailureException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractEar: " + dirName);
        }
        File f = new File(dirName);
        if (bCleanup && f.exists()) {
            EarUtils.deleteDirTree(f);
        }
        f.mkdirs();
        earFile.extractTo(dirName, options);
        if (AdminHelper.getPlatformHelper().isZOS()) {
            EarUtils.setDLLExecutePermissions(dirName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractEar");
        }
    }

    public static void extractArchive(Archive arc, String dirName, boolean bCleanup, int options) throws SaveFailureException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractArchive: " + dirName + " options=" + options);
        }
        File f = new File(dirName);
        if (bCleanup && f.exists()) {
            EarUtils.deleteDirTree(f);
        }
        f.mkdirs();
        arc.extractTo(dirName, options);
        if (AdminHelper.getPlatformHelper().isZOS()) {
            EarUtils.setDLLExecutePermissions(dirName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractArchive");
        }
    }

    private static void setDLLExecutePermissions(String dirName) {
        File dir;
        File[] files;
        int filecount;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDLLExecutePermissions " + dirName);
        }
        int n = filecount = (files = (dir = new File(dirName)).listFiles()) != null ? files.length : 0;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Number of files= " + filecount);
        }
        for (int i = 0; i < filecount; ++i) {
            int returnCode;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Check dir entry=" + files[i].getName());
            }
            String pathName = dirName + File.separator + files[i].getName();
            if (files[i].isDirectory()) {
                EarUtils.setDLLExecutePermissions(pathName);
                continue;
            }
            if (!files[i].getName().endsWith(".so")) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Set execute permission on file=" + pathName);
            }
            if ((returnCode = ws390FileUtilities.chmod((String)pathName, (int)509)) == 0) continue;
            Tr.debug(tc, "chmod return code= " + returnCode);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDLLExecutePermissions");
        }
    }

    public static synchronized void deleteDirTree(String dir) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteDirTree");
        }
        EarUtils.deleteDirTree(new File(dir));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteDirTree");
        }
    }

    public static synchronized void deleteDirTree(File dir) throws IOException {
        if (!dir.exists()) {
            Tr.event(tc, "directory does not exist");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deleteDirTree");
            }
            return;
        }
        String osName = System.getProperty("os.name");
        boolean notSymLink = true;
        if (!osName.startsWith("Windows")) {
            notSymLink = osName.equals("OS/400") ? dir.getAbsolutePath().equalsIgnoreCase(dir.getCanonicalPath()) : dir.getAbsolutePath().equals(dir.getCanonicalPath());
        }
        if (!notSymLink) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "file/dir a symlink: " + dir);
            }
            if (!dir.delete()) {
                Tr.warning(tc, "ADMA0078W", dir);
            }
            return;
        }
        if (dir.isDirectory()) {
            String[] entries = dir.list();
            for (int i = 0; i < entries.length; ++i) {
                File f = new File(dir.getPath(), entries[i]);
                EarUtils.deleteDirTree(f);
            }
        }
        if (!dir.delete()) {
            Tr.warning(tc, "ADMA0078W", dir);
        }
    }

    public static int getAppVersionForDeployment(EARFile ear) {
        int appVersion = ear.getDeploymentDescriptor().getVersionID();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "App Version in app DD " + appVersion);
        }
        return appVersion;
    }

    public static int getLowestNodeVersionForModule(Module module) {
        int appVersion = module.getApplication().getVersionID();
        for (int i = 0; i < versionTable.length; ++i) {
            if (appVersion != versionTable[i][0]) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Node Version " + versionTable[i][1]);
            }
            return versionTable[i][1];
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Node Version 2147483647");
        }
        return Integer.MAX_VALUE;
    }
}

