/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementBaseFactory;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.EditionInfo;
import com.ibm.websphere.management.exception.AdminException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.management.ObjectName;

public class AppManagementProxy
implements AppManagement {
    private static TraceComponent tc = Tr.register(AppManagementProxy.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.AppDeploymentMessages");
    AppManagement mgmt = null;
    AdminClient adminClient = null;
    boolean bRemote = false;
    ObjectName on = null;

    public static AppManagement getLocalProxy() throws Exception {
        return new AppManagementProxy(false, null);
    }

    public static AppManagement getJMXProxyForClient(AdminClient adminClient) throws Exception {
        return new AppManagementProxy(true, adminClient);
    }

    public static AppManagement getJMXProxyForServer() throws Exception {
        return new AppManagementProxy(true, null);
    }

    AppManagementProxy(boolean bRem, AdminClient cl) throws Exception {
        this.bRemote = bRem;
        if (!this.bRemote) {
            this.mgmt = AppManagementBaseFactory.createLocalAppManagementImpl();
        } else {
            this.adminClient = cl;
            String q = "WebSphere:type=AppManagement,process=";
            if (this.adminClient == null) {
                q = q + AdminServiceFactory.getAdminService().getProcessName();
            } else {
                ObjectName sName = cl.getServerMBean();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "sName: " + sName);
                }
                q = q + sName.getKeyProperty("process");
            }
            q = q + ",*";
            ObjectName qName = new ObjectName(q);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "q = " + q);
            }
            Iterator it = null;
            it = this.adminClient == null ? AdminServiceFactory.getAdminService().queryNames(qName, null).iterator() : this.adminClient.queryNames(qName, null).iterator();
            if (!it.hasNext()) {
                throw new AdminException(nls.getFormattedMessage("ADMA0089E", new Object[0], "AppManagement MBean not found."));
            }
            this.on = (ObjectName)it.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AppM on: " + this.on);
            }
        }
    }

    private void proxyInvokeNoRet(String mName, Object[] pars, String[] sig) throws AdminException {
        try {
            if (this.adminClient == null) {
                AdminServiceFactory.getAdminService().invoke(this.on, mName, pars, sig);
            } else {
                this.adminClient.invoke(this.on, mName, pars, sig);
            }
        }
        catch (Exception ex) {
            if (ex instanceof AdminException) {
                throw (AdminException)ex;
            }
            throw new AdminException(ex, "");
        }
    }

    private Object proxyInvoke(String mName, Object[] pars, String[] sig) throws AdminException {
        try {
            if (this.adminClient == null) {
                return AdminServiceFactory.getAdminService().invoke(this.on, mName, pars, sig);
            }
            return this.adminClient.invoke(this.on, mName, pars, sig);
        }
        catch (Exception ex) {
            if (ex instanceof AdminException) {
                throw (AdminException)ex;
            }
            throw new AdminException(ex, "");
        }
    }

    public void sendJMXEvent(Object arg0) {
    }

    public void sendJMXEvent(String s, Object arg0) {
    }

    public Hashtable getGlobalSettings() {
        return null;
    }

    public void clusterMemberAdded(ObjectName arg0, ObjectName arg1, Hashtable arg2, String arg3) throws AdminException {
        if (!this.bRemote) {
            this.mgmt.clusterMemberAdded(arg0, arg1, arg2, arg3);
        } else {
            this.proxyInvokeNoRet("clusterMemberAdded", new Object[]{arg0, arg1, arg2, arg3}, new String[]{ObjectName.class.getName(), ObjectName.class.getName(), Hashtable.class.getName(), String.class.getName()});
        }
    }

    public void changeServerToCluster(ObjectName arg0, ObjectName arg1, Hashtable arg2, String arg3) throws AdminException {
        if (!this.bRemote) {
            this.mgmt.changeServerToCluster(arg0, arg1, arg2, arg3);
        } else {
            this.proxyInvokeNoRet("changeServerToCluster", new Object[]{arg0, arg1, arg2, arg3}, new String[]{ObjectName.class.getName(), ObjectName.class.getName(), Hashtable.class.getName(), String.class.getName()});
        }
    }

    public void removeAllAppsFromCluster(ObjectName arg0, Hashtable arg1, String arg2) throws AdminException {
        if (!this.bRemote) {
            this.mgmt.removeAllAppsFromCluster(arg0, arg1, arg2);
        } else {
            this.proxyInvokeNoRet("removeAllAppsFromCluster", new Object[]{arg0, arg1, arg2}, new String[]{ObjectName.class.getName(), Hashtable.class.getName(), String.class.getName()});
        }
    }

    public void removeAllAppsFromServer(ObjectName arg0, Hashtable arg1, String arg2) throws AdminException {
        if (!this.bRemote) {
            this.mgmt.removeAllAppsFromServer(arg0, arg1, arg2);
        } else {
            this.proxyInvokeNoRet("removeAllAppsFromServer", new Object[]{arg0, arg1, arg2}, new String[]{ObjectName.class.getName(), Hashtable.class.getName(), String.class.getName()});
        }
    }

    public void removeAllAppsFromNode(String arg0, String arg1, Hashtable arg2, String arg3) throws AdminException {
        if (!this.bRemote) {
            this.mgmt.removeAllAppsFromNode(arg0, arg1, arg2, arg3);
        } else {
            this.proxyInvokeNoRet("removeAllAppsFromNode", new Object[]{arg0, arg1, arg2, arg3}, new String[]{String.class.getName(), String.class.getName(), Hashtable.class.getName(), String.class.getName()});
        }
    }

    public boolean checkIfAppExists(String arg0, Hashtable arg1, String arg2) throws AdminException {
        if (!this.bRemote) {
            return this.mgmt.checkIfAppExists(arg0, arg1, arg2);
        }
        Boolean bool = null;
        bool = (Boolean)this.proxyInvoke("checkIfAppExists", new Object[]{arg0, arg1, arg2}, new String[]{String.class.getName(), Hashtable.class.getName(), String.class.getName()});
        return bool;
    }

    public void installStandaloneRAR(String arg0, Hashtable arg1, String arg2) throws AdminException {
    }

    public Vector compareSecurityPolicy(String arg0, Hashtable arg1, String arg2) throws AdminException {
        if (!this.bRemote) {
            return this.mgmt.compareSecurityPolicy(arg0, arg1, arg2);
        }
        return (Vector)this.proxyInvoke("compareSecurityPolicy", new Object[]{arg0, arg1, arg2}, new String[]{String.class.getName(), Hashtable.class.getName(), String.class.getName()});
    }

    public Object listModules(String arg0, Hashtable arg1, String arg2) throws AdminException {
        if (!this.bRemote) {
            return this.mgmt.listModules(arg0, arg1, arg2);
        }
        return this.proxyInvoke("listModules", new Object[]{arg0, arg1, arg2}, new String[]{String.class.getName(), Hashtable.class.getName(), String.class.getName()});
    }

    public Vector listApplications(Hashtable arg0, String arg1) throws AdminException {
        if (!this.bRemote) {
            return this.mgmt.listApplications(arg0, arg1);
        }
        return (Vector)this.proxyInvoke("listApplications", new Object[]{arg0, arg1}, new String[]{Hashtable.class.getName(), String.class.getName()});
    }

    public void extractDDL(String arg0, String arg1, String arg2, Hashtable arg3, String arg4) throws AdminException {
        if (!this.bRemote) {
            this.mgmt.extractDDL(arg0, arg1, arg2, arg3, arg4);
        } else {
            this.proxyInvokeNoRet("extractDDL", new Object[]{arg0, arg1, arg2, arg3, arg4}, new String[]{String.class.getName(), String.class.getName(), String.class.getName(), Hashtable.class.getName(), String.class.getName()});
        }
    }

    public void exportApplication(String arg0, String arg1, Hashtable arg2, String arg3) throws AdminException {
        if (!this.bRemote) {
            this.mgmt.exportApplication(arg0, arg1, arg2, arg3);
        } else {
            this.proxyInvokeNoRet("exportApplication", new Object[]{arg0, arg1, arg2, arg3}, new String[]{String.class.getName(), String.class.getName(), Hashtable.class.getName(), String.class.getName()});
        }
    }

    public void moveModule(String arg0, Hashtable arg1, String arg2, ObjectName arg3, String arg4) throws AdminException {
    }

    public void setModuleInfo(String arg0, Hashtable arg1, String arg2, String arg3, Vector arg4) throws AdminException {
        if (!this.bRemote) {
            this.mgmt.setModuleInfo(arg0, arg1, arg2, arg3, arg4);
        } else {
            this.proxyInvokeNoRet("setModuleInfo", new Object[]{arg0, arg1, arg2, arg3, arg4}, new String[]{String.class.getName(), Hashtable.class.getName(), String.class.getName(), String.class.getName(), Vector.class.getName()});
        }
    }

    public void setApplicationInfo(String arg0, Hashtable arg1, String arg2, Vector arg3) throws AdminException {
        if (!this.bRemote) {
            this.mgmt.setApplicationInfo(arg0, arg1, arg2, arg3);
        } else {
            this.proxyInvokeNoRet("setApplicationInfo", new Object[]{arg0, arg1, arg2, arg3}, new String[]{String.class.getName(), Hashtable.class.getName(), String.class.getName(), Vector.class.getName()});
        }
    }

    public Vector getModuleInfo(String arg0, Hashtable arg1, String arg2, String arg3) throws AdminException {
        if (!this.bRemote) {
            return this.mgmt.getModuleInfo(arg0, arg1, arg2, arg3);
        }
        return (Vector)this.proxyInvoke("getModuleInfo", new Object[]{arg0, arg1, arg2, arg3}, new String[]{String.class.getName(), Hashtable.class.getName(), String.class.getName(), String.class.getName()});
    }

    public Vector getApplicationInfo(String arg0, Hashtable arg1, String arg2) throws AdminException {
        if (!this.bRemote) {
            return this.mgmt.getApplicationInfo(arg0, arg1, arg2);
        }
        return (Vector)this.proxyInvoke("getApplicationInfo", new Object[]{arg0, arg1, arg2}, new String[]{String.class.getName(), Hashtable.class.getName(), String.class.getName()});
    }

    public void redeployApplication(String localEarPath, String arg1, Hashtable properties, String arg3) throws AdminException {
        if (!this.bRemote) {
            this.mgmt.redeployApplication(localEarPath, arg1, properties, arg3);
        } else {
            String path = localEarPath;
            if (properties != null && this.adminClient != null && Boolean.TRUE.equals(properties.get("archive.upload"))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "need to upload");
                }
                path = this.uploadArchive(localEarPath);
                properties.put("DeleteSourceEar", Boolean.TRUE);
            }
            this.proxyInvokeNoRet("redeployApplication", new Object[]{path, arg1, properties, arg3}, new String[]{String.class.getName(), String.class.getName(), Hashtable.class.getName(), String.class.getName()});
        }
    }

    public void redeployApplicationLocal(String arg0, String arg1, Hashtable arg2, AppNotification.Listener arg3, String arg4) throws AdminException {
        if (this.bRemote) {
            throw new AdminException(nls.getFormattedMessage("ADMA0088E", new Object[]{"redeployApplicationLocal"}, "Invalid usage of {0}. Operation {0} can only be called in local mode of AppManagement"));
        }
        this.mgmt.redeployApplicationLocal(arg0, arg1, arg2, arg3, arg4);
    }

    public void uninstallApplication(String arg0, Hashtable arg1, String arg2) throws AdminException {
        if (!this.bRemote) {
            this.mgmt.uninstallApplication(arg0, arg1, arg2);
        } else {
            this.proxyInvokeNoRet("uninstallApplication", new Object[]{arg0, arg1, arg2}, new String[]{String.class.getName(), Hashtable.class.getName(), String.class.getName()});
        }
    }

    public void uninstallApplicationLocal(String arg0, Hashtable arg1, AppNotification.Listener arg2, String arg3) throws AdminException {
        if (this.bRemote) {
            throw new AdminException(nls.getFormattedMessage("ADMA0088E", new Object[]{"uninstallApplicationLocal"}, "Invalid usage of {0}. Operation {0} can only be called in local mode of AppManagement"));
        }
        this.mgmt.uninstallApplicationLocal(arg0, arg1, arg2, arg3);
    }

    public void uninstallApplicationLocal(String arg0, Hashtable arg1, AppNotification.Listener arg2) throws AdminException {
        if (this.bRemote) {
            throw new AdminException(nls.getFormattedMessage("ADMA0088E", new Object[]{"uninstallApplicationLocal"}, "Invalid usage of {0}. Operation {0} can only be called in local mode of AppManagement"));
        }
        this.mgmt.uninstallApplicationLocal(arg0, arg1, arg2);
    }

    public void installApplicationLocal(String arg0, String arg1, Hashtable arg2, AppNotification.Listener arg3, String arg4) throws AdminException {
        if (this.bRemote) {
            throw new AdminException(nls.getFormattedMessage("ADMA0088E", new Object[]{"installApplicationLocal"}, "Invalid usage of {0}. Operation {0} can only be called in local mode of AppManagement"));
        }
        this.mgmt.installApplicationLocal(arg0, arg1, arg2, arg3, arg4);
    }

    public void installApplicationLocal(String arg0, String arg1, Hashtable arg2, AppNotification.Listener arg3) throws AdminException {
        if (this.bRemote) {
            throw new AdminException(nls.getFormattedMessage("ADMA0088E", new Object[]{"installApplicationLocal"}, "Invalid usage of {0}. Operation {0} can only be called in local mode of AppManagement"));
        }
        this.mgmt.installApplicationLocal(arg0, arg1, arg2, arg3);
    }

    public void installApplication(String localEarPath, String appName, Hashtable properties, String workspaceID) throws AdminException {
        if (!this.bRemote) {
            this.mgmt.installApplication(localEarPath, appName, properties, workspaceID);
        } else {
            String path = localEarPath;
            if (properties != null && this.adminClient != null && Boolean.TRUE.equals(properties.get("archive.upload"))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "need to upload");
                }
                path = this.uploadArchive(localEarPath);
                properties.put("DeleteSourceEar", Boolean.TRUE);
            }
            this.proxyInvokeNoRet("installApplication", new Object[]{path, appName, properties, workspaceID}, new String[]{String.class.getName(), String.class.getName(), Hashtable.class.getName(), String.class.getName()});
        }
    }

    public void installApplication(String localEarPath, Hashtable properties, String workspaceID) throws AdminException {
        if (!this.bRemote) {
            this.mgmt.installApplication(localEarPath, properties, workspaceID);
        } else {
            String path = localEarPath;
            if (properties != null && this.adminClient != null && Boolean.TRUE.equals(properties.get("archive.upload"))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "need to upload");
                }
                path = this.uploadArchive(localEarPath);
                properties.put("DeleteSourceEar", Boolean.TRUE);
            }
            this.proxyInvokeNoRet("installApplication", new Object[]{path, properties, workspaceID}, new String[]{String.class.getName(), Hashtable.class.getName(), String.class.getName()});
        }
    }

    public void updateAccessIDs(String appName, Boolean bAll, Hashtable prefs, String wID) throws AdminException {
        if (!this.bRemote) {
            throw new AdminException(nls.getFormattedMessage("ADMA0090", new Object[]{"updateAccessIDs"}, "Invalid usage of {0}. Operation {0} can only be called in JMX mode of AppManagement"));
        }
        this.proxyInvokeNoRet("updateAccessIDs", new Object[]{appName, bAll, prefs, wID}, new String[]{String.class.getName(), Boolean.class.getName(), Hashtable.class.getName(), String.class.getName()});
    }

    public void deleteUserAndGroupEntries(String appName, Hashtable prefs, String wID) throws AdminException {
        if (!this.bRemote) {
            this.mgmt.deleteUserAndGroupEntries(appName, prefs, wID);
        } else {
            this.proxyInvokeNoRet("deleteUserAndGroupEntries", new Object[]{appName, prefs, wID}, new String[]{String.class.getName(), Hashtable.class.getName(), String.class.getName()});
        }
    }

    public String startApplication(String appName, Hashtable prefs, String wID) throws AdminException {
        if (!this.bRemote) {
            throw new AdminException(nls.getFormattedMessage("ADMA0090", new Object[]{"startApplication"}, "Invalid usage of {0}. Operation {0} can only be called in JMX mode of AppManagement"));
        }
        return (String)this.proxyInvoke("startApplication", new Object[]{appName, prefs, wID}, new String[]{String.class.getName(), Hashtable.class.getName(), String.class.getName()});
    }

    public String startApplication(String appName, String target, Hashtable prefs, String wID) throws AdminException {
        if (!this.bRemote) {
            throw new AdminException(nls.getFormattedMessage("ADMA0090", new Object[]{"startApplication"}, "Invalid usage of {0}. Operation {0} can only be called in JMX mode of AppManagement"));
        }
        return (String)this.proxyInvoke("startApplication", new Object[]{appName, target, prefs, wID}, new String[]{String.class.getName(), String.class.getName(), Hashtable.class.getName(), String.class.getName()});
    }

    public String stopApplication(String appName, Hashtable prefs, String wID) throws AdminException {
        if (!this.bRemote) {
            throw new AdminException(nls.getFormattedMessage("ADMA0090", new Object[]{"stopApplication"}, "Invalid usage of {0}. Operation {0} can only be called in JMX mode of AppManagement"));
        }
        return (String)this.proxyInvoke("stopApplication", new Object[]{appName, prefs, wID}, new String[]{String.class.getName(), Hashtable.class.getName(), String.class.getName()});
    }

    public String stopApplication(String appName, String target, Hashtable prefs, String wID) throws AdminException {
        if (!this.bRemote) {
            throw new AdminException(nls.getFormattedMessage("ADMA0090", new Object[]{"stopApplication"}, "Invalid usage of {0}. Operation {0} can only be called in JMX mode of AppManagement"));
        }
        return (String)this.proxyInvoke("stopApplication", new Object[]{appName, target, prefs, wID}, new String[]{String.class.getName(), String.class.getName(), Hashtable.class.getName(), String.class.getName()});
    }

    public void publishWSDL(String arg0, String arg1, Hashtable arg2, String arg3) throws AdminException {
        if (!this.bRemote) {
            this.mgmt.publishWSDL(arg0, arg1, arg2, arg3);
        } else {
            this.proxyInvokeNoRet("publishWSDL", new Object[]{arg0, arg1, arg2, arg3}, new String[]{String.class.getName(), String.class.getName(), Hashtable.class.getName(), String.class.getName()});
        }
    }

    public Hashtable searchJNDIReferences(List sList, String nodes, Hashtable prefs, String wID) throws AdminException {
        if (!this.bRemote) {
            return this.mgmt.searchJNDIReferences(sList, nodes, prefs, wID);
        }
        return (Hashtable)this.proxyInvoke("searchJNDIReferences", new Object[]{sList, nodes, prefs, wID}, new String[]{List.class.getName(), String.class.getName(), Hashtable.class.getName(), String.class.getName()});
    }

    public void updateApplication(String appName, String contentURI, String pathToContents, String operation, Hashtable properties, String sessionID) throws AdminException {
        if (!this.bRemote) {
            this.mgmt.updateApplication(appName, contentURI, pathToContents, operation, properties, sessionID);
        } else {
            String path = pathToContents;
            if (properties != null && this.adminClient != null && pathToContents != null && Boolean.TRUE.equals(properties.get("archive.upload"))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "need to upload");
                }
                path = this.uploadArchive(pathToContents);
                properties.put("DeleteSourceEar", Boolean.TRUE);
            }
            this.proxyInvokeNoRet("updateApplication", new Object[]{appName, contentURI, path, operation, properties, sessionID}, new String[]{String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), Hashtable.class.getName(), String.class.getName()});
        }
    }

    public void updateApplicationLocal(String appName, String contentURI, String pathToContents, String operation, Hashtable properties, AppNotification.Listener notf, String sessionID) throws AdminException {
        if (this.bRemote) {
            throw new AdminException(nls.getFormattedMessage("ADMA0088E", new Object[]{"updateApplicationLocal"}, "Invalid usage of {0}. Operation {0} can only be called in local mode of AppManagement"));
        }
        this.mgmt.updateApplicationLocal(appName, contentURI, pathToContents, operation, properties, notf, sessionID);
    }

    public List listURIs(String appName, String moduleURI, Hashtable prefs, String sessionID) throws AdminException {
        if (!this.bRemote) {
            return this.mgmt.listURIs(appName, moduleURI, prefs, sessionID);
        }
        return (List)this.proxyInvoke("listURIs", new Object[]{appName, moduleURI, prefs, sessionID}, new String[]{String.class.getName(), String.class.getName(), Hashtable.class.getName(), String.class.getName()});
    }

    private String uploadArchive(String archive) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "uploadArchive: " + archive);
        }
        try {
            Class<?> c = Class.forName("com.ibm.ws.management.application.client.AppInstallHelper");
            Method m = c.getMethod("copyToServer", AdminClient.class, String.class);
            String s = (String)m.invoke(c, this.adminClient, archive);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "uploadArchive: " + s);
            }
            return s;
        }
        catch (ClassNotFoundException cex) {
            throw new AdminException(cex, "Failure uploading archive to server");
        }
        catch (NoSuchMethodException nsmex) {
            throw new AdminException(nsmex, "Failure uploading archive to server");
        }
        catch (InvocationTargetException intex) {
            throw new AdminException(intex.getCause(), "Failure uploading archive to server");
        }
        catch (IllegalAccessException ilex) {
            throw new AdminException(ilex, "Failure uploading archive to server");
        }
    }

    public void updateCluster(String[] arg0, Integer arg1, Hashtable arg2, String arg3) throws AdminException {
        if (!this.bRemote) {
            this.mgmt.updateCluster(arg0, arg1, arg2, arg3);
        } else {
            this.proxyInvokeNoRet("updateCluster", new Object[]{arg0, arg1, arg2, arg3}, new String[]{arg0.getClass().getName(), Integer.class.getName(), Hashtable.class.getName(), String.class.getName()});
        }
    }

    public void updateClusterLocal(String[] arg0, Integer arg1, Hashtable arg2, String arg3, AppNotification.Listener arg4) throws AdminException {
        if (this.bRemote) {
            throw new AdminException(nls.getFormattedMessage("ADMA0088E", new Object[]{"updateClusterLocal"}, "Invalid usage of {0}. Operation {0} can only be called in local mode of AppManagement"));
        }
        this.mgmt.updateClusterLocal(arg0, arg1, arg2, arg3, arg4);
    }

    public List searchResources(String appName, Hashtable prefs, String wID) throws AdminException {
        if (!this.bRemote) {
            return this.mgmt.searchResources(appName, prefs, wID);
        }
        return (List)this.proxyInvoke("searchResources", new Object[]{appName, prefs, wID}, new String[]{String.class.getName(), Hashtable.class.getName(), String.class.getName()});
    }

    public List convertRefToConfigID(String appName, List resources, Hashtable prefs, String wID) throws AdminException {
        if (!this.bRemote) {
            return this.mgmt.convertRefToConfigID(appName, resources, prefs, wID);
        }
        return (List)this.proxyInvoke("convertRefToConfigID", new Object[]{appName, resources, prefs, wID}, new String[]{String.class.getName(), List.class.getName(), Hashtable.class.getName(), String.class.getName()});
    }

    public byte[] getApplicationContents(String appName, String uri, Hashtable prefs, String wID) throws AdminException {
        if (!this.bRemote) {
            return this.mgmt.getApplicationContents(appName, uri, prefs, wID);
        }
        return (byte[])this.proxyInvoke("getApplicationContents", new Object[]{appName, uri, prefs, wID}, new String[]{String.class.getName(), String.class.getName(), Hashtable.class.getName(), String.class.getName()});
    }

    public void getDistributionStatus(String appName, Hashtable prefs, String wID) throws AdminException {
        if (!this.bRemote) {
            this.mgmt.getDistributionStatus(appName, prefs, wID);
        } else {
            this.proxyInvokeNoRet("getDistributionStatus", new Object[]{appName, prefs, wID}, new String[]{String.class.getName(), Hashtable.class.getName(), String.class.getName()});
        }
    }

    public String[] getAppAssociation(String scope, String retVal, Hashtable prefs, String wID) throws AdminException {
        if (!this.bRemote) {
            return this.mgmt.getAppAssociation(scope, retVal, prefs, wID);
        }
        return (String[])this.proxyInvoke("getAppAssociation", new Object[]{scope, retVal, prefs, wID}, new String[]{String.class.getName(), String.class.getName(), Hashtable.class.getName(), String.class.getName()});
    }

    public EditionInfo[] getEditionInfo(String appName, String edition, Hashtable prefs, String wID) throws AdminException {
        if (!this.bRemote) {
            return this.mgmt.getEditionInfo(appName, edition, prefs, wID);
        }
        return (EditionInfo[])this.proxyInvoke("getEditionInfo", new Object[]{appName, edition, prefs, wID}, new String[]{String.class.getName(), String.class.getName(), Hashtable.class.getName(), String.class.getName()});
    }

    public void setEditionInfo(EditionInfo[] info, Hashtable prefs, String wID) throws AdminException {
        if (!this.bRemote) {
            this.mgmt.setEditionInfo(info, prefs, wID);
        } else {
            this.proxyInvokeNoRet("setEditionInfo", new Object[]{info, prefs, wID}, new String[]{info.getClass().getName(), Hashtable.class.getName(), String.class.getName()});
        }
    }

    public Vector listApplications(String targetScope, Hashtable props, String sessionID) throws AdminException {
        if (!this.bRemote) {
            return this.mgmt.listApplications(targetScope, props, sessionID);
        }
        return (Vector)this.proxyInvoke("listApplications", new Object[]{targetScope, props, sessionID}, new String[]{String.class.getName(), Hashtable.class.getName(), String.class.getName()});
    }

    public Vector listSystemApplications(Hashtable prefs, String sessionID) throws AdminException {
        if (!this.bRemote) {
            return this.mgmt.listSystemApplications(prefs, sessionID);
        }
        return (Vector)this.proxyInvoke("listSystemApplications", new Object[]{prefs, sessionID}, new String[]{Hashtable.class.getName(), String.class.getName()});
    }
}

