/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import java.util.EmptyStackException;
import java.util.Stack;

public class AdminContext {
    private static TraceComponent tc = Tr.register(AdminContext.class, "Admin", "com.ibm.ws.management");
    private static ThreadLocal profileStack = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new Stack();
        }
    };

    public static boolean push(String uuid) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "push", uuid);
        }
        if (tc.isDebugEnabled()) {
            Exception ex = new Exception("AdminContext.push(" + uuid + ") stack trace");
            Tr.debug(tc, "AdminContext.push() stack trace: ", ex.getStackTrace());
        }
        Stack s = (Stack)profileStack.get();
        s.push(uuid);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "push", uuid);
        }
        return true;
    }

    public static String peek() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "peek");
        }
        Stack s = (Stack)profileStack.get();
        String uuid = null;
        if (s.empty()) {
            return uuid;
        }
        try {
            uuid = (String)s.peek();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "peek", uuid);
        }
        return uuid;
    }

    public static String pop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pop");
        }
        if (tc.isDebugEnabled()) {
            String uuid = AdminContext.peek();
            Exception ex = new Exception("AdminContext.pop() stack trace:" + uuid);
            Tr.debug(tc, "AdminContext.pop() stack trace: " + uuid, ex.getStackTrace());
        }
        Stack s = (Stack)profileStack.get();
        String uuid = null;
        try {
            uuid = (String)s.pop();
        }
        catch (EmptyStackException e) {
            Manager.Ffdc.log(e, AdminContext.class, "com.ibm.webspheres.management.AdminContext", "123", AdminContext.class);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pop", uuid);
        }
        return uuid;
    }

    public static boolean isEmpty() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEmpty");
        }
        Stack s = (Stack)profileStack.get();
        boolean empty = s.empty();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isEmpty", empty);
        }
        return empty;
    }

    public static Stack exportStack() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportStack");
        }
        if (tc.isDebugEnabled()) {
            Exception ex = new Exception("AdminContext.exportStack()");
            Tr.debug(tc, "AdminContext.exportStack() stack trace: ", ex.getStackTrace());
        }
        Stack s = (Stack)profileStack.get();
        s = (Stack)s.clone();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportStack", s);
        }
        return s;
    }

    public static void importStack(Stack stack) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importStack", stack);
        }
        if (tc.isDebugEnabled()) {
            Exception ex = new Exception("AdminContext.importStack()");
            Tr.debug(tc, "AdminContext.importStack() stack trace: ", ex.getStackTrace());
        }
        stack = (Stack)stack.clone();
        profileStack.set(stack);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "importStack");
        }
    }
}

